/*$Id: fkRule.cpp,v 1.6 2006/10/02 11:56:20 jwrobel Exp $*/
/* ***** BEGIN LICENSE BLOCK *****
 *  This file is part of Firekeeper.
 *
 *  Copyright (C) 2006 Jan Wrobel <wrobel@blues.ath.cx>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * ***** END LICENSE BLOCK ***** */

#include "fkRule.h"
#include "fkRuleReference.h"
#include "Error.h"
#include "string.h"
#include "nsMemory.h"
#include "nsCRT.h"

fkRule::fkRule(const Rule *rule)
{
	TRACE("constructor %08x", this);
	this->rule = rule;
}

fkRule::~fkRule()
{
	TRACE("destructor %08x", this);
}

NS_IMPL_ISUPPORTS1(fkRule, fkIRule)

NS_IMETHODIMP fkRule::GetAction(char **aAction)
{
	if (!aAction)
		return NS_ERROR_NULL_POINTER;
	*aAction = nsnull;

	if(rule->action){
		*aAction = nsCRT::strdup(rule->action);	
		if (!*aAction)
			return NS_ERROR_OUT_OF_MEMORY;
	}
	return NS_OK;
}

/* readonly attribute string msg; */
NS_IMETHODIMP fkRule::GetMsg(char **aMsg)
{
	if (!aMsg)
		return NS_ERROR_NULL_POINTER;
	*aMsg = nsnull;

	if(rule->msg){
		*aMsg = nsCRT::strdup(rule->msg);	
		if (!*aMsg)
			return NS_ERROR_OUT_OF_MEMORY;
	}
	return NS_OK;
}


NS_IMETHODIMP fkRule::GetReferences(PRUint32 *count, fkIRuleReference ***references)
{
	if (!count || !references)
		return NS_ERROR_NULL_POINTER;
	*count = 0;
	*references = nsnull;
	
	int size = rule->references.size();
	if (size == 0)
		return NS_OK;
	
	fkIRuleReference **out = (fkIRuleReference **)
		nsMemory::Alloc(sizeof(fkIRuleReference *) * size);
	if (!out)
		return NS_ERROR_OUT_OF_MEMORY;
	
	list<reference>::const_iterator it = rule->references.begin();
	
	for(int i = 0; i < size; ++i, ++it){
		out[i] = new fkRuleReference(&*it);
		
		if (!out[i]){
			for(int j = 0; j < i; j++)
				NS_RELEASE(out[j]);
			nsMemory::Free(out);
			return NS_ERROR_OUT_OF_MEMORY;
		}
		NS_ADDREF(out[i]);		
	}
	
	*references = out;
	*count = size;
	return NS_OK;
}

/* readonly attribute unsigned long fid; */
NS_IMETHODIMP fkRule::GetFid(PRUint32 *aFid)
{	
	if (!aFid)
		return NS_ERROR_NULL_POINTER;
	*aFid = rule->fid;
	return NS_OK;
}

/* readonly attribute unsigned long rev; */
NS_IMETHODIMP fkRule::GetRev(PRUint32 *aRev)
{
	if (!aRev)
		return NS_ERROR_NULL_POINTER;
	*aRev = rule->rev;
	return NS_OK;
}


