/*$Id: fkSentence.cpp,v 1.4 2006/08/20 16:39:54 jwrobel Exp $*/
/* ***** BEGIN LICENSE BLOCK *****
 *  This file is part of Firekeeper.
 *
 *  Copyright (C) 2006 Jan Wrobel <wrobel@blues.ath.cx>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License Version 2 as
 *  published by the Free Software Foundation.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * ***** END LICENSE BLOCK ***** */

#include "Error.h"
#include "fkSentence.h"
#include "string.h"
#include "stdlib.h"
#include "nsCRT.h"
#include "nsMemory.h"

NS_IMPL_ISUPPORTS1(fkSentence, fkISentence)


fkSentence::fkSentence(): newBody(nsnull), newHeaders(nsnull), action(AUDIT)
{
	TRACE("constructor %08x", this);
}

fkSentence::~fkSentence()
{
	TRACE("destructor %08x", this);
	if (newBody != nsnull){
		nsMemory::Free(newBody);
		newBody = nsnull;
	}
	if (newHeaders != nsnull){
		nsMemory::Free(newHeaders);
		newHeaders = nsnull;
	}
}


NS_IMETHODIMP fkSentence::GetNewBody(char **aNewBody)
{
	if (!aNewBody)
		return NS_ERROR_NULL_POINTER;
	*aNewBody = nsnull;

	if(newBody){
		*aNewBody = nsCRT::strdup(newBody);	
		if (!*aNewBody)
			return NS_ERROR_OUT_OF_MEMORY;
	}
	return NS_OK;
}

NS_IMETHODIMP fkSentence::SetNewBody(const char *aNewBody)
{
	if (!aNewBody)
		return NS_ERROR_NULL_POINTER;
	
	if (newBody){
		nsMemory::Free(newBody);
	}
	newBody = nsCRT::strdup(aNewBody);
	if (!newBody)
		return NS_ERROR_OUT_OF_MEMORY;

	return NS_OK;
}


NS_IMETHODIMP fkSentence::GetNewHeaders(char **aNewHeaders)
{
	if (!aNewHeaders)
		return NS_ERROR_NULL_POINTER;
	*aNewHeaders = nsnull;

	if(newHeaders){
		*aNewHeaders = nsCRT::strdup(newHeaders);	
		if (!*aNewHeaders)
			return NS_ERROR_OUT_OF_MEMORY;
	}
	return NS_OK;
}

NS_IMETHODIMP fkSentence::SetNewHeaders(const char *aNewHeaders)
{
	if (!aNewHeaders)
		return NS_ERROR_NULL_POINTER;
	
	if (newHeaders){
		nsMemory::Free(newHeaders);
	}
	newHeaders = nsCRT::strdup(aNewHeaders);
	if (!newHeaders)
		return NS_ERROR_OUT_OF_MEMORY;

	return NS_OK;
}

/* attribute long action; */
NS_IMETHODIMP fkSentence::GetAction(PRInt32 *aAction)
{
	if (!aAction)
		return NS_ERROR_NULL_POINTER;
	*aAction = action;
	return NS_OK;
}

NS_IMETHODIMP fkSentence::SetAction(PRInt32 aAction)
{
	action = aAction;
	return NS_OK;
}


PRInt32 fkSentence::GetAction()
{
	return action;
}
