/*
 * License: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is Gesso, an extension for Mozilla Firefox
 *
 * The Initial Developer of the Original Code is Ningjie (Jim) Chen.
 * Portions created by the Initial Developer are Copyright (C) 2007
 * the Initial Developer. All Rights Reserved.
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the License, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the License, the GPL or the LGPL.
 *
 * See MPL.txt for terms of the Mozilla Public License Version 1.1
 * See GPL.txt for terms of the GNU General Public License Version 2.0
 * See LGPL.txt for terms of the GNU Lesser General Public License Version 2.1
 */

#include "stdafx.h"
#include "igesso.h"
#include "gesso.h"
#include "gessoutil.h"

// COM
#include "com/ISimpleDOMText.h"
DEFINE_COMPTR(ISimpleDOMText);


static const nsCID GESSO_CID = {0x8c7cad59, 0xd5e8, 0x4e4d, {0x9b, 0x34, 0x42, 0x55, 0x87, 0x44, 0x38, 0xff}};
static const char GESSO_CONTRACT_ID[] = "@gesso.mozdev.org/gesso;1";

NS_IMPL_ISUPPORTS1(CGesso, iGesso);

NS_GENERIC_FACTORY_SINGLETON_CONSTRUCTOR(CGesso, CGesso::GetInstance);

CGesso *CGesso::m_pGesso = NULL;
CGesso *CGesso::GetInstance() {
	if (m_pGesso == NULL) 
		NS_NEWXPCOM(m_pGesso, CGesso);
	NS_ADDREF(m_pGesso);
	return m_pGesso;
}

/* void init (out BOOL bInit); */
NS_IMETHODIMP CGesso::Init(BOOL *bInit)
{
	if (!m_pTsfMgr) {
		HRESULT hr;
		// initialize com just in case it wasn't
		CoInitializeEx(NULL, COINIT_APARTMENTTHREADED);
		// get text services framework thread manager
		if (FAILED(hr = CoCreateInstance(CLSID_TF_ThreadMgr, NULL, 
			CLSCTX_INPROC_SERVER, IID_ITfThreadMgr, reinterpret_cast<LPVOID*>(&m_pTsfMgr))))
			return H_TO_NSRESULT(hr);
		// activate TSF (must be called from the main/UI thread)
		if (FAILED(hr = m_pTsfMgr->Activate(&m_dwTsfID)))
			return H_TO_NSRESULT(hr);
		*bInit = TRUE;
	} else *bInit = FALSE;
	return NS_OK;
}

/* void term (out BOOL bTerm); */
NS_IMETHODIMP CGesso::Term(BOOL *bTerm)
{
	// deactivate TSF
	if (m_pTsfMgr) {
		m_pTsfMgr->Deactivate();
		m_pTsfMgr = NULL;
		*bTerm = TRUE;
	} else *bTerm = FALSE;
	return NS_OK;
}

/* void addDocument (in iGessoDocument doc, out iGessoDocumentSink sink); */
NS_IMETHODIMP CGesso::AddDocument(iGessoDocument *doc, iGessoDocumentSink **sink)
{
	HRESULT hr;
	// create text store for whatever element (input, textarea, etc.)
	CComObject<CGessoTextStore> *pRawStore;
	if (FAILED(hr = CComObject<CGessoTextStore>::CreateInstance(&pRawStore))) return H_TO_NSRESULT(hr);
	CGessoTextStorePtr pStore = pRawStore; pRawStore = NULL;

	pStore->m_pDoc = doc;

	// create TSF document manager and primary editing context
	ITfDocumentMgrPtr pDocMgr; ITfContextPtr pContext;
	if (FAILED(hr = m_pTsfMgr->CreateDocumentMgr(&pDocMgr))) return H_TO_NSRESULT(hr);
	if (FAILED(hr = pDocMgr->CreateContext(m_dwTsfID, 0, static_cast<IUnknown*>(pStore), 
			&pContext, &pStore->m_dwDefCookie))) return H_TO_NSRESULT(hr);
	if (FAILED(hr = pDocMgr->Push(pContext))) return H_TO_NSRESULT(hr);

	pStore->m_pDocMgr = pDocMgr;

	*sink = pStore; (*sink)->AddRef();
	return NS_OK;
}


// NASTY helper functions 
//  (shouldn't there be better ways in JavaScript, especially when the functions are there but just not exposed?)

NS_IMETHODIMP CGesso::AccTextHas(nsIAccessible *acc, BOOL *bHas)
{
	nsresult nr;
	IAccessiblePtr pAccParent, pAcc;
	if (FAILED(nr = H_TO_NSRESULT(acc->GetNativeInterface(reinterpret_cast<void**>(&pAccParent))))) return nr;
	getText(pAccParent, &pAcc); if (!pAcc) return NS_ERROR_UNEXPECTED;
	IServiceProviderPtr pProvider;
	if (FAILED(nr = H_TO_NSRESULT(pAcc.QueryInterface(&pProvider)))) return nr;
	ISimpleDOMTextPtr pText;
	if (FAILED(nr = H_TO_NSRESULT(pProvider->QueryService(GUID_NULL, __uuidof(ISimpleDOMText), 
		reinterpret_cast<void**>(&pText)))))
		*bHas = FALSE;
	else *bHas = TRUE;
	return NS_OK;
}

void CGesso::getText(IAccessible *pAcc, IAccessible **ppOut)
{
	CComPtr<IEnumVARIANT> pEnum;
	if (SUCCEEDED(pAcc->QueryInterface(__uuidof(IEnumVARIANT), reinterpret_cast<void**>(&pEnum)))) {
		long lCt;
		if (SUCCEEDED(pAcc->get_accChildCount(&lCt))) {
			CComVariant *pVars = new CComVariant[lCt];
			if (pVars) {
				ULONG ulFetched;
				pEnum->Reset();
				if (SUCCEEDED(pEnum->Next(lCt, pVars, &ulFetched))) {
					for (ULONG i = 0; i < ulFetched; ++i) {
						IAccessiblePtr pChild;
						if (SUCCEEDED(pVars[i].pdispVal->QueryInterface(__uuidof(IAccessible), reinterpret_cast<void**>(&pChild)))) {
							IAccessiblePtr pOut;
							getText(pChild, &pOut);
							if (pOut) {
								*ppOut = pOut;
								(*ppOut)->AddRef();
								return;
							}
						}
					}
				}
				delete [] pVars;
			}
		}
	}
	CComVariant varChild = CHILDID_SELF, varRole;
	if (SUCCEEDED(pAcc->get_accRole(varChild, &varRole)) &&
		varRole.lVal == 42) {
		*ppOut = pAcc;
		(*ppOut)->AddRef();
	}
}


// Note: the character offset used by ISimpleDOMText is relative to its own domText property
//  NOT nsIDOMText's, because nsIDOMText usually strips off whitespaces (?)
//  but in this case those two should be equal because nsIDOMText inside an editor leaves
//  whitespaces intact ("pre" style) and therefore should be the same as ISimpleDOMText and domText.

extern const nsIID nsISupportsIID;
/* void accTextGetBounds (in nsIAccessible acc, in LONG start, in LONG end, out BOOL clipped, out iGessoRect bounds); */
NS_IMETHODIMP CGesso::AccTextGetBounds(nsIAccessible *acc, LONG start, LONG end, BOOL *clipped, iGessoRect **bounds)
{
	nsresult nr;
	IAccessiblePtr pAccParent, pAcc;
	if (FAILED(nr = H_TO_NSRESULT(acc->GetNativeInterface(reinterpret_cast<void**>(&pAccParent))))) return nr;
	getText(pAccParent, &pAcc); if (!pAcc) return NS_ERROR_UNEXPECTED;
	IServiceProviderPtr pProvider;
	if (FAILED(nr = H_TO_NSRESULT(pAcc.QueryInterface(&pProvider)))) return nr;
	ISimpleDOMTextPtr pText;
	if (FAILED(nr = H_TO_NSRESULT(pProvider->QueryService(GUID_NULL, __uuidof(ISimpleDOMText), 
		reinterpret_cast<void**>(&pText))))) return nr;

	CGessoRealRect *pRect = new CGessoRealRect();
	if (!pRect) return NS_ERROR_OUT_OF_MEMORY;
	pRect->AddRef();

	int x, y, w, h;
	if (FAILED(nr = H_TO_NSRESULT(pText->get_clippedSubstringBounds( // get clipped first
		static_cast<unsigned int>(start), static_cast<unsigned int>(end), &x, &y, &w, &h)))) return nr;
	pRect->left = x; pRect->top = y; pRect->right = x + w; pRect->bottom = y + h;

	// yes, test for clipping could be done in JavaScript but that's more code to write :)
	if (FAILED(nr = H_TO_NSRESULT(pText->get_unclippedSubstringBounds( // get unclipped to see if clipped
		static_cast<unsigned int>(start), static_cast<unsigned int>(end), &x, &y, &w, &h)))) return nr;
	*clipped = pRect->left != x || pRect->top != y || pRect->right != x + w || pRect->bottom != y + h ? TRUE : FALSE;

	*bounds = static_cast<iGessoRect*>(pRect);
	(*bounds)->AddRef();
	pRect->Release();
    return NS_OK;
}

/* void accTextGetOffset (in nsIAccessible acc, in LONG px, in LONG py, in DWORD dwFlags, in ULONG length, out LONG offset); */
NS_IMETHODIMP CGesso::AccTextGetOffset(nsIAccessible *acc, LONG px, LONG py, DWORD dwFlags, ULONG length, LONG *offset)
{
	nsresult nr;
	IAccessiblePtr pAccParent, pAcc;
	if (FAILED(nr = acc->GetNativeInterface(reinterpret_cast<void**>(&pAccParent)))) return nr;
	getText(pAccParent, &pAcc); if (!pAcc) return NS_ERROR_UNEXPECTED;
	IServiceProviderPtr pProvider;
	if (FAILED(nr = H_TO_NSRESULT(pAcc.QueryInterface(&pProvider)))) return nr;
	ISimpleDOMTextPtr pText;
	if (FAILED(nr = H_TO_NSRESULT(pProvider->QueryService(GUID_NULL, __uuidof(ISimpleDOMText), 
		reinterpret_cast<void**>(&pText))))) return nr;

	int x, y, w, h;
	// must clip to the bounding rectangle of the text view
	// otherwise we might give an offset that's currently out of view
	if (FAILED(nr = H_TO_NSRESULT(pText->get_clippedSubstringBounds(0, length - 1, &x, &y, &w, &h)))) return nr;
	if (dwFlags & GXFPF_NEAREST) { // clip to top and bottom to get the closest offset
		if (py < y) py = y; else if (py >= y + h) py = y + h - 1;
	} else if (px < x || py < y || px >= x + w || py >= y + h) // out of bounds, no offset for you
		return H_TO_NSRESULT(TS_E_INVALIDPOINT);

	// binary search algorithm copied from Wikipedia :)
	long result = -1;
	unsigned int low = 0, high = length - 1;
	while (low <= high) {
		unsigned int mid = (low + high) >> 1;
		if (FAILED(nr = H_TO_NSRESULT(pText->get_unclippedSubstringBounds(
			mid, mid + 1, &x, &y, &w, &h)))) return nr;
		if (py >= y + h || (py >= y && px >= x + w)) high = mid - 1; // greater
		else if (py < y || (py < y + h && px < x)) low = mid + 1; // lesser
		else { // same
			result = mid; 
			break;
		}
		if (low >= mid && mid >= high) { // search ended
			if (dwFlags & GXFPF_NEAREST) result = mid;
			break;
		}
	}
	if (result >= 0) {
		if (dwFlags & GXFPF_ROUND_NEAREST && px - x > x + w - px) *offset = result + 1;
		else *offset = result;
		return NS_OK;
	}
    return H_TO_NSRESULT(TS_E_INVALIDPOINT);
}


static const nsModuleComponentInfo COMPONENTS[] = { {
	"Gesso", GESSO_CID, GESSO_CONTRACT_ID, CGessoConstructor //, CGessoReg, CGessoUnreg
} };


#pragma warning(disable: 4100)
NS_IMPL_NSGETMODULE(Gesso, COMPONENTS);


//**********************************************************
//  COM Stuff
//**********************************************************

class CGessoModule : public CAtlDllModuleT<CGessoModule> {
protected:
	static CGessoModule m_mod;
};
CGessoModule CGessoModule::m_mod;

