#!/bin/bash

# sets up environment for xpi scripts

# get the environment variables from the directory of this script
homedir=`dirname $0`
. $homedir/env.sh

if [[ $3 == '' ]] ; then
 echo syntax:   $scriptname language country mozversion where
 echo \ \ language is the language code - xh/zu/ss
 echo \ \ country is the country code - fi/in/us/za
 echo \ \ mozversion is the mozilla version to use, 1.0 or 1.1
 exit
fi

language=$1
country=$2
mozversion=$3
templatelanguage=en
templatecountry=us

languagepretty=`$homedir/languagenames $language $country`

mozdir=`pwd`
basedir=$mozdir/xpi/
srcdir=$mozdir/dtd/
rdfdir=$mozdir/rdf/
xpidir=$basedir/$mozversion/$language-$country
xpiname=$basedir/`$pythonbin $scriptsdir/lowerargs.py lang$language$country-$mozversion.xpi`
# alternate name for the xpi
# xpiname=$basedir/`$pythonbin $scriptsdir/lowerargs.py $languagepretty-$mozversion.xpi`
chromedir=$xpidir/bin/chrome

