

/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is mozdom4java
 *
 * The Initial Developer of the Original Code is
 * Peter Szinek, Lixto Software GmbH, http://www.lixto.com.
 * Portions created by the Initial Developer are Copyright (C) 2005-2006
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *  Peter Szinek (peter@rubyrailways.com)
 *  Michal Ceresna (michal.ceresna@gmail.com)
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */


package org.mozilla.dom.html;

//Java imports
import java.util.*;

//org.w3c imports
import org.w3c.dom.*;
import org.w3c.dom.html2.*;
import org.w3c.dom.html.*;
import org.w3c.dom.events.*;
import org.w3c.dom.traversal.*;
import org.w3c.dom.ranges.*;
import org.w3c.dom.views.*;

//mozdom4java imports
import org.mozilla.dom.*;
import org.mozilla.dom.views.*;

//XPCOM import
import org.mozilla.xpcom.*;


public class HTMLInputElementImpl extends HTMLElementImpl implements org.w3c.dom.html.HTMLInputElement
{
    protected HTMLInputElementImpl(nsIDOMHTMLInputElement mozInst)
    {
        super( mozInst );
    }

    public static HTMLInputElementImpl getDOMInstance(nsIDOMHTMLInputElement mozInst)
    {
        HTMLInputElementImpl node = (HTMLInputElementImpl) instances.get(mozInst);
        return node == null ? new HTMLInputElementImpl(mozInst) : node;
    }
    
    public nsIDOMHTMLInputElement getInstance()
    {
        //This was already queryinterfaced, so safe to cast
        return (nsIDOMHTMLInputElement) moz;
    }
    
    public HTMLFormElement getForm()
    {
        nsIDOMHTMLFormElement result = getInstance().getForm();
        return (HTMLFormElement) NodeFactory.getNodeInstance(result);
    }
    
    public void focus()
    {
        getInstance().focus();
    }
    
    public String getSize()
    {
        long result = getInstance().getSize();
        return new Long(result).toString();        
    }
    
    public String getAlt()
    {
        String result = getInstance().getAlt();
        return result;
    }
    
    public boolean getDefaultChecked()
    {
        boolean result = getInstance().getDefaultChecked();
        return result;
    }
    
    public boolean getChecked()
    {
        boolean result = getInstance().getChecked();
        return result;
    }
    
    public void select()
    {
        getInstance().select();
    }
    
    public String getAccept()
    {
        String result = getInstance().getAccept();
        return result;
    }
    
    public void setValue(String value)
    {
        getInstance().setValue(value);
    }
    
    public String getName()
    {
        String result = getInstance().getName();
        return result;
    }
    
    public boolean getReadOnly()
    {
        boolean result = getInstance().getReadOnly();
        return result;
    }
    
    public void click()
    {
        getInstance().click();
    }
    
    public void setChecked(boolean checked)
    {
        getInstance().setChecked(checked);
    }
    
    public void setDefaultChecked(boolean defaultChecked)
    {
        getInstance().setDefaultChecked(defaultChecked);
    }
    
    public void setTabIndex(int tabIndex)
    {
        getInstance().setTabIndex(tabIndex);
    }
    
    public String getAccessKey()
    {
        String result = getInstance().getAccessKey();
        return result;
    }
    
    public void setSrc(String src)
    {
        getInstance().setSrc(src);
    }
    
    public String getDefaultValue()
    {
        String result = getInstance().getDefaultValue();
        return result;
    }
    
    public void setName(String name)
    {
        getInstance().setName(name);
    }
    
    public void setAlign(String align)
    {
        getInstance().setAlign(align);
    }
    
    public void setDefaultValue(String defaultValue)
    {
        getInstance().setDefaultValue(defaultValue);
    }
    
    public String getType()
    {
        String result = getInstance().getType();
        return result;
    }
    
    public void setAccessKey(String accessKey)
    {
        getInstance().setAccessKey(accessKey);
    }
    
    public void setUseMap(String useMap)
    {
        getInstance().setUseMap(useMap);
    }
    
    public String getAlign()
    {
        String result = getInstance().getAlign();
        return result;
    }
    
    public int getTabIndex()
    {
        int result = getInstance().getTabIndex();
        return result;
    }
    
    public void setAccept(String accept)
    {
        getInstance().setAccept(accept);
    }
    
    public String getUseMap()
    {
        String result = getInstance().getUseMap();
        return result;
    }
    
    public int getMaxLength()
    {
        int result = getInstance().getMaxLength();
        return result;
    }
    
    public String getSrc()
    {
        String result = getInstance().getSrc();
        return result;
    }
    
    public String getValue()
    {
        String result = getInstance().getValue();
        return result;
    }
    
    public void setReadOnly(boolean readOnly)
    {
        getInstance().setReadOnly(readOnly);
    }
    
    public void setMaxLength(int maxLength)
    {
        getInstance().setMaxLength(maxLength);
    }
    
    public void setDisabled(boolean disabled)
    {
        getInstance().setDisabled(disabled);
    }
    
    public boolean getDisabled()
    {
        boolean result = getInstance().getDisabled();
        return result;
    }
    
    public void setSize(String size)
    {
        getInstance().setSize(new Long(size).intValue());
    }
    
    public void blur()
    {
        getInstance().blur();
    }
    
    public void setAlt(String alt)
    {
        getInstance().setAlt(alt);
    }
    
}
