

/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is mozdom4java
 *
 * The Initial Developer of the Original Code is
 * Peter Szinek, Lixto Software GmbH, http://www.lixto.com.
 * Portions created by the Initial Developer are Copyright (C) 2005-2006
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *  Peter Szinek (peter@rubyrailways.com)
 *  Michal Ceresna (michal.ceresna@gmail.com)
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */


package org.mozilla.dom;

//Java imports
import java.util.*;

//org.w3c imports
import org.w3c.dom.*;
import org.w3c.dom.html2.*;
import org.w3c.dom.html.*;
import org.w3c.dom.events.*;
import org.w3c.dom.traversal.*;
import org.w3c.dom.ranges.*;
import org.w3c.dom.views.*;

//mozdom4java imports
import org.mozilla.dom.*;
import org.mozilla.dom.views.*;

//XPCOM import
import org.mozilla.xpcom.*;
import org.mozilla.interfaces.*;


public class ElementImpl extends NodeImpl implements org.w3c.dom.Element
{
    protected ElementImpl(nsIDOMElement mozInst)
    {
        super( mozInst );
    }

    public static ElementImpl getDOMInstance(nsIDOMElement mozInst)
    {
        ElementImpl node = (ElementImpl) instances.get(mozInst);
        return node == null ? new ElementImpl(mozInst) : node;
    }
    
    public nsIDOMElement getInstance()
    {
        //This was already queryinterfaced, so safe to cast
        return (nsIDOMElement) moz;
    }
    
    public void removeAttributeNS(String namespaceURI, String localName)
    {
        getInstance().removeAttributeNS(namespaceURI, localName);
    }
    
    public TypeInfo getSchemaTypeInfo()
    {
        throw new UnsupportedException();
    }
    
    public boolean hasAttributeNS(String namespaceURI, String localName)
    {
        boolean result = getInstance().hasAttributeNS(namespaceURI, localName);
        return result;
    }
    
    public void removeAttribute(String name)
    {
        getInstance().removeAttribute(name);
    }
    
    public String getAttribute(String name)
    {
        String result = getInstance().getAttribute(name);
        /* Case insensitivity patch */
        if (result == null)
	    return null;
        if (NodeFactory.getConvertNodeNamesToLowerCase())
            return result.toLowerCase();
        else
            return result;
    }
    
    public NodeList getElementsByTagName(String name)
    {
        nsIDOMNodeList result = getInstance().getElementsByTagName(name);
        return new NodeListImpl(result);
    }
    
    public Attr setAttributeNodeNS(Attr newAttr)
    {
        nsIDOMAttr mozNewattr = ((AttrImpl) newAttr).getInstance();
        nsIDOMAttr result = getInstance().setAttributeNodeNS(mozNewattr);
        return (Attr) NodeFactory.getNodeInstance(result);
    }
    
    public void setAttribute(String name, String value)
    {
        getInstance().setAttribute(name, value);
    }
    
    public NodeList getElementsByTagNameNS(String namespaceURI, String localName)
    {
        nsIDOMNodeList result = getInstance().getElementsByTagNameNS(namespaceURI, localName);
        return new NodeListImpl(result);
    }
    
    public String getTagName()
    {
        String result = getInstance().getTagName();
        /* Case insensitivity patch */
        if (NodeFactory.getConvertNodeNamesToLowerCase())
            return result.toLowerCase();
        else
            return result;
    }
    
    public Attr getAttributeNode(String name)
    {
        nsIDOMAttr result = getInstance().getAttributeNode(name);
        return (Attr) NodeFactory.getNodeInstance(result);
    }
    
    public void setIdAttributeNode(Attr idAttr, boolean isId)
    {
        nsIDOMAttr mozIdattr = ((AttrImpl) idAttr).getInstance();
        throw new UnsupportedException();
    }
    
    public Attr getAttributeNodeNS(String namespaceURI, String localName)
    {
        nsIDOMAttr result = getInstance().getAttributeNodeNS(namespaceURI, localName);
        return (Attr) NodeFactory.getNodeInstance(result);
    }
    
    public Attr setAttributeNode(Attr newAttr)
    {
        nsIDOMAttr mozNewattr = ((AttrImpl) newAttr).getInstance();
        nsIDOMAttr result = getInstance().setAttributeNode(mozNewattr);
        return (Attr) NodeFactory.getNodeInstance(result);
    }
    
    public void setAttributeNS(String namespaceURI, String qualifiedName, String value)
    {
        getInstance().setAttributeNS(namespaceURI, qualifiedName, value);
    }
    
    public void setIdAttribute(String name, boolean isId)
    {
        throw new UnsupportedException();
    }
    
    public boolean hasAttribute(String name)
    {
        boolean result = getInstance().hasAttribute(name);
        return result;
    }
    
    public String getAttributeNS(String namespaceURI, String localName)
    {
        String result = getInstance().getAttributeNS(namespaceURI, localName);
        return result;
    }
    
    public void setIdAttributeNS(String namespaceURI, String localName, boolean isId)
    {
        throw new UnsupportedException();
    }
    
    public Attr removeAttributeNode(Attr oldAttr)
    {
        nsIDOMAttr mozOldattr = ((AttrImpl) oldAttr).getInstance();
        nsIDOMAttr result = getInstance().removeAttributeNode(mozOldattr);
        return (Attr) NodeFactory.getNodeInstance(result);
    }
    
}
