/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.dom.events;

import java.util.concurrent.Callable;
import org.mozilla.dom.NodeFactory;
import org.mozilla.dom.ThreadProxy;
import org.mozilla.dom.WeakValueHashMap;
import org.mozilla.interfaces.nsIDOMEvent;
import org.mozilla.interfaces.nsIDOMEventTarget;
import org.mozilla.interfaces.nsISupports;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventTarget;

public class EventImpl
implements Event {
    protected nsISupports moz;
    protected static WeakValueHashMap instances = new WeakValueHashMap();

    public nsIDOMEvent getInstance() {
        return this.getInstanceAsnsIDOMEvent();
    }

    protected EventImpl(nsISupports mozInst) {
        this.moz = mozInst;
        instances.put(mozInst, this);
    }

    public EventImpl(nsIDOMEvent mozInst) {
        this((nsISupports)mozInst);
    }

    public static EventImpl getDOMInstance(nsIDOMEvent mozInst) {
        EventImpl node = (EventImpl)instances.get(mozInst);
        return node == null ? new EventImpl(mozInst) : node;
    }

    public nsIDOMEvent getInstanceAsnsIDOMEvent() {
        if (this.moz == null) {
            return null;
        }
        return (nsIDOMEvent)this.moz.queryInterface("{a66b7b80-ff46-bd97-0080-5f8ae38add32}");
    }

    public boolean getCancelable() {
        Callable<Boolean> c = new Callable<Boolean>(){

            @Override
            public Boolean call() {
                boolean result = EventImpl.this.getInstanceAsnsIDOMEvent().getCancelable();
                return result;
            }
        };
        return ThreadProxy.getSingleton().syncExec(c);
    }

    public short getEventPhase() {
        Callable<Short> c = new Callable<Short>(){

            @Override
            public Short call() {
                int result = EventImpl.this.getInstanceAsnsIDOMEvent().getEventPhase();
                return (short)result;
            }
        };
        return ThreadProxy.getSingleton().syncExec(c);
    }

    public String getType() {
        Callable<String> c = new Callable<String>(){

            @Override
            public String call() {
                String result = EventImpl.this.getInstanceAsnsIDOMEvent().getType();
                return result;
            }
        };
        return ThreadProxy.getSingleton().syncExec(c);
    }

    public EventTarget getTarget() {
        Callable<EventTarget> c = new Callable<EventTarget>(){

            @Override
            public EventTarget call() {
                nsIDOMEventTarget result = EventImpl.this.getInstanceAsnsIDOMEvent().getTarget();
                return (EventTarget)((Object)NodeFactory.getNodeInstance(result));
            }
        };
        return ThreadProxy.getSingleton().syncExec(c);
    }

    public void initEvent(final String eventTypeArg, final boolean canBubbleArg, final boolean cancelableArg) {
        Runnable r = new Runnable(){

            public void run() {
                EventImpl.this.getInstanceAsnsIDOMEvent().initEvent(eventTypeArg, canBubbleArg, cancelableArg);
            }
        };
        ThreadProxy.getSingleton().syncExec(r);
    }

    public void preventDefault() {
        Runnable r = new Runnable(){

            public void run() {
                EventImpl.this.getInstanceAsnsIDOMEvent().preventDefault();
            }
        };
        ThreadProxy.getSingleton().syncExec(r);
    }

    public long getTimeStamp() {
        Callable<Long> c = new Callable<Long>(){

            @Override
            public Long call() {
                double result = EventImpl.this.getInstanceAsnsIDOMEvent().getTimeStamp();
                return (long)result;
            }
        };
        return ThreadProxy.getSingleton().syncExec(c);
    }

    public EventTarget getCurrentTarget() {
        Callable<EventTarget> c = new Callable<EventTarget>(){

            @Override
            public EventTarget call() {
                nsIDOMEventTarget result = EventImpl.this.getInstanceAsnsIDOMEvent().getCurrentTarget();
                return (EventTarget)((Object)NodeFactory.getNodeInstance(result));
            }
        };
        return ThreadProxy.getSingleton().syncExec(c);
    }

    public boolean getBubbles() {
        Callable<Boolean> c = new Callable<Boolean>(){

            @Override
            public Boolean call() {
                boolean result = EventImpl.this.getInstanceAsnsIDOMEvent().getBubbles();
                return result;
            }
        };
        return ThreadProxy.getSingleton().syncExec(c);
    }

    public void stopPropagation() {
        Runnable r = new Runnable(){

            public void run() {
                EventImpl.this.getInstanceAsnsIDOMEvent().stopPropagation();
            }
        };
        ThreadProxy.getSingleton().syncExec(r);
    }
}

