/*
 * Decompiled with CFR 0.152.
 */
package org.mozdev.multexi.utils;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import org.mozdev.multexi.conf.Configuration;
import org.mozdev.multexi.utils.UtilException;

public class VFS {
    private static final String TMP_DIR = "/tmp";
    public static final String SEPARATOR = "/";
    private static final String TMP_FILE_PREFIX = "VFS_TMP_";
    private String rootDirectory = Configuration.get((String)"CFG_ABSOLUTE_PATH");
    private String cwd;

    public VFS() {
        if (this.rootDirectory == null) {
            throw new RuntimeException("Missing configuration parameter: ".concat("CFG_ABSOLUTE_PATH"));
        }
        this.cwd = this.rootDirectory = this.rootDirectory.concat(SEPARATOR);
    }

    public VFS(String relCwd) {
        this();
        this.chdir(relCwd);
    }

    protected String createPath(String path) {
        if (path.length() > 0 && path.charAt(0) == '/') {
            return this.rootDirectory.concat(SEPARATOR).concat(path);
        }
        return this.cwd.concat(SEPARATOR).concat(path);
    }

    public boolean chdir(String path) {
        String newPath = this.createPath(path);
        File file = new File(newPath);
        if (!file.exists() || !file.isDirectory()) {
            return false;
        }
        this.cwd = newPath;
        return true;
    }

    public boolean chdir(File path) {
        if (!path.exists() || !path.isDirectory()) {
            return false;
        }
        this.cwd = path.getAbsolutePath();
        return true;
    }

    public File getFile(String path, boolean create) {
        File result = new File(this.cwd.concat(SEPARATOR).concat(path));
        if (!result.exists()) {
            if (create) {
                try {
                    if (!result.createNewFile()) {
                        return null;
                    }
                    return result;
                }
                catch (IOException e) {
                    return null;
                }
            }
            return null;
        }
        return result;
    }

    public boolean removeFile(File file) {
        if (file.exists()) {
            return file.delete();
        }
        return false;
    }

    protected File verifyTmpDir() {
        File dirFile = new File(this.rootDirectory.concat(SEPARATOR).concat(TMP_DIR));
        if (!dirFile.exists() && !dirFile.mkdir()) {
            throw new RuntimeException("Couldn't create temporary directory: ".concat(dirFile.getAbsolutePath()));
        }
        return dirFile;
    }

    public File createTmp(String suffix) {
        File tmpFile;
        File dirFile = this.verifyTmpDir();
        try {
            tmpFile = File.createTempFile(TMP_FILE_PREFIX, suffix, dirFile);
        }
        catch (IOException e) {
            return null;
        }
        return tmpFile;
    }

    public File createTmpDir() {
        this.verifyTmpDir();
        StringBuffer path = new StringBuffer(this.rootDirectory);
        path.append(SEPARATOR);
        path.append(TMP_DIR);
        path.append(SEPARATOR);
        path.append(new Long(System.currentTimeMillis()).toString());
        path.append(new Double(Math.random()).toString());
        File dirFile = new File(path.toString());
        if (!dirFile.mkdir()) {
            return null;
        }
        return dirFile;
    }

    protected String cleanUrlPath(StringBuffer path) {
        String pathNew = path.toString();
        pathNew = pathNew.replaceAll("//", SEPARATOR);
        pathNew = pathNew.replaceFirst(":/", "://");
        return pathNew;
    }

    public URL createDownloadUrl(String relFile) throws UtilException {
        StringBuffer baseUrl = new StringBuffer(Configuration.get((String)"multexi.extension.server.downloadUrl"));
        String relCwd = this.cwd.substring(this.rootDirectory.length() + 1);
        if (baseUrl == null) {
            throw new UtilException("Missing conifguration variable: ".concat("multexi.extension.server.downloadUrl"));
        }
        baseUrl.append(relCwd);
        baseUrl.append(SEPARATOR);
        baseUrl.append(relFile);
        try {
            return new URL(this.cleanUrlPath(baseUrl));
        }
        catch (MalformedURLException e) {
            throw new UtilException((Throwable)e);
        }
    }

    public String getCwd() {
        return this.cwd;
    }

    public String getRootDirectory() {
        return this.rootDirectory;
    }
}

