/*
 * @(#)UrlClassLoaderJDK12UTest.java      0.9.0 23-May-2001 - 14:40
 *
 * Copyright (C) 2001,2002-2003 Matt Albrecht
 * groboclown@users.sourceforge.net
 * http://groboutils.sourceforge.net
 *
 *  Permission is hereby granted, free of charge, to any person obtaining a
 *  copy of this software and associated documentation files (the "Software"),
 *  to deal in the Software without restriction, including without limitation
 *  the rights to use, copy, modify, merge, publish, distribute, sublicense,
 *  and/or sell copies of the Software, and to permit persons to whom the 
 *  Software is furnished to do so, subject to the following conditions:
 *
 *  The above copyright notice and this permission notice shall be included in 
 *  all copies or substantial portions of the Software. 
 *
 *  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 *  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL 
 *  THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 *  FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
 *  DEALINGS IN THE SOFTWARE.
 */

package net.sourceforge.groboutils.util.classes.v1.jdk2;

import net.sourceforge.groboutils.util.classes.v1.*;
import net.sourceforge.groboutils.junit.v1.iftc.*;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

import java.net.URL;


/**
 * Just like util.http.tests, this uses the Sourceforge account to ensure
 * that the URLs work correctly.  It loads the sample applet "BeliefOfTheDay"
 * to make sure that this is able to load classes remotely.
 * As insurance, this also tests to make sure that the same applet is not
 * in the current classpath.
 *
 * @author    Matt Albrecht <a href="mailto:groboclown@users.sourceforge.net">groboclown@users.sourceforge.net</a>
 * @version   $Date: 2003/05/06 05:35:01 $
 * @since     May 23, 2001
 */
public class UrlClassLoaderJDK12UTest extends TestCase
{
    private static final Class THIS_CLASS = UrlClassLoaderJDK12UTest.class;
    
    public UrlClassLoaderJDK12UTest( String name )
    {
        super( name );
    }
    
    public static Test suite()
    {
        InterfaceTestSuite suite = IUrlClassLoaderUTestI.suite();
        suite.addTestSuite( THIS_CLASS );
        suite.addFactory( new CxFactory( "A" ) {
            public Object createImplObject() {
                return createLoader();
            }
        } );
        
        return suite;
    }
    
    public static void main( String[] args )
    {
        String[] name = { THIS_CLASS.getName() };
        
        // junit.textui.TestRunner.main( name );
        // junit.swingui.TestRunner.main( name );
        
        junit.textui.TestRunner.main( name );
    }
    
    protected void setUp() throws Exception
    {
        super.setUp();
        
        // set ourself up
    }
    
    
    protected void tearDown() throws Exception
    {
        // tear ourself down
        
        super.tearDown();
    }

    
    protected static UrlClassLoader createLoader()
    {
        return new UrlClassLoader();
    }
    
    
    //---------------------------------------
    // Super class has many base tests
    
    public void testConvertUrl1()
    {
        assertNull(
            "returned URL must be null.",
            createLoader().convertUrl( null ) );
    }
    
    
    public void testConvertUrl2()
    {
        URL url = createLoader().convertUrl( "http://yo.mama" );
        assertNotNull(
            "convertURL returned null.",
            url );
        // JDK 1.2 adds an extra '/' to the end of the URL
        if (!url.toString().equals( "http://yo.mama" )
            && !url.toString().equals( "http://yo.mama/" ))
        {
            fail("convertURL did not format right: it returned '"+
                url.toString()+"'");
        }
    }
    
    
    public void testConvertUrl3()
    {
        URL url = createLoader().convertUrl( "afile.txt" );
        assertNotNull(
            "convertURL returned null.",
            url );
        assertEquals(
            "convertURL did not format right.",
            url.toString(),
            "file:afile.txt" );
    }
}
