/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.panel;

import com.sun.deploy.config.Config;
import com.sun.deploy.panel.BasicDialog;
import com.sun.deploy.panel.ControlPanel;
import com.sun.deploy.panel.JSmartTextArea;
import com.sun.deploy.panel.SecurityLevel;
import com.sun.deploy.panel.SecurityProperties;
import com.sun.deploy.panel.SettingsDialog;
import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.ui.FancyButton;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Hashtable;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class SecurityLevelPanel
extends JPanel
implements SecurityProperties.JavaEnableListener {
    private JButton customSettingButton;
    private JSlider slider;
    private JSmartTextArea text;
    private boolean sliderStateChanged;
    static final int SPACE = 46;

    public SecurityLevelPanel() {
        this.initComponents();
    }

    private void initComponents() {
        this.setBorder(new EmptyBorder(new Insets(5, 15, 5, 15)));
        Box box = Box.createVerticalBox();
        box.add(this.createSecurityLabel());
        JComponent jComponent = this.getSliderPanel();
        JComponent jComponent2 = this.overlaySettingsButton(jComponent);
        box.add(jComponent2);
        box.add(this.createTextComponent());
        box.add(SecurityLevelPanel.createHyperLink());
        this.add(box);
    }

    private JComponent createSecurityLabel() {
        Box box = Box.createHorizontalBox();
        JLabel jLabel = new JLabel(ResourceManager.getMessage("deployment.security.level.title"));
        box.add(Box.createRigidArea(new Dimension(10, jLabel.getPreferredSize().height)));
        box.add(jLabel);
        box.add(Box.createHorizontalGlue());
        return box;
    }

    private JComponent createTextComponent() {
        Box box = Box.createHorizontalBox();
        this.text = new JSmartTextArea("");
        this.text.preferred_width = this.text.preferred_width - 46 - 5;
        int n = this.text.getPreferredSize().height * 2;
        this.text.setPreferredSize(new Dimension(this.text.preferred_width, n));
        box.add(Box.createRigidArea(new Dimension(46, n)));
        this.text.setText(SecurityProperties.getProposedSecurityLevel().getDescription());
        box.add(this.text);
        return box;
    }

    public static JComponent createHyperLink() {
        Box box = Box.createHorizontalBox();
        FancyButton fancyButton = new FancyButton(ResourceManager.getMessage("deployment.security.level.linkto.advanced"), ResourceManager.getMnemonic("deployment.security.level.linkto.advanced"), Color.BLUE);
        Dimension dimension = fancyButton.getPreferredSize();
        fancyButton.setPreferredSize(new Dimension(dimension.width + 10, dimension.height));
        box.setAlignmentX(1.0f);
        box.add(Box.createRigidArea(new Dimension(41, fancyButton.getPreferredSize().height)));
        fancyButton.addActionListener(new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                ControlPanel.showPanel("advanced");
            }
        });
        box.add(fancyButton);
        return box;
    }

    private JComponent overlaySettingsButton(JComponent jComponent) {
        JLayeredPane jLayeredPane = new JLayeredPane();
        Dimension dimension = jComponent.getPreferredSize();
        jLayeredPane.setPreferredSize(dimension);
        jComponent.setBounds(0, 0, dimension.width, dimension.height);
        jLayeredPane.add((Component)jComponent, JLayeredPane.DEFAULT_LAYER);
        this.customSettingButton = new JButton(ResourceManager.getMessage("deployment.security.settings.button"));
        Dimension dimension2 = this.customSettingButton.getPreferredSize();
        this.customSettingButton.setBounds(dimension.width - dimension2.width - 5, dimension.height - dimension2.height - 5, dimension2.width, dimension2.height);
        this.customSettingButton.setEnabled(SecurityProperties.getProposedSecurityLevel().isCustomLevel());
        jLayeredPane.add((Component)this.customSettingButton, JLayeredPane.POPUP_LAYER);
        this.customSettingButton.addActionListener(new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                SettingsDialog settingsDialog = new SettingsDialog((JFrame)SecurityLevelPanel.this.getTopLevelAncestor(), true);
                settingsDialog.setLocationRelativeTo(SecurityLevelPanel.this);
                settingsDialog.setVisible(true);
            }
        });
        return jLayeredPane;
    }

    private JComponent getSliderPanel() {
        JPanel jPanel = new JPanel();
        Box box = Box.createHorizontalBox();
        JComponent jComponent = this.createSlider();
        Dimension dimension = jComponent.getPreferredSize();
        jPanel.add(jComponent);
        JComponent jComponent2 = this.createLevelIconsPanel(dimension);
        box.add(jComponent2);
        box.add(jComponent);
        jPanel.add(box);
        return jPanel;
    }

    private JComponent createLevelIconsPanel(Dimension dimension) {
        Box box = Box.createVerticalBox();
        int n = (int)(dimension.getHeight() / 5.0);
        ImageIcon imageIcon = ResourceManager.getIcon("security.images.gear");
        ImageIcon imageIcon2 = ResourceManager.getIcon("security.images.open.lock");
        ImageIcon imageIcon3 = ResourceManager.getIcon("security.images.secure.lock");
        int n2 = 32;
        JLabel jLabel = new JLabel(imageIcon);
        jLabel.setPreferredSize(new Dimension(n2, n));
        JLabel jLabel2 = new JLabel(imageIcon2);
        jLabel2.setPreferredSize(new Dimension(n2, n));
        JLabel jLabel3 = new JLabel(imageIcon3);
        jLabel3.setPreferredSize(new Dimension(n2, n));
        box.add(jLabel3);
        box.add(Box.createGlue());
        box.add(Box.createRigidArea(new Dimension(n2, n)));
        box.add(Box.createGlue());
        box.add(Box.createRigidArea(new Dimension(n2, n)));
        box.add(Box.createGlue());
        box.add(jLabel2);
        box.add(Box.createGlue());
        box.add(jLabel);
        return box;
    }

    private JComponent createSlider() {
        this.slider = new JSlider();
        this.slider.setOrientation(1);
        this.slider.setMinimum(SecurityLevel.Custom.getSliderSetting());
        this.slider.setMaximum(SecurityLevel.VeryHigh.getSliderSetting());
        Hashtable<Integer, JLabel> hashtable = new Hashtable<Integer, JLabel>();
        SecurityLevel securityLevel = SecurityLevel.VeryHigh;
        hashtable.put(new Integer(securityLevel.getSliderSetting()), new JLabel(securityLevel.getName()));
        securityLevel = SecurityLevel.High;
        hashtable.put(new Integer(securityLevel.getSliderSetting()), new JLabel(securityLevel.getName()));
        securityLevel = SecurityLevel.Medium;
        hashtable.put(new Integer(securityLevel.getSliderSetting()), new JLabel(securityLevel.getName()));
        securityLevel = SecurityLevel.Low;
        ImageIcon imageIcon = ResourceManager.getIcon("security.images.warning");
        JLabel jLabel = new JLabel(securityLevel.getName(), imageIcon, 10);
        jLabel.setHorizontalTextPosition(10);
        hashtable.put(new Integer(securityLevel.getSliderSetting()), jLabel);
        securityLevel = SecurityLevel.Custom;
        JLabel jLabel2 = new JLabel(securityLevel.getName());
        hashtable.put(new Integer(securityLevel.getSliderSetting()), jLabel2);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        this.slider.setLabelTable(hashtable);
        this.slider.setPaintTicks(true);
        this.slider.setPaintLabels(true);
        this.slider.setSnapToTicks(true);
        this.slider.setMinorTickSpacing(1);
        this.slider.setValue(SecurityProperties.getProposedSecurityLevel().getSliderSetting());
        Dimension dimension = this.slider.getPreferredSize();
        this.slider.setPreferredSize(new Dimension(dimension.width + 40, dimension.height - 20));
        this.slider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                SecurityLevelPanel.this.sliderStateChanged = true;
            }
        });
        this.slider.addMouseListener(new MouseAdapter(){

            public void mouseReleased(MouseEvent mouseEvent) {
                SecurityLevelPanel.this.setSlider();
                SecurityLevelPanel.this.sliderStateChanged = false;
            }
        });
        this.slider.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent keyEvent) {
                SecurityLevelPanel.this.setSlider();
                SecurityLevelPanel.this.sliderStateChanged = false;
            }
        });
        this.slider.setEnabled(SecurityProperties.isJavaInBrowserEnabled() && !Config.get().isPropertyLocked("deployment.security.level"));
        SecurityProperties.addJavaEnableListener(this);
        return this.slider;
    }

    public void javaEnableChanged(SecurityProperties.JavaEnableEvent javaEnableEvent) {
        this.slider.setEnabled(javaEnableEvent.isEnabled() && !Config.get().isPropertyLocked("deployment.security.level"));
        this.slider.invalidate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setSlider() {
        try {
            SecurityLevel securityLevel = SecurityProperties.getProposedSecurityLevel();
            int n = this.slider.getValue();
            SecurityLevel securityLevel2 = SecurityLevel.getSliderSetting(n);
            if (this.sliderStateChanged && securityLevel2 != securityLevel) {
                if (SecurityProperties.getCurrentSecurityLevel() != SecurityLevel.Low && securityLevel2.equals(SecurityLevel.Low) && !this.confirmLowSettingDialog()) {
                    this.slider.setValue(securityLevel.getSliderSetting());
                    this.text.setText(securityLevel.getDescription());
                    Object var5_4 = null;
                    this.sliderStateChanged = false;
                    return;
                }
                SecurityProperties.setProposedSecurityLevel(n);
                this.customSettingButton.setEnabled(n == SecurityLevel.Custom.getSliderSetting());
                this.text.setText(securityLevel2.getDescription());
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            this.sliderStateChanged = false;
            throw throwable;
        }
        Object var5_5 = null;
        this.sliderStateChanged = false;
    }

    private boolean confirmLowSettingDialog() {
        SecurityLevelChangedDialog securityLevelChangedDialog = new SecurityLevelChangedDialog(null);
        securityLevelChangedDialog.setLocationRelativeTo(this);
        securityLevelChangedDialog.setVisible(true);
        return securityLevelChangedDialog.isOK();
    }

    private class SecurityLevelChangedDialog
    extends BasicDialog {
        private boolean isOK = false;

        SecurityLevelChangedDialog(JFrame jFrame) {
            super(jFrame, SecurityLevelChangedDialog.getMessage("deployment.security.slider.low.title"), true);
        }

        protected JComponent createContentPanel() {
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new FlowLayout(3));
            ImageIcon imageIcon = ResourceManager.getIcon("warning48.image");
            JLabel jLabel = new JLabel(imageIcon);
            jLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 16));
            jPanel.add(jLabel);
            JSmartTextArea jSmartTextArea = new JSmartTextArea(SecurityLevelChangedDialog.getMessage("deployment.security.slider.low.description"));
            jSmartTextArea.preferred_width = 280;
            jSmartTextArea.setFont(jSmartTextArea.getFont().deriveFont(1));
            jPanel.add(jSmartTextArea);
            jPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 16, 0));
            return jPanel;
        }

        protected void okAction() {
            this.isOK = true;
            this.closeDialog();
        }

        private boolean isOK() {
            return this.isOK;
        }
    }
}

