/*
 * Decompiled with CFR 0.152.
 */
package demo.cms;

import demo.DemoUtil;
import demo.keystore.CMSKeyStore;
import iaik.asn1.ASN1Object;
import iaik.asn1.CodingException;
import iaik.asn1.ObjectID;
import iaik.asn1.SEQUENCE;
import iaik.asn1.UTF8String;
import iaik.asn1.structures.AlgorithmID;
import iaik.asn1.structures.Attribute;
import iaik.asn1.structures.ChoiceOfTime;
import iaik.asn1.structures.GeneralName;
import iaik.asn1.structures.GeneralNames;
import iaik.asn1.structures.Name;
import iaik.asn1.structures.PolicyInformation;
import iaik.asn1.structures.PolicyQualifierInfo;
import iaik.cms.CMSException;
import iaik.cms.CertificateIdentifier;
import iaik.cms.IssuerAndSerialNumber;
import iaik.cms.SignedData;
import iaik.cms.SubjectKeyID;
import iaik.cms.Utils;
import iaik.pkcs.PKCSException;
import iaik.pkcs.pkcs7.SignedDataStream;
import iaik.pkcs.pkcs7.SignerInfo;
import iaik.smime.ess.SigningCertificate;
import iaik.utils.CryptoUtils;
import iaik.utils.StreamCopier;
import iaik.x509.X509Certificate;
import iaik.x509.X509ExtensionException;
import iaik.x509.attr.AttCertIssuer;
import iaik.x509.attr.AttributeCertificate;
import iaik.x509.attr.Holder;
import iaik.x509.attr.V1Form;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.SignatureException;
import java.security.cert.Certificate;
import java.util.Date;
import java.util.GregorianCalendar;

public class PKCS7CMSSignedData {
    PrivateKey issuer1_pk;
    Certificate[] user1Certs;
    Certificate[] certs;
    Certificate[] certificates;
    PrivateKey user3_pk;
    X509Certificate user3;
    PrivateKey user2_pk;
    X509Certificate user2;
    PrivateKey user1_pk;
    X509Certificate user1;

    public void start() {
        String string = "This is the test message.";
        System.out.println("Test message: \"" + string + "\"");
        System.out.println();
        byte[] byArray = string.getBytes();
        try {
            byte[] byArray2 = null;
            System.out.println("Stream implementation demos");
            System.out.println("===========================");
            System.out.println("\nImplicit SignedDataStream demo [create]:\n");
            byte[] byArray3 = this.createSignedDataStream(byArray, 1, false);
            System.out.println("\nImplicit SignedDataStream demo [parse]:\n");
            byArray2 = this.getSignedDataStream(byArray3, null, false);
            System.out.print("\nSigned content: ");
            System.out.println(new String(byArray2));
            System.out.println("\nExplicit SignedDataStream demo [create]:\n");
            byArray3 = this.createSignedDataStream(byArray, 2, false);
            System.out.println("\nExplicit SignedDataStream demo [parse]:\n");
            byArray2 = this.getSignedDataStream(byArray3, byArray, false);
            System.out.print("\nSigned content: ");
            System.out.println(new String(byArray2));
            System.out.println("\nNow checking against PKCS#7...");
            System.out.println("\nCreating implicit CMS SignedDataStream: \n");
            byArray3 = this.createSignedDataStream(byArray, 1, true);
            System.out.println("\nParse implicit CMS SignedDataStream with PKCS#7:\n");
            byArray2 = this.getPKCS7SignedDataStream(byArray3, null);
            System.out.print("\nSigned content: ");
            System.out.println(new String(byArray2));
            System.out.println("\nCreating explicit CMS SignedDataStream: \n");
            byArray3 = this.createSignedDataStream(byArray, 2, true);
            System.out.println("\nParse explicit CMS SignedDataStream SignedDataStream with PKCS#7:\n");
            byArray2 = this.getPKCS7SignedDataStream(byArray3, byArray);
            System.out.print("\nSigned content: ");
            System.out.println(new String(byArray2));
            System.out.println("\nCreating implicit PKCS#7 SignedDataStream: \n");
            byArray3 = this.createPKCS7SignedDataStream(byArray, 1);
            System.out.println("\nParse implicit PKCS#7 SignedDataStream with CMS:\n");
            byArray2 = this.getSignedDataStream(byArray3, null, true);
            System.out.print("\nSigned content: ");
            System.out.println(new String(byArray2));
            System.out.println("\nCreating explicit CMS SignedDataStream: \n");
            byArray3 = this.createSignedDataStream(byArray, 2, true);
            System.out.println("\nParse explicit SignedDataStream SignedDataStream with PKCS#7:\n");
            byArray2 = this.getPKCS7SignedDataStream(byArray3, byArray);
            System.out.print("\nSigned content: ");
            System.out.println(new String(byArray2));
            System.out.println("\nNon-stream implementation demos");
            System.out.println("===============================");
            ASN1Object aSN1Object = null;
            System.out.println("\nImplicit CMS SignedData demo [create]:\n");
            aSN1Object = this.createSignedData(byArray, 1, false);
            System.out.println("\nImplicit CMS SignedData demo [parse]:\n");
            byArray2 = this.getSignedData(aSN1Object, null, false);
            System.out.print("\nSigned content: ");
            System.out.println(new String(byArray2));
            System.out.println("\nExplicit CMS SignedData demo [create]:\n");
            aSN1Object = this.createSignedData(byArray, 2, false);
            System.out.println("\nExplicit CMS SignedData demo [parse]:\n");
            byArray2 = this.getSignedData(aSN1Object, byArray, false);
            System.out.print("\nSigned content: ");
            System.out.println(new String(byArray2));
            System.out.println("\nNow checking against PKCS#7...");
            System.out.println("\nCreating implicit CMS SignedData: \n");
            aSN1Object = this.createSignedData(byArray, 1, true);
            System.out.println("\nParsing implicit CMS SignedData with PKCS#7:\n");
            byArray2 = this.getPKCS7SignedData(aSN1Object, null);
            System.out.print("\nSigned content: ");
            System.out.println(new String(byArray2));
            System.out.println("\nCreating explicit CMS SignedData: \n");
            aSN1Object = this.createSignedData(byArray, 2, true);
            System.out.println("\nParsing explicit CMS SignedData with PKCS#7:\n");
            byArray2 = this.getPKCS7SignedData(aSN1Object, byArray);
            System.out.print("\nSigned content: ");
            System.out.println(new String(byArray2));
            System.out.println("\nCreating implicit PCSK#7 SignedData: \n");
            aSN1Object = this.createPKCS7SignedData(byArray, 1);
            System.out.println("\nParsing implicit PKCS#7 SignedData with CMS:\n");
            byArray2 = this.getSignedData(aSN1Object, null, true);
            System.out.print("\nSigned content: ");
            System.out.println(new String(byArray2));
            System.out.println("\nCreating implicit PKCS#7 SignedData: \n");
            aSN1Object = this.createPKCS7SignedData(byArray, 2);
            System.out.println("\nParsing explicit PKCS#7 SignedData with CMS:\n");
            byArray2 = this.getSignedData(aSN1Object, byArray, true);
            System.out.print("\nSigned content: ");
            System.out.println(new String(byArray2));
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new RuntimeException();
        }
    }

    public static void main(String[] stringArray) throws Exception {
        DemoUtil.initDemos();
        new PKCS7CMSSignedData().start();
        System.in.read();
    }

    public byte[] getSignedDataStream(byte[] byArray, byte[] byArray2, boolean bl) throws IOException, CMSException {
        AttributeCertificate[] attributeCertificateArray;
        X509Certificate x509Certificate;
        AlgorithmID[] algorithmIDArray;
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        iaik.cms.SignedDataStream signedDataStream = null;
        if (byArray2 == null) {
            signedDataStream = new iaik.cms.SignedDataStream((InputStream)byteArrayInputStream);
        } else {
            algorithmIDArray = new AlgorithmID[]{AlgorithmID.sha1, AlgorithmID.md5};
            signedDataStream = new iaik.cms.SignedDataStream((InputStream)new ByteArrayInputStream(byArray2), algorithmIDArray);
        }
        algorithmIDArray = signedDataStream.getInputStream();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        StreamCopier streamCopier = new StreamCopier((InputStream)algorithmIDArray, (OutputStream)byteArrayOutputStream);
        streamCopier.copyStream();
        if (byArray2 != null) {
            signedDataStream.decode((InputStream)byteArrayInputStream);
        }
        System.out.println("SignedData contains the following signer information:");
        iaik.cms.SignerInfo[] signerInfoArray = signedDataStream.getSignerInfos();
        int n = 0;
        while (n < signerInfoArray.length) {
            try {
                Attribute attribute;
                x509Certificate = signedDataStream.verify(n);
                System.out.println("Signature OK from signer: " + x509Certificate.getSubjectDN());
                attributeCertificateArray = signerInfoArray[n].getSignedAttribute(ObjectID.signingTime);
                if (attributeCertificateArray != null) {
                    attribute = new ChoiceOfTime(attributeCertificateArray.getValue()[0]);
                    System.out.println("This message has been signed at " + attribute.getDate());
                }
                if ((attribute = signerInfoArray[n].getSignedAttribute(ObjectID.contentType)) != null) {
                    System.out.println("The content has PKCS#7 content type " + attribute.getValue()[0]);
                }
                try {
                    SigningCertificate signingCertificate = signerInfoArray[n].getSigningCertificateAttribute();
                    if (signingCertificate != null) {
                        Certificate[] certificateArray;
                        System.out.println("SigningCertificate attribute included!");
                        if (!signingCertificate.isSignerCertificate(x509Certificate)) {
                            System.out.println("Cert ERROR!!! The certificate used for signing is not the one identified by the SignerCertificate attribute!");
                        } else {
                            System.out.println("SigningCertificate attribute: Signer cert ok!");
                        }
                        Certificate[] certificateArray2 = signingCertificate.getAuthorizedCertificates(signedDataStream.getCertificates());
                        if (certificateArray2 != null) {
                            System.out.println("SignedData contains the following authorization certs for SignerInfo No " + (n + 1) + ":");
                            int n2 = 0;
                            while (n2 < certificateArray2.length) {
                                if (certificateArray2[n2].getType().equalsIgnoreCase("X.509")) {
                                    System.out.println("X.509 public key cert: " + ((X509Certificate)certificateArray2[n2]).getSubjectDN());
                                } else {
                                    System.out.println("X.509 attribute cert: " + ((AttributeCertificate)certificateArray2[n2]).getHolder());
                                }
                                ++n2;
                            }
                        }
                        if (signingCertificate.countPolicies() > 0 && (certificateArray = signingCertificate.getPolicyInformationCerts(signedDataStream.getCertificates())) != null) {
                            System.out.println("SignedData contains the following certs corresponding to policy informations of SignerInfo No " + (n + 1) + ":");
                            int n3 = 0;
                            while (n3 < certificateArray.length) {
                                if (certificateArray[n3].getType().equalsIgnoreCase("X.509")) {
                                    System.out.println("X.509 public key cert: " + ((X509Certificate)certificateArray[n3]).getSubjectDN());
                                } else {
                                    System.out.println("X.509 attribute cert: " + ((AttributeCertificate)certificateArray[n3]).getHolder());
                                }
                                ++n3;
                            }
                        }
                    }
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                    throw new CMSException("Cannot check SigningCertificate attribute: Algorithm SHA not implemented!");
                }
                catch (CMSException cMSException) {
                    throw new CMSException("Error parsing SigningCertificate attribute: " + cMSException.getMessage());
                }
            }
            catch (SignatureException signatureException) {
                System.out.println("Signature ERROR from signer: " + signedDataStream.getCertificate(signerInfoArray[n].getSignerIdentifier()).getSubjectDN());
                throw new CMSException(signatureException.toString());
            }
            catch (CodingException codingException) {
                throw new CMSException("Attribute decoding error: " + codingException.toString());
            }
            ++n;
        }
        System.out.println("Now check the signature assuming that no certs have been included:");
        try {
            signedDataStream.verify(this.user1);
            System.out.println("Signature OK from signer: " + this.user1.getSubjectDN());
        }
        catch (SignatureException signatureException) {
            System.out.println("Signature ERROR from signer: " + this.user1.getSubjectDN());
            throw new CMSException(signatureException.toString());
        }
        if (bl) {
            x509Certificate = this.user3;
        } else {
            x509Certificate = this.user2;
            System.out.println("Included attribute certificates:");
            attributeCertificateArray = signedDataStream.getAttributeCertificates();
            if (attributeCertificateArray == null) {
                System.out.println("No attribute certificates");
            } else {
                int n4 = 0;
                while (n4 < attributeCertificateArray.length) {
                    System.out.println(attributeCertificateArray[n4].getHolder());
                    ++n4;
                }
            }
        }
        try {
            attributeCertificateArray = signedDataStream.verify(x509Certificate);
            System.out.println("Signature OK from signer: " + signedDataStream.getCertificate(attributeCertificateArray.getSignerIdentifier()).getSubjectDN());
        }
        catch (SignatureException signatureException) {
            System.out.println("Signature ERROR from signer: " + x509Certificate.getSubjectDN());
            throw new CMSException(signatureException.toString());
        }
        return byteArrayOutputStream.toByteArray();
    }

    public byte[] getSignedData(ASN1Object aSN1Object, byte[] byArray, boolean bl) throws IOException, CMSException {
        Attribute attribute;
        X509Certificate x509Certificate;
        AlgorithmID[] algorithmIDArray;
        SignedData signedData = null;
        if (byArray == null) {
            signedData = new SignedData(aSN1Object);
        } else {
            algorithmIDArray = new AlgorithmID[]{AlgorithmID.sha1, AlgorithmID.md5};
            try {
                signedData = new SignedData(byArray, algorithmIDArray);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new CMSException(noSuchAlgorithmException.getMessage());
            }
        }
        algorithmIDArray = signedData.getInputStream();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        StreamCopier streamCopier = new StreamCopier((InputStream)algorithmIDArray, (OutputStream)byteArrayOutputStream);
        streamCopier.copyStream();
        if (byArray != null) {
            signedData.decode(aSN1Object);
        }
        System.out.println("SignedData contains the following signer information:");
        iaik.cms.SignerInfo[] signerInfoArray = signedData.getSignerInfos();
        int n = 0;
        while (n < signerInfoArray.length) {
            block19: {
                try {
                    Attribute attribute2;
                    Attribute attribute3;
                    x509Certificate = signedData.verify(n);
                    System.out.println("Signature OK from signer: " + x509Certificate.getSubjectDN());
                    attribute = signerInfoArray[n].getSignedAttribute(ObjectID.signingTime);
                    if (attribute != null) {
                        attribute3 = new ChoiceOfTime(attribute.getValue()[0]);
                        System.out.println("This message has been signed at " + attribute3.getDate());
                    }
                    if ((attribute3 = signerInfoArray[n].getSignedAttribute(ObjectID.contentType)) != null) {
                        System.out.println("The content has PKCS#7 content type " + attribute3.getValue()[0]);
                    }
                    if ((attribute2 = signerInfoArray[n].getSignedAttribute(ObjectID.signingCertificate)) == null) break block19;
                    System.out.println("SigningCertificate attribute included in this SignerInfo.");
                    SigningCertificate signingCertificate = new SigningCertificate(attribute2.getValue()[0]);
                    try {
                        byte[] byArray2 = x509Certificate.getFingerprint("SHA");
                        if (!CryptoUtils.equalsBlock((byte[])byArray2, (byte[])signingCertificate.getESSCertIDs()[0].getCertHash())) {
                            System.out.println("Cert ERROR!!! The certificate used for signing is not the one identified by the SignerCertificate attribute!");
                        } else {
                            System.out.println("SigningCertificate cert hash of Signer cert ok!");
                        }
                    }
                    catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                        throw new CMSException("Cannot check SigningCertificate: Algorithm SHA not implemented!");
                    }
                }
                catch (SignatureException signatureException) {
                    System.out.println("Signature ERROR from signer: " + signedData.getCertificate(signerInfoArray[n].getSignerIdentifier()).getSubjectDN());
                    throw new CMSException(signatureException.toString());
                }
                catch (CodingException codingException) {
                    throw new CMSException("Attribute decoding error: " + codingException.toString());
                }
            }
            ++n;
        }
        System.out.println("Now check the signature assuming that no certs have been included:");
        try {
            x509Certificate = signedData.verify(this.user1);
            System.out.println("Signature OK from signer: " + signedData.getCertificate(x509Certificate.getSignerIdentifier()).getSubjectDN());
        }
        catch (SignatureException signatureException) {
            System.out.println("Signature ERROR from signer: " + this.user1.getSubjectDN());
            throw new CMSException(signatureException.toString());
        }
        x509Certificate = bl ? this.user3 : this.user2;
        try {
            attribute = signedData.verify(x509Certificate);
            System.out.println("Signature OK from signer: " + signedData.getCertificate(attribute.getSignerIdentifier()).getSubjectDN());
        }
        catch (SignatureException signatureException) {
            System.out.println("Signature ERROR from signer: " + x509Certificate.getSubjectDN());
            throw new CMSException(signatureException.toString());
        }
        return signedData.getContent();
    }

    public byte[] getPKCS7SignedDataStream(byte[] byArray, byte[] byArray2) throws IOException, PKCSException {
        X509Certificate x509Certificate;
        AlgorithmID[] algorithmIDArray;
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        SignedDataStream signedDataStream = null;
        if (byArray2 == null) {
            signedDataStream = new SignedDataStream((InputStream)byteArrayInputStream);
        } else {
            algorithmIDArray = new AlgorithmID[]{AlgorithmID.sha1, AlgorithmID.md5};
            signedDataStream = new SignedDataStream((InputStream)new ByteArrayInputStream(byArray2), algorithmIDArray);
        }
        algorithmIDArray = signedDataStream.getInputStream();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        StreamCopier streamCopier = new StreamCopier((InputStream)algorithmIDArray, (OutputStream)byteArrayOutputStream);
        streamCopier.copyStream();
        if (byArray2 != null) {
            signedDataStream.decode((InputStream)byteArrayInputStream);
        }
        System.out.println("SignedData contains the following signer information:");
        SignerInfo[] signerInfoArray = signedDataStream.getSignerInfos();
        int n = 0;
        while (n < signerInfoArray.length) {
            try {
                Attribute attribute;
                x509Certificate = signedDataStream.verify(n);
                System.out.println("Signature OK from signer: " + x509Certificate.getSubjectDN());
                Attribute attribute2 = signerInfoArray[n].getAuthenticatedAttribute(ObjectID.signingTime);
                if (attribute2 != null) {
                    attribute = new ChoiceOfTime(attribute2.getValue()[0]);
                    System.out.println("This message has been signed at " + attribute.getDate());
                }
                if ((attribute = signerInfoArray[n].getAuthenticatedAttribute(ObjectID.contentType)) != null) {
                    System.out.println("The content has PKCS#7 content type " + attribute.getValue()[0]);
                }
            }
            catch (SignatureException signatureException) {
                System.out.println("Signature ERROR from signer: " + signedDataStream.getCertificate(signerInfoArray[n].getIssuerAndSerialNumber()).getSubjectDN());
                throw new PKCSException(signatureException.toString());
            }
            catch (CodingException codingException) {
                throw new PKCSException("Attribute decoding error: " + codingException.toString());
            }
            ++n;
        }
        System.out.println("Now check the signature assuming that no certs have been included:");
        try {
            x509Certificate = signedDataStream.verify(this.user1);
            System.out.println("Signature OK from signer: " + signedDataStream.getCertificate(x509Certificate.getIssuerAndSerialNumber()).getSubjectDN());
        }
        catch (SignatureException signatureException) {
            System.out.println("Signature ERROR from signer: " + this.user1.getSubjectDN());
            throw new PKCSException(signatureException.toString());
        }
        try {
            x509Certificate = signedDataStream.verify(this.user3);
            System.out.println("Signature OK from signer: " + signedDataStream.getCertificate(x509Certificate.getIssuerAndSerialNumber()).getSubjectDN());
        }
        catch (SignatureException signatureException) {
            System.out.println("Signature ERROR from signer: " + this.user3.getSubjectDN());
            throw new PKCSException(signatureException.toString());
        }
        return byteArrayOutputStream.toByteArray();
    }

    public byte[] getPKCS7SignedData(ASN1Object aSN1Object, byte[] byArray) throws IOException, PKCSException {
        X509Certificate x509Certificate;
        AlgorithmID[] algorithmIDArray;
        iaik.pkcs.pkcs7.SignedData signedData = null;
        if (byArray == null) {
            signedData = new iaik.pkcs.pkcs7.SignedData(aSN1Object);
        } else {
            algorithmIDArray = new AlgorithmID[]{AlgorithmID.sha1, AlgorithmID.md5};
            try {
                signedData = new iaik.pkcs.pkcs7.SignedData(byArray, algorithmIDArray);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new PKCSException(noSuchAlgorithmException.toString());
            }
        }
        algorithmIDArray = signedData.getInputStream();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        StreamCopier streamCopier = new StreamCopier((InputStream)algorithmIDArray, (OutputStream)byteArrayOutputStream);
        streamCopier.copyStream();
        if (byArray != null) {
            signedData.decode(aSN1Object);
        }
        System.out.println("SignedData contains the following signer information:");
        SignerInfo[] signerInfoArray = signedData.getSignerInfos();
        int n = 0;
        while (n < signerInfoArray.length) {
            try {
                Attribute attribute;
                x509Certificate = signedData.verify(n);
                System.out.println("Signature OK from signer: " + x509Certificate.getSubjectDN());
                Attribute attribute2 = signerInfoArray[n].getAuthenticatedAttribute(ObjectID.signingTime);
                if (attribute2 != null) {
                    attribute = new ChoiceOfTime(attribute2.getValue()[0]);
                    System.out.println("This message has been signed at " + attribute.getDate());
                }
                if ((attribute = signerInfoArray[n].getAuthenticatedAttribute(ObjectID.contentType)) != null) {
                    System.out.println("The content has PKCS#7 content type " + attribute.getValue()[0]);
                }
            }
            catch (SignatureException signatureException) {
                System.out.println("Signature ERROR from signer: " + signedData.getCertificate(signerInfoArray[n].getIssuerAndSerialNumber()).getSubjectDN());
                throw new PKCSException(signatureException.toString());
            }
            catch (CodingException codingException) {
                throw new PKCSException("Attribute decoding error: " + codingException.toString());
            }
            ++n;
        }
        System.out.println("Now check the signature assuming that no certs have been included:");
        try {
            x509Certificate = signedData.verify(this.user1);
            System.out.println("Signature OK from signer: " + signedData.getCertificate(x509Certificate.getIssuerAndSerialNumber()).getSubjectDN());
        }
        catch (SignatureException signatureException) {
            System.out.println("Signature ERROR from signer: " + this.user1.getSubjectDN());
            throw new PKCSException(signatureException.toString());
        }
        try {
            x509Certificate = signedData.verify(this.user3);
            System.out.println("Signature OK from signer: " + signedData.getCertificate(x509Certificate.getIssuerAndSerialNumber()).getSubjectDN());
        }
        catch (SignatureException signatureException) {
            System.out.println("Signature ERROR from signer: " + this.user3.getSubjectDN());
            throw new PKCSException(signatureException.toString());
        }
        return signedData.getContent();
    }

    public byte[] createSignedDataStream(byte[] byArray, int n, boolean bl) throws IOException, CMSException {
        Object object;
        Object object2;
        IssuerAndSerialNumber issuerAndSerialNumber;
        System.out.print("Create a new message signed by user 1 :");
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        iaik.cms.SignedDataStream signedDataStream = new iaik.cms.SignedDataStream((InputStream)byteArrayInputStream, n);
        if (bl) {
            issuerAndSerialNumber = new X509Certificate[this.user1Certs.length + 1];
            System.arraycopy(this.user1Certs, 0, issuerAndSerialNumber, 0, this.user1Certs.length);
            issuerAndSerialNumber[this.user1Certs.length] = this.user3;
            signedDataStream.setCertificates((Certificate[])issuerAndSerialNumber);
        } else {
            signedDataStream.setCertificates(this.certificates);
        }
        issuerAndSerialNumber = new IssuerAndSerialNumber(this.user1);
        iaik.cms.SignerInfo signerInfo = new iaik.cms.SignerInfo((CertificateIdentifier)issuerAndSerialNumber, AlgorithmID.md5, this.user1_pk);
        Attribute[] attributeArray = new Attribute[3];
        attributeArray[0] = new Attribute(ObjectID.contentType, new ASN1Object[]{ObjectID.pkcs7_data});
        attributeArray[1] = new Attribute(ObjectID.signingTime, new ASN1Object[]{new ChoiceOfTime().toASN1Object()});
        try {
            object2 = new SigningCertificate(this.certs, true);
            object = "This certificate only may be used for test purposes";
            PolicyQualifierInfo policyQualifierInfo = new PolicyQualifierInfo(null, null, (String)object);
            PolicyInformation[] policyInformationArray = new PolicyInformation[]{new PolicyInformation(new ObjectID("1.3.6.1.4.1.2706.17.0.11.1.1"), new PolicyQualifierInfo[]{policyQualifierInfo})};
            object2.setPolicies(policyInformationArray);
            System.out.println("Include signingCertificate attribute:");
            System.out.println(object2);
            attributeArray[2] = new Attribute(ObjectID.signingCertificate, new ASN1Object[]{object2.toASN1Object()});
        }
        catch (Exception exception) {
            throw new CMSException("Cannot create SigningCertificate attribute: " + exception.getMessage());
        }
        signerInfo.setSignedAttributes(attributeArray);
        try {
            signedDataStream.addSignerInfo(signerInfo);
            signerInfo = bl ? new iaik.cms.SignerInfo((CertificateIdentifier)new IssuerAndSerialNumber(this.user3), AlgorithmID.sha1, this.user3_pk) : new iaik.cms.SignerInfo((CertificateIdentifier)new SubjectKeyID(this.user2), AlgorithmID.sha1, AlgorithmID.dsaWithSHA, this.user2_pk);
            signedDataStream.addSignerInfo(signerInfo);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new CMSException("No implementation for signature algorithm: " + noSuchAlgorithmException.getMessage());
        }
        catch (X509ExtensionException x509ExtensionException) {
            throw new CMSException("Cannot create SubjectKeyID for user2 : " + x509ExtensionException.getMessage());
        }
        if (n == 2) {
            int n2;
            object2 = signedDataStream.getInputStream();
            object = new byte[1024];
            while ((n2 = ((InputStream)object2).read((byte[])object)) > 0) {
            }
        }
        object2 = new ByteArrayOutputStream();
        signedDataStream.writeTo((OutputStream)object2, 2048);
        return ((ByteArrayOutputStream)object2).toByteArray();
    }

    public ASN1Object createSignedData(byte[] byArray, int n, boolean bl) throws IOException, CMSException {
        IssuerAndSerialNumber issuerAndSerialNumber;
        System.out.println("Create a new message signed by user 1 :");
        SignedData signedData = new SignedData(byArray, n);
        if (bl) {
            issuerAndSerialNumber = new X509Certificate[this.user1Certs.length + 1];
            System.arraycopy(this.user1Certs, 0, issuerAndSerialNumber, 0, this.user1Certs.length);
            issuerAndSerialNumber[this.user1Certs.length] = this.user3;
            signedData.setCertificates((Certificate[])issuerAndSerialNumber);
        } else {
            signedData.setCertificates(this.certificates);
        }
        issuerAndSerialNumber = new IssuerAndSerialNumber(this.user1);
        iaik.cms.SignerInfo signerInfo = new iaik.cms.SignerInfo((CertificateIdentifier)issuerAndSerialNumber, AlgorithmID.md5, this.user1_pk);
        Attribute[] attributeArray = new Attribute[3];
        attributeArray[0] = new Attribute(ObjectID.contentType, new ASN1Object[]{ObjectID.pkcs7_data});
        attributeArray[1] = new Attribute(ObjectID.signingTime, new ASN1Object[]{new ChoiceOfTime().toASN1Object()});
        SigningCertificate signingCertificate = Utils.makeSigningCertificate((Certificate[])this.certs, null, (boolean)true);
        System.out.println("Include signingCertificate attribute:");
        System.out.println(signingCertificate);
        attributeArray[2] = new Attribute(ObjectID.signingCertificate, new ASN1Object[]{signingCertificate.toASN1Object()});
        signerInfo.setSignedAttributes(attributeArray);
        try {
            signedData.addSignerInfo(signerInfo);
            signerInfo = bl ? new iaik.cms.SignerInfo((CertificateIdentifier)new IssuerAndSerialNumber(this.user3), AlgorithmID.sha1, this.user3_pk) : new iaik.cms.SignerInfo((CertificateIdentifier)new SubjectKeyID(this.user2), AlgorithmID.sha1, AlgorithmID.dsaWithSHA, this.user2_pk);
            signedData.addSignerInfo(signerInfo);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new CMSException("No implementation for signature algorithm: " + noSuchAlgorithmException.getMessage());
        }
        catch (X509ExtensionException x509ExtensionException) {
            throw new CMSException("Cannot create SubjectKeyID for user2 : " + x509ExtensionException.getMessage());
        }
        return signedData.toASN1Object();
    }

    public byte[] createPKCS7SignedDataStream(byte[] byArray, int n) throws IOException, PKCSException {
        Closeable closeable;
        X509Certificate[] x509CertificateArray = new X509Certificate[this.user1Certs.length + 1];
        System.arraycopy(this.user1Certs, 0, x509CertificateArray, 0, this.user1Certs.length);
        x509CertificateArray[this.user1Certs.length] = this.user3;
        System.out.println("Create a new message signed by user 1 and 3:");
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        SignedDataStream signedDataStream = new SignedDataStream((InputStream)byteArrayInputStream, n);
        signedDataStream.setCertificates(x509CertificateArray);
        iaik.pkcs.pkcs7.IssuerAndSerialNumber issuerAndSerialNumber = new iaik.pkcs.pkcs7.IssuerAndSerialNumber((java.security.cert.X509Certificate)this.user1);
        SignerInfo signerInfo = new SignerInfo(issuerAndSerialNumber, AlgorithmID.md5, this.user1_pk);
        Attribute[] attributeArray = new Attribute[]{new Attribute(ObjectID.contentType, new ASN1Object[]{ObjectID.pkcs7_data}), new Attribute(ObjectID.signingTime, new ASN1Object[]{new ChoiceOfTime().toASN1Object()})};
        signerInfo.setAuthenticatedAttributes(attributeArray);
        try {
            signedDataStream.addSignerInfo(signerInfo);
            signerInfo = new SignerInfo(new iaik.pkcs.pkcs7.IssuerAndSerialNumber((java.security.cert.X509Certificate)this.user3), AlgorithmID.sha1, this.user3_pk);
            signedDataStream.addSignerInfo(signerInfo);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new PKCSException("No implementation for signature algorithm: " + noSuchAlgorithmException.getMessage());
        }
        if (n == 2) {
            int n2;
            closeable = signedDataStream.getInputStream();
            byte[] byArray2 = new byte[1024];
            while ((n2 = ((InputStream)closeable).read(byArray2)) > 0) {
            }
        }
        closeable = new ByteArrayOutputStream();
        signedDataStream.writeTo((OutputStream)closeable, 2048);
        return ((ByteArrayOutputStream)closeable).toByteArray();
    }

    public ASN1Object createPKCS7SignedData(byte[] byArray, int n) throws IOException, PKCSException {
        X509Certificate[] x509CertificateArray = new X509Certificate[this.user1Certs.length + 1];
        System.arraycopy(this.user1Certs, 0, x509CertificateArray, 0, this.user1Certs.length);
        x509CertificateArray[this.user1Certs.length] = this.user3;
        System.out.println("Create a new message signed by user 1 and 3:");
        iaik.pkcs.pkcs7.SignedData signedData = new iaik.pkcs.pkcs7.SignedData(byArray, n);
        signedData.setCertificates(x509CertificateArray);
        iaik.pkcs.pkcs7.IssuerAndSerialNumber issuerAndSerialNumber = new iaik.pkcs.pkcs7.IssuerAndSerialNumber((java.security.cert.X509Certificate)this.user1);
        SignerInfo signerInfo = new SignerInfo(issuerAndSerialNumber, AlgorithmID.md5, this.user1_pk);
        Attribute[] attributeArray = new Attribute[]{new Attribute(ObjectID.contentType, new ASN1Object[]{ObjectID.pkcs7_data}), new Attribute(ObjectID.signingTime, new ASN1Object[]{new ChoiceOfTime().toASN1Object()})};
        signerInfo.setAuthenticatedAttributes(attributeArray);
        try {
            signedData.addSignerInfo(signerInfo);
            signerInfo = new SignerInfo(new iaik.pkcs.pkcs7.IssuerAndSerialNumber((java.security.cert.X509Certificate)this.user3), AlgorithmID.sha1, this.user3_pk);
            signedData.addSignerInfo(signerInfo);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new PKCSException("No implementation for signature algorithm: " + noSuchAlgorithmException.getMessage());
        }
        return signedData.toASN1Object();
    }

    public AttributeCertificate createAttributeCertificate() throws CMSException {
        try {
            Name name = (Name)this.user1.getIssuerDN();
            GeneralName generalName = new GeneralName(4, (Object)name);
            GeneralNames generalNames = new GeneralNames(generalName);
            V1Form v1Form = new V1Form(generalNames);
            Name name2 = (Name)this.user1.getSubjectDN();
            GeneralName generalName2 = new GeneralName(4, (Object)name2);
            GeneralNames generalNames2 = new GeneralNames(generalName2);
            Holder holder = new Holder();
            holder.setEntityName(generalNames2);
            AttributeCertificate attributeCertificate = new AttributeCertificate();
            attributeCertificate.setHolder(holder);
            attributeCertificate.setIssuer((AttCertIssuer)v1Form);
            attributeCertificate.setSerialNumber(new BigInteger("27"));
            GregorianCalendar gregorianCalendar = new GregorianCalendar();
            Date date = gregorianCalendar.getTime();
            gregorianCalendar.add(2, 1);
            Date date2 = gregorianCalendar.getTime();
            attributeCertificate.setNotBeforeTime(date);
            attributeCertificate.setNotAfterTime(date2);
            Attribute[] attributeArray = new Attribute[1];
            SEQUENCE sEQUENCE = new SEQUENCE();
            sEQUENCE.addComponent((ASN1Object)new UTF8String("A-8010 Graz, Austria"));
            sEQUENCE.addComponent((ASN1Object)new UTF8String("Inffeldgasse 16A"));
            attributeArray[0] = new Attribute(ObjectID.postalAddress, new ASN1Object[]{sEQUENCE});
            attributeCertificate.setAttributes(attributeArray);
            attributeCertificate.sign(AlgorithmID.sha1WithRSAEncryption_, this.issuer1_pk);
            attributeCertificate.verify(this.user1Certs[1].getPublicKey());
            return attributeCertificate;
        }
        catch (Exception exception) {
            throw new CMSException(exception.getMessage());
        }
    }

    public PKCS7CMSSignedData() throws IOException {
        System.out.println();
        System.out.println("***********************************************************************************************");
        System.out.println("*                                 PKCS7CMSSignedData demo                                     *");
        System.out.println("*    (tests the CMS SignedData against the IAIK-JCE PKCS#7 Signedata type implementation)     *");
        System.out.println("***********************************************************************************************");
        System.out.println();
        this.user1Certs = CMSKeyStore.getCertificateChain(0, 1);
        this.user1 = (X509Certificate)this.user1Certs[0];
        this.user1_pk = CMSKeyStore.getPrivateKey(0, 1);
        this.user2 = CMSKeyStore.getCertificateChain(1, 1)[0];
        this.user2_pk = CMSKeyStore.getPrivateKey(1, 1);
        this.user3 = CMSKeyStore.getCertificateChain(0, 2)[0];
        this.user3_pk = CMSKeyStore.getPrivateKey(0, 2);
        this.certs = this.user1Certs;
        try {
            this.issuer1_pk = CMSKeyStore.getCaPrivateKey(0);
            AttributeCertificate attributeCertificate = this.createAttributeCertificate();
            this.certs = new Certificate[this.user1Certs.length + 1];
            System.arraycopy(this.user1Certs, 0, this.certs, 0, this.user1Certs.length);
            this.certs[this.user1Certs.length] = attributeCertificate;
        }
        catch (CMSException cMSException) {
            System.out.println("No attribute certificates!");
        }
        this.certificates = new Certificate[this.certs.length + 1];
        System.arraycopy(this.certs, 0, this.certificates, 0, this.certs.length);
        this.certificates[this.certs.length] = this.user2;
    }
}

