/*
 * Decompiled with CFR 0.152.
 */
package iaik.asn1;

import iaik.asn1.ASN;
import iaik.asn1.CON_SPEC;
import iaik.asn1.CodingException;
import iaik.asn1.EncodeListener;
import iaik.asn1.b;
import iaik.utils.Util;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public abstract class ASN1Object
implements Cloneable {
    protected boolean stream_mode = false;
    protected b[] encode_listener;
    protected boolean isStringType = false;
    protected ASN asnType;
    protected boolean indefinite_length = false;
    protected boolean constructed = false;

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.asnType.getName());
        if (this.constructed) {
            stringBuffer.append("[C]");
        }
        if (this.indefinite_length) {
            stringBuffer.append("[I]");
        }
        stringBuffer.append(" = ");
        return stringBuffer.toString();
    }

    public abstract void setValue(Object var1);

    public void setIndefiniteLength(boolean bl) {
        this.indefinite_length = bl;
    }

    public boolean isStringType() {
        return this.isStringType;
    }

    public boolean isConstructed() {
        return this.constructed;
    }

    public boolean isA(ASN aSN) {
        if (aSN.equals(ASN.CON_SPEC)) {
            return this instanceof CON_SPEC;
        }
        return this.asnType.equals(aSN);
    }

    public boolean indefiniteLength() {
        return this.indefinite_length;
    }

    public abstract Object getValue();

    public ASN1Object getComponentAt(int n2) throws CodingException {
        throw new CodingException("ASN1: " + this.asnType.getName() + " does not support getComponentAt(int)!");
    }

    public ASN getAsnType() {
        return this.asnType;
    }

    protected void encodeObject(OutputStream outputStream, boolean bl) throws IOException {
        if (this.encode_listener != null) {
            try {
                b b2 = null;
                int n2 = 0;
                while (n2 < this.encode_listener.length) {
                    b2 = this.encode_listener[n2];
                    if (b2.a() == -1) {
                        b2.b().encodeCalled(this, b2.c());
                    }
                    ++n2;
                }
            }
            catch (CodingException codingException) {
                throw new IOException("Error from EncodeListener: " + codingException.getMessage());
            }
        }
        this.stream_mode = bl;
        this.encode(outputStream);
    }

    protected abstract void encode(OutputStream var1) throws IOException;

    protected abstract void decode(int var1, InputStream var2) throws IOException, CodingException;

    public int countComponents() throws CodingException {
        throw new CodingException("ASN1: " + this.asnType.getName() + " does not support countComponents()!");
    }

    public Object clone() {
        ASN1Object aSN1Object = null;
        try {
            aSN1Object = (ASN1Object)super.clone();
            if (this.encode_listener != null) {
                aSN1Object.encode_listener = (b[])this.encode_listener.clone();
            }
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {}
        return aSN1Object;
    }

    public void addEncodeListener(EncodeListener encodeListener, int n2) {
        b b2 = new b(encodeListener, n2, -1);
        if (this.encode_listener == null) {
            this.encode_listener = new b[]{b2};
            return;
        }
        this.encode_listener = (b[])Util.resizeArray(this.encode_listener, this.encode_listener.length + 1);
        this.encode_listener[this.encode_listener.length - 1] = b2;
    }

    public void addComponent(ASN1Object aSN1Object) throws CodingException {
        throw new CodingException("ASN1: " + this.asnType.getName() + " does not support addComponent()!");
    }

    protected ASN1Object() {
    }
}

