/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.raw.data;

import java.io.File;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.cache.CacheFactory;
import org.apache.derby.iapi.services.cache.CacheManager;
import org.apache.derby.iapi.services.cache.Cacheable;
import org.apache.derby.iapi.services.cache.CacheableFactory;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.services.daemon.DaemonService;
import org.apache.derby.iapi.services.daemon.Serviceable;
import org.apache.derby.iapi.services.i18n.MessageService;
import org.apache.derby.iapi.services.info.ProductVersionHolder;
import org.apache.derby.iapi.services.io.FileUtil;
import org.apache.derby.iapi.services.monitor.ModuleControl;
import org.apache.derby.iapi.services.monitor.ModuleSupportable;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.iapi.services.monitor.PersistentService;
import org.apache.derby.iapi.services.property.PropertyUtil;
import org.apache.derby.iapi.services.stream.HeaderPrintWriter;
import org.apache.derby.iapi.services.uuid.UUIDFactory;
import org.apache.derby.iapi.store.access.FileResource;
import org.apache.derby.iapi.store.access.RowSource;
import org.apache.derby.iapi.store.raw.ContainerHandle;
import org.apache.derby.iapi.store.raw.ContainerKey;
import org.apache.derby.iapi.store.raw.LockingPolicy;
import org.apache.derby.iapi.store.raw.Page;
import org.apache.derby.iapi.store.raw.RawStoreFactory;
import org.apache.derby.iapi.store.raw.StreamContainerHandle;
import org.apache.derby.iapi.store.raw.Transaction;
import org.apache.derby.iapi.store.raw.data.DataFactory;
import org.apache.derby.iapi.store.raw.data.RawContainerHandle;
import org.apache.derby.iapi.store.raw.log.LogFactory;
import org.apache.derby.iapi.store.raw.log.LogInstant;
import org.apache.derby.iapi.store.raw.xact.RawTransaction;
import org.apache.derby.iapi.util.ByteArray;
import org.apache.derby.iapi.util.CheapDateFormatter;
import org.apache.derby.iapi.util.ReuseFactory;
import org.apache.derby.impl.store.raw.data.AllocationActions;
import org.apache.derby.impl.store.raw.data.BaseContainerHandle;
import org.apache.derby.impl.store.raw.data.ContainerOperation;
import org.apache.derby.impl.store.raw.data.DirectActions;
import org.apache.derby.impl.store.raw.data.DirectAllocActions;
import org.apache.derby.impl.store.raw.data.EncryptData;
import org.apache.derby.impl.store.raw.data.FileContainer;
import org.apache.derby.impl.store.raw.data.InputStreamContainer;
import org.apache.derby.impl.store.raw.data.LoggableActions;
import org.apache.derby.impl.store.raw.data.LoggableAllocActions;
import org.apache.derby.impl.store.raw.data.PageActions;
import org.apache.derby.impl.store.raw.data.RAFContainer;
import org.apache.derby.impl.store.raw.data.RFResource;
import org.apache.derby.impl.store.raw.data.ReclaimSpace;
import org.apache.derby.impl.store.raw.data.ReclaimSpaceHelper;
import org.apache.derby.impl.store.raw.data.StoredPage;
import org.apache.derby.impl.store.raw.data.StreamFileContainer;
import org.apache.derby.impl.store.raw.data.StreamFileContainerHandle;
import org.apache.derby.io.StorageFactory;
import org.apache.derby.io.StorageFile;
import org.apache.derby.io.StorageRandomAccessFile;
import org.apache.derby.io.WritableStorageFactory;

public class BaseDataFileFactory
implements DataFactory,
CacheableFactory,
ModuleControl,
ModuleSupportable,
PrivilegedExceptionAction {
    StorageFactory storageFactory;
    WritableStorageFactory writableStorageFactory;
    private long nextContainerId = System.currentTimeMillis();
    private boolean databaseEncrypted;
    private CacheManager pageCache;
    private CacheManager containerCache;
    private LogFactory logFactory;
    private ProductVersionHolder jbmsVersion;
    private RawStoreFactory rawStoreFactory;
    private String dataDirectory;
    private boolean throwDBlckException;
    private UUID identifier;
    private Object freezeSemaphore;
    private boolean isFrozen;
    private int writersInProgress;
    private boolean removeStubsOK;
    private boolean isCorrupt;
    private boolean inCreateNoLog;
    private StorageRandomAccessFile fileLockOnDB;
    private StorageFile exFileLock;
    private HeaderPrintWriter istream;
    private static final String LINE = "----------------------------------------------------------------";
    boolean dataNotSyncedAtAllocation = true;
    boolean dataNotSyncedAtCheckpoint = false;
    private PageActions loggablePageActions;
    private AllocationActions loggableAllocActions;
    private boolean readOnly;
    private boolean supportsRandomAccess;
    private FileResource fileHandler;
    private Hashtable droppedTableStubInfo;
    private Hashtable postRecoveryRemovedFiles;
    private EncryptData containerEncrypter;
    private int actionCode;
    private static final int GET_TEMP_DIRECTORY_ACTION = 1;
    private static final int REMOVE_TEMP_DIRECTORY_ACTION = 2;
    private static final int GET_CONTAINER_PATH_ACTION = 3;
    private static final int GET_ALTERNATE_CONTAINER_PATH_ACTION = 4;
    private static final int FIND_MAX_CONTAINER_ID_ACTION = 5;
    private static final int DELETE_IF_EXISTS_ACTION = 6;
    private static final int GET_PATH_ACTION = 7;
    private static final int POST_RECOVERY_REMOVE_ACTION = 8;
    private static final int REMOVE_STUBS_ACTION = 9;
    private static final int BOOT_ACTION = 10;
    private static final int GET_LOCK_ON_DB_ACTION = 11;
    private static final int RELEASE_LOCK_ON_DB_ACTION = 12;
    private static final int RESTORE_DATA_DIRECTORY_ACTION = 13;
    private static final int GET_CONTAINER_NAMES_ACTION = 14;
    private ContainerKey containerId;
    private boolean stub;
    private StorageFile actionFile;
    private UUID myUUID;
    private UUIDFactory uuidFactory;
    private String databaseDirectory;
    private String backupPath;
    private File backupRoot;
    private String[] bfilelist;

    public boolean canSupport(Properties properties) {
        String string = properties.getProperty("derby.__rt.serviceType");
        if (string == null) {
            return false;
        }
        if (!this.handleServiceType(string)) {
            return false;
        }
        return properties.getProperty("derby.__rt.serviceDirectory") != null;
    }

    public void boot(boolean bl, Properties properties) throws StandardException {
        this.jbmsVersion = Monitor.getMonitor().getEngineVersion();
        this.dataDirectory = properties.getProperty("derby.__rt.serviceDirectory");
        UUIDFactory uUIDFactory = Monitor.getMonitor().getUUIDFactory();
        this.identifier = uUIDFactory.createUUID();
        PersistentService persistentService = Monitor.getMonitor().getServiceType(this);
        try {
            this.storageFactory = persistentService.getStorageFactoryInstance(true, this.dataDirectory, properties.getProperty("derby.storage.tempDirectory", PropertyUtil.getSystemProperty("derby.storage.tempDirectory")), this.identifier.toANSIidentifier());
        }
        catch (IOException iOException) {
            if (bl) {
                throw StandardException.newException("XBM0H.D", iOException, (Object)this.dataDirectory);
            }
            throw StandardException.newException("XJ004.C", iOException, (Object)this.dataDirectory);
        }
        if (this.storageFactory instanceof WritableStorageFactory) {
            this.writableStorageFactory = (WritableStorageFactory)this.storageFactory;
        }
        this.actionCode = 10;
        try {
            AccessController.doPrivileged(this);
        }
        catch (PrivilegedActionException privilegedActionException) {
            // empty catch block
        }
        String string = properties.getProperty("derby.database.forceDatabaseLock", PropertyUtil.getSystemProperty("derby.database.forceDatabaseLock"));
        this.throwDBlckException = Boolean.valueOf(string != null ? string.trim() : string);
        if (!this.isReadOnly()) {
            this.getJBMSLockOnDB(this.identifier, uUIDFactory, this.dataDirectory);
        }
        String string2 = null;
        string2 = properties.getProperty("createFrom");
        if (string2 == null) {
            string2 = properties.getProperty("restoreFrom");
        }
        if (string2 == null) {
            string2 = properties.getProperty("rollForwardRecoveryFrom");
        }
        if (string2 != null) {
            try {
                String string3 = properties.getProperty("dataEncryption");
                this.databaseEncrypted = Boolean.valueOf(string3);
                this.restoreDataDirectory(string2);
            }
            catch (StandardException standardException) {
                this.releaseJBMSLockOnDB();
                throw standardException;
            }
        }
        this.logMsg(LINE);
        long l = System.currentTimeMillis();
        String string4 = this.isReadOnly() ? MessageService.getTextMessage("D014") : "";
        boolean bl2 = Boolean.valueOf(properties.getProperty("derby.stream.error.logBootTrace", PropertyUtil.getSystemProperty("derby.stream.error.logBootTrace")));
        this.logMsg(CheapDateFormatter.formatDate(l) + MessageService.getTextMessage("D001", this.jbmsVersion, this.identifier, this.dataDirectory + " " + string4, this.getClass().getClassLoader()));
        if (bl2) {
            Monitor.logThrowable(new Throwable("boot trace"));
        }
        uUIDFactory = null;
        CacheFactory cacheFactory = (CacheFactory)Monitor.startSystemModule("org.apache.derby.iapi.services.cache.CacheFactory");
        int n = this.getIntParameter("derby.storage.pageCacheSize", null, 1000, 40, Integer.MAX_VALUE);
        this.pageCache = cacheFactory.newCacheManager(this, "PageCache", n / 2, n);
        int n2 = this.getIntParameter("derby.storage.fileCacheSize", null, 100, 2, Integer.MAX_VALUE);
        this.containerCache = cacheFactory.newCacheManager(this, "ContainerCache", n2 / 2, n2);
        if (bl) {
            String string5 = properties.getProperty("derby.__rt.storage.createWithNoLog");
            this.inCreateNoLog = string5 != null && Boolean.valueOf(string5) != false;
        }
        this.freezeSemaphore = new Object();
        this.droppedTableStubInfo = new Hashtable();
        if ("test".equalsIgnoreCase(PropertyUtil.getSystemProperty("derby.system.durability"))) {
            this.dataNotSyncedAtCheckpoint = true;
            Monitor.logMessage(MessageService.getTextMessage("D013", "derby.system.durability", "test"));
        }
        this.fileHandler = new RFResource(this);
    }

    public void stop() {
        DaemonService daemonService;
        boolean bl = false;
        if (this.rawStoreFactory != null && (daemonService = this.rawStoreFactory.getDaemon()) != null) {
            daemonService.stop();
        }
        long l = System.currentTimeMillis();
        boolean bl2 = PropertyUtil.getSystemBoolean("derby.stream.error.logBootTrace");
        this.logMsg("\n" + CheapDateFormatter.formatDate(l) + MessageService.getTextMessage("D002", this.getIdentifier(), this.getClass().getClassLoader()));
        if (bl2) {
            Monitor.logThrowable(new Throwable("shutdown trace"));
        }
        this.istream.println(LINE);
        if (!this.isCorrupt) {
            try {
                if (this.pageCache != null && this.containerCache != null) {
                    this.pageCache.shutdown();
                    this.containerCache.shutdown();
                    bl = true;
                }
            }
            catch (StandardException standardException) {
                standardException.printStackTrace(this.istream.getPrintWriter());
            }
        }
        this.removeTempDirectory();
        if (this.isReadOnly()) {
            this.storageFactory.shutdown();
            return;
        }
        if (this.removeStubsOK && bl) {
            this.removeStubs();
        }
        this.releaseJBMSLockOnDB();
        this.writableStorageFactory.shutdown();
    }

    public Cacheable newCacheable(CacheManager cacheManager) {
        if (cacheManager == this.pageCache) {
            StoredPage storedPage = new StoredPage();
            storedPage.setFactory(this);
            return storedPage;
        }
        return this.newContainerObject();
    }

    public void createFinished() throws StandardException {
        if (!this.inCreateNoLog) {
            throw StandardException.newException("XSDG5.D");
        }
        this.checkpoint();
        this.inCreateNoLog = false;
    }

    public ContainerHandle openContainer(RawTransaction rawTransaction, ContainerKey containerKey, LockingPolicy lockingPolicy, int n) throws StandardException {
        return this.openContainer(rawTransaction, containerKey, lockingPolicy, n, false);
    }

    public RawContainerHandle openDroppedContainer(RawTransaction rawTransaction, ContainerKey containerKey, LockingPolicy lockingPolicy, int n) throws StandardException {
        return this.openContainer(rawTransaction, containerKey, lockingPolicy, n |= 0x400, true);
    }

    private RawContainerHandle openContainer(RawTransaction rawTransaction, ContainerKey containerKey, LockingPolicy lockingPolicy, int n, boolean bl) throws StandardException {
        boolean bl2;
        boolean bl3 = bl2 = (n & 0x80) == 0;
        if ((n & 0x40) != 0) {
            BaseContainerHandle baseContainerHandle = new BaseContainerHandle(this.getIdentifier(), rawTransaction, containerKey, lockingPolicy, n);
            if (baseContainerHandle.useContainer(true, bl2)) {
                return baseContainerHandle;
            }
            return null;
        }
        FileContainer fileContainer = (FileContainer)this.containerCache.find(containerKey);
        if (fileContainer == null) {
            return null;
        }
        if (containerKey.getSegmentId() == -1L) {
            n = (n & 0x800) == 2048 ? (n |= 1) : (n |= 0x101);
            lockingPolicy = rawTransaction.newLockingPolicy(0, 0, true);
        } else {
            if (this.inCreateNoLog) {
                n |= 3;
            } else if (this.logFactory.logArchived() || this.logFactory.inReplicationMasterMode()) {
                n &= 0xFFFFFFFC;
            } else if (!((n & 1) != 1 && (n & 2) != 2 || rawTransaction.blockBackup(false))) {
                n &= 0xFFFFFFFC;
            }
            if ((n & 1) == 1 && (n & 2) == 0) {
                n |= 0x200;
            }
        }
        PageActions pageActions = null;
        AllocationActions allocationActions = null;
        if ((n & 4) == 4) {
            if ((n & 1) == 0) {
                pageActions = this.getLoggablePageActions();
                allocationActions = this.getLoggableAllocationActions();
            } else {
                pageActions = new DirectActions();
                allocationActions = new DirectAllocActions();
            }
        }
        BaseContainerHandle baseContainerHandle = new BaseContainerHandle(this.getIdentifier(), rawTransaction, pageActions, allocationActions, lockingPolicy, fileContainer, n);
        try {
            if (!baseContainerHandle.useContainer(bl, bl2)) {
                this.containerCache.release(fileContainer);
                return null;
            }
        }
        catch (StandardException standardException) {
            this.containerCache.release(fileContainer);
            throw standardException;
        }
        return baseContainerHandle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long addContainer(RawTransaction rawTransaction, long l, long l2, int n, Properties properties, int n2) throws StandardException {
        long l3 = l2 != 0L ? l2 : this.getNextId();
        ContainerKey containerKey = new ContainerKey(l, l3);
        boolean bl = l == -1L;
        ContainerHandle containerHandle = null;
        LockingPolicy lockingPolicy = null;
        if (!bl) {
            if (this.isReadOnly()) {
                throw StandardException.newException("40XD1");
            }
            lockingPolicy = rawTransaction.newLockingPolicy(2, 5, true);
            containerHandle = rawTransaction.openContainer(containerKey, lockingPolicy, 68);
        }
        FileContainer fileContainer = (FileContainer)this.containerCache.create(containerKey, properties);
        ContainerHandle containerHandle2 = null;
        Page page = null;
        try {
            if (bl && (n2 & 2) == 2) {
                n |= 0x800;
            }
            containerHandle2 = rawTransaction.openContainer(containerKey, null, 4 | n);
            if (!bl) {
                RawContainerHandle rawContainerHandle = (RawContainerHandle)containerHandle2;
                ContainerOperation containerOperation = new ContainerOperation(rawContainerHandle, 1);
                rawContainerHandle.preDirty(true);
                try {
                    rawTransaction.logAndDo(containerOperation);
                    this.flush(rawTransaction.getLastLogInstant());
                    Object var21_17 = null;
                }
                catch (Throwable throwable) {
                    Object var21_18 = null;
                    rawContainerHandle.preDirty(false);
                    throw throwable;
                }
                rawContainerHandle.preDirty(false);
                {
                }
            }
            page = containerHandle2.addPage();
            Object var23_20 = null;
            if (page != null) {
                page.unlatch();
                page = null;
            }
            this.containerCache.release(fileContainer);
            if (containerHandle2 != null) {
                containerHandle2.close();
                containerHandle2 = null;
            }
            if (!bl) {
                lockingPolicy.unlockContainer(rawTransaction, containerHandle);
            }
        }
        catch (Throwable throwable) {
            Object var23_21 = null;
            if (page != null) {
                page.unlatch();
                page = null;
            }
            this.containerCache.release(fileContainer);
            if (containerHandle2 != null) {
                containerHandle2.close();
                containerHandle2 = null;
            }
            if (!bl) {
                lockingPolicy.unlockContainer(rawTransaction, containerHandle);
            }
            throw throwable;
        }
        return l3;
    }

    public long addAndLoadStreamContainer(RawTransaction rawTransaction, long l, Properties properties, RowSource rowSource) throws StandardException {
        long l2 = this.getNextId();
        ContainerKey containerKey = new ContainerKey(l, l2);
        StreamFileContainer streamFileContainer = new StreamFileContainer(containerKey, this, properties);
        streamFileContainer.load(rowSource);
        return l2;
    }

    public StreamContainerHandle openStreamContainer(RawTransaction rawTransaction, long l, long l2, boolean bl) throws StandardException {
        ContainerKey containerKey = new ContainerKey(l, l2);
        StreamFileContainer streamFileContainer = new StreamFileContainer(containerKey, this);
        if ((streamFileContainer = streamFileContainer.open(false)) == null) {
            return null;
        }
        StreamFileContainerHandle streamFileContainerHandle = new StreamFileContainerHandle(this.getIdentifier(), rawTransaction, streamFileContainer, bl);
        if (streamFileContainerHandle.useContainer()) {
            return streamFileContainerHandle;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dropStreamContainer(RawTransaction rawTransaction, long l, long l2) throws StandardException {
        boolean bl = l == -1L;
        StreamContainerHandle streamContainerHandle = null;
        try {
            ContainerKey containerKey = new ContainerKey(l, l2);
            rawTransaction.notifyObservers(containerKey);
            streamContainerHandle = rawTransaction.openStreamContainer(l, l2, false);
            if (bl && streamContainerHandle != null) {
                streamContainerHandle.removeContainer();
                Object var10_7 = null;
                if (streamContainerHandle != null) {
                    streamContainerHandle.close();
                }
                return;
            }
            Object var10_8 = null;
            if (streamContainerHandle != null) {
                streamContainerHandle.close();
            }
        }
        catch (Throwable throwable) {
            Object var10_9 = null;
            if (streamContainerHandle != null) {
                streamContainerHandle.close();
            }
            throw throwable;
        }
    }

    public void reCreateContainerForRedoRecovery(RawTransaction rawTransaction, long l, long l2, ByteArray byteArray) throws StandardException {
        ContainerKey containerKey = new ContainerKey(l, l2);
        FileContainer fileContainer = (FileContainer)this.containerCache.create(containerKey, byteArray);
        this.containerCache.release(fileContainer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void dropContainer(RawTransaction rawTransaction, ContainerKey containerKey) throws StandardException {
        RawContainerHandle rawContainerHandle;
        block10: {
            block9: {
                boolean bl = containerKey.getSegmentId() == -1L;
                LockingPolicy lockingPolicy = null;
                if (!bl) {
                    if (this.isReadOnly()) {
                        throw StandardException.newException("40XD1");
                    }
                    lockingPolicy = rawTransaction.newLockingPolicy(2, 5, true);
                }
                rawTransaction.notifyObservers(containerKey);
                rawContainerHandle = (RawContainerHandle)rawTransaction.openContainer(containerKey, lockingPolicy, 4);
                try {
                    if (rawContainerHandle == null || rawContainerHandle.getContainerStatus() != 1) {
                        if (!bl) throw StandardException.newException("40XD2", containerKey);
                        if (rawContainerHandle != null) {
                            rawContainerHandle.removeContainer(null);
                        }
                        Object var10_6 = null;
                        if (rawContainerHandle == null) return;
                        break block9;
                    }
                    if (bl) {
                        rawContainerHandle.dropContainer(null, true);
                        rawContainerHandle.removeContainer(null);
                        break block10;
                    }
                    ContainerOperation containerOperation = new ContainerOperation(rawContainerHandle, 2);
                    rawContainerHandle.preDirty(true);
                    try {
                        rawTransaction.logAndDo(containerOperation);
                        Object var8_10 = null;
                    }
                    catch (Throwable throwable) {
                        Object var8_11 = null;
                        rawContainerHandle.preDirty(false);
                        throw throwable;
                    }
                    rawContainerHandle.preDirty(false);
                    ReclaimSpace reclaimSpace = new ReclaimSpace(1, containerKey, (DataFactory)this, true);
                    rawTransaction.addPostCommitWork(reclaimSpace);
                    break block10;
                }
                catch (Throwable throwable) {
                    Object var10_8 = null;
                    if (rawContainerHandle == null) throw throwable;
                    rawContainerHandle.close();
                    throw throwable;
                }
            }
            rawContainerHandle.close();
            return;
        }
        Object var10_7 = null;
        if (rawContainerHandle == null) return;
        rawContainerHandle.close();
    }

    public void checkpoint() throws StandardException {
        this.pageCache.cleanAll();
        this.containerCache.cleanAll();
    }

    public void idle() throws StandardException {
        this.pageCache.ageOut();
        this.containerCache.ageOut();
    }

    public void setRawStoreFactory(RawStoreFactory rawStoreFactory, boolean bl, Properties properties) throws StandardException {
        this.rawStoreFactory = rawStoreFactory;
        this.bootLogFactory(bl, properties);
    }

    public UUID getIdentifier() {
        return this.identifier;
    }

    public int reclaimSpace(Serviceable serviceable, ContextManager contextManager) throws StandardException {
        if (serviceable == null) {
            return 1;
        }
        Transaction transaction = this.rawStoreFactory.findUserTransaction(contextManager, "SystemTransaction");
        return ReclaimSpaceHelper.reclaimSpace(this, (RawTransaction)transaction, (ReclaimSpace)serviceable);
    }

    public StandardException markCorrupt(StandardException standardException) {
        boolean bl = !this.isCorrupt;
        this.isCorrupt = true;
        if (this.getLogFactory() != null) {
            this.getLogFactory().markCorrupt(standardException);
        }
        if (bl) {
            if (this.pageCache != null) {
                this.pageCache.discard(null);
            }
            if (this.containerCache != null) {
                this.containerCache.discard(null);
            }
            this.pageCache = null;
            this.containerCache = null;
            this.releaseJBMSLockOnDB();
        }
        return standardException;
    }

    public FileResource getFileHandler() {
        return this.fileHandler;
    }

    public void removeStubsOK() {
        this.removeStubsOK = true;
    }

    public int getIntParameter(String string, Properties properties, int n, int n2, int n3) {
        String string2 = null;
        if (properties != null) {
            string2 = properties.getProperty(string);
        }
        if (string2 == null) {
            string2 = PropertyUtil.getSystemProperty(string);
        }
        if (string2 != null) {
            try {
                int n4 = Integer.parseInt(string2);
                if (n4 >= n2 && n4 <= n3) {
                    return n4;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return n;
    }

    CacheManager getContainerCache() {
        return this.containerCache;
    }

    CacheManager getPageCache() {
        return this.pageCache;
    }

    void flush(LogInstant logInstant) throws StandardException {
        this.getLogFactory().flush(logInstant);
    }

    private void syncSideLog(long l) throws StandardException {
    }

    LogFactory getLogFactory() {
        return this.logFactory;
    }

    RawStoreFactory getRawStoreFactory() {
        return this.rawStoreFactory;
    }

    public String getRootDirectory() {
        return this.dataDirectory;
    }

    Cacheable newContainerObject() {
        if (this.supportsRandomAccess) {
            return this.newRAFContainer(this);
        }
        return new InputStreamContainer(this);
    }

    protected Cacheable newRAFContainer(BaseDataFileFactory baseDataFileFactory) {
        return new RAFContainer(baseDataFileFactory);
    }

    private void pageToDirty(RawTransaction rawTransaction, StoredPage storedPage) throws StandardException {
    }

    private PageActions getLoggablePageActions() throws StandardException {
        if (this.loggablePageActions == null) {
            this.loggablePageActions = new LoggableActions();
        }
        return this.loggablePageActions;
    }

    private AllocationActions getLoggableAllocationActions() {
        if (this.loggableAllocActions == null) {
            this.loggableAllocActions = new LoggableAllocActions();
        }
        return this.loggableAllocActions;
    }

    synchronized StorageFile getTempDirectory() {
        this.actionCode = 1;
        try {
            return (StorageFile)AccessController.doPrivileged(this);
        }
        catch (PrivilegedActionException privilegedActionException) {
            return null;
        }
    }

    private synchronized void removeTempDirectory() {
        if (this.storageFactory != null) {
            this.actionCode = 2;
            try {
                AccessController.doPrivileged(this);
            }
            catch (PrivilegedActionException privilegedActionException) {
                // empty catch block
            }
        }
    }

    public StorageFile getContainerPath(ContainerKey containerKey, boolean bl) {
        return this.getContainerPath(containerKey, bl, 3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private synchronized StorageFile getContainerPath(ContainerKey containerKey, boolean bl, int n) {
        Throwable throwable2;
        StorageFile storageFile;
        this.actionCode = n;
        this.containerId = containerKey;
        this.stub = bl;
        try {
            storageFile = (StorageFile)AccessController.doPrivileged(this);
        }
        catch (PrivilegedActionException privilegedActionException) {
            try {
                StorageFile storageFile2 = null;
                Object var7_7 = null;
                this.containerId = null;
                return storageFile2;
            }
            catch (Throwable throwable2) {
                Object var7_8 = null;
                this.containerId = null;
            }
        }
        Object var7_6 = null;
        this.containerId = null;
        return storageFile;
        throw throwable2;
    }

    public StorageFile getAlternateContainerPath(ContainerKey containerKey, boolean bl) {
        return this.getContainerPath(containerKey, bl, 4);
    }

    private synchronized void removeStubs() {
        this.actionCode = 9;
        try {
            AccessController.doPrivileged(this);
        }
        catch (PrivilegedActionException privilegedActionException) {
            // empty catch block
        }
    }

    public void stubFileToRemoveAfterCheckPoint(StorageFile storageFile, LogInstant logInstant, Object object) {
        if (this.droppedTableStubInfo != null) {
            Object[] objectArray = new Object[]{storageFile, object};
            this.droppedTableStubInfo.put(logInstant, objectArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDroppedContainerFileStubs(LogInstant logInstant) throws StandardException {
        if (this.droppedTableStubInfo != null) {
            Hashtable hashtable = this.droppedTableStubInfo;
            synchronized (hashtable) {
                Enumeration enumeration = this.droppedTableStubInfo.keys();
                while (enumeration.hasMoreElements()) {
                    LogInstant logInstant2 = (LogInstant)enumeration.nextElement();
                    if (!logInstant2.lessThan(logInstant)) continue;
                    Object[] objectArray = (Object[])this.droppedTableStubInfo.get(logInstant2);
                    Object object = objectArray[1];
                    Cacheable cacheable = this.containerCache.findCached(object);
                    if (cacheable != null) {
                        this.containerCache.remove(cacheable);
                    }
                    BaseDataFileFactory baseDataFileFactory = this;
                    synchronized (baseDataFileFactory) {
                        this.actionFile = (StorageFile)objectArray[0];
                        this.actionCode = 6;
                        try {
                            if (AccessController.doPrivileged(this) != null) {
                                this.droppedTableStubInfo.remove(logInstant2);
                            }
                        }
                        catch (PrivilegedActionException privilegedActionException) {
                            // empty catch block
                        }
                    }
                }
            }
        }
    }

    private synchronized long findMaxContainerId() {
        this.actionCode = 5;
        try {
            return (Long)AccessController.doPrivileged(this);
        }
        catch (PrivilegedActionException privilegedActionException) {
            return 0L;
        }
    }

    private void bootLogFactory(boolean bl, Properties properties) throws StandardException {
        if (this.isReadOnly()) {
            properties.put("derby.__rt.storage.log", "readonly");
        }
        this.logFactory = (LogFactory)Monitor.bootServiceModule(bl, this, this.rawStoreFactory.getLogFactoryModule(), properties);
    }

    private boolean handleServiceType(String string) {
        try {
            PersistentService persistentService = Monitor.getMonitor().getServiceProvider(string);
            return persistentService != null && persistentService.hasStorageFactory();
        }
        catch (StandardException standardException) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getJBMSLockOnDB(UUID uUID, UUIDFactory uUIDFactory, String string) throws StandardException {
        if (this.fileLockOnDB != null) {
            return;
        }
        if (this.isReadOnly()) {
            return;
        }
        BaseDataFileFactory baseDataFileFactory = this;
        synchronized (baseDataFileFactory) {
            this.actionCode = 11;
            this.myUUID = uUID;
            this.uuidFactory = uUIDFactory;
            this.databaseDirectory = string;
            try {
                try {
                    AccessController.doPrivileged(this);
                }
                catch (PrivilegedActionException privilegedActionException) {
                    throw (StandardException)privilegedActionException.getException();
                }
                Object var7_5 = null;
                this.myUUID = null;
                this.uuidFactory = null;
                this.databaseDirectory = null;
            }
            catch (Throwable throwable) {
                Object var7_6 = null;
                this.myUUID = null;
                this.uuidFactory = null;
                this.databaseDirectory = null;
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void privGetJBMSLockOnDB() throws StandardException {
        Object[] objectArray;
        boolean bl = false;
        String string = null;
        StorageFile storageFile = this.storageFactory.newStorageFile("db.lck");
        try {
            if (storageFile.exists()) {
                bl = true;
                this.fileLockOnDB = storageFile.getRandomAccessFile("rw");
                try {
                    string = this.fileLockOnDB.readUTF();
                }
                catch (IOException iOException) {
                    bl = false;
                }
                this.fileLockOnDB.close();
                this.fileLockOnDB = null;
                if (!storageFile.delete()) {
                    throw StandardException.newException("XSDB6.D", this.databaseDirectory);
                }
            }
            this.fileLockOnDB = storageFile.getRandomAccessFile("rw");
            this.fileLockOnDB.writeUTF(this.myUUID.toString());
            this.fileLockOnDB.sync(false);
            this.fileLockOnDB.seek(0L);
            objectArray = this.uuidFactory.recreateUUID(this.fileLockOnDB.readUTF());
            if (!objectArray.equals(this.myUUID)) {
                throw StandardException.newException("XSDB6.D", this.databaseDirectory);
            }
        }
        catch (IOException iOException) {
            this.readOnly = true;
            try {
                if (this.fileLockOnDB != null) {
                    this.fileLockOnDB.close();
                }
            }
            catch (IOException iOException2) {
                // empty catch block
            }
            this.fileLockOnDB = null;
            return;
        }
        if (storageFile.delete()) {
            objectArray = new Object[]{this.myUUID, this.databaseDirectory, string};
            int n = 0;
            if (!this.throwDBlckException) {
                this.exFileLock = this.storageFactory.newStorageFile("dbex.lck");
                n = this.exFileLock.getExclusiveFileLock();
            }
            if (n == 0 && bl && !this.throwDBlckException) {
                StandardException standardException = StandardException.newException("XSDB7.D", objectArray);
                String string2 = MessageService.getCompleteMessage("XSDB7.D", objectArray);
                this.logMsg(string2);
                System.err.println(string2);
            }
            try {
                try {
                    if (this.fileLockOnDB != null) {
                        this.fileLockOnDB.close();
                    }
                    this.fileLockOnDB = storageFile.getRandomAccessFile("rw");
                    this.fileLockOnDB.writeUTF(this.myUUID.toString());
                    this.fileLockOnDB.sync(false);
                    this.fileLockOnDB.close();
                }
                catch (IOException iOException) {
                    try {
                        this.fileLockOnDB.close();
                    }
                    catch (IOException iOException3) {
                    }
                    Object var9_14 = null;
                    this.fileLockOnDB = null;
                }
                Object var9_13 = null;
                this.fileLockOnDB = null;
            }
            catch (Throwable throwable) {
                Object var9_15 = null;
                this.fileLockOnDB = null;
                throw throwable;
            }
            if (bl && this.throwDBlckException) {
                throw StandardException.newException("XSDB8.D", objectArray);
            }
            if (n == 2) {
                throw StandardException.newException("XSDB6.D", this.databaseDirectory);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseJBMSLockOnDB() {
        if (this.isReadOnly()) {
            return;
        }
        BaseDataFileFactory baseDataFileFactory = this;
        synchronized (baseDataFileFactory) {
            this.actionCode = 12;
            try {
                try {
                    AccessController.doPrivileged(this);
                }
                catch (PrivilegedActionException privilegedActionException) {
                    Object var4_3 = null;
                    this.fileLockOnDB = null;
                }
                Object var4_2 = null;
                this.fileLockOnDB = null;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                this.fileLockOnDB = null;
                throw throwable;
            }
        }
    }

    private void privReleaseJBMSLockOnDB() throws IOException {
        if (this.fileLockOnDB != null) {
            this.fileLockOnDB.close();
        }
        if (this.storageFactory != null) {
            StorageFile storageFile = this.storageFactory.newStorageFile("db.lck");
            storageFile.delete();
        }
        if (this.exFileLock != null) {
            this.exFileLock.releaseExclusiveFileLock();
        }
    }

    private void logMsg(String string) {
        if (this.istream == null) {
            this.istream = Monitor.getStream();
        }
        this.istream.println(string);
    }

    public final boolean databaseEncrypted() {
        return this.databaseEncrypted;
    }

    public void setDatabaseEncrypted() {
        this.databaseEncrypted = true;
    }

    public int encrypt(byte[] byArray, int n, int n2, byte[] byArray2, int n3, boolean bl) throws StandardException {
        return this.rawStoreFactory.encrypt(byArray, n, n2, byArray2, n3, bl);
    }

    public int decrypt(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws StandardException {
        return this.rawStoreFactory.decrypt(byArray, n, n2, byArray2, n3);
    }

    public void encryptAllContainers(RawTransaction rawTransaction) throws StandardException {
        this.containerEncrypter = new EncryptData(this);
        this.containerEncrypter.encryptAllContainers(rawTransaction);
    }

    public void removeOldVersionOfContainers(boolean bl) throws StandardException {
        if (bl) {
            this.containerEncrypter = new EncryptData(this);
        }
        this.containerEncrypter.removeOldVersionOfContainers(bl);
        this.containerEncrypter = null;
    }

    public int getEncryptionBlockSize() {
        return this.rawStoreFactory.getEncryptionBlockSize();
    }

    public String getVersionedName(String string, long l) {
        return string.concat(".G".concat(Long.toString(l)));
    }

    public long getMaxContainerId() throws StandardException {
        return this.findMaxContainerId();
    }

    synchronized long getNextId() {
        return this.nextContainerId++;
    }

    int random() {
        return this.databaseEncrypted ? this.rawStoreFactory.random() : 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fileToRemove(StorageFile storageFile, boolean bl) {
        if (this.postRecoveryRemovedFiles == null) {
            this.postRecoveryRemovedFiles = new Hashtable();
        }
        String string = null;
        BaseDataFileFactory baseDataFileFactory = this;
        synchronized (baseDataFileFactory) {
            this.actionCode = 7;
            this.actionFile = storageFile;
            try {
                try {
                    string = (String)AccessController.doPrivileged(this);
                }
                catch (PrivilegedActionException privilegedActionException) {
                    Object var7_6 = null;
                    this.actionFile = null;
                }
                Object var7_5 = null;
                this.actionFile = null;
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                this.actionFile = null;
                throw throwable;
            }
        }
        if (bl) {
            this.postRecoveryRemovedFiles.put(string, storageFile);
        } else {
            this.postRecoveryRemovedFiles.remove(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postRecovery() throws StandardException {
        DaemonService daemonService = this.rawStoreFactory.getDaemon();
        if (daemonService == null) {
            return;
        }
        if (this.postRecoveryRemovedFiles != null) {
            BaseDataFileFactory baseDataFileFactory = this;
            synchronized (baseDataFileFactory) {
                this.actionCode = 8;
                try {
                    AccessController.doPrivileged(this);
                }
                catch (PrivilegedActionException privilegedActionException) {
                    // empty catch block
                }
            }
            this.postRecoveryRemovedFiles = null;
        }
    }

    public void setupCacheCleaner(DaemonService daemonService) {
        this.containerCache.useDaemonService(daemonService);
        this.pageCache.useDaemonService(daemonService);
    }

    /*
     * Exception decompiling
     */
    public void freezePersistentStore() throws StandardException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unfreezePersistentStore() {
        Object object = this.freezeSemaphore;
        synchronized (object) {
            this.isFrozen = false;
            this.freezeSemaphore.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeInProgress() throws StandardException {
        Object object = this.freezeSemaphore;
        synchronized (object) {
            while (this.isFrozen) {
                try {
                    this.freezeSemaphore.wait();
                }
                catch (InterruptedException interruptedException) {
                    throw StandardException.interrupt(interruptedException);
                }
            }
            ++this.writersInProgress;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeFinished() {
        Object object = this.freezeSemaphore;
        synchronized (object) {
            --this.writersInProgress;
            this.freezeSemaphore.notifyAll();
        }
    }

    public void backupDataFiles(Transaction transaction, File file) throws StandardException {
        String[] stringArray = this.getContainerNames();
        if (stringArray != null) {
            LockingPolicy lockingPolicy = transaction.newLockingPolicy(0, 0, false);
            long l = 0L;
            for (int i = stringArray.length - 1; i >= 0; --i) {
                long l2;
                try {
                    l2 = Long.parseLong(stringArray[i].substring(1, stringArray[i].length() - 4), 16);
                }
                catch (Throwable throwable) {
                    continue;
                }
                ContainerKey containerKey = new ContainerKey(l, l2);
                RawContainerHandle rawContainerHandle = this.openDroppedContainer((RawTransaction)transaction, containerKey, lockingPolicy, 8);
                if (rawContainerHandle == null) continue;
                rawContainerHandle.backupContainer(file.getPath());
                rawContainerHandle.close();
            }
        }
    }

    synchronized String[] getContainerNames() {
        this.actionCode = 14;
        try {
            return (String[])AccessController.doPrivileged(this);
        }
        catch (PrivilegedActionException privilegedActionException) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void restoreDataDirectory(String string) throws StandardException {
        final File file = new File(string);
        String[] stringArray = (String[])AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return file.list();
            }
        });
        if (stringArray != null) {
            boolean bl = false;
            for (int i = 0; i < stringArray.length; ++i) {
                boolean bl2;
                File file2;
                boolean bl3;
                if (!stringArray[i].startsWith("seg") || !(bl3 = ((Boolean)AccessController.doPrivileged(new PrivilegedAction(file2 = new File(file, stringArray[i])){
                    private final /* synthetic */ File val$bsegdir;
                    {
                        this.val$bsegdir = file;
                    }

                    public Object run() {
                        return new Boolean(this.val$bsegdir.exists());
                    }
                })).booleanValue()) || !(bl2 = ((Boolean)AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        return new Boolean(file2.isDirectory());
                    }
                })).booleanValue())) continue;
                bl = true;
                break;
            }
            if (!bl) {
                throw StandardException.newException("XSDG6.D", file);
            }
        } else {
            throw StandardException.newException("XSDG6.D", file);
        }
        BaseDataFileFactory baseDataFileFactory = this;
        synchronized (baseDataFileFactory) {
            this.actionCode = 13;
            this.backupPath = string;
            this.backupRoot = file;
            this.bfilelist = stringArray;
            try {
                try {
                    AccessController.doPrivileged(this);
                }
                catch (PrivilegedActionException privilegedActionException) {
                    throw (StandardException)privilegedActionException.getException();
                }
                Object var10_11 = null;
                this.backupPath = null;
                this.backupRoot = null;
                this.bfilelist = null;
            }
            catch (Throwable throwable) {
                Object var10_12 = null;
                this.backupPath = null;
                this.backupRoot = null;
                this.bfilelist = null;
                throw throwable;
            }
        }
    }

    private void privRestoreDataDirectory() throws StandardException {
        StorageFile storageFile;
        int n;
        StorageFile storageFile2 = this.storageFactory.newStorageFile(null);
        String[] stringArray = storageFile2.list();
        if (stringArray != null) {
            for (n = 0; n < stringArray.length; ++n) {
                if (!stringArray[n].startsWith("seg") || (storageFile = this.storageFactory.newStorageFile(stringArray[n])).deleteAll()) continue;
                throw StandardException.newException("XSDG7.D", storageFile);
            }
        }
        for (n = 0; n < this.bfilelist.length; ++n) {
            StorageFile storageFile3;
            File file;
            if (this.bfilelist[n].startsWith("seg")) {
                file = new File(this.backupRoot, this.bfilelist[n]);
                storageFile = this.storageFactory.newStorageFile(this.bfilelist[n]);
                if (FileUtil.copyDirectory(this.writableStorageFactory, file, storageFile)) continue;
                throw StandardException.newException("XSDG8.D", (Object)file, (Object)storageFile);
            }
            if (!this.databaseEncrypted || !this.bfilelist[n].startsWith("verifyKey.dat") || FileUtil.copyFile(this.writableStorageFactory, file = new File(this.backupRoot, this.bfilelist[n]), storageFile3 = this.storageFactory.newStorageFile(this.bfilelist[n]))) continue;
            throw StandardException.newException("XSDG8.D", (Object)this.bfilelist[n], (Object)storageFile3);
        }
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public StorageFactory getStorageFactory() {
        return this.storageFactory;
    }

    public final Object run() throws IOException, StandardException {
        switch (this.actionCode) {
            case 10: {
                this.readOnly = this.storageFactory.isReadOnlyDatabase();
                this.supportsRandomAccess = this.storageFactory.supportsRandomAccess();
                return null;
            }
            case 1: {
                return this.storageFactory.getTempDir();
            }
            case 2: {
                StorageFile storageFile = this.storageFactory.getTempDir();
                if (storageFile != null) {
                    storageFile.deleteAll();
                }
                return null;
            }
            case 3: 
            case 4: {
                StringBuffer stringBuffer = new StringBuffer("seg");
                stringBuffer.append(this.containerId.getSegmentId());
                stringBuffer.append(this.storageFactory.getSeparator());
                if (this.actionCode == 3) {
                    stringBuffer.append(this.stub ? (char)'d' : 'c');
                    stringBuffer.append(Long.toHexString(this.containerId.getContainerId()));
                    stringBuffer.append(".dat");
                } else {
                    stringBuffer.append(this.stub ? (char)'D' : 'C');
                    stringBuffer.append(Long.toHexString(this.containerId.getContainerId()));
                    stringBuffer.append(".DAT");
                }
                return this.storageFactory.newStorageFile(stringBuffer.toString());
            }
            case 9: {
                char c = this.storageFactory.getSeparator();
                StorageFile storageFile = this.storageFactory.newStorageFile(null);
                String[] stringArray = storageFile.list();
                for (int i = stringArray.length - 1; i >= 0; --i) {
                    StorageFile storageFile2;
                    if (!stringArray[i].startsWith("seg") || !(storageFile2 = this.storageFactory.newStorageFile(storageFile, stringArray[i])).exists() || !storageFile2.isDirectory()) continue;
                    String[] stringArray2 = storageFile2.list();
                    for (int j = stringArray2.length - 1; j >= 0; --j) {
                        if (!stringArray2[j].startsWith("D") && !stringArray2[j].startsWith("d")) continue;
                        StorageFile storageFile3 = this.storageFactory.newStorageFile(storageFile, stringArray[i] + c + stringArray2[j]);
                        boolean bl = storageFile3.delete();
                    }
                }
                break;
            }
            case 5: {
                long l = 1L;
                StorageFile storageFile = this.storageFactory.newStorageFile("seg0");
                if (storageFile.exists() && storageFile.isDirectory()) {
                    String[] stringArray = storageFile.list();
                    for (int i = stringArray.length - 1; i >= 0; --i) {
                        try {
                            long l2 = Long.parseLong(stringArray[i].substring(1, stringArray[i].length() - 4), 16);
                            if (l2 <= l) continue;
                            l = l2;
                            continue;
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                }
                return ReuseFactory.getLong(l);
            }
            case 6: {
                boolean bl = this.actionFile.exists() && this.actionFile.delete();
                this.actionFile = null;
                return bl ? this : null;
            }
            case 7: {
                String string = this.actionFile.getPath();
                this.actionFile = null;
                return string;
            }
            case 8: {
                Enumeration enumeration = this.postRecoveryRemovedFiles.elements();
                while (enumeration.hasMoreElements()) {
                    StorageFile storageFile = (StorageFile)enumeration.nextElement();
                    if (!storageFile.exists()) continue;
                    boolean bl = storageFile.delete();
                }
                return null;
            }
            case 11: {
                this.privGetJBMSLockOnDB();
                return null;
            }
            case 12: {
                this.privReleaseJBMSLockOnDB();
                return null;
            }
            case 13: {
                this.privRestoreDataDirectory();
                return null;
            }
            case 14: {
                StorageFile storageFile = this.storageFactory.newStorageFile("seg0");
                if (storageFile.exists() && storageFile.isDirectory()) {
                    return storageFile.list();
                }
                return null;
            }
        }
        return null;
    }
}

