/*
 * Decompiled with CFR 0.152.
 */
package com.sun.prism.es2;

import com.sun.glass.ui.Screen;
import com.sun.prism.Graphics;
import com.sun.prism.Image;
import com.sun.prism.PixelFormat;
import com.sun.prism.RTTexture;
import com.sun.prism.ReadbackRenderTarget;
import com.sun.prism.Texture;
import com.sun.prism.es2.ES2Context;
import com.sun.prism.es2.ES2Graphics;
import com.sun.prism.es2.ES2Pipeline;
import com.sun.prism.es2.ES2Texture;
import com.sun.prism.es2.gl.GLContext;
import com.sun.prism.impl.PrismSettings;
import com.sun.prism.impl.PrismTrace;
import java.nio.Buffer;

class ES2RTTexture
extends ES2Texture
implements RTTexture,
ReadbackRenderTarget {
    private int fboID;
    private int dbID;
    private boolean opaque;

    private ES2RTTexture(ES2Context eS2Context, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        super(eS2Context, PixelFormat.BYTE_BGRA_PRE, n2, n3, n4, n5, n6, n7, n8, new ES2RTTextureDisposerRecord(eS2Context, n2, n));
        this.fboID = n;
        this.dbID = 0;
        this.opaque = false;
    }

    void attachDepthBuffer(ES2Context eS2Context) {
        if (this.dbID != 0) {
            return;
        }
        this.dbID = eS2Context.getGLContext().createDepthBuffer(this.getPhysicalWidth(), this.getPhysicalHeight());
        ((ES2RTTextureDisposerRecord)this.disposerRecord).setDepthBufferID(this.dbID);
    }

    static ES2RTTexture create(ES2Context eS2Context, int n, int n2) {
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        int n10;
        boolean bl;
        boolean bl2 = bl = !ES2Pipeline.glFactory.isGL2();
        if (bl) {
            n10 = 2;
            n9 = 2;
            n8 = n + 4;
            n7 = n2 + 4;
        } else {
            n10 = 0;
            n9 = 0;
            n8 = n;
            n7 = n2;
        }
        GLContext gLContext = eS2Context.getGLContext();
        int n11 = gLContext.getMaxTextureSize();
        if (gLContext.canCreateNonPowTwoTextures()) {
            n6 = n8 <= n11 ? n8 : 0;
            n5 = n7 <= n11 ? n7 : 0;
        } else {
            n6 = ES2RTTexture.nextPowerOfTwo(n8, n11);
            n5 = ES2RTTexture.nextPowerOfTwo(n7, n11);
        }
        if (n6 == 0 || n5 == 0) {
            throw new RuntimeException("Requested texture dimensions (" + n + "x" + n2 + ") " + "require dimensions (" + n6 + "x" + n5 + ") " + "that exceed maximum texture size (" + n11 + ")");
        }
        int n12 = PrismSettings.minTextureSize;
        n6 = Math.max(n6, n12);
        n5 = Math.max(n5, n12);
        if (bl) {
            n4 = n6 - 4;
            n3 = n5 - 4;
        } else {
            n4 = n6;
            n3 = n5;
        }
        gLContext.setActiveTextureUnit(0);
        int n13 = gLContext.getBoundTexture();
        int n14 = gLContext.createTexture(n6, n5);
        int n15 = gLContext.createFBO(n14, n6, n5);
        gLContext.setBoundTexture(n13);
        return new ES2RTTexture(eS2Context, n15, n14, n6, n5, n10, n9, n4, n3);
    }

    @Override
    public Texture getBackBuffer() {
        return this;
    }

    @Override
    public Graphics createGraphics() {
        return ES2Graphics.create(this.context, this);
    }

    @Override
    public int[] getPixels() {
        return null;
    }

    @Override
    public boolean readPixels(Buffer buffer) {
        this.context.flushVertexBuffer();
        GLContext gLContext = this.context.getGLContext();
        return gLContext.readPixels(buffer, this.getContentX(), this.getContentY(), this.getContentWidth(), this.getContentHeight());
    }

    @Override
    public long getNativeDestHandle() {
        return this.fboID;
    }

    @Override
    public Screen getAssociatedScreen() {
        return this.context.getAssociatedScreen();
    }

    @Override
    public void update(Image image) {
        throw new UnsupportedOperationException("update() not supported for RTTextures");
    }

    @Override
    public void update(Image image, int n, int n2) {
        throw new UnsupportedOperationException("update() not supported for RTTextures");
    }

    @Override
    public void update(Image image, int n, int n2, int n3, int n4) {
        throw new UnsupportedOperationException("update() not supported for RTTextures");
    }

    @Override
    public void update(Image image, int n, int n2, int n3, int n4, boolean bl) {
        throw new UnsupportedOperationException("update() not supported for RTTextures");
    }

    @Override
    public void update(Buffer buffer, PixelFormat pixelFormat, int n, int n2, int n3, int n4, int n5, int n6, int n7, boolean bl) {
        throw new UnsupportedOperationException("update() not supported for RTTextures");
    }

    @Override
    public boolean isOpaque() {
        return this.opaque;
    }

    @Override
    public void setOpaque(boolean bl) {
        this.opaque = bl;
    }

    @Override
    public boolean isVolatile() {
        return false;
    }

    static class ES2RTTextureDisposerRecord
    extends ES2Texture.ES2TextureDisposerRecord {
        private int fboID;
        private int dbID;

        ES2RTTextureDisposerRecord(ES2Context eS2Context, int n, int n2) {
            super(eS2Context, n);
            this.fboID = n2;
        }

        @Override
        void traceDispose() {
            PrismTrace.rttDisposed(this.fboID);
        }

        @Override
        public void dispose() {
            super.dispose();
            if (this.fboID != 0) {
                this.context.getGLContext().deleteFBO(this.fboID);
                if (this.dbID != 0) {
                    this.context.getGLContext().deleteRenderBuffer(this.dbID);
                    this.dbID = 0;
                }
                this.fboID = 0;
            }
        }

        void setDepthBufferID(int n) {
            this.dbID = n;
        }
    }
}

