/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.text;

import com.sun.javafx.css.StyleConverter;
import com.sun.javafx.css.StyleableBooleanProperty;
import com.sun.javafx.css.StyleableObjectProperty;
import com.sun.javafx.css.StyleableProperty;
import com.sun.javafx.css.converters.BooleanConverter;
import com.sun.javafx.css.converters.EnumConverter;
import com.sun.javafx.geom.BaseBounds;
import com.sun.javafx.geom.RectBounds;
import com.sun.javafx.geom.Shape;
import com.sun.javafx.geom.transform.Affine3D;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.javafx.scene.DirtyBits;
import com.sun.javafx.scene.shape.PathUtils;
import com.sun.javafx.scene.text.HitInfo;
import com.sun.javafx.sg.PGNode;
import com.sun.javafx.sg.PGShape;
import com.sun.javafx.sg.PGText;
import com.sun.javafx.sg.PGTextHelper;
import com.sun.javafx.tk.FontLoader;
import com.sun.javafx.tk.Toolkit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javafx.beans.DefaultProperty;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.BooleanPropertyBase;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.DoublePropertyBase;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.IntegerPropertyBase;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ObjectPropertyBase;
import javafx.beans.property.ReadOnlyDoubleProperty;
import javafx.beans.property.ReadOnlyDoubleWrapper;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.property.StringPropertyBase;
import javafx.beans.value.WritableValue;
import javafx.collections.ObservableList;
import javafx.geometry.BoundingBox;
import javafx.geometry.Bounds;
import javafx.geometry.Point2D;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.PathElement;
import javafx.scene.text.Font;
import javafx.scene.text.FontSmoothingType;
import javafx.scene.text.TextAlignment;
import javafx.scene.text.TextBoundsType;
import javafx.scene.transform.Transform;

@DefaultProperty(value="text")
public class Text
extends javafx.scene.shape.Shape {
    private PGTextHelper textHelper;
    private static FontLoader fontLoader = null;
    private StringProperty text;
    private DoubleProperty x;
    private DoubleProperty y;
    private ObjectProperty<Font> font;
    private ObjectProperty<VPos> textOrigin;
    private ObjectProperty<TextBoundsType> boundsType;
    private DoubleProperty wrappingWidth;
    private BooleanProperty underline;
    private BooleanProperty strikethrough;
    private ObjectProperty<TextAlignment> textAlignment;
    private ReadOnlyDoubleWrapper baselineOffset;
    private ObjectProperty<FontSmoothingType> fontSmoothingType;
    @Deprecated
    private ObjectProperty<PathElement[]> impl_selectionShape;
    @Deprecated
    private IntegerProperty impl_selectionStart;
    @Deprecated
    private IntegerProperty impl_selectionEnd;
    @Deprecated
    private ObjectProperty<PathElement[]> impl_caretShape;
    @Deprecated
    private IntegerProperty impl_caretPosition;
    @Deprecated
    private BooleanProperty impl_caretBias;
    private RectBounds impl_layoutBounds = new RectBounds();
    private boolean impl_layoutBoundsInvalid = true;
    private ObjectProperty<Paint> selectionFill;

    @Override
    @Deprecated
    protected final PGNode impl_createPGNode() {
        return Toolkit.getToolkit().createPGText();
    }

    private PGText getPGText() {
        return (PGText)this.impl_getPGNode();
    }

    private PGTextHelper getTextHelper() {
        if (this.textHelper == null) {
            Scene.impl_setAllowPGAccess(true);
            this.textHelper = this.getPGText().getTextHelper();
            Scene.impl_setAllowPGAccess(false);
        }
        this.updatePGTextHelper(this.textHelper);
        return this.textHelper;
    }

    public Text() {
        if (fontLoader == null) {
            fontLoader = Toolkit.getToolkit().getFontLoader();
        }
        this.setPickOnBounds(true);
        this.getDecorationShapes();
        this.setBaselineOffset(fontLoader.getFontMetrics(this.getFontInternal()).getAscent());
    }

    public Text(String string) {
        this();
        this.setText(string);
    }

    public Text(double d, double d2, String string) {
        this(string);
        this.setX(d);
        this.setY(d2);
    }

    public final void setText(String string) {
        if (string == null) {
            string = "";
        }
        this.textProperty().set(string);
    }

    public final String getText() {
        return this.text == null ? "" : (String)this.text.get();
    }

    private String getTextInternal() {
        String string = this.getText();
        return string == null ? "" : string;
    }

    public final StringProperty textProperty() {
        if (this.text == null) {
            this.text = new StringPropertyBase(""){

                @Override
                public void invalidated() {
                    Text.this.impl_markDirty(DirtyBits.NODE_CONTENTS);
                    Text.this.setImpl_selectionStart(-1);
                    Text.this.setImpl_selectionEnd(-1);
                    Text.this.impl_geomChanged();
                    String string = this.get();
                    if (string == null && !this.isBound()) {
                        this.set("");
                    }
                }

                @Override
                public Object getBean() {
                    return Text.this;
                }

                @Override
                public String getName() {
                    return "text";
                }
            };
        }
        return this.text;
    }

    public final void setX(double d) {
        this.xProperty().set(d);
    }

    public final double getX() {
        return this.x == null ? 0.0 : this.x.get();
    }

    public final DoubleProperty xProperty() {
        if (this.x == null) {
            this.x = new DoublePropertyBase(){

                @Override
                public void invalidated() {
                    Text.this.impl_markDirty(DirtyBits.NODE_GEOMETRY);
                    Text.this.impl_geomChanged();
                }

                @Override
                public Object getBean() {
                    return Text.this;
                }

                @Override
                public String getName() {
                    return "x";
                }
            };
        }
        return this.x;
    }

    public final void setY(double d) {
        this.yProperty().set(d);
    }

    public final double getY() {
        return this.y == null ? 0.0 : this.y.get();
    }

    public final DoubleProperty yProperty() {
        if (this.y == null) {
            this.y = new DoublePropertyBase(){

                @Override
                public void invalidated() {
                    Text.this.impl_markDirty(DirtyBits.NODE_GEOMETRY);
                    Text.this.impl_geomChanged();
                }

                @Override
                public Object getBean() {
                    return Text.this;
                }

                @Override
                public String getName() {
                    return "y";
                }
            };
        }
        return this.y;
    }

    public final void setFont(Font font) {
        this.fontProperty().set(font);
    }

    public final Font getFont() {
        return this.font == null ? Font.getDefault() : (Font)this.font.get();
    }

    private Font getFontInternal() {
        Font font = this.getFont();
        return font != null ? font : Font.getDefault();
    }

    public final ObjectProperty<Font> fontProperty() {
        if (this.font == null) {
            this.font = new StyleableObjectProperty<Font>(Font.getDefault()){

                @Override
                public void invalidated() {
                    Text.this.impl_markDirty(DirtyBits.TEXT_FONT);
                    Text.this.impl_geomChanged();
                    Text.this.setBaselineOffset(fontLoader.getFontMetrics(Text.this.getFontInternal()).getAscent());
                }

                @Override
                public StyleableProperty getStyleableProperty() {
                    return StyleableProperties.FONT;
                }

                @Override
                public Object getBean() {
                    return Text.this;
                }

                @Override
                public String getName() {
                    return "font";
                }
            };
        }
        return this.font;
    }

    public final void setTextOrigin(VPos vPos) {
        this.textOriginProperty().set(vPos);
    }

    public final VPos getTextOrigin() {
        return this.textOrigin == null ? VPos.BASELINE : (VPos)((Object)this.textOrigin.get());
    }

    public final ObjectProperty<VPos> textOriginProperty() {
        if (this.textOrigin == null) {
            this.textOrigin = new StyleableObjectProperty<VPos>(VPos.BASELINE){

                @Override
                public void invalidated() {
                    Text.this.impl_markDirty(DirtyBits.TEXT_ATTRS);
                    Text.this.impl_geomChanged();
                }

                @Override
                public StyleableProperty getStyleableProperty() {
                    return StyleableProperties.TEXT_ORIGIN;
                }

                @Override
                public Object getBean() {
                    return Text.this;
                }

                @Override
                public String getName() {
                    return "textOrigin";
                }
            };
        }
        return this.textOrigin;
    }

    public final void setBoundsType(TextBoundsType textBoundsType) {
        this.boundsTypeProperty().set(textBoundsType);
    }

    public final TextBoundsType getBoundsType() {
        return this.boundsType == null ? TextBoundsType.LOGICAL : (TextBoundsType)((Object)this.boundsType.get());
    }

    public final ObjectProperty<TextBoundsType> boundsTypeProperty() {
        if (this.boundsType == null) {
            this.boundsType = new ObjectPropertyBase<TextBoundsType>(TextBoundsType.LOGICAL){

                @Override
                public void invalidated() {
                    Text.this.impl_markDirty(DirtyBits.TEXT_ATTRS);
                    Text.this.impl_geomChanged();
                }

                @Override
                public Object getBean() {
                    return Text.this;
                }

                @Override
                public String getName() {
                    return "boundsType";
                }
            };
        }
        return this.boundsType;
    }

    public final void setWrappingWidth(double d) {
        this.wrappingWidthProperty().set(d);
    }

    public final double getWrappingWidth() {
        return this.wrappingWidth == null ? 0.0 : this.wrappingWidth.get();
    }

    public final DoubleProperty wrappingWidthProperty() {
        if (this.wrappingWidth == null) {
            this.wrappingWidth = new DoublePropertyBase(){

                @Override
                public void invalidated() {
                    Text.this.impl_markDirty(DirtyBits.TEXT_ATTRS);
                    Text.this.impl_geomChanged();
                }

                @Override
                public Object getBean() {
                    return Text.this;
                }

                @Override
                public String getName() {
                    return "wrappingWidth";
                }
            };
        }
        return this.wrappingWidth;
    }

    public final void setUnderline(boolean bl) {
        this.underlineProperty().set(bl);
    }

    public final boolean isUnderline() {
        return this.underline == null ? false : this.underline.get();
    }

    public final BooleanProperty underlineProperty() {
        if (this.underline == null) {
            this.underline = new StyleableBooleanProperty(){

                @Override
                public void invalidated() {
                    Text.this.impl_markDirty(DirtyBits.TEXT_ATTRS);
                    Text.this.impl_geomChanged();
                }

                @Override
                public StyleableProperty getStyleableProperty() {
                    return StyleableProperties.UNDERLINE;
                }

                @Override
                public Object getBean() {
                    return Text.this;
                }

                @Override
                public String getName() {
                    return "underline";
                }
            };
        }
        return this.underline;
    }

    public final void setStrikethrough(boolean bl) {
        this.strikethroughProperty().set(bl);
    }

    public final boolean isStrikethrough() {
        return this.strikethrough == null ? false : this.strikethrough.get();
    }

    public final BooleanProperty strikethroughProperty() {
        if (this.strikethrough == null) {
            this.strikethrough = new StyleableBooleanProperty(){

                @Override
                public void invalidated() {
                    Text.this.impl_markDirty(DirtyBits.TEXT_ATTRS);
                    Text.this.impl_geomChanged();
                }

                @Override
                public StyleableProperty getStyleableProperty() {
                    return StyleableProperties.STRIKETHROUGH;
                }

                @Override
                public Object getBean() {
                    return Text.this;
                }

                @Override
                public String getName() {
                    return "strikethrough";
                }
            };
        }
        return this.strikethrough;
    }

    public final void setTextAlignment(TextAlignment textAlignment) {
        this.textAlignmentProperty().set(textAlignment);
    }

    public final TextAlignment getTextAlignment() {
        return this.textAlignment == null ? TextAlignment.LEFT : (TextAlignment)((Object)this.textAlignment.get());
    }

    public final ObjectProperty<TextAlignment> textAlignmentProperty() {
        if (this.textAlignment == null) {
            this.textAlignment = new StyleableObjectProperty<TextAlignment>(TextAlignment.LEFT){

                @Override
                public void invalidated() {
                    Text.this.impl_markDirty(DirtyBits.TEXT_ATTRS);
                    Text.this.impl_geomChanged();
                }

                @Override
                public StyleableProperty getStyleableProperty() {
                    return StyleableProperties.TEXT_ALIGNMENT;
                }

                @Override
                public Object getBean() {
                    return Text.this;
                }

                @Override
                public String getName() {
                    return "textAlignment";
                }
            };
        }
        return this.textAlignment;
    }

    private void setBaselineOffset(double d) {
        this.baselineOffsetPropertyImpl().set(d);
    }

    @Override
    public final double getBaselineOffset() {
        return this.baselineOffset == null ? 0.0 : this.baselineOffset.get();
    }

    public final ReadOnlyDoubleProperty baselineOffsetProperty() {
        return this.baselineOffsetPropertyImpl().getReadOnlyProperty();
    }

    private ReadOnlyDoubleWrapper baselineOffsetPropertyImpl() {
        if (this.baselineOffset == null) {
            this.baselineOffset = new ReadOnlyDoubleWrapper(this, "baselineOffset");
        }
        return this.baselineOffset;
    }

    public final void setFontSmoothingType(FontSmoothingType fontSmoothingType) {
        this.fontSmoothingTypeProperty().set(fontSmoothingType);
    }

    public final FontSmoothingType getFontSmoothingType() {
        return this.fontSmoothingType == null ? FontSmoothingType.GRAY : (FontSmoothingType)((Object)this.fontSmoothingType.get());
    }

    public final ObjectProperty<FontSmoothingType> fontSmoothingTypeProperty() {
        if (this.fontSmoothingType == null) {
            this.fontSmoothingType = new StyleableObjectProperty<FontSmoothingType>(FontSmoothingType.GRAY){

                @Override
                public void invalidated() {
                    Text.this.impl_markDirty(DirtyBits.TEXT_ATTRS);
                    Text.this.impl_geomChanged();
                }

                @Override
                public StyleableProperty getStyleableProperty() {
                    return StyleableProperties.FONT_SMOOTHING_TYPE;
                }

                @Override
                public Object getBean() {
                    return Text.this;
                }

                @Override
                public String getName() {
                    return "fontSmoothingType";
                }
            };
        }
        return this.fontSmoothingType;
    }

    @Override
    @Deprecated
    protected final void impl_geomChanged() {
        this.getDecorationShapes();
        super.impl_geomChanged();
    }

    @Deprecated
    public final void setImpl_selectionShape(PathElement[] pathElementArray) {
        this.impl_selectionShapeProperty().set(pathElementArray);
    }

    @Deprecated
    public final PathElement[] getImpl_selectionShape() {
        return this.impl_selectionShape == null ? null : (PathElement[])this.impl_selectionShape.get();
    }

    @Deprecated
    public final ObjectProperty<PathElement[]> impl_selectionShapeProperty() {
        if (this.impl_selectionShape == null) {
            this.impl_selectionShape = new SimpleObjectProperty<PathElement[]>(this, "impl_selectionShape");
        }
        return this.impl_selectionShape;
    }

    @Deprecated
    public final void setImpl_selectionStart(int n) {
        this.impl_selectionStartProperty().set(n);
    }

    @Deprecated
    public final int getImpl_selectionStart() {
        return this.impl_selectionStart == null ? -1 : this.impl_selectionStart.get();
    }

    @Deprecated
    public final IntegerProperty impl_selectionStartProperty() {
        if (this.impl_selectionStart == null) {
            this.impl_selectionStart = new IntegerPropertyBase(-1){

                @Override
                protected void invalidated() {
                    Text.this.impl_markDirty(DirtyBits.TEXT_SELECTION);
                    Text.this.getDecorationShapes();
                }

                @Override
                public Object getBean() {
                    return Text.this;
                }

                @Override
                public String getName() {
                    return "impl_selectionStart";
                }
            };
        }
        return this.impl_selectionStart;
    }

    @Deprecated
    public final void setImpl_selectionEnd(int n) {
        this.impl_selectionEndProperty().set(n);
    }

    @Deprecated
    public final int getImpl_selectionEnd() {
        return this.impl_selectionEnd == null ? -1 : this.impl_selectionEnd.get();
    }

    @Deprecated
    public final IntegerProperty impl_selectionEndProperty() {
        if (this.impl_selectionEnd == null) {
            this.impl_selectionEnd = new IntegerPropertyBase(-1){

                @Override
                protected void invalidated() {
                    Text.this.impl_markDirty(DirtyBits.TEXT_SELECTION);
                    Text.this.getDecorationShapes();
                }

                @Override
                public Object getBean() {
                    return Text.this;
                }

                @Override
                public String getName() {
                    return "impl_selectionEnd";
                }
            };
        }
        return this.impl_selectionEnd;
    }

    @Override
    @Deprecated
    protected final void impl_strokeOrFillChanged() {
        this.impl_markDirty(DirtyBits.TEXT_SELECTION);
    }

    @Deprecated
    public final void setImpl_caretShape(PathElement[] pathElementArray) {
        this.impl_caretShapeProperty().set(pathElementArray);
    }

    @Deprecated
    public final PathElement[] getImpl_caretShape() {
        return this.impl_caretShape == null ? null : (PathElement[])this.impl_caretShape.get();
    }

    @Deprecated
    public final ObjectProperty<PathElement[]> impl_caretShapeProperty() {
        if (this.impl_caretShape == null) {
            this.impl_caretShape = new SimpleObjectProperty<PathElement[]>(this, "impl_caretShape");
        }
        return this.impl_caretShape;
    }

    @Deprecated
    public final void setImpl_caretPosition(int n) {
        this.impl_caretPositionProperty().set(n);
    }

    @Deprecated
    public final int getImpl_caretPosition() {
        return this.impl_caretPosition == null ? -1 : this.impl_caretPosition.get();
    }

    @Deprecated
    public final IntegerProperty impl_caretPositionProperty() {
        if (this.impl_caretPosition == null) {
            this.impl_caretPosition = new IntegerPropertyBase(-1){

                @Override
                protected void invalidated() {
                    Text.this.getDecorationShapes();
                }

                @Override
                public Object getBean() {
                    return Text.this;
                }

                @Override
                public String getName() {
                    return "impl_caretPosition";
                }
            };
        }
        return this.impl_caretPosition;
    }

    @Deprecated
    public final void setImpl_caretBias(boolean bl) {
        this.impl_caretBiasProperty().set(bl);
    }

    @Deprecated
    public final boolean isImpl_caretBias() {
        return this.impl_caretBias == null ? true : this.impl_caretBias.get();
    }

    @Deprecated
    public final BooleanProperty impl_caretBiasProperty() {
        if (this.impl_caretBias == null) {
            this.impl_caretBias = new BooleanPropertyBase(true){

                @Override
                protected void invalidated() {
                    Text.this.getDecorationShapes();
                }

                @Override
                public Object getBean() {
                    return Text.this;
                }

                @Override
                public String getName() {
                    return "impl_caretBias";
                }
            };
        }
        return this.impl_caretBias;
    }

    @Deprecated
    public final HitInfo impl_hitTestChar(Point2D point2D) {
        return Toolkit.getToolkit().convertHitInfoToFX(this.getTextHelper().getHitInfo((float)point2D.getX(), (float)point2D.getY()));
    }

    @Deprecated
    public final PathElement[] impl_getRangeShape(int n, int n2) {
        Object object = this.getTextHelper().getRangeShape(n, n2);
        return Toolkit.getToolkit().convertShapeToFXPath(object);
    }

    @Deprecated
    public final PathElement[] impl_getUnderlineShape(int n, int n2) {
        Object object = this.getTextHelper().getUnderlineShape(n, n2);
        return Toolkit.getToolkit().convertShapeToFXPath(object);
    }

    private void getDecorationShapes() {
        if (this.getImpl_caretPosition() >= 0) {
            int n = this.getImpl_caretPosition() - (this.isImpl_caretBias() ? 0 : 1);
            Object object = this.getTextHelper().getCaretShape(n, this.isImpl_caretBias());
            this.setImpl_caretShape(Toolkit.getToolkit().convertShapeToFXPath(object));
        } else {
            this.setImpl_caretShape(null);
        }
        if (this.getImpl_selectionStart() >= 0 && this.getImpl_selectionEnd() >= 0) {
            Object object = this.getTextHelper().getSelectionShape();
            this.setImpl_selectionShape(Toolkit.getToolkit().convertShapeToFXPath(object));
        } else {
            this.setImpl_selectionShape(null);
        }
    }

    @Deprecated
    public final void impl_displaySoftwareKeyboard(boolean bl) {
    }

    @Override
    @Deprecated
    public final void impl_notifyLayoutBoundsChanged() {
        this.impl_layoutBoundsInvalid = true;
        super.impl_notifyLayoutBoundsChanged();
    }

    @Deprecated
    public final BaseBounds impl_computeLayoutBoundsInt(RectBounds rectBounds) {
        if (this.getBoundsType() == TextBoundsType.VISUAL && this.getTextInternal().equals("")) {
            return rectBounds.makeEmpty();
        }
        return this.getTextHelper().computeLayoutBounds(rectBounds);
    }

    @Override
    @Deprecated
    protected final Bounds impl_computeLayoutBounds() {
        if (this.impl_layoutBoundsInvalid) {
            this.impl_computeLayoutBoundsInt(this.impl_layoutBounds);
            this.impl_layoutBoundsInvalid = false;
        }
        return new BoundingBox(this.impl_layoutBounds.getMinX(), this.impl_layoutBounds.getMinY(), this.impl_layoutBounds.getWidth(), this.impl_layoutBounds.getHeight());
    }

    @Override
    @Deprecated
    public final BaseBounds impl_computeGeomBounds(BaseBounds baseBounds, BaseTransform baseTransform) {
        if (this.impl_mode == PGShape.Mode.EMPTY || this.getTextInternal().equals("") && this.getBoundsType() == TextBoundsType.VISUAL) {
            return baseBounds.makeEmpty();
        }
        return this.getTextHelper().computeContentBounds(baseBounds, baseTransform);
    }

    @Override
    @Deprecated
    protected final boolean impl_computeContains(double d, double d2) {
        return this.getTextHelper().computeContains((float)d, (float)d2);
    }

    @Override
    @Deprecated
    public final Shape impl_configShape() {
        Object object = this.getTextHelper().getShape();
        PathElement[] pathElementArray = Toolkit.getToolkit().convertShapeToFXPath(object);
        return PathUtils.configShape(Arrays.asList(pathElementArray), false);
    }

    @Deprecated
    public final ObjectProperty<Paint> impl_selectionFillProperty() {
        if (this.selectionFill == null) {
            this.selectionFill = new SimpleObjectProperty<Color>(this, "selectionFill", Color.WHITE);
        }
        return this.selectionFill;
    }

    @Deprecated
    public static List<StyleableProperty> impl_CSS_STYLEABLES() {
        return StyleableProperties.STYLEABLES;
    }

    @Override
    @Deprecated
    public List<StyleableProperty> impl_getStyleableProperties() {
        return Text.impl_CSS_STYLEABLES();
    }

    private void updatePGText() {
        this.getTextHelper();
        this.getPGText().updateText();
    }

    private Affine3D getConcatenatedNodeTransform(Node node, Affine3D affine3D) {
        if (node.getScaleX() != 1.0 || node.getScaleY() != 1.0 || node.getRotate() != 0.0 || node.impl_hasTransforms()) {
            if (node.getRotate() != 0.0) {
                affine3D.rotate(Math.toRadians(node.getRotate()), node.getRotationAxis().getX(), node.getRotationAxis().getY(), node.getRotationAxis().getZ());
            }
            if (node.getScaleX() != 1.0 || node.getScaleY() != 1.0) {
                affine3D.scale(node.getScaleX(), node.getScaleY());
            }
            if (node.impl_hasTransforms()) {
                for (Transform transform : node.getTransforms()) {
                    transform.impl_apply(affine3D);
                }
            }
        }
        return affine3D;
    }

    private BaseTransform getCumulativeTransform() {
        Affine3D affine3D = new Affine3D();
        Node node = this;
        do {
            affine3D = this.getConcatenatedNodeTransform(node, affine3D);
        } while ((node = node.getParent()) != null);
        return affine3D;
    }

    private PGShape.Mode getMode() {
        if (this.getFill() != null && this.getStroke() != null) {
            return PGShape.Mode.STROKE_FILL;
        }
        if (this.getFill() != null) {
            return PGShape.Mode.FILL;
        }
        if (this.getStroke() != null) {
            return PGShape.Mode.STROKE;
        }
        return PGShape.Mode.EMPTY;
    }

    private void updatePGTextHelper(PGTextHelper pGTextHelper) {
        if (this.impl_isDirty(DirtyBits.NODE_GEOMETRY)) {
            pGTextHelper.setLocation((float)this.getX(), (float)this.getY());
            this.impl_clearDirty(DirtyBits.NODE_GEOMETRY);
            this.impl_markDirty(DirtyBits.TEXT_HELPER);
        }
        if (this.impl_isDirty(DirtyBits.TEXT_ATTRS)) {
            pGTextHelper.setTextBoundsType(this.getBoundsType().ordinal());
            pGTextHelper.setTextOrigin(this.getTextOrigin().ordinal());
            pGTextHelper.setWrappingWidth((float)this.getWrappingWidth());
            pGTextHelper.setUnderline(this.isUnderline());
            pGTextHelper.setStrikethrough(this.isStrikethrough());
            pGTextHelper.setTextAlignment(this.getTextAlignment().ordinal());
            pGTextHelper.setFontSmoothingType(this.getFontSmoothingType().ordinal());
            this.impl_clearDirty(DirtyBits.TEXT_ATTRS);
            this.impl_markDirty(DirtyBits.TEXT_HELPER);
        }
        if (this.impl_isDirty(DirtyBits.TEXT_FONT)) {
            pGTextHelper.setFont(this.getFontInternal().impl_getNativeFont());
            this.impl_clearDirty(DirtyBits.TEXT_FONT);
            this.impl_markDirty(DirtyBits.TEXT_HELPER);
        }
        if (this.impl_isDirty(DirtyBits.NODE_CONTENTS)) {
            pGTextHelper.setText(this.getTextInternal());
            this.impl_clearDirty(DirtyBits.NODE_CONTENTS);
            this.impl_markDirty(DirtyBits.TEXT_HELPER);
        }
        if (this.impl_isDirty(DirtyBits.TEXT_SELECTION)) {
            if (this.getImpl_selectionStart() >= 0 && this.getImpl_selectionEnd() >= 0) {
                pGTextHelper.setLogicalSelection(this.getImpl_selectionStart(), this.getImpl_selectionEnd());
                Paint paint = this.getStroke();
                Paint paint2 = this.selectionFill == null ? null : (Paint)this.selectionFill.get();
                Object object = paint == null ? null : paint.impl_getPlatformPaint();
                Object object2 = paint2 == null ? null : paint2.impl_getPlatformPaint();
                pGTextHelper.setSelectionPaint(object, object2);
            } else {
                pGTextHelper.setLogicalSelection(0, 0);
            }
            this.impl_clearDirty(DirtyBits.TEXT_SELECTION);
            this.impl_markDirty(DirtyBits.TEXT_HELPER);
        }
        pGTextHelper.setCumulativeTransform(this.getCumulativeTransform());
        pGTextHelper.setMode(this.getMode());
        if (this.impl_isDirty(DirtyBits.SHAPE_STROKE) || this.impl_isDirty(DirtyBits.SHAPE_STROKEATTRS)) {
            boolean bl = this.getStroke() != null;
            pGTextHelper.setStroke(bl);
            if (bl) {
                pGTextHelper.setStrokeParameters(this.getPGStrokeType(), this.getPGStrokeDashArray(), (float)this.getStrokeDashOffset(), this.getPGStrokeLineCap(), this.getPGStrokeLineJoin(), Math.max((float)this.getStrokeMiterLimit(), 1.0f), Math.max((float)this.getStrokeWidth(), 0.0f));
            }
        }
    }

    private PGShape.StrokeType getPGStrokeType() {
        switch (this.getStrokeType()) {
            case INSIDE: {
                return PGShape.StrokeType.INSIDE;
            }
            case OUTSIDE: {
                return PGShape.StrokeType.OUTSIDE;
            }
        }
        return PGShape.StrokeType.CENTERED;
    }

    private PGShape.StrokeLineCap getPGStrokeLineCap() {
        switch (this.getStrokeLineCap()) {
            case SQUARE: {
                return PGShape.StrokeLineCap.SQUARE;
            }
            case BUTT: {
                return PGShape.StrokeLineCap.BUTT;
            }
        }
        return PGShape.StrokeLineCap.ROUND;
    }

    private PGShape.StrokeLineJoin getPGStrokeLineJoin() {
        switch (this.getStrokeLineJoin()) {
            case MITER: {
                return PGShape.StrokeLineJoin.MITER;
            }
            case BEVEL: {
                return PGShape.StrokeLineJoin.BEVEL;
            }
        }
        return PGShape.StrokeLineJoin.ROUND;
    }

    private float[] getPGStrokeDashArray() {
        ObservableList<Double> observableList = this.getStrokeDashArray();
        int n = observableList.size();
        float[] fArray = new float[n];
        for (int i = 0; i < n; ++i) {
            fArray[i] = ((Double)observableList.get(i)).floatValue();
        }
        return fArray;
    }

    @Override
    @Deprecated
    public final void impl_updatePG() {
        super.impl_updatePG();
        this.updatePGText();
    }

    private static class StyleableProperties {
        private static final StyleableProperty<Text, Font> FONT = new StyleableProperty.FONT<Text>("-fx-font", Font.getDefault()){

            @Override
            public boolean isSettable(Text text) {
                return text.font == null || !text.font.isBound();
            }

            @Override
            public WritableValue<Font> getWritableValue(Text text) {
                return text.fontProperty();
            }
        };
        private static final StyleableProperty<Text, Boolean> UNDERLINE = new StyleableProperty<Text, Boolean>("-fx-underline", (StyleConverter)BooleanConverter.getInstance(), Boolean.FALSE){

            @Override
            public boolean isSettable(Text text) {
                return text.underline == null || !text.underline.isBound();
            }

            @Override
            public WritableValue<Boolean> getWritableValue(Text text) {
                return text.underlineProperty();
            }
        };
        private static final StyleableProperty<Text, Boolean> STRIKETHROUGH = new StyleableProperty<Text, Boolean>("-fx-strikethrough", (StyleConverter)BooleanConverter.getInstance(), Boolean.FALSE){

            @Override
            public boolean isSettable(Text text) {
                return text.strikethrough == null || !text.strikethrough.isBound();
            }

            @Override
            public WritableValue<Boolean> getWritableValue(Text text) {
                return text.strikethroughProperty();
            }
        };
        private static final StyleableProperty<Text, TextAlignment> TEXT_ALIGNMENT = new StyleableProperty<Text, TextAlignment>("-fx-text-alignment", new EnumConverter(TextAlignment.class), TextAlignment.LEFT){

            @Override
            public boolean isSettable(Text text) {
                return text.textAlignment == null || !text.textAlignment.isBound();
            }

            @Override
            public WritableValue<TextAlignment> getWritableValue(Text text) {
                return text.textAlignmentProperty();
            }
        };
        private static final StyleableProperty<Text, VPos> TEXT_ORIGIN = new StyleableProperty<Text, VPos>("-fx-text-origin", new EnumConverter(VPos.class), VPos.BASELINE){

            @Override
            public boolean isSettable(Text text) {
                return text.textOrigin == null || !text.textOrigin.isBound();
            }

            @Override
            public WritableValue<VPos> getWritableValue(Text text) {
                return text.textOriginProperty();
            }
        };
        private static final StyleableProperty<Text, FontSmoothingType> FONT_SMOOTHING_TYPE = new StyleableProperty<Text, FontSmoothingType>("-fx-font-smoothing-type", new EnumConverter(FontSmoothingType.class), FontSmoothingType.GRAY){

            @Override
            public boolean isSettable(Text text) {
                return text.fontSmoothingType == null || !text.fontSmoothingType.isBound();
            }

            @Override
            public WritableValue<FontSmoothingType> getWritableValue(Text text) {
                return text.fontSmoothingTypeProperty();
            }
        };
        private static final List<StyleableProperty> STYLEABLES;

        private StyleableProperties() {
        }

        static {
            ArrayList<StyleableProperty> arrayList = new ArrayList<StyleableProperty>(javafx.scene.shape.Shape.impl_CSS_STYLEABLES());
            Collections.addAll(arrayList, FONT, UNDERLINE, STRIKETHROUGH, TEXT_ALIGNMENT, TEXT_ORIGIN, FONT_SMOOTHING_TYPE);
            STYLEABLES = Collections.unmodifiableList(arrayList);
        }
    }
}

