/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.web;

import com.sun.javafx.scene.web.Debugger;
import com.sun.javafx.tk.TKPulseListener;
import com.sun.javafx.tk.Toolkit;
import com.sun.webpane.platform.Disposer;
import com.sun.webpane.platform.DisposerRecord;
import com.sun.webpane.platform.InspectorClient;
import com.sun.webpane.platform.LoadListenerClient;
import com.sun.webpane.platform.WebPage;
import com.sun.webpane.sg.Accessor;
import com.sun.webpane.sg.ImplementationManager;
import com.sun.webpane.sg.PGWebView;
import com.sun.webpane.webkit.Timer;
import com.sun.webpane.webkit.network.URLs;
import com.sun.webpane.webkit.network.Util;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.ref.WeakReference;
import java.net.MalformedURLException;
import java.net.URLConnection;
import javafx.animation.AnimationTimer;
import javafx.beans.InvalidationListener;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.BooleanPropertyBase;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyBooleanWrapper;
import javafx.beans.property.ReadOnlyDoubleProperty;
import javafx.beans.property.ReadOnlyDoubleWrapper;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectPropertyBase;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.ReadOnlyStringProperty;
import javafx.beans.property.ReadOnlyStringWrapper;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.property.StringPropertyBase;
import javafx.concurrent.Worker;
import javafx.event.EventHandler;
import javafx.geometry.Rectangle2D;
import javafx.scene.Node;
import javafx.scene.web.PopupFeatures;
import javafx.scene.web.PromptData;
import javafx.scene.web.WebEvent;
import javafx.scene.web.WebHistory;
import javafx.scene.web.WebView;
import javafx.util.Callback;
import org.w3c.dom.Document;
import sun.misc.BASE64Encoder;

public final class WebEngine {
    private static int instanceCount;
    private final ObjectProperty<WebView> view = new SimpleObjectProperty<WebView>(this, "view");
    private final LoadWorker loadWorker = new LoadWorker();
    private final WebPage page;
    private final DebuggerImpl debugger = new DebuggerImpl();
    private final DocumentProperty document = new DocumentProperty();
    private final ReadOnlyStringWrapper location = new ReadOnlyStringWrapper(this, "location");
    private final ReadOnlyStringWrapper title = new ReadOnlyStringWrapper(this, "title");
    private BooleanProperty javaScriptEnabled;
    private StringProperty userStyleSheetLocation;
    private ObjectProperty<EventHandler<WebEvent<String>>> onAlert = new SimpleObjectProperty<EventHandler<WebEvent<String>>>(this, "onAlert");
    private ObjectProperty<EventHandler<WebEvent<String>>> onStatusChanged = new SimpleObjectProperty<EventHandler<WebEvent<String>>>(this, "onStatusChanged");
    private ObjectProperty<EventHandler<WebEvent<Rectangle2D>>> onResized = new SimpleObjectProperty<EventHandler<WebEvent<Rectangle2D>>>(this, "onResized");
    private ObjectProperty<EventHandler<WebEvent<Boolean>>> onVisibilityChanged = new SimpleObjectProperty<EventHandler<WebEvent<Boolean>>>(this, "onVisibilityChanged");
    private ObjectProperty<Callback<PopupFeatures, WebEngine>> createPopupHandler = new SimpleObjectProperty<4>(this, "createPopupHandler", new Callback<PopupFeatures, WebEngine>(){

        @Override
        public WebEngine call(PopupFeatures popupFeatures) {
            return WebEngine.this;
        }
    });
    private ObjectProperty<Callback<String, Boolean>> confirmHandler = new SimpleObjectProperty<Callback<String, Boolean>>(this, "confirmHandler");
    private ObjectProperty<Callback<PromptData, String>> promptHandler = new SimpleObjectProperty<Callback<PromptData, String>>(this, "promptHandler");
    private WebHistory history;

    public final Worker<Void> getLoadWorker() {
        return this.loadWorker;
    }

    public final Document getDocument() {
        return (Document)this.document.getValue();
    }

    public final ReadOnlyObjectProperty<Document> documentProperty() {
        return this.document;
    }

    public final String getLocation() {
        return this.location.getValue();
    }

    public final ReadOnlyStringProperty locationProperty() {
        return this.location.getReadOnlyProperty();
    }

    private void updateLocation(String string) {
        this.location.set(string);
        this.document.invalidate(false);
        this.title.set(null);
    }

    public final String getTitle() {
        return this.title.getValue();
    }

    public final ReadOnlyStringProperty titleProperty() {
        return this.title.getReadOnlyProperty();
    }

    private void updateTitle() {
        this.title.set(this.page.getTitle(this.page.getMainFrame()));
    }

    public final void setJavaScriptEnabled(boolean bl) {
        this.javaScriptEnabledProperty().set(bl);
    }

    public final boolean isJavaScriptEnabled() {
        return this.javaScriptEnabled == null ? true : this.javaScriptEnabled.get();
    }

    public final BooleanProperty javaScriptEnabledProperty() {
        if (this.javaScriptEnabled == null) {
            this.javaScriptEnabled = new BooleanPropertyBase(true){

                @Override
                public void invalidated() {
                    WebEngine.checkThread();
                    WebEngine.this.page.setJavaScriptEnabled(this.get());
                }

                @Override
                public Object getBean() {
                    return WebEngine.this;
                }

                @Override
                public String getName() {
                    return "javaScriptEnabled";
                }
            };
        }
        return this.javaScriptEnabled;
    }

    public final void setUserStyleSheetLocation(String string) {
        this.userStyleSheetLocationProperty().set(string);
    }

    public final String getUserStyleSheetLocation() {
        return this.userStyleSheetLocation == null ? null : (String)this.userStyleSheetLocation.get();
    }

    public final StringProperty userStyleSheetLocationProperty() {
        if (this.userStyleSheetLocation == null) {
            this.userStyleSheetLocation = new StringPropertyBase(null){
                private static final String DATA_PREFIX = "data:text/css;charset=utf-8;base64,";

                @Override
                public void invalidated() {
                    String string;
                    WebEngine.checkThread();
                    String string2 = this.get();
                    if (string2 == null || string2.length() <= 0) {
                        string = null;
                    } else if (string2.startsWith(DATA_PREFIX)) {
                        string = string2;
                    } else if (string2.startsWith("file:") || string2.startsWith("jar:") || string2.startsWith("data:")) {
                        try {
                            URLConnection uRLConnection = URLs.newURL(string2).openConnection();
                            uRLConnection.connect();
                            BufferedInputStream bufferedInputStream = new BufferedInputStream(uRLConnection.getInputStream());
                            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                            new BASE64Encoder().encodeBuffer((InputStream)bufferedInputStream, (OutputStream)byteArrayOutputStream);
                            string = DATA_PREFIX + byteArrayOutputStream.toString();
                        }
                        catch (IOException iOException) {
                            throw new RuntimeException(iOException);
                        }
                    } else {
                        throw new IllegalArgumentException("Invalid stylesheet URL");
                    }
                    WebEngine.this.page.setUserStyleSheetLocation(string);
                }

                @Override
                public Object getBean() {
                    return WebEngine.this;
                }

                @Override
                public String getName() {
                    return "userStyleSheetLocation";
                }
            };
        }
        return this.userStyleSheetLocation;
    }

    public final EventHandler<WebEvent<String>> getOnAlert() {
        return (EventHandler)this.onAlert.get();
    }

    public final void setOnAlert(EventHandler<WebEvent<String>> eventHandler) {
        this.onAlert.set(eventHandler);
    }

    public final ObjectProperty<EventHandler<WebEvent<String>>> onAlertProperty() {
        return this.onAlert;
    }

    public final EventHandler<WebEvent<String>> getOnStatusChanged() {
        return (EventHandler)this.onStatusChanged.get();
    }

    public final void setOnStatusChanged(EventHandler<WebEvent<String>> eventHandler) {
        this.onStatusChanged.set(eventHandler);
    }

    public final ObjectProperty<EventHandler<WebEvent<String>>> onStatusChangedProperty() {
        return this.onStatusChanged;
    }

    public final EventHandler<WebEvent<Rectangle2D>> getOnResized() {
        return (EventHandler)this.onResized.get();
    }

    public final void setOnResized(EventHandler<WebEvent<Rectangle2D>> eventHandler) {
        this.onResized.set(eventHandler);
    }

    public final ObjectProperty<EventHandler<WebEvent<Rectangle2D>>> onResizedProperty() {
        return this.onResized;
    }

    public final EventHandler<WebEvent<Boolean>> getOnVisibilityChanged() {
        return (EventHandler)this.onVisibilityChanged.get();
    }

    public final void setOnVisibilityChanged(EventHandler<WebEvent<Boolean>> eventHandler) {
        this.onVisibilityChanged.set(eventHandler);
    }

    public final ObjectProperty<EventHandler<WebEvent<Boolean>>> onVisibilityChangedProperty() {
        return this.onVisibilityChanged;
    }

    public final Callback<PopupFeatures, WebEngine> getCreatePopupHandler() {
        return (Callback)this.createPopupHandler.get();
    }

    public final void setCreatePopupHandler(Callback<PopupFeatures, WebEngine> callback) {
        this.createPopupHandler.set(callback);
    }

    public final ObjectProperty<Callback<PopupFeatures, WebEngine>> createPopupHandlerProperty() {
        return this.createPopupHandler;
    }

    public final Callback<String, Boolean> getConfirmHandler() {
        return (Callback)this.confirmHandler.get();
    }

    public final void setConfirmHandler(Callback<String, Boolean> callback) {
        this.confirmHandler.set(callback);
    }

    public final ObjectProperty<Callback<String, Boolean>> confirmHandlerProperty() {
        return this.confirmHandler;
    }

    public final Callback<PromptData, String> getPromptHandler() {
        return (Callback)this.promptHandler.get();
    }

    public final void setPromptHandler(Callback<PromptData, String> callback) {
        this.promptHandler.set(callback);
    }

    public final ObjectProperty<Callback<PromptData, String>> promptHandlerProperty() {
        return this.promptHandler;
    }

    public WebEngine() {
        this(null);
    }

    public WebEngine(String string) {
        if (instanceCount == 0 && Timer.getMode() == Timer.Mode.PLATFORM_TICKS) {
            PulseTimer.start();
        }
        AccessorImpl accessorImpl = new AccessorImpl(this);
        this.page = ImplementationManager.createPage(accessorImpl);
        this.page.addLoadListenerClient(new PageLoadListener(this));
        this.page.setInspectorClient(new InspectorClientImpl(this));
        this.history = new WebHistory(this.page);
        Disposer.addRecord(this, new SelfDisposer(this.page));
        this.load(string);
        ++instanceCount;
    }

    public void load(String string) {
        WebEngine.checkThread();
        this.loadWorker.cancelAndReset();
        if (string == null) {
            string = "";
        } else {
            try {
                string = Util.adjustUrlForWebKit(string);
            }
            catch (MalformedURLException malformedURLException) {
                this.loadWorker.dispatchLoadEvent(this.getMainFrame(), 0, string, null, 0.0, 0);
                this.loadWorker.dispatchLoadEvent(this.getMainFrame(), 5, string, null, 0.0, 2);
            }
        }
        this.page.open(this.page.getMainFrame(), string);
    }

    public void loadContent(String string) {
        this.loadContent(string, "text/html");
    }

    public void loadContent(String string, String string2) {
        WebEngine.checkThread();
        this.loadWorker.cancelAndReset();
        this.page.load(this.page.getMainFrame(), string, string2);
    }

    public void reload() {
        WebEngine.checkThread();
        this.page.refresh(this.page.getMainFrame());
    }

    public WebHistory getHistory() {
        return this.history;
    }

    public Object executeScript(String string) {
        WebEngine.checkThread();
        return this.page.executeScript(this.page.getMainFrame(), string);
    }

    private long getMainFrame() {
        return this.page.getMainFrame();
    }

    WebPage getPage() {
        return this.page;
    }

    void setView(WebView webView) {
        this.view.setValue(webView);
    }

    private void stop() {
        WebEngine.checkThread();
        this.page.stop(this.page.getMainFrame());
    }

    static void checkThread() {
        Toolkit.getToolkit().checkFxUserThread();
    }

    @Deprecated
    public Debugger impl_getDebugger() {
        return this.debugger;
    }

    static {
        Accessor.setPageAccessor(new Accessor.PageAccessor(){

            @Override
            public WebPage getPage(WebEngine webEngine) {
                return webEngine == null ? null : webEngine.getPage();
            }
        });
        instanceCount = 0;
    }

    private static class InspectorClientImpl
    implements InspectorClient {
        private final WeakReference<WebEngine> engine;

        InspectorClientImpl(WebEngine webEngine) {
            this.engine = new WeakReference<WebEngine>(webEngine);
        }

        @Override
        public boolean sendMessageToFrontend(String string) {
            Callback callback;
            boolean bl = false;
            WebEngine webEngine = (WebEngine)this.engine.get();
            if (webEngine != null && (callback = webEngine.debugger.messageCallback) != null) {
                callback.call(string);
                bl = true;
            }
            return bl;
        }
    }

    private class DebuggerImpl
    implements Debugger {
        private boolean enabled;
        private Callback<String, Void> messageCallback;

        private DebuggerImpl() {
        }

        @Override
        public boolean isEnabled() {
            WebEngine.checkThread();
            return this.enabled;
        }

        @Override
        public void setEnabled(boolean bl) {
            WebEngine.checkThread();
            if (bl != this.enabled) {
                if (bl) {
                    WebEngine.this.page.setDeveloperExtrasEnabled(true);
                    WebEngine.this.page.connectInspectorFrontend();
                } else {
                    WebEngine.this.page.disconnectInspectorFrontend();
                    WebEngine.this.page.setDeveloperExtrasEnabled(false);
                }
                this.enabled = bl;
            }
        }

        @Override
        public void sendMessage(String string) {
            WebEngine.checkThread();
            if (!this.enabled) {
                throw new IllegalStateException("Debugger is not enabled");
            }
            if (string == null) {
                throw new NullPointerException("message is null");
            }
            WebEngine.this.page.dispatchInspectorMessageFromFrontend(string);
        }

        @Override
        public Callback<String, Void> getMessageCallback() {
            WebEngine.checkThread();
            return this.messageCallback;
        }

        @Override
        public void setMessageCallback(Callback<String, Void> callback) {
            WebEngine.checkThread();
            this.messageCallback = callback;
        }
    }

    private final class DocumentProperty
    extends ReadOnlyObjectPropertyBase<Document> {
        private boolean available;
        private Document document;

        private DocumentProperty() {
        }

        private void invalidate(boolean bl) {
            if (this.available || bl) {
                this.available = bl;
                this.document = null;
                this.fireValueChangedEvent();
            }
        }

        @Override
        public Document get() {
            if (!this.available) {
                return null;
            }
            if (this.document == null) {
                this.document = WebEngine.this.page.getDocument(WebEngine.this.page.getMainFrame());
                if (this.document == null) {
                    this.available = false;
                }
            }
            return this.document;
        }

        @Override
        public Object getBean() {
            return WebEngine.this;
        }

        @Override
        public String getName() {
            return "document";
        }
    }

    private class LoadWorker
    implements Worker<Void> {
        private ReadOnlyObjectWrapper<Worker.State> state = new ReadOnlyObjectWrapper<Worker.State>(this, "state", Worker.State.READY);
        private ReadOnlyObjectWrapper<Void> value = new ReadOnlyObjectWrapper<Object>(this, "value", null);
        private ReadOnlyObjectWrapper<Throwable> exception = new ReadOnlyObjectWrapper(this, "exception");
        private ReadOnlyDoubleWrapper workDone = new ReadOnlyDoubleWrapper(this, "workDone", -1.0);
        private ReadOnlyDoubleWrapper totalWorkToBeDone = new ReadOnlyDoubleWrapper(this, "totalWork", -1.0);
        private ReadOnlyDoubleWrapper progress = new ReadOnlyDoubleWrapper(this, "progress", -1.0);
        private ReadOnlyBooleanWrapper running = new ReadOnlyBooleanWrapper(this, "running", false);
        private ReadOnlyStringWrapper message = new ReadOnlyStringWrapper(this, "message", "");
        private ReadOnlyStringWrapper title = new ReadOnlyStringWrapper(this, "title", "WebEngine Loader");

        private LoadWorker() {
        }

        @Override
        public final Worker.State getState() {
            WebEngine.checkThread();
            return (Worker.State)((Object)this.state.get());
        }

        @Override
        public final ReadOnlyObjectProperty<Worker.State> stateProperty() {
            WebEngine.checkThread();
            return this.state.getReadOnlyProperty();
        }

        private final void updateState(Worker.State state) {
            WebEngine.checkThread();
            this.state.set(state);
            this.running.set(state == Worker.State.SCHEDULED || state == Worker.State.RUNNING);
        }

        @Override
        public final Void getValue() {
            WebEngine.checkThread();
            return (Void)this.value.get();
        }

        @Override
        public final ReadOnlyObjectProperty<Void> valueProperty() {
            WebEngine.checkThread();
            return this.value.getReadOnlyProperty();
        }

        @Override
        public final Throwable getException() {
            WebEngine.checkThread();
            return (Throwable)this.exception.get();
        }

        @Override
        public final ReadOnlyObjectProperty<Throwable> exceptionProperty() {
            WebEngine.checkThread();
            return this.exception.getReadOnlyProperty();
        }

        @Override
        public final double getWorkDone() {
            WebEngine.checkThread();
            return this.workDone.get();
        }

        @Override
        public final ReadOnlyDoubleProperty workDoneProperty() {
            WebEngine.checkThread();
            return this.workDone.getReadOnlyProperty();
        }

        @Override
        public final double getTotalWork() {
            WebEngine.checkThread();
            return this.totalWorkToBeDone.get();
        }

        @Override
        public final ReadOnlyDoubleProperty totalWorkProperty() {
            WebEngine.checkThread();
            return this.totalWorkToBeDone.getReadOnlyProperty();
        }

        @Override
        public final double getProgress() {
            WebEngine.checkThread();
            return this.progress.get();
        }

        @Override
        public final ReadOnlyDoubleProperty progressProperty() {
            WebEngine.checkThread();
            return this.progress.getReadOnlyProperty();
        }

        private void updateProgress(double d) {
            this.totalWorkToBeDone.set(100.0);
            this.workDone.set(d * 100.0);
            this.progress.set(d);
        }

        @Override
        public final boolean isRunning() {
            WebEngine.checkThread();
            return this.running.get();
        }

        @Override
        public final ReadOnlyBooleanProperty runningProperty() {
            WebEngine.checkThread();
            return this.running.getReadOnlyProperty();
        }

        @Override
        public final String getMessage() {
            return this.message.get();
        }

        @Override
        public final ReadOnlyStringProperty messageProperty() {
            return this.message.getReadOnlyProperty();
        }

        @Override
        public final String getTitle() {
            return this.title.get();
        }

        @Override
        public final ReadOnlyStringProperty titleProperty() {
            return this.title.getReadOnlyProperty();
        }

        @Override
        public boolean cancel() {
            if (this.isRunning()) {
                WebEngine.this.stop();
                return true;
            }
            return false;
        }

        private void cancelAndReset() {
            this.cancel();
            this.exception.set(null);
            this.message.set("");
            this.totalWorkToBeDone.set(-1.0);
            this.workDone.set(-1.0);
            this.progress.set(-1.0);
            this.updateState(Worker.State.READY);
            this.running.set(false);
        }

        private void dispatchLoadEvent(long l, int n, String string, String string2, double d, int n2) {
            if (l != WebEngine.this.getMainFrame()) {
                return;
            }
            switch (n) {
                case 0: {
                    this.message.set("Loading " + string);
                    WebEngine.this.updateLocation(string);
                    this.updateProgress(0.0);
                    this.updateState(Worker.State.SCHEDULED);
                    this.updateState(Worker.State.RUNNING);
                    break;
                }
                case 2: {
                    this.message.set("Loading " + string);
                    WebEngine.this.updateLocation(string);
                    break;
                }
                case 1: {
                    this.message.set("Loading complete");
                    this.updateProgress(1.0);
                    this.updateState(Worker.State.SUCCEEDED);
                    break;
                }
                case 5: {
                    this.message.set("Loading failed");
                    this.exception.set(this.describeError(n2));
                    this.updateState(Worker.State.FAILED);
                    break;
                }
                case 6: {
                    this.message.set("Loading stopped");
                    this.updateState(Worker.State.CANCELLED);
                    break;
                }
                case 30: {
                    this.updateProgress(d);
                    break;
                }
                case 11: {
                    WebEngine.this.updateTitle();
                    break;
                }
                case 14: {
                    WebEngine.this.document.invalidate(true);
                }
            }
        }

        Throwable describeError(int n) {
            String string = "Unknown error";
            switch (n) {
                case 1: {
                    string = "Unknown host";
                    break;
                }
                case 2: {
                    string = "Malformed URL";
                    break;
                }
                case 3: {
                    string = "SSL handshake failed";
                    break;
                }
                case 4: {
                    string = "Connection refused by server";
                    break;
                }
                case 5: {
                    string = "Connection reset by server";
                    break;
                }
                case 6: {
                    string = "No route to host";
                    break;
                }
                case 7: {
                    string = "Connection timed out";
                    break;
                }
                case 8: {
                    string = "Permission denied";
                    break;
                }
                case 9: {
                    string = "Invalid response from server";
                    break;
                }
                case 10: {
                    string = "Too many redirects";
                    break;
                }
                case 11: {
                    string = "File not found";
                }
            }
            return new Throwable(string);
        }
    }

    private static class PageLoadListener
    implements LoadListenerClient {
        private WeakReference<WebEngine> engine;

        PageLoadListener(WebEngine webEngine) {
            this.engine = new WeakReference<WebEngine>(webEngine);
        }

        @Override
        public void dispatchLoadEvent(long l, int n, String string, String string2, double d, int n2) {
            WebEngine webEngine = (WebEngine)this.engine.get();
            if (webEngine != null) {
                webEngine.loadWorker.dispatchLoadEvent(l, n, string, string2, d, n2);
            }
        }

        @Override
        public void dispatchResourceLoadEvent(long l, int n, String string, String string2, double d, int n2) {
        }
    }

    private static class PulseTimer {
        private static AnimationTimer animation = new AnimationTimer(){

            @Override
            public void handle(long l) {
            }
        };
        private static TKPulseListener listener = new TKPulseListener(){

            @Override
            public void pulse() {
                Timer.getTimer().notifyTick();
            }
        };

        private PulseTimer() {
        }

        public static void start() {
            Toolkit.getToolkit().addSceneTkPulseListener(listener);
            animation.start();
        }

        public static void stop() {
            Toolkit.getToolkit().removeSceneTkPulseListener(listener);
            animation.stop();
        }
    }

    private static class AccessorImpl
    extends Accessor {
        private WeakReference<WebEngine> engine;

        public AccessorImpl(WebEngine webEngine) {
            this.engine = new WeakReference<WebEngine>(webEngine);
        }

        @Override
        public WebEngine getEngine() {
            return (WebEngine)this.engine.get();
        }

        @Override
        public WebPage getPage() {
            WebEngine webEngine = this.getEngine();
            return webEngine == null ? null : webEngine.page;
        }

        @Override
        public WebView getView() {
            WebEngine webEngine = this.getEngine();
            return webEngine == null ? null : (WebView)webEngine.view.get();
        }

        @Override
        public PGWebView getPGView() {
            WebView webView = this.getView();
            return webView == null ? null : webView.getPGWebView();
        }

        @Override
        public void addChild(Node node) {
            WebView webView = this.getView();
            if (webView != null) {
                webView.getChildren().add(node);
            }
        }

        @Override
        public void removeChild(Node node) {
            WebView webView = this.getView();
            if (webView != null) {
                webView.getChildren().remove(node);
            }
        }

        @Override
        public void addViewListener(InvalidationListener invalidationListener) {
            WebEngine webEngine = this.getEngine();
            if (webEngine != null) {
                webEngine.view.addListener(invalidationListener);
            }
        }
    }

    private static class SelfDisposer
    implements DisposerRecord {
        WebPage page;

        SelfDisposer(WebPage webPage) {
            this.page = webPage;
        }

        @Override
        public void dispose() {
            this.page.dispose();
            instanceCount--;
            if (instanceCount == 0 && Timer.getMode() == Timer.Mode.PLATFORM_TICKS) {
                PulseTimer.stop();
            }
        }
    }
}

