/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.snmp.daemon;

import com.sun.jmx.defaults.JmxProperties;
import com.sun.jmx.snmp.daemon.SnmpInformRequest;
import com.sun.jmx.snmp.daemon.SnmpQManager;
import java.util.Vector;
import java.util.logging.Level;

class SendQ
extends Vector<SnmpInformRequest> {
    boolean isBeingDestroyed = false;

    SendQ(int n, int n2) {
        super(n, n2);
    }

    private synchronized void notifyClients() {
        this.notifyAll();
    }

    public synchronized void addRequest(SnmpInformRequest snmpInformRequest) {
        int n;
        long l = snmpInformRequest.getAbsNextPollTime();
        for (n = this.size(); n > 0 && l >= this.getRequestAt(n - 1).getAbsNextPollTime(); --n) {
        }
        if (n == this.size()) {
            this.addElement(snmpInformRequest);
            this.notifyClients();
        } else {
            this.insertElementAt(snmpInformRequest, n);
        }
    }

    public synchronized boolean waitUntilReady() {
        while (!this.isBeingDestroyed) {
            long l = 0L;
            if (!this.isEmpty()) {
                long l2 = System.currentTimeMillis();
                SnmpInformRequest snmpInformRequest = (SnmpInformRequest)this.lastElement();
                l = snmpInformRequest.getAbsNextPollTime() - l2;
                if (l <= 0L) {
                    return true;
                }
            }
            this.waitOnThisQueue(l);
        }
        return false;
    }

    public synchronized Vector getAllOutstandingRequest(long l) {
        Vector<SnmpInformRequest> vector = new Vector<SnmpInformRequest>();
        while (this.waitUntilReady()) {
            SnmpInformRequest snmpInformRequest;
            long l2 = System.currentTimeMillis() + l;
            for (int i = this.size(); i > 0 && (snmpInformRequest = this.getRequestAt(i - 1)).getAbsNextPollTime() <= l2; --i) {
                vector.addElement(snmpInformRequest);
            }
            if (vector.isEmpty()) continue;
            this.elementCount -= vector.size();
            return vector;
        }
        return null;
    }

    public synchronized void waitOnThisQueue(long l) {
        if (l == 0L && !this.isEmpty() && JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINEST)) {
            JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINEST, SnmpQManager.class.getName(), "waitOnThisQueue", "[" + Thread.currentThread().toString() + "]:" + "Fatal BUG :: Blocking on newq permenantly. But size = " + this.size());
        }
        try {
            this.wait(l);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public SnmpInformRequest getRequestAt(int n) {
        return (SnmpInformRequest)this.elementAt(n);
    }

    public synchronized SnmpInformRequest removeRequest(long l) {
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            SnmpInformRequest snmpInformRequest = this.getRequestAt(i);
            if (l != (long)snmpInformRequest.getRequestId()) continue;
            this.removeElementAt(i);
            return snmpInformRequest;
        }
        return null;
    }
}

