/*
 * Decompiled with CFR 0.152.
 */
package com.sun.script.javascript;

import com.sun.script.javascript.ExternalScriptable;
import com.sun.script.javascript.RhinoClassShutter;
import com.sun.script.javascript.RhinoCompiledScript;
import com.sun.script.javascript.RhinoScriptEngineFactory;
import com.sun.script.javascript.RhinoTopLevel;
import com.sun.script.javascript.RhinoWrapFactory;
import com.sun.script.util.InterfaceImplementor;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Method;
import java.security.AccessControlContext;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.AllPermission;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Map;
import javax.script.AbstractScriptEngine;
import javax.script.Bindings;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.Invocable;
import javax.script.ScriptContext;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptException;
import javax.script.SimpleBindings;
import sun.org.mozilla.javascript.internal.Callable;
import sun.org.mozilla.javascript.internal.Context;
import sun.org.mozilla.javascript.internal.ContextFactory;
import sun.org.mozilla.javascript.internal.Function;
import sun.org.mozilla.javascript.internal.JavaScriptException;
import sun.org.mozilla.javascript.internal.RhinoException;
import sun.org.mozilla.javascript.internal.Script;
import sun.org.mozilla.javascript.internal.Scriptable;
import sun.org.mozilla.javascript.internal.ScriptableObject;
import sun.org.mozilla.javascript.internal.Undefined;
import sun.org.mozilla.javascript.internal.Wrapper;
import sun.security.action.GetPropertyAction;

public final class RhinoScriptEngine
extends AbstractScriptEngine
implements Invocable,
Compilable {
    private static final boolean DEBUG = false;
    private AccessControlContext accCtxt;
    private RhinoTopLevel topLevel;
    private Map<Object, Object> indexedProps;
    private ScriptEngineFactory factory;
    private InterfaceImplementor implementor;
    private static final int languageVersion = RhinoScriptEngine.getLanguageVersion();
    private static final int optimizationLevel = RhinoScriptEngine.getOptimizationLevel();
    private static final String RHINO_JS_VERSION = "rhino.js.version";
    private static final String RHINO_OPT_LEVEL = "rhino.opt.level";
    private static final String printSource = "function print(str, newline) {                \n    if (typeof(str) == 'undefined') {         \n        str = 'undefined';                    \n    } else if (str == null) {                 \n        str = 'null';                         \n    }                                         \n    var out = context.getWriter();            \n    if (!(out instanceof java.io.PrintWriter))\n        out = new java.io.PrintWriter(out);   \n    out.print(String(str));                   \n    if (newline) out.print('\\n');            \n    out.flush();                              \n}\nfunction println(str) {                       \n    print(str, true);                         \n}";

    private static int getLanguageVersion() {
        String string = AccessController.doPrivileged(new GetPropertyAction(RHINO_JS_VERSION));
        int n = string != null ? Integer.parseInt(string) : 180;
        return n;
    }

    private static int getOptimizationLevel() {
        int n = -1;
        if (System.getSecurityManager() == null) {
            n = Integer.getInteger(RHINO_OPT_LEVEL, -1);
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RhinoScriptEngine() {
        if (System.getSecurityManager() != null) {
            try {
                AccessController.checkPermission(new AllPermission());
            }
            catch (AccessControlException accessControlException) {
                this.accCtxt = AccessController.getContext();
            }
        }
        Context context = RhinoScriptEngine.enterContext();
        try {
            this.topLevel = new RhinoTopLevel(context, this);
        }
        finally {
            context.exit();
        }
        this.indexedProps = new HashMap<Object, Object>();
        this.implementor = new InterfaceImplementor(this){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected boolean isImplemented(Object object, Class<?> clazz) {
                Context context = RhinoScriptEngine.enterContext();
                try {
                    if (object != null && !(object instanceof Scriptable)) {
                        object = Context.toObject(object, RhinoScriptEngine.this.topLevel);
                    }
                    Scriptable scriptable = RhinoScriptEngine.this.getRuntimeScope(RhinoScriptEngine.this.context);
                    Scriptable scriptable2 = object != null ? (Scriptable)object : scriptable;
                    for (Method method : clazz.getMethods()) {
                        Object object2;
                        if (method.getDeclaringClass() == Object.class || (object2 = ScriptableObject.getProperty(scriptable2, method.getName())) instanceof Function) continue;
                        boolean bl = false;
                        return bl;
                    }
                    boolean bl = true;
                    return bl;
                }
                finally {
                    context.exit();
                }
            }

            @Override
            protected Object convertResult(Method method, Object object) throws ScriptException {
                Class<?> clazz = method.getReturnType();
                if (clazz == Void.TYPE) {
                    return null;
                }
                return Context.jsToJava(object, clazz);
            }
        };
    }

    @Override
    public Object eval(Reader reader, ScriptContext scriptContext) throws ScriptException {
        Object object;
        Context context = RhinoScriptEngine.enterContext();
        try {
            Scriptable scriptable = this.getRuntimeScope(scriptContext);
            String string = (String)this.get("javax.script.filename");
            string = string == null ? "<Unknown source>" : string;
            object = context.evaluateReader(scriptable, reader, string, 1, null);
        }
        catch (RhinoException rhinoException) {
            int n = rhinoException.lineNumber();
            n = n == 0 ? -1 : n;
            String string = rhinoException instanceof JavaScriptException ? String.valueOf(((JavaScriptException)rhinoException).getValue()) : rhinoException.toString();
            ScriptException scriptException = new ScriptException(string, rhinoException.sourceName(), n);
            scriptException.initCause(rhinoException);
            throw scriptException;
        }
        catch (IOException iOException) {
            throw new ScriptException(iOException);
        }
        finally {
            context.exit();
        }
        return this.unwrapReturnValue(object);
    }

    @Override
    public Object eval(String string, ScriptContext scriptContext) throws ScriptException {
        if (string == null) {
            throw new NullPointerException("null script");
        }
        return this.eval((Reader)new StringReader(string), scriptContext);
    }

    @Override
    public ScriptEngineFactory getFactory() {
        if (this.factory != null) {
            return this.factory;
        }
        return new RhinoScriptEngineFactory();
    }

    @Override
    public Bindings createBindings() {
        return new SimpleBindings();
    }

    @Override
    public Object invokeFunction(String string, Object ... objectArray) throws ScriptException, NoSuchMethodException {
        return this.invoke(null, string, objectArray);
    }

    @Override
    public Object invokeMethod(Object object, String string, Object ... objectArray) throws ScriptException, NoSuchMethodException {
        if (object == null) {
            throw new IllegalArgumentException("script object can not be null");
        }
        return this.invoke(object, string, objectArray);
    }

    private Object invoke(Object object, String string, Object ... objectArray) throws ScriptException, NoSuchMethodException {
        Context context = RhinoScriptEngine.enterContext();
        try {
            if (string == null) {
                throw new NullPointerException("method name is null");
            }
            if (object != null && !(object instanceof Scriptable)) {
                object = Context.toObject(object, this.topLevel);
            }
            Scriptable scriptable = this.getRuntimeScope(this.context);
            Scriptable scriptable2 = object != null ? (Scriptable)object : scriptable;
            Object object2 = ScriptableObject.getProperty(scriptable2, string);
            if (!(object2 instanceof Function)) {
                throw new NoSuchMethodException("no such method: " + string);
            }
            Function function = (Function)object2;
            Scriptable scriptable3 = function.getParentScope();
            if (scriptable3 == null) {
                scriptable3 = scriptable;
            }
            Object object3 = function.call(context, scriptable3, scriptable2, this.wrapArguments(objectArray));
            Object object4 = this.unwrapReturnValue(object3);
            return object4;
        }
        catch (RhinoException rhinoException) {
            int n = rhinoException.lineNumber();
            n = n == 0 ? -1 : n;
            ScriptException scriptException = new ScriptException(rhinoException.toString(), rhinoException.sourceName(), n);
            scriptException.initCause(rhinoException);
            throw scriptException;
        }
        finally {
            context.exit();
        }
    }

    @Override
    public <T> T getInterface(Class<T> clazz) {
        try {
            return this.implementor.getInterface(null, clazz);
        }
        catch (ScriptException scriptException) {
            return null;
        }
    }

    @Override
    public <T> T getInterface(Object object, Class<T> clazz) {
        if (object == null) {
            throw new IllegalArgumentException("script object can not be null");
        }
        try {
            return this.implementor.getInterface(object, clazz);
        }
        catch (ScriptException scriptException) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Scriptable getRuntimeScope(ScriptContext scriptContext) {
        if (scriptContext == null) {
            throw new NullPointerException("null script context");
        }
        ExternalScriptable externalScriptable = new ExternalScriptable(scriptContext, this.indexedProps);
        externalScriptable.setPrototype(this.topLevel);
        externalScriptable.put("context", (Scriptable)externalScriptable, (Object)scriptContext);
        Context context = RhinoScriptEngine.enterContext();
        try {
            context.evaluateString(externalScriptable, printSource, "print", 1, null);
        }
        finally {
            context.exit();
        }
        return externalScriptable;
    }

    @Override
    public CompiledScript compile(String string) throws ScriptException {
        return this.compile(new StringReader(string));
    }

    @Override
    public CompiledScript compile(Reader reader) throws ScriptException {
        RhinoCompiledScript rhinoCompiledScript = null;
        Context context = RhinoScriptEngine.enterContext();
        try {
            String string = (String)this.get("javax.script.filename");
            if (string == null) {
                string = "<Unknown Source>";
            }
            Scriptable scriptable = this.getRuntimeScope(this.context);
            Script script = context.compileReader(scriptable, reader, string, 1, null);
            rhinoCompiledScript = new RhinoCompiledScript(this, script);
        }
        catch (Exception exception) {
            throw new ScriptException(exception);
        }
        finally {
            context.exit();
        }
        return rhinoCompiledScript;
    }

    static Context enterContext() {
        return Context.enter();
    }

    void setEngineFactory(ScriptEngineFactory scriptEngineFactory) {
        this.factory = scriptEngineFactory;
    }

    AccessControlContext getAccessContext() {
        return this.accCtxt;
    }

    Object[] wrapArguments(Object[] objectArray) {
        if (objectArray == null) {
            return Context.emptyArgs;
        }
        Object[] objectArray2 = new Object[objectArray.length];
        for (int i = 0; i < objectArray2.length; ++i) {
            objectArray2[i] = Context.javaToJS(objectArray[i], this.topLevel);
        }
        return objectArray2;
    }

    Object unwrapReturnValue(Object object) {
        if (object instanceof Wrapper) {
            object = ((Wrapper)object).unwrap();
        }
        return object instanceof Undefined ? null : object;
    }

    static {
        ContextFactory.initGlobal(new ContextFactory(){

            @Override
            protected Context makeContext() {
                Context context = super.makeContext();
                context.setLanguageVersion(languageVersion);
                context.setOptimizationLevel(optimizationLevel);
                context.setClassShutter(RhinoClassShutter.getInstance());
                context.setWrapFactory(RhinoWrapFactory.getInstance());
                return context;
            }

            @Override
            protected Object doTopCall(final Callable callable, final Context context, final Scriptable scriptable, final Scriptable scriptable2, final Object[] objectArray) {
                AccessControlContext accessControlContext = null;
                Scriptable scriptable3 = ScriptableObject.getTopLevelScope(scriptable);
                Scriptable scriptable4 = scriptable3.getPrototype();
                if (scriptable4 instanceof RhinoTopLevel) {
                    accessControlContext = ((RhinoTopLevel)scriptable4).getAccessContext();
                }
                if (accessControlContext != null) {
                    return AccessController.doPrivileged(new PrivilegedAction<Object>(){

                        @Override
                        public Object run() {
                            return this.superDoTopCall(callable, context, scriptable, scriptable2, objectArray);
                        }
                    }, accessControlContext);
                }
                return this.superDoTopCall(callable, context, scriptable, scriptable2, objectArray);
            }

            private Object superDoTopCall(Callable callable, Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) {
                return super.doTopCall(callable, context, scriptable, scriptable2, objectArray);
            }
        });
    }
}

