/*
 * Decompiled with CFR 0.152.
 */
package it.sogei.dt.patch;

import it.sogei.dt.patch.OSFinder;
import it.sogei.utilities.log4j.LogUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.LinkedList;
import java.util.Scanner;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.eclipse.core.resources.ResourcesPlugin;

public class PatchUtils {
    public static final String PREFS_4 = "/p2/org.eclipse.equinox.p2.engine/profileRegistry/profile.profile/.data/.settings/org.eclipse.equinox.p2.metadata.repository.prefs";
    public static final String PREFS_3 = "/p2/org.eclipse.equinox.p2.engine/profileRegistry/profile.profile/.data/.settings/org.eclipse.equinox.p2.artifact.repository.prefs";
    public static final String PREFS_2 = "/p2/org.eclipse.equinox.p2.engine/.settings/org.eclipse.equinox.p2.metadata.repository.prefs";
    public static final String PREFS_1 = "/p2/org.eclipse.equinox.p2.engine/.settings/org.eclipse.equinox.p2.artifact.repository.prefs";
    public static final String TEST_NEW_URL_UPDATE_SITE = "https\\\\://jwstest\\.agenziaentrate\\.it/";
    public static final String TEST_OLD_URL_UPDATE_SITE = "http\\\\://jwstest\\.agenziaentrate\\.it/";
    public static final String VAL_NEW_URL_UPDATE_SITE = "https\\\\://jwsval\\.agenziaentrate\\.it/";
    public static final String VAL_OLD_URL_UPDATE_SITE = "http\\\\://jwsval\\.agenziaentrate\\.it/";
    public static final String PROD_NEW_URL_UPDATE_SITE = "https\\\\://jws\\.agenziaentrate\\.it/";
    public static final String PROD_OLD_URL_UPDATE_SITE = "http\\\\://jws\\.agenziaentrate\\.it/";
    public static final String TLS_VERSION = "TLSv1.2";
    public static final String[] JVM_ARGS = new String[]{"-Dhttps.protocols=TLSv1.2"};
    public static final String DESKTOP_TELEM_INI = "DesktopTelematico.ini";
    public static final String TARGET_PATCH_MACOS_VERSION = "10.16";
    public static final String CF_BUNDLER_IDENTIFIER_TARGET = "org.eclipse.eclipse";

    public static void main(String[] args) {
    }

    public static String getJrePath() {
        String filePath = null;
        filePath = OSFinder.isMac() ? String.valueOf(System.getProperty("user.dir")) + File.separator + ".." + File.separator + ".." + File.separator + "jre" + File.separator + "Contents" + File.separator + "Home" + File.separator + "jre" : String.valueOf(System.getProperty("user.dir")) + File.separator + "jre";
        LogUtil.log(PatchUtils.class, (int)1, (String)("getJrePath generated jre path: " + filePath));
        return filePath;
    }

    public static String getWorkspacePath() {
        String WORKSPACE_PATH = ResourcesPlugin.getWorkspace().getRoot().getLocation().makeAbsolute().addTrailingSeparator().toOSString();
        LogUtil.log(PatchUtils.class, (int)1, (String)("getWorkspacePath generated Workspace path: " + WORKSPACE_PATH));
        return WORKSPACE_PATH;
    }

    public static String getBasePath() {
        String filePath = null;
        filePath = OSFinder.isMac() ? String.valueOf(System.getProperty("user.dir")) + File.separator + ".." + File.separator + "Resources" : System.getProperty("user.dir");
        LogUtil.log(PatchUtils.class, (int)1, (String)("getBasePath generated base path: " + filePath));
        return filePath;
    }

    public static void replaceUpdateSiteUrl(String basePath) throws IOException {
        LinkedList<String> filePathList = new LinkedList<String>();
        filePathList.add(String.valueOf(basePath) + PREFS_1);
        filePathList.add(String.valueOf(basePath) + PREFS_2);
        filePathList.add(String.valueOf(basePath) + PREFS_3);
        filePathList.add(String.valueOf(basePath) + PREFS_4);
        String dtEnv = System.getProperty("dt.env") == null ? "PROD" : System.getProperty("dt.env");
        String newUrl = PROD_NEW_URL_UPDATE_SITE;
        String oldUrl = PROD_OLD_URL_UPDATE_SITE;
        if ("TEST".equals(dtEnv)) {
            oldUrl = PROD_OLD_URL_UPDATE_SITE;
            newUrl = TEST_NEW_URL_UPDATE_SITE;
        }
        if ("VAL".equals(dtEnv)) {
            oldUrl = PROD_OLD_URL_UPDATE_SITE;
            newUrl = VAL_NEW_URL_UPDATE_SITE;
        }
        if ("PROD".equals(dtEnv)) {
            oldUrl = PROD_OLD_URL_UPDATE_SITE;
            newUrl = PROD_NEW_URL_UPDATE_SITE;
        }
        for (String path : filePathList) {
            PatchUtils.replaceContent(path, newUrl, oldUrl);
        }
    }

    public static void replaceCaCerts(InputStream initialStream, String CA_PATH) throws IOException, FileNotFoundException {
        byte[] buffer = new byte[initialStream.available()];
        initialStream.read(buffer);
        File targetFile = new File(CA_PATH);
        FileOutputStream outStream = new FileOutputStream(targetFile);
        ((OutputStream)outStream).write(buffer);
        ((OutputStream)outStream).close();
    }

    public static void exportResource(String resourceName, String dest) throws Exception {
        InputStream stream = null;
        OutputStream resStreamOut = null;
        try {
            int readBytes;
            stream = PatchUtils.class.getResourceAsStream(resourceName);
            if (stream == null) {
                throw new Exception("Cannot get resource \"" + resourceName + "\" from Jar file.");
            }
            byte[] buffer = new byte[4096];
            resStreamOut = new FileOutputStream(String.valueOf(dest) + File.separator + "cacerts.zip");
            while ((readBytes = stream.read(buffer)) > 0) {
                resStreamOut.write(buffer, 0, readBytes);
            }
            PatchUtils.unzip(String.valueOf(dest) + File.separator + "cacerts.zip", new File(dest));
        }
        finally {
            if (stream != null) {
                stream.close();
            }
            if (resStreamOut != null) {
                resStreamOut.close();
            }
        }
    }

    private static void replaceContent(String path, String newUrl, String oldUrl) throws IOException {
        LogUtil.log(PatchUtils.class, (int)1, (String)"replaceContent");
        LogUtil.log(PatchUtils.class, (int)1, (String)("replaceContent - path: " + path));
        LogUtil.log(PatchUtils.class, (int)1, (String)("replaceContent - oldUrl:" + oldUrl));
        LogUtil.log(PatchUtils.class, (int)1, (String)("replaceContent - newUrl: " + newUrl));
        File currentFile = new File(path);
        LogUtil.log(PatchUtils.class, (int)1, (String)("replaceContent - AbsolutePath: " + currentFile.getAbsolutePath()));
        if (!currentFile.exists()) {
            LogUtil.log(PatchUtils.class, (int)1, (String)("replaceContent - file doesn't exist:  " + path));
            return;
        }
        LogUtil.log(PatchUtils.class, (int)1, (String)"replaceContent - in progress ");
        Scanner sc = new Scanner(new File(path));
        StringBuffer buffer = new StringBuffer();
        while (sc.hasNextLine()) {
            buffer.append(String.valueOf(sc.nextLine()) + System.lineSeparator());
        }
        String fileContents = buffer.toString();
        System.out.println("Contents of the file: " + fileContents);
        sc.close();
        fileContents = fileContents.replaceAll(oldUrl, newUrl);
        System.out.println("new data: " + fileContents);
        FileWriter writer = new FileWriter(path);
        writer.append(fileContents);
        writer.flush();
        writer.close();
        LogUtil.log(PatchUtils.class, (int)1, (String)"replaceContent - completed ");
    }

    public static void addMissingJvmArgs(String path) throws IOException {
        String protocol_version = System.getProperty("https.protocols");
        if (!TLS_VERSION.equals(protocol_version)) {
            PatchUtils.addContentToFile(path, JVM_ARGS);
        }
    }

    private static void addContentToFile(String path, String[] line) throws IOException {
        File file = new File(path);
        if (!file.exists()) {
            LogUtil.log(PatchUtils.class, (int)1, (String)("DesktopTelematico.ini not found in path: " + path));
            return;
        }
        FileWriter fr = new FileWriter(file, true);
        String[] stringArray = line;
        int n = line.length;
        int n2 = 0;
        while (n2 < n) {
            String cmd = stringArray[n2];
            fr.write(String.valueOf(cmd) + System.lineSeparator());
            ++n2;
        }
        fr.close();
    }

    public static void unzip(String fileZip, File destDir) throws IOException {
        byte[] buffer = new byte[1024];
        ZipInputStream zis = new ZipInputStream(new FileInputStream(fileZip));
        ZipEntry zipEntry = zis.getNextEntry();
        while (zipEntry != null) {
            File newFile = PatchUtils.newFile(destDir, zipEntry);
            if (zipEntry.isDirectory()) {
                if (!newFile.isDirectory() && !newFile.mkdirs()) {
                    throw new IOException("Failed to create directory " + newFile);
                }
            } else {
                int len;
                File parent = newFile.getParentFile();
                if (!parent.isDirectory() && !parent.mkdirs()) {
                    throw new IOException("Failed to create directory " + parent);
                }
                FileOutputStream fos = new FileOutputStream(newFile);
                while ((len = zis.read(buffer)) > 0) {
                    fos.write(buffer, 0, len);
                }
                fos.close();
            }
            zipEntry = zis.getNextEntry();
        }
        zis.closeEntry();
        zis.close();
    }

    public static File newFile(File destinationDir, ZipEntry zipEntry) throws IOException {
        File destFile = new File(destinationDir, zipEntry.getName());
        String destDirPath = destinationDir.getCanonicalPath();
        String destFilePath = destFile.getCanonicalPath();
        if (!destFilePath.startsWith(String.valueOf(destDirPath) + File.separator)) {
            throw new IOException("Entry is outside of the target dir: " + zipEntry.getName());
        }
        return destFile;
    }
}

