/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.webapp.servlet;

import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.help.internal.webapp.HelpWebappPlugin;
import org.eclipse.help.internal.webapp.WebappResources;
import org.eclipse.help.internal.webapp.data.UrlUtil;

public class CookieUtil {
    private static final int COOKIE_LIFE = 157680000;
    private static final int MAX_COOKIE_PAYLOAD = 4096 - "wset_contents01=".length() - "81920<".length() - 1;

    public static String getCookieValue(String name, HttpServletRequest request) {
        String ret = null;
        Cookie[] cookies = request.getCookies();
        if (cookies != null) {
            int i = 0;
            while (i < cookies.length) {
                if (name.equals(cookies[i].getName())) {
                    ret = cookies[i].getValue();
                    break;
                }
                ++i;
            }
        }
        if (HelpWebappPlugin.DEBUG_WORKINGSETS) {
            System.out.println("CookieUtil.getCookieValue(" + name + ", " + request.getRequestURI() + ") returning " + ret);
        }
        return ret;
    }

    public static void setCookieValue(String name, String value, HttpServletRequest request, HttpServletResponse response) {
        Cookie cookie = new Cookie(name, value);
        cookie.setMaxAge(157680000);
        if (CookieUtil.needsCookiePath(request)) {
            cookie.setPath(CookieUtil.getCookiePath(request));
        }
        response.addCookie(cookie);
        if (HelpWebappPlugin.DEBUG_WORKINGSETS) {
            System.out.println("CookieUtil.setCookieValue(" + name + ", " + value + ",...)");
        }
    }

    public static void setCookieValueWithoutPath(String name, String value, HttpServletRequest request, HttpServletResponse response) {
        Cookie cookie = new Cookie(name, value);
        cookie.setMaxAge(157680000);
        response.addCookie(cookie);
        if (HelpWebappPlugin.DEBUG_WORKINGSETS) {
            System.out.println("CookieUtil.setCookieValueWithoutPath(" + name + ", " + value + ",...)");
        }
    }

    private static boolean needsCookiePath(HttpServletRequest request) {
        String contextPath;
        String requestURI = request.getRequestURI();
        return requestURI.indexOf(47, (contextPath = request.getContextPath()).length() + 1) > 0;
    }

    private static String getCookiePath(HttpServletRequest request) {
        return String.valueOf(request.getContextPath()) + '/';
    }

    public static void deleteCookie(String name, HttpServletRequest request, HttpServletResponse response) {
        CookieUtil.deleteCookieUsingPath(name, request, response, CookieUtil.getCookiePath(request));
    }

    protected static void deleteCookieUsingPath(String name, HttpServletRequest request, HttpServletResponse response, String cookiePath) {
        Cookie cookie = new Cookie(name, "");
        String requestURI = request.getRequestURI();
        if (!requestURI.startsWith(cookiePath) || requestURI.indexOf(47, cookiePath.length() + 1) != -1) {
            cookie.setPath(cookiePath);
        }
        cookie.setMaxAge(0);
        response.addCookie(cookie);
    }

    public static void deleteObsoleteCookies(HttpServletRequest request, HttpServletResponse response) {
        Cookie[] cookies = request.getCookies();
        HashSet<String> cookiesToKeep = new HashSet<String>();
        HashSet<String> cookiesToDelete = new HashSet<String>();
        if (cookies != null) {
            String name;
            int i = 0;
            while (i < cookies.length) {
                name = cookies[i].getName();
                if (CookieUtil.isObsoleteCookie(name) || cookiesToKeep.contains(name)) {
                    cookiesToDelete.add(name);
                }
                cookiesToKeep.add(name);
                ++i;
            }
            Iterator iter = cookiesToDelete.iterator();
            while (iter.hasNext()) {
                name = (String)iter.next();
                CookieUtil.deleteCookieUsingPath(name, request, response, String.valueOf(request.getContextPath()) + "/advanced/");
                CookieUtil.deleteCookieUsingPath(name, request, response, "/");
            }
        }
    }

    private static boolean isObsoleteCookie(String name) {
        if (!name.startsWith("wset")) {
            return false;
        }
        int i = "wset".length();
        while (i < name.length()) {
            char suffixChar = name.charAt(i);
            if (suffixChar < '0' || suffixChar > '9') {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static void saveString(String name, String data, int maxCookies, HttpServletRequest request, HttpServletResponse response) throws IOException {
        int len = data.length();
        int n = len / MAX_COOKIE_PAYLOAD;
        if (n > maxCookies) {
            throw new IOException(WebappResources.getString("CookieUtil.tooManyCookiesNeeded", UrlUtil.getLocaleObj(request, response)));
        }
        int i = 1;
        while (i <= n) {
            if (i == 1) {
                CookieUtil.setCookieValue(String.valueOf(name) + "1", String.valueOf(len) + "<" + data.substring(0, MAX_COOKIE_PAYLOAD), request, response);
            } else {
                CookieUtil.setCookieValue(String.valueOf(name) + i, data.substring(MAX_COOKIE_PAYLOAD * (i - 1), MAX_COOKIE_PAYLOAD * i), request, response);
            }
            ++i;
        }
        if (len % MAX_COOKIE_PAYLOAD > 0) {
            if (n == 0) {
                CookieUtil.setCookieValue(String.valueOf(name) + "1", String.valueOf(len) + "<" + data.substring(0, len), request, response);
            } else {
                CookieUtil.setCookieValue(String.valueOf(name) + (n + 1), data.substring(MAX_COOKIE_PAYLOAD * n, len), request, response);
            }
        }
        i = n + 1;
        while (i <= maxCookies) {
            if (i != n + 1 || len % MAX_COOKIE_PAYLOAD <= 0) {
                if (CookieUtil.getCookieValue(String.valueOf(name) + i, request) == null) break;
                CookieUtil.deleteCookie(String.valueOf(name) + i, request, response);
            }
            ++i;
        }
    }

    public static String restoreString(String name, HttpServletRequest request) {
        String value1 = CookieUtil.getCookieValue(String.valueOf(name) + "1", request);
        if (value1 == null) {
            return null;
        }
        String[] lengthAndSubstring1 = value1.split("<");
        if (lengthAndSubstring1.length < 2) {
            return null;
        }
        int len = 0;
        try {
            len = Integer.parseInt(lengthAndSubstring1[0]);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
        if (len <= 0) {
            return null;
        }
        StringBuffer data = new StringBuffer(len);
        data.append(lengthAndSubstring1[1]);
        int n = len / MAX_COOKIE_PAYLOAD;
        int i = 2;
        while (i <= n) {
            String substring = CookieUtil.getCookieValue(String.valueOf(name) + i, request);
            if (substring == null) {
                return null;
            }
            data.append(substring);
            ++i;
        }
        if (len % MAX_COOKIE_PAYLOAD > 0 && n > 0) {
            String substring = CookieUtil.getCookieValue(String.valueOf(name) + (n + 1), request);
            if (substring == null) {
                return null;
            }
            data.append(substring);
        }
        if (data.length() != len) {
            return null;
        }
        return data.toString();
    }
}

