/*
 * Decompiled with CFR 0.152.
 */
package com.sun.security.sasl.ntlm;

import com.sun.security.ntlm.Client;
import com.sun.security.ntlm.NTLMException;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Map;
import java.util.Random;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.TextInputCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.RealmCallback;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslException;

final class NTLMClient
implements SaslClient {
    private static final String NTLM_VERSION = "com.sun.security.sasl.ntlm.version";
    private static final String NTLM_RANDOM = "com.sun.security.sasl.ntlm.random";
    private static final String NTLM_DOMAIN = "com.sun.security.sasl.ntlm.domain";
    private static final String NTLM_HOSTNAME = "com.sun.security.sasl.ntlm.hostname";
    private final Client client;
    private final String mech;
    private final Random random;
    private int step = 0;

    NTLMClient(String string, String string2, String string3, String string4, Map map, CallbackHandler callbackHandler) throws SaslException {
        Object object;
        this.mech = string;
        String string5 = null;
        Random random = null;
        String string6 = null;
        if (map != null) {
            object = (String)map.get("javax.security.sasl.qop");
            if (object != null && !((String)object).equals("auth")) {
                throw new SaslException("NTLM only support auth");
            }
            string5 = (String)map.get(NTLM_VERSION);
            random = (Random)map.get(NTLM_RANDOM);
            string6 = (String)map.get(NTLM_HOSTNAME);
        }
        Random random2 = this.random = random != null ? random : new Random();
        if (string5 == null) {
            string5 = System.getProperty("ntlm.version");
        }
        object = string4 != null && !string4.isEmpty() ? new RealmCallback("Realm: ", string4) : new RealmCallback("Realm: ");
        NameCallback nameCallback = string2 != null && !string2.isEmpty() ? new NameCallback("User name: ", string2) : new NameCallback("User name: ");
        PasswordCallback passwordCallback = new PasswordCallback("Password: ", false);
        try {
            callbackHandler.handle(new Callback[]{object, nameCallback, passwordCallback});
        }
        catch (UnsupportedCallbackException unsupportedCallbackException) {
            throw new SaslException("NTLM: Cannot perform callback to acquire realm, username or password", unsupportedCallbackException);
        }
        catch (IOException iOException) {
            throw new SaslException("NTLM: Error acquiring realm, username or password", iOException);
        }
        if (string6 == null) {
            try {
                string6 = InetAddress.getLocalHost().getCanonicalHostName();
            }
            catch (UnknownHostException unknownHostException) {
                string6 = "localhost";
            }
        }
        try {
            this.client = new Client(string5, string6, nameCallback.getName(), ((TextInputCallback)object).getText(), passwordCallback.getPassword());
        }
        catch (NTLMException nTLMException) {
            throw new SaslException("NTLM: Invalid version string: " + string5, nTLMException);
        }
    }

    @Override
    public String getMechanismName() {
        return this.mech;
    }

    @Override
    public boolean isComplete() {
        return this.step >= 2;
    }

    @Override
    public byte[] unwrap(byte[] byArray, int n, int n2) throws SaslException {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public byte[] wrap(byte[] byArray, int n, int n2) throws SaslException {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public Object getNegotiatedProperty(String string) {
        if (string.equals("javax.security.sasl.qop")) {
            return "auth";
        }
        if (string.equals(NTLM_DOMAIN)) {
            return this.client.getDomain();
        }
        return null;
    }

    @Override
    public void dispose() throws SaslException {
        this.client.dispose();
    }

    @Override
    public boolean hasInitialResponse() {
        return true;
    }

    @Override
    public byte[] evaluateChallenge(byte[] byArray) throws SaslException {
        ++this.step;
        if (this.step == 1) {
            return this.client.type1();
        }
        try {
            byte[] byArray2 = new byte[8];
            this.random.nextBytes(byArray2);
            return this.client.type3(byArray, byArray2);
        }
        catch (NTLMException nTLMException) {
            throw new SaslException("Type3 creation failed", nTLMException);
        }
    }
}

