/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.synth;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JSeparator;
import javax.swing.JToolBar;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.DimensionUIResource;
import javax.swing.plaf.SeparatorUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthLookAndFeel;
import javax.swing.plaf.synth.SynthStyle;
import javax.swing.plaf.synth.SynthUI;

public class SynthSeparatorUI
extends SeparatorUI
implements PropertyChangeListener,
SynthUI {
    private SynthStyle style;

    public static ComponentUI createUI(JComponent jComponent) {
        return new SynthSeparatorUI();
    }

    @Override
    public void installUI(JComponent jComponent) {
        this.installDefaults((JSeparator)jComponent);
        this.installListeners((JSeparator)jComponent);
    }

    @Override
    public void uninstallUI(JComponent jComponent) {
        this.uninstallListeners((JSeparator)jComponent);
        this.uninstallDefaults((JSeparator)jComponent);
    }

    public void installDefaults(JSeparator jSeparator) {
        this.updateStyle(jSeparator);
    }

    private void updateStyle(JSeparator jSeparator) {
        Dimension dimension;
        SynthContext synthContext = this.getContext(jSeparator, 1);
        SynthStyle synthStyle = this.style;
        this.style = SynthLookAndFeel.updateStyle(synthContext, this);
        if (this.style != synthStyle && jSeparator instanceof JToolBar.Separator && ((dimension = ((JToolBar.Separator)jSeparator).getSeparatorSize()) == null || dimension instanceof UIResource)) {
            dimension = (DimensionUIResource)this.style.get(synthContext, "ToolBar.separatorSize");
            if (dimension == null) {
                dimension = new DimensionUIResource(10, 10);
            }
            ((JToolBar.Separator)jSeparator).setSeparatorSize(dimension);
        }
        synthContext.dispose();
    }

    public void uninstallDefaults(JSeparator jSeparator) {
        SynthContext synthContext = this.getContext(jSeparator, 1);
        this.style.uninstallDefaults(synthContext);
        synthContext.dispose();
        this.style = null;
    }

    public void installListeners(JSeparator jSeparator) {
        jSeparator.addPropertyChangeListener(this);
    }

    public void uninstallListeners(JSeparator jSeparator) {
        jSeparator.removePropertyChangeListener(this);
    }

    @Override
    public void update(Graphics graphics, JComponent jComponent) {
        SynthContext synthContext = this.getContext(jComponent);
        JSeparator jSeparator = (JSeparator)synthContext.getComponent();
        SynthLookAndFeel.update(synthContext, graphics);
        synthContext.getPainter().paintSeparatorBackground(synthContext, graphics, 0, 0, jComponent.getWidth(), jComponent.getHeight(), jSeparator.getOrientation());
        this.paint(synthContext, graphics);
        synthContext.dispose();
    }

    @Override
    public void paint(Graphics graphics, JComponent jComponent) {
        SynthContext synthContext = this.getContext(jComponent);
        this.paint(synthContext, graphics);
        synthContext.dispose();
    }

    protected void paint(SynthContext synthContext, Graphics graphics) {
        JSeparator jSeparator = (JSeparator)synthContext.getComponent();
        synthContext.getPainter().paintSeparatorForeground(synthContext, graphics, 0, 0, jSeparator.getWidth(), jSeparator.getHeight(), jSeparator.getOrientation());
    }

    @Override
    public void paintBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
        JSeparator jSeparator = (JSeparator)synthContext.getComponent();
        synthContext.getPainter().paintSeparatorBorder(synthContext, graphics, n, n2, n3, n4, jSeparator.getOrientation());
    }

    @Override
    public Dimension getPreferredSize(JComponent jComponent) {
        SynthContext synthContext = this.getContext(jComponent);
        int n = this.style.getInt(synthContext, "Separator.thickness", 2);
        Insets insets = jComponent.getInsets();
        Dimension dimension = ((JSeparator)jComponent).getOrientation() == 1 ? new Dimension(insets.left + insets.right + n, insets.top + insets.bottom) : new Dimension(insets.left + insets.right, insets.top + insets.bottom + n);
        synthContext.dispose();
        return dimension;
    }

    @Override
    public Dimension getMinimumSize(JComponent jComponent) {
        return this.getPreferredSize(jComponent);
    }

    @Override
    public Dimension getMaximumSize(JComponent jComponent) {
        return new Dimension(Short.MAX_VALUE, Short.MAX_VALUE);
    }

    @Override
    public SynthContext getContext(JComponent jComponent) {
        return this.getContext(jComponent, SynthLookAndFeel.getComponentState(jComponent));
    }

    private SynthContext getContext(JComponent jComponent, int n) {
        return SynthContext.getContext(SynthContext.class, jComponent, SynthLookAndFeel.getRegion(jComponent), this.style, n);
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (SynthLookAndFeel.shouldUpdateStyle(propertyChangeEvent)) {
            this.updateStyle((JSeparator)propertyChangeEvent.getSource());
        }
    }
}

