/*
 * Decompiled with CFR 0.152.
 */
package it.sogei.utilities.log4j;

import it.sogei.rcp.ui.preferences.entities.PreferenceBean;
import it.sogei.rcp.ui.preferences.entities.ScopeEnum;
import it.sogei.rcp.ui.preferences.util.PreferencesUtilRCP;
import it.sogei.utilities.log4j.ConsoleUtil;
import it.sogei.utilities.log4j.PropertiesLog4j;
import java.util.Hashtable;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;
import org.eclipse.core.resources.ResourcesPlugin;

public class LogUtil {
    public static final int DEBUG = 1;
    public static final int INFO = 2;
    public static final int WARN = 3;
    public static final int ERROR = 4;
    public static final int FATAL = 5;
    public static String defaultLevel = "INFO";
    private static Hashtable<String, Logger> loggers;
    public static final String LOG_PATH = "logs/";
    public static final String LOG_NAME = "rcp.log";
    public static final String SESSION_LOG_NAME = "sessionrcp.log";
    public static boolean workspaceLogSet;
    public static boolean workspaceLogPathSet;
    private static String completelogPath;

    static {
        workspaceLogSet = false;
        workspaceLogPathSet = false;
        workspaceLogPathSet = false;
        loggers = new Hashtable();
        completelogPath = String.valueOf(System.getProperty("user.dir")) + '/' + LOG_PATH;
        PropertiesLog4j.setString("log4j.appender.A1.File", String.valueOf(completelogPath) + LOG_NAME);
        PropertiesLog4j.setString("log4j.appender.A2.File", String.valueOf(completelogPath) + SESSION_LOG_NAME);
        PropertyConfigurator.configure((Properties)PropertiesLog4j.getProps());
    }

    private static void initWorkspaceLog() {
        workspaceLogSet = new Boolean(PreferencesUtilRCP.getPreferenceValue((PreferenceBean)new PreferenceBean("it.sogei.utilities.log4j", "log", "wsCreated"), (ScopeEnum)ScopeEnum.CONFIGURATION));
        if (workspaceLogSet && !workspaceLogPathSet) {
            String WORKSPACE_PATH = ResourcesPlugin.getWorkspace().getRoot().getLocation().makeAbsolute().addTrailingSeparator().toOSString();
            completelogPath = String.valueOf(WORKSPACE_PATH) + LOG_PATH;
            PropertiesLog4j.setString("log4j.appender.A1.File", String.valueOf(completelogPath) + LOG_NAME);
            PropertiesLog4j.setString("log4j.appender.A2.File", String.valueOf(completelogPath) + SESSION_LOG_NAME);
            PropertyConfigurator.configure((Properties)PropertiesLog4j.getProps());
            workspaceLogSet = true;
            workspaceLogPathSet = true;
        }
    }

    private static Logger getLogger(String loggerName) {
        LogUtil.initWorkspaceLog();
        Logger log4jLogger = null;
        if (loggers.containsKey(loggerName)) {
            log4jLogger = loggers.get(loggerName);
        } else {
            log4jLogger = Logger.getLogger((String)loggerName);
            loggers.put(loggerName, log4jLogger);
        }
        return log4jLogger;
    }

    public static void log(String loggerName, int level, String message, boolean logToConsole) {
        Logger log4jLogger = LogUtil.getLogger(loggerName);
        switch (level) {
            case 1: {
                log4jLogger.debug((Object)message);
                break;
            }
            case 2: {
                log4jLogger.info((Object)message);
                break;
            }
            case 3: {
                log4jLogger.warn((Object)message);
            }
            case 4: {
                log4jLogger.error((Object)message);
                break;
            }
            case 5: {
                log4jLogger.fatal((Object)message);
                break;
            }
            default: {
                Logger.getLogger(LogUtil.class).error((Object)"Il livello di log deve essere scelto tra quelli esposti dagli attributi statici di questa classe");
            }
        }
        if (logToConsole) {
            ConsoleUtil.logToConsole(message, level);
        }
    }

    public static void log(String loggerName, int level, String message) {
        LogUtil.log(loggerName, level, message, false);
    }

    public static void log(Object loggerInvoker, int level, String message) {
        LogUtil.log(loggerInvoker.getClass().getName(), level, message);
    }

    public static void log(Object loggerInvoker, int level, String message, boolean logToConsole) {
        LogUtil.log(loggerInvoker.getClass().getName(), level, message, logToConsole);
    }

    public static void log(String loggerName, int level, String message, Throwable exception, boolean logToConsole) {
        Logger log4jLogger = LogUtil.getLogger(loggerName);
        switch (level) {
            case 1: {
                log4jLogger.debug((Object)message, exception);
                break;
            }
            case 2: {
                log4jLogger.info((Object)message, exception);
                break;
            }
            case 3: {
                log4jLogger.warn((Object)message, exception);
                break;
            }
            case 4: {
                log4jLogger.error((Object)message, exception);
                break;
            }
            case 5: {
                log4jLogger.fatal((Object)message, exception);
                break;
            }
            default: {
                Logger.getLogger(LogUtil.class).error((Object)"Il livello di log deve essere scelto tra quelli esposti dagli attributi statici di questa classe");
            }
        }
        if (logToConsole) {
            ConsoleUtil.logToConsole(message, level);
        }
    }

    public static void log(String loggerName, int level, String message, Throwable exception) {
        LogUtil.log(loggerName, level, message, exception, false);
    }

    public static void log(Object loggerInvoker, int level, String message, Throwable exception) {
        LogUtil.log(loggerInvoker.getClass().getName(), level, message, exception, false);
    }

    public static void log(Object loggerInvoker, int level, String message, Throwable exception, boolean logToConsole) {
        LogUtil.log(loggerInvoker.getClass().getName(), level, message, exception, logToConsole);
    }

    public static boolean changeLogLevel(String newlevel) {
        if (!("DEBUG".equals(newlevel) || "INFO".equals(newlevel) || "WARN".equals(newlevel) || "ERROR".equals(newlevel) || "FATAL".equals(newlevel))) {
            return false;
        }
        loggers = new Hashtable();
        PropertiesLog4j.setString("log4j.rootLogger", String.valueOf(newlevel) + ", A1, A2");
        PropertyConfigurator.configure((Properties)PropertiesLog4j.getProps());
        return true;
    }
}

