/*
 * Decompiled with CFR 0.152.
 */
package iaik.security.cipher;

import iaik.security.cipher.DESKeyGenerator;
import iaik.security.cipher.SecretKey;
import iaik.security.cipher.VarLengthKeyGenerator;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.SecureRandom;
import javax.crypto.spec.DESKeySpec;

public class TripleDESKeyGenerator
extends VarLengthKeyGenerator {
    protected void engineInit(int n2, SecureRandom secureRandom) {
        if (n2 == -1) {
            n2 = 192;
        } else if (n2 == 112) {
            n2 = 128;
        } else if (n2 == 168) {
            n2 = 192;
        }
        if (n2 != 128 && n2 != 192) {
            throw new InvalidParameterException("Invalid 3DES key length (" + n2 + "). Only 128 or 192 allowed!");
        }
        super.engineInit(n2, secureRandom);
    }

    protected javax.crypto.SecretKey engineGenerateKey() {
        try {
            byte[] byArray = super.engineGenerateKey().getEncoded();
            int n2 = 0;
            while (n2 < byArray.length) {
                DESKeyGenerator.adjustParity(byArray, n2);
                if (!DESKeySpec.isWeak(byArray, n2)) {
                    // empty if block
                }
                n2 += 8;
            }
            return new SecretKey(byArray, "DESede");
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new RuntimeException(invalidKeyException.toString());
        }
    }

    public TripleDESKeyGenerator() {
        super("DESede", 128, 192, 192);
    }
}

