/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.internal.provider.filetransfer.httpclient4;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.http.conn.scheme.LayeredSchemeSocketFactory;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.eclipse.ecf.core.util.Trace;
import org.eclipse.ecf.filetransfer.events.socket.ISocketEvent;
import org.eclipse.ecf.filetransfer.events.socket.ISocketEventSource;
import org.eclipse.ecf.filetransfer.events.socket.ISocketListener;
import org.eclipse.ecf.internal.provider.filetransfer.httpclient4.CloseMonitoringSocket;
import org.eclipse.ecf.provider.filetransfer.events.socket.SocketClosedEvent;
import org.eclipse.ecf.provider.filetransfer.events.socket.SocketConnectedEvent;
import org.eclipse.ecf.provider.filetransfer.events.socket.SocketCreatedEvent;

public final class ECFHttpClientSecureProtocolSocketFactory
implements LayeredSchemeSocketFactory {
    private final SSLSocketFactory sslSocketFactory;
    private final ISocketEventSource source;
    private final ISocketListener socketConnectListener;

    public ECFHttpClientSecureProtocolSocketFactory(SSLSocketFactory sslSocketFactory, ISocketEventSource source, ISocketListener socketConnectListener) {
        this.sslSocketFactory = sslSocketFactory;
        this.source = source;
        this.socketConnectListener = socketConnectListener;
    }

    public Socket createSocket(HttpParams params) {
        Trace.entering((String)"org.eclipse.ecf.provider.filetransfer.httpclient4", (String)"org.eclipse.ecf.provider.filetransfer.httpclient4/debug/methods/entering", ECFHttpClientSecureProtocolSocketFactory.class, (String)"createSocket");
        Socket socket = new Socket();
        ECFHttpClientSecureProtocolSocketFactory.fireEvent(this.socketConnectListener, (ISocketEvent)new SocketCreatedEvent(this.source, socket));
        Trace.exiting((String)"org.eclipse.ecf.provider.filetransfer.httpclient4", (String)"org.eclipse.ecf.provider.filetransfer.httpclient4/debug/methods/exiting", ECFHttpClientSecureProtocolSocketFactory.class, (String)("socketCreated " + socket));
        return socket;
    }

    public Socket connectSocket(Socket socket, InetSocketAddress remoteAddress, InetSocketAddress localAddress, HttpParams params) throws IOException, UnknownHostException, ConnectTimeoutException {
        if (remoteAddress == null) {
            throw new IllegalArgumentException("Remote address must not be null");
        }
        if (params == null) {
            throw new IllegalArgumentException("HTTP parameters must not be null");
        }
        if (socket == null) {
            SSLSocket sslSocket = (SSLSocket)this.sslSocketFactory.createSocket();
            this.performConnection(sslSocket, remoteAddress, localAddress, params);
            return this.wrapSocket(sslSocket);
        }
        if (socket instanceof SSLSocket) {
            this.performConnection(socket, remoteAddress, localAddress, params);
            return this.wrapSocket(socket);
        }
        if (!socket.isConnected()) {
            this.performConnection(socket, remoteAddress, localAddress, params);
        }
        Socket layeredSocket = this.sslSocketFactory.createSocket(socket, remoteAddress.getHostName(), remoteAddress.getPort(), true);
        return this.wrapSocket(layeredSocket);
    }

    private void performConnection(Socket socket, InetSocketAddress remoteAddress, InetSocketAddress localAddress, HttpParams params) throws SocketException, IOException {
        try {
            socket.setReuseAddress(HttpConnectionParams.getSoReuseaddr((HttpParams)params));
            socket.bind(localAddress);
            int connectionTimeout = HttpConnectionParams.getConnectionTimeout((HttpParams)params);
            int socketTimeout = HttpConnectionParams.getSoTimeout((HttpParams)params);
            socket.connect(remoteAddress, connectionTimeout);
            socket.setSoTimeout(socketTimeout);
        }
        catch (SocketException e) {
            Trace.catching((String)"org.eclipse.ecf.provider.filetransfer.httpclient4", (String)"org.eclipse.ecf.provider.filetransfer.httpclient4/debug/exceptions/catching", ECFHttpClientSecureProtocolSocketFactory.class, (String)"performConnection", (Throwable)e);
            ECFHttpClientSecureProtocolSocketFactory.fireEvent(this.socketConnectListener, (ISocketEvent)new SocketClosedEvent(this.source, socket, socket));
            Trace.throwing((String)"org.eclipse.ecf.provider.filetransfer.httpclient4", (String)"org.eclipse.ecf.provider.filetransfer.httpclient4/debug/exceptions/throwing", ECFHttpClientSecureProtocolSocketFactory.class, (String)"performConnection", (Throwable)e);
            throw e;
        }
        catch (IOException e) {
            Trace.catching((String)"org.eclipse.ecf.provider.filetransfer.httpclient4", (String)"org.eclipse.ecf.provider.filetransfer.httpclient4/debug/exceptions/catching", ECFHttpClientSecureProtocolSocketFactory.class, (String)"performConnection", (Throwable)e);
            ECFHttpClientSecureProtocolSocketFactory.fireEvent(this.socketConnectListener, (ISocketEvent)new SocketClosedEvent(this.source, socket, socket));
            Trace.throwing((String)"org.eclipse.ecf.provider.filetransfer.httpclient4", (String)"org.eclipse.ecf.provider.filetransfer.httpclient4/debug/exceptions/throwing", ECFHttpClientSecureProtocolSocketFactory.class, (String)"performConnection", (Throwable)e);
            throw e;
        }
    }

    public boolean isSecure(Socket sock) throws IllegalArgumentException {
        if (sock == null) {
            throw new IllegalArgumentException("Socket must not be null");
        }
        if (sock instanceof CloseMonitoringSocket) {
            return ((CloseMonitoringSocket)((Object)sock)).isSecure();
        }
        if (!(sock instanceof SSLSocket)) {
            throw new IllegalArgumentException("Socket not created by this factory");
        }
        if (sock.isClosed()) {
            throw new IllegalArgumentException("Socket is closed");
        }
        return true;
    }

    public Socket createLayeredSocket(Socket socket, String host, int port, boolean autoClose) throws IOException {
        Trace.entering((String)"org.eclipse.ecf.provider.filetransfer.httpclient4", (String)"org.eclipse.ecf.provider.filetransfer.httpclient4/debug/methods/entering", ECFHttpClientSecureProtocolSocketFactory.class, (String)("createLayeredSocket " + host + ":" + port + ",socket=" + socket));
        SSLSocket sslSocket = null;
        try {
            Trace.trace((String)"org.eclipse.ecf.provider.filetransfer.httpclient4", (String)("connectingLayeredSocket(original=" + socket + ",dest=" + host + ":" + port + ")"));
            sslSocket = (SSLSocket)this.sslSocketFactory.createSocket(socket, host, port, autoClose);
            Trace.trace((String)"org.eclipse.ecf.provider.filetransfer.httpclient4", (String)"connected");
        }
        catch (IOException e) {
            Trace.catching((String)"org.eclipse.ecf.provider.filetransfer.httpclient4", (String)"org.eclipse.ecf.provider.filetransfer.httpclient4/debug/exceptions/catching", ECFHttpClientSecureProtocolSocketFactory.class, (String)"createLayeredSocket", (Throwable)e);
            ECFHttpClientSecureProtocolSocketFactory.fireEvent(this.socketConnectListener, (ISocketEvent)new SocketClosedEvent(this.source, sslSocket, sslSocket));
            Trace.throwing((String)"org.eclipse.ecf.provider.filetransfer.httpclient4", (String)"org.eclipse.ecf.provider.filetransfer.httpclient4/debug/exceptions/throwing", ECFHttpClientSecureProtocolSocketFactory.class, (String)"createSocket", (Throwable)e);
            throw e;
        }
        return this.wrapSocket(sslSocket);
    }

    private Socket wrapSocket(Socket toWrap) {
        CloseMonitoringSocket wrappedSocket = new CloseMonitoringSocket(toWrap, this.socketConnectListener, this.source);
        SocketConnectedEvent connectedEvent = new SocketConnectedEvent(this.source, toWrap, (Socket)((Object)wrappedSocket));
        ECFHttpClientSecureProtocolSocketFactory.fireEvent(this.socketConnectListener, (ISocketEvent)connectedEvent);
        Socket connectedEventSocket = connectedEvent.getSocket();
        if (connectedEventSocket != wrappedSocket) {
            wrappedSocket.setWrappedSocket(connectedEventSocket);
            return connectedEventSocket;
        }
        return wrappedSocket;
    }

    static void fireEvent(ISocketListener spyListener, ISocketEvent event) {
        if (spyListener != null) {
            spyListener.handleSocketEvent(event);
        }
        event.getSource().fireEvent(event);
    }

    public boolean equals(Object obj) {
        return obj != null && obj.getClass().equals(ECFHttpClientSecureProtocolSocketFactory.class);
    }

    public int hashCode() {
        return ECFHttpClientSecureProtocolSocketFactory.class.hashCode();
    }
}

