/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.dialogs;

import java.io.File;
import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.SelectionStatusDialog;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;

public class ProjectLocationSelectionDialog
extends SelectionStatusDialog {
    private Text projectNameField;
    private Text locationPathField;
    private Label locationLabel;
    private IProject project;
    private Button browseButton;
    private static String PROJECT_NAME_LABEL = IDEWorkbenchMessages.getString("ProjectLocationSelectionDialog.nameLabel");
    private static String LOCATION_LABEL = IDEWorkbenchMessages.getString("ProjectLocationSelectionDialog.locationLabel");
    private static String BROWSE_LABEL = IDEWorkbenchMessages.getString("ProjectLocationSelectionDialog.browseLabel");
    private static String DIRECTORY_DIALOG_LABEL = IDEWorkbenchMessages.getString("ProjectLocationSelectionDialog.directoryLabel");
    private static String INVALID_LOCATION_MESSAGE = IDEWorkbenchMessages.getString("ProjectLocationSelectionDialog.locationError");
    private static String PROJECT_LOCATION_SELECTION_TITLE = IDEWorkbenchMessages.getString("ProjectLocationSelectionDialog.selectionTitle");
    private static final int SIZING_TEXT_FIELD_WIDTH = 250;
    private boolean useDefaults = true;
    private boolean firstLocationCheck;

    public ProjectLocationSelectionDialog(Shell parentShell, IProject existingProject) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.setTitle(PROJECT_LOCATION_SELECTION_TITLE);
        this.setStatusLineAboveButtons(true);
        this.project = existingProject;
        try {
            this.useDefaults = this.getProject().getDescription().getLocation() == null;
        }
        catch (CoreException coreException) {}
    }

    private void applyValidationResult(String errorMsg) {
        int code;
        boolean allowFinish = false;
        if (errorMsg == null) {
            code = 0;
            errorMsg = "";
            allowFinish = true;
        } else {
            code = this.firstLocationCheck ? 0 : 4;
        }
        this.updateStatus((IStatus)new Status(code, IDEWorkbenchPlugin.getDefault().getDescriptor().getUniqueIdentifier(), code, errorMsg, null));
        this.getOkButton().setEnabled(allowFinish);
    }

    private String checkValid() {
        String valid = this.checkValidName();
        if (valid != null) {
            return valid;
        }
        return this.checkValidLocation();
    }

    private String checkValidLocation() {
        if (this.useDefaults) {
            return null;
        }
        String locationFieldContents = this.locationPathField.getText();
        if (locationFieldContents.equals("")) {
            return IDEWorkbenchMessages.getString("WizardNewProjectCreationPage.projectLocationEmpty");
        }
        Path path = new Path("");
        if (!path.isValidPath(locationFieldContents)) {
            return INVALID_LOCATION_MESSAGE;
        }
        IStatus locationStatus = this.project.getWorkspace().validateProjectLocation(this.project, (IPath)new Path(locationFieldContents));
        if (!locationStatus.isOK()) {
            return locationStatus.getMessage();
        }
        return null;
    }

    private String checkValidName() {
        String name = this.projectNameField.getText();
        IWorkspace workspace = this.getProject().getWorkspace();
        IStatus nameStatus = workspace.validateName(name, 4);
        if (!nameStatus.isOK()) {
            return nameStatus.getMessage();
        }
        IProject newProject = workspace.getRoot().getProject(name);
        if (newProject.exists()) {
            return IDEWorkbenchMessages.format("CopyProjectAction.alreadyExists", new Object[]{name});
        }
        return null;
    }

    protected void computeResult() {
        ArrayList<String> list = new ArrayList<String>();
        list.add(this.projectNameField.getText());
        if (this.useDefaults) {
            list.add(Platform.getLocation().toString());
        } else {
            list.add(this.locationPathField.getText());
        }
        this.setResult(list);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        WorkbenchHelp.setHelp((Control)shell, (String)"org.eclipse.ui.ide.project_location_selection_dialog_context");
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(1808));
        this.createProjectNameGroup(composite);
        this.createProjectLocationGroup(composite);
        return composite;
    }

    private void createLocationListener() {
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                ProjectLocationSelectionDialog.this.firstLocationCheck = false;
                ProjectLocationSelectionDialog.this.applyValidationResult(ProjectLocationSelectionDialog.this.checkValid());
            }
        };
        this.locationPathField.addListener(24, listener);
    }

    private void createNameListener() {
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                ProjectLocationSelectionDialog.this.setLocationForSelection();
                ProjectLocationSelectionDialog.this.applyValidationResult(ProjectLocationSelectionDialog.this.checkValid());
            }
        };
        this.projectNameField.addListener(24, listener);
    }

    private final void createProjectLocationGroup(Composite parent) {
        Font font = parent.getFont();
        Composite projectGroup = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        projectGroup.setLayout((Layout)layout);
        projectGroup.setLayoutData((Object)new GridData(768));
        projectGroup.setFont(font);
        final Button useDefaultsButton = new Button(projectGroup, 131104);
        useDefaultsButton.setText(IDEWorkbenchMessages.getString("ProjectLocationSelectionDialog.useDefaultLabel"));
        useDefaultsButton.setSelection(this.useDefaults);
        GridData buttonData = new GridData();
        buttonData.horizontalSpan = 3;
        useDefaultsButton.setLayoutData((Object)buttonData);
        useDefaultsButton.setFont(font);
        this.createUserSpecifiedProjectLocationGroup(projectGroup, !this.useDefaults);
        SelectionAdapter listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProjectLocationSelectionDialog.this.useDefaults = useDefaultsButton.getSelection();
                ProjectLocationSelectionDialog.this.browseButton.setEnabled(!ProjectLocationSelectionDialog.this.useDefaults);
                ProjectLocationSelectionDialog.this.locationPathField.setEnabled(!ProjectLocationSelectionDialog.this.useDefaults);
                ProjectLocationSelectionDialog.this.locationLabel.setEnabled(!ProjectLocationSelectionDialog.this.useDefaults);
                ProjectLocationSelectionDialog.this.setLocationForSelection();
                if (!ProjectLocationSelectionDialog.this.useDefaults) {
                    ProjectLocationSelectionDialog.this.firstLocationCheck = true;
                    ProjectLocationSelectionDialog.this.applyValidationResult(ProjectLocationSelectionDialog.this.checkValid());
                }
            }
        };
        useDefaultsButton.addSelectionListener((SelectionListener)listener);
    }

    private void createProjectNameGroup(Composite parent) {
        Font font = parent.getFont();
        Composite projectGroup = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        projectGroup.setLayout((Layout)layout);
        projectGroup.setLayoutData((Object)new GridData(768));
        Label projectLabel = new Label(projectGroup, 0);
        projectLabel.setFont(font);
        projectLabel.setText(PROJECT_NAME_LABEL);
        this.projectNameField = new Text(projectGroup, 2048);
        GridData data = new GridData(768);
        data.widthHint = 250;
        this.projectNameField.setLayoutData((Object)data);
        this.projectNameField.setFont(font);
        this.projectNameField.setText(this.getCopyNameFor(this.getProject().getName()));
        this.projectNameField.selectAll();
        this.createNameListener();
    }

    private Composite createUserSpecifiedProjectLocationGroup(Composite projectGroup, boolean enabled) {
        Font font = projectGroup.getFont();
        this.locationLabel = new Label(projectGroup, 0);
        this.locationLabel.setFont(font);
        this.locationLabel.setText(LOCATION_LABEL);
        this.locationLabel.setEnabled(enabled);
        this.locationPathField = new Text(projectGroup, 2048);
        GridData data = new GridData(768);
        data.widthHint = 250;
        this.locationPathField.setLayoutData((Object)data);
        this.locationPathField.setFont(font);
        this.locationPathField.setEnabled(enabled);
        this.browseButton = new Button(projectGroup, 8);
        this.browseButton.setFont(font);
        this.browseButton.setText(BROWSE_LABEL);
        this.browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ProjectLocationSelectionDialog.this.handleLocationBrowseButtonPressed();
            }
        });
        this.browseButton.setEnabled(enabled);
        this.setButtonLayoutData(this.browseButton);
        try {
            IPath location = this.getProject().getDescription().getLocation();
            if (location == null) {
                this.setLocationForSelection();
            } else {
                this.locationPathField.setText(location.toString());
            }
        }
        catch (CoreException coreException) {
            this.setLocationForSelection();
        }
        this.createLocationListener();
        return projectGroup;
    }

    private String getCopyNameFor(String projectName) {
        IWorkspace workspace = this.getProject().getWorkspace();
        if (!workspace.getRoot().getProject(projectName).exists()) {
            return projectName;
        }
        int counter = 1;
        while (true) {
            String nameSegment = counter > 1 ? IDEWorkbenchMessages.format("CopyProjectAction.copyNameTwoArgs", new Object[]{new Integer(counter), projectName}) : IDEWorkbenchMessages.format("CopyProjectAction.copyNameOneArg", new Object[]{projectName});
            if (!workspace.getRoot().getProject(nameSegment).exists()) {
                return nameSegment;
            }
            ++counter;
        }
    }

    private IProject getProject() {
        return this.project;
    }

    private void handleLocationBrowseButtonPressed() {
        String selectedDirectory;
        File path;
        DirectoryDialog dialog = new DirectoryDialog(this.locationPathField.getShell());
        dialog.setMessage(DIRECTORY_DIALOG_LABEL);
        String dirName = this.locationPathField.getText();
        if (!dirName.equals("") && (path = new File(dirName)).exists()) {
            dialog.setFilterPath(dirName);
        }
        if ((selectedDirectory = dialog.open()) != null) {
            this.locationPathField.setText(selectedDirectory);
        }
    }

    private void setLocationForSelection() {
        if (this.useDefaults) {
            IPath defaultPath = Platform.getLocation().append(this.projectNameField.getText());
            this.locationPathField.setText(defaultPath.toOSString());
        }
    }
}

