/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.ide.dialogs;

import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.WorkbenchEncoding;
import org.eclipse.ui.ide.IDEEncoding;
import org.eclipse.ui.ide.dialogs.ResourceEncodingFieldEditor;
import org.eclipse.ui.internal.dialogs.EditorsPreferencePage;
import org.eclipse.ui.internal.dialogs.PreferenceLinkArea;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;

public class IDEEditorsPreferencePage
extends EditorsPreferencePage {
    private boolean clearUserSettings = false;
    private ResourceEncodingFieldEditor encodingEditor;

    protected Control createContents(Composite parent) {
        Composite composite = this.createComposite(parent);
        PreferenceLinkArea area = new PreferenceLinkArea(composite, 2048, "org.eclipse.ui.preferencePages.FileEditors", IDEWorkbenchMessages.getString("IDEEditorsPreferencePage.WorkbenchPreference.relatedLink"));
        GridData data = new GridData(768);
        data.heightHint = 25;
        data.widthHint = 100;
        area.setLayoutData((Object)data);
        this.createEditorHistoryGroup(composite);
        this.createSpace(composite);
        this.createShowMultipleEditorTabsPref(composite);
        this.createCloseEditorsOnExitPref(composite);
        this.createEditorReuseGroup(composite);
        this.createSpace(composite);
        this.encodingEditor = new ResourceEncodingFieldEditor(IDEWorkbenchMessages.getString("WorkbenchPreference.encoding"), composite, (IResource)ResourcesPlugin.getWorkspace().getRoot());
        this.encodingEditor.setPage((DialogPage)this);
        this.encodingEditor.load();
        this.encodingEditor.setPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (event.getProperty().equals("field_editor_is_valid")) {
                    IDEEditorsPreferencePage.this.updateValidState();
                }
            }
        });
        return composite;
    }

    protected void performDefaults() {
        this.clearUserSettings = true;
        List encodings = WorkbenchEncoding.getDefinedEncodings();
        Collections.sort(encodings);
        this.encodingEditor.loadDefault();
        super.performDefaults();
    }

    protected void updateValidState() {
        if (!this.encodingEditor.isValid()) {
            this.setValid(false);
            return;
        }
        super.updateValidState();
    }

    public boolean performOk() {
        if (this.clearUserSettings) {
            IDEEncoding.clearUserEncodings();
        }
        this.encodingEditor.store();
        return super.performOk();
    }
}

