/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.ide.dialogs;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeViewerListener;
import org.eclipse.jface.viewers.TreeExpansionEvent;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetManager;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.IWorkingSetPage;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.internal.ide.IDEInternalWorkbenchImages;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.internal.ide.dialogs.ResourceSorter;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class ResourceWorkingSetPage
extends WizardPage
implements IWorkingSetPage {
    private static final int SIZING_SELECTION_WIDGET_WIDTH = 50;
    private static final int SIZING_SELECTION_WIDGET_HEIGHT = 200;
    private Text text;
    private CheckboxTreeViewer tree;
    private IWorkingSet workingSet;
    private boolean firstCheck = false;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public ResourceWorkingSetPage() {
        super("resourceWorkingSetPage", IDEWorkbenchMessages.getString("ResourceWorkingSetPage.title"), IDEInternalWorkbenchImages.getImageDescriptor("IMG_WIZBAN_EXPORTZIP_WIZ"));
        this.setDescription(IDEWorkbenchMessages.getString("ResourceWorkingSetPage.description"));
    }

    private void addWorkingSetElements(List collectedResources, IContainer container) {
        IAdaptable[] elements = this.workingSet.getElements();
        IPath containerPath = container.getFullPath();
        int i = 0;
        while (i < elements.length) {
            IPath resourcePath;
            IResource resource = null;
            if (elements[i] instanceof IResource) {
                resource = (IResource)elements[i];
            } else {
                IAdaptable iAdaptable = elements[i];
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("org.eclipse.core.resources.IResource");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                resource = (IResource)iAdaptable.getAdapter((Class)clazz);
            }
            if (resource != null && containerPath.isPrefixOf(resourcePath = resource.getFullPath())) {
                collectedResources.add(elements[i]);
            }
            ++i;
        }
    }

    public void createControl(Composite parent) {
        Font font = parent.getFont();
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(256));
        this.setControl((Control)composite);
        WorkbenchHelp.setHelp((Control)composite, (String)"org.eclipse.ui.ide.working_set_resource_page");
        Label label = new Label(composite, 64);
        label.setText(IDEWorkbenchMessages.getString("ResourceWorkingSetPage.message"));
        GridData data = new GridData(772);
        label.setLayoutData((Object)data);
        label.setFont(font);
        this.text = new Text(composite, 2052);
        this.text.setLayoutData((Object)new GridData(768));
        this.text.setFont(font);
        this.text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ResourceWorkingSetPage.this.validateInput();
            }
        });
        this.text.setFocus();
        label = new Label(composite, 64);
        label.setText(IDEWorkbenchMessages.getString("ResourceWorkingSetPage.label.tree"));
        data = new GridData(772);
        label.setLayoutData((Object)data);
        label.setFont(font);
        this.tree = new CheckboxTreeViewer(composite);
        this.tree.setUseHashlookup(true);
        this.tree.setContentProvider((IContentProvider)new WorkbenchContentProvider());
        this.tree.setLabelProvider((IBaseLabelProvider)new DecoratingLabelProvider((ILabelProvider)new WorkbenchLabelProvider(), IDEWorkbenchPlugin.getDefault().getWorkbench().getDecoratorManager().getLabelDecorator()));
        this.tree.setInput((Object)IDEWorkbenchPlugin.getPluginWorkspace().getRoot());
        this.tree.setSorter((ViewerSorter)new ResourceSorter(1));
        data = new GridData(1808);
        data.heightHint = 200;
        data.widthHint = 50;
        this.tree.getControl().setLayoutData((Object)data);
        this.tree.getControl().setFont(font);
        this.tree.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                ResourceWorkingSetPage.this.handleCheckStateChange(event);
            }
        });
        this.tree.addTreeListener(new ITreeViewerListener(){

            public void treeCollapsed(TreeExpansionEvent event) {
            }

            public void treeExpanded(TreeExpansionEvent event) {
                Object element = event.getElement();
                if (!ResourceWorkingSetPage.this.tree.getGrayed(element)) {
                    BusyIndicator.showWhile((Display)ResourceWorkingSetPage.this.getShell().getDisplay(), (Runnable)new Runnable(this, element){
                        final /* synthetic */ 3 this$1;
                        private final /* synthetic */ Object val$element;
                        {
                            this.this$1 = var1_1;
                            this.val$element = object;
                        }

                        public void run() {
                            ResourceWorkingSetPage.access$3(3.access$0(this.this$1), (IContainer)this.val$element, ResourceWorkingSetPage.access$2(3.access$0(this.this$1)).getChecked(this.val$element), false);
                        }
                    });
                }
            }

            static /* synthetic */ ResourceWorkingSetPage access$0(3 var0) {
                return var0.ResourceWorkingSetPage.this;
            }
        });
        this.initializeCheckedState();
        if (this.workingSet != null) {
            this.text.setText(this.workingSet.getName());
        }
        this.setPageComplete(false);
    }

    private void findCheckedResources(List checkedResources, IContainer container) {
        IResource[] resources = null;
        try {
            resources = container.members();
        }
        catch (CoreException ex) {
            this.handleCoreException(ex, this.getShell(), IDEWorkbenchMessages.getString("ResourceWorkingSetPage.error"), IDEWorkbenchMessages.getString("ResourceWorkingSetPage.error.updateCheckedState"));
        }
        int i = 0;
        while (i < resources.length) {
            if (this.tree.getGrayed((Object)resources[i])) {
                if (resources[i].isAccessible()) {
                    this.findCheckedResources(checkedResources, (IContainer)resources[i]);
                } else {
                    this.addWorkingSetElements(checkedResources, (IContainer)resources[i]);
                }
            } else if (this.tree.getChecked((Object)resources[i])) {
                checkedResources.add(resources[i]);
            }
            ++i;
        }
    }

    public void finish() {
        ArrayList resources = new ArrayList(10);
        this.findCheckedResources(resources, (IContainer)this.tree.getInput());
        if (this.workingSet == null) {
            IWorkingSetManager workingSetManager = PlatformUI.getWorkbench().getWorkingSetManager();
            this.workingSet = workingSetManager.createWorkingSet(this.getWorkingSetName(), resources.toArray(new IAdaptable[resources.size()]));
        } else {
            this.workingSet.setName(this.getWorkingSetName());
            this.workingSet.setElements(resources.toArray(new IAdaptable[resources.size()]));
        }
    }

    public IWorkingSet getSelection() {
        return this.workingSet;
    }

    private String getWorkingSetName() {
        return this.text.getText();
    }

    private void handleCheckStateChange(final CheckStateChangedEvent event) {
        BusyIndicator.showWhile((Display)this.getShell().getDisplay(), (Runnable)new Runnable(){

            public void run() {
                IResource resource = (IResource)event.getElement();
                boolean state = event.getChecked();
                ResourceWorkingSetPage.this.tree.setGrayed((Object)resource, false);
                if (resource instanceof IContainer) {
                    ResourceWorkingSetPage.this.setSubtreeChecked((IContainer)resource, state, true);
                }
                ResourceWorkingSetPage.this.updateParentState(resource);
                ResourceWorkingSetPage.this.validateInput();
            }
        });
    }

    private void handleCoreException(CoreException exception, Shell shell, String title, String message) {
        IStatus status = exception.getStatus();
        if (status != null) {
            ErrorDialog.openError((Shell)shell, (String)title, (String)message, (IStatus)status);
        } else {
            MessageDialog.openError((Shell)shell, (String)IDEWorkbenchMessages.getString("InternalError"), (String)exception.getLocalizedMessage());
        }
    }

    private void initializeCheckedState() {
        if (this.workingSet == null) {
            return;
        }
        BusyIndicator.showWhile((Display)this.getShell().getDisplay(), (Runnable)new Runnable(){

            public void run() {
                Object[] items = ResourceWorkingSetPage.this.workingSet.getElements();
                ResourceWorkingSetPage.this.tree.setCheckedElements(items);
                int i = 0;
                while (i < items.length) {
                    Object item = items[i];
                    IContainer container = null;
                    IResource resource = null;
                    if (item instanceof IContainer) {
                        container = (IContainer)item;
                    } else {
                        Class<?> clazz = class$1;
                        if (clazz == null) {
                            try {
                                clazz = Class.forName("org.eclipse.core.resources.IContainer");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        container = (IContainer)item.getAdapter((Class)clazz);
                    }
                    if (container != null) {
                        ResourceWorkingSetPage.this.setSubtreeChecked(container, true, true);
                    }
                    if (item instanceof IResource) {
                        resource = (IResource)item;
                    } else {
                        Class<?> clazz = class$0;
                        if (clazz == null) {
                            try {
                                clazz = Class.forName("org.eclipse.core.resources.IResource");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        resource = (IResource)item.getAdapter((Class)clazz);
                    }
                    if (resource != null && !resource.isAccessible()) {
                        IProject project = resource.getProject();
                        if (!ResourceWorkingSetPage.this.tree.getChecked((Object)project)) {
                            ResourceWorkingSetPage.this.tree.setGrayChecked((Object)project, true);
                        }
                    } else {
                        ResourceWorkingSetPage.this.updateParentState(resource);
                    }
                    ++i;
                }
            }
        });
    }

    public void setSelection(IWorkingSet workingSet) {
        if (workingSet == null) {
            throw new IllegalArgumentException("Working set must not be null");
        }
        this.workingSet = workingSet;
        if (this.getShell() != null && this.text != null) {
            this.firstCheck = true;
            this.initializeCheckedState();
            this.text.setText(workingSet.getName());
        }
    }

    private void setSubtreeChecked(IContainer container, boolean state, boolean checkExpandedState) {
        if (!container.isAccessible() || !this.tree.getExpandedState((Object)container) && state && checkExpandedState) {
            return;
        }
        IResource[] members = null;
        try {
            members = container.members();
        }
        catch (CoreException ex) {
            this.handleCoreException(ex, this.getShell(), IDEWorkbenchMessages.getString("ResourceWorkingSetPage.error"), IDEWorkbenchMessages.getString("ResourceWorkingSetPage.error.updateCheckedState"));
        }
        int i = members.length - 1;
        while (i >= 0) {
            boolean elementGrayChecked;
            IResource element = members[i];
            boolean bl = elementGrayChecked = this.tree.getGrayed((Object)element) || this.tree.getChecked((Object)element);
            if (state) {
                this.tree.setChecked((Object)element, true);
                this.tree.setGrayed((Object)element, false);
            } else {
                this.tree.setGrayChecked((Object)element, false);
            }
            if (element instanceof IContainer && (state || elementGrayChecked)) {
                this.setSubtreeChecked((IContainer)element, state, true);
            }
            --i;
        }
    }

    private void updateParentState(IResource child) {
        if (child == null || child.getParent() == null) {
            return;
        }
        IContainer parent = child.getParent();
        boolean childChecked = false;
        IResource[] members = null;
        try {
            members = parent.members();
        }
        catch (CoreException ex) {
            this.handleCoreException(ex, this.getShell(), IDEWorkbenchMessages.getString("ResourceWorkingSetPage.error"), IDEWorkbenchMessages.getString("ResourceWorkingSetPage.error.updateCheckedState"));
        }
        int i = members.length - 1;
        while (i >= 0) {
            if (this.tree.getChecked((Object)members[i]) || this.tree.getGrayed((Object)members[i])) {
                childChecked = true;
                break;
            }
            --i;
        }
        this.tree.setGrayChecked((Object)parent, childChecked);
        this.updateParentState((IResource)parent);
    }

    private void validateInput() {
        String errorMessage = null;
        String newText = this.text.getText();
        if (!newText.equals(newText.trim())) {
            errorMessage = IDEWorkbenchMessages.getString("ResourceWorkingSetPage.warning.nameWhitespace");
        } else if (this.firstCheck) {
            this.firstCheck = false;
            return;
        }
        if (newText.equals("")) {
            errorMessage = IDEWorkbenchMessages.getString("ResourceWorkingSetPage.warning.nameMustNotBeEmpty");
        }
        if (!(errorMessage != null || this.workingSet != null && newText.equals(this.workingSet.getName()))) {
            IWorkingSet[] workingSets = PlatformUI.getWorkbench().getWorkingSetManager().getWorkingSets();
            int i = 0;
            while (i < workingSets.length) {
                if (newText.equals(workingSets[i].getName())) {
                    errorMessage = IDEWorkbenchMessages.getString("ResourceWorkingSetPage.warning.workingSetExists");
                }
                ++i;
            }
        }
        if (errorMessage == null && this.tree.getCheckedElements().length == 0) {
            errorMessage = IDEWorkbenchMessages.getString("ResourceWorkingSetPage.warning.resourceMustBeChecked");
        }
        this.setErrorMessage(errorMessage);
        this.setPageComplete(errorMessage == null);
    }
}

