/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.wizards.datatransfer;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.internal.wizards.datatransfer.DataTransferMessages;
import org.eclipse.ui.internal.wizards.datatransfer.MinimizedFileSystemElement;
import org.eclipse.ui.internal.wizards.datatransfer.TarException;
import org.eclipse.ui.internal.wizards.datatransfer.TarFile;
import org.eclipse.ui.internal.wizards.datatransfer.TarFileStructureProvider;
import org.eclipse.ui.internal.wizards.datatransfer.WizardFileSystemResourceImportPage1;
import org.eclipse.ui.model.AdaptableList;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.wizards.datatransfer.ImportOperation;
import org.eclipse.ui.wizards.datatransfer.ZipFileStructureProvider;

public class WizardArchiveFileResourceImportPage1
extends WizardFileSystemResourceImportPage1
implements Listener {
    private ZipFileStructureProvider zipProviderCache;
    private TarFileStructureProvider tarProviderCache;
    ZipFileStructureProvider zipCurrentProvider;
    TarFileStructureProvider tarCurrentProvider;
    private static final String[] FILE_IMPORT_MASK = new String[]{"*.jar;*.zip;*.tar;*.tar.gz;*.tgz", "*.*"};
    private static final String STORE_SOURCE_NAMES_ID = "WizardZipFileResourceImportPage1.STORE_SOURCE_NAMES_ID";
    private static final String STORE_OVERWRITE_EXISTING_RESOURCES_ID = "WizardZipFileResourceImportPage1.STORE_OVERWRITE_EXISTING_RESOURCES_ID";
    private static final String STORE_SELECTED_TYPES_ID = "WizardZipFileResourceImportPage1.STORE_SELECTED_TYPES_ID";

    public WizardArchiveFileResourceImportPage1(IWorkbench aWorkbench, IStructuredSelection selection) {
        super("zipFileImportPage1", aWorkbench, selection);
        this.setTitle(DataTransferMessages.getString("ArchiveExport.exportTitle"));
        this.setDescription(DataTransferMessages.getString("ArchiveImport.description"));
    }

    public boolean cancel() {
        this.clearProviderCache();
        return true;
    }

    protected void clearProviderCache() {
        if (this.zipProviderCache != null) {
            this.closeZipFile(this.zipProviderCache.getZipFile());
            this.zipProviderCache = null;
        }
        this.tarProviderCache = null;
    }

    protected boolean closeZipFile(ZipFile file) {
        try {
            file.close();
        }
        catch (IOException iOException) {
            this.displayErrorDialog(DataTransferMessages.format("ZipImport.couldNotClose", new Object[]{file.getName()}));
            return false;
        }
        return true;
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        WorkbenchHelp.setHelp((Control)this.getControl(), (String)"org.eclipse.ui.zip_file_import_wizard_page");
    }

    protected void createOptionsGroup(Composite parent) {
        this.overwriteExistingResourcesCheckbox = new Button(parent, 32);
        this.overwriteExistingResourcesCheckbox.setText(DataTransferMessages.getString("FileImport.overwriteExisting"));
        this.overwriteExistingResourcesCheckbox.setFont(parent.getFont());
    }

    private boolean isTarFile(String fileName) {
        if (fileName.length() == 0) {
            return false;
        }
        try {
            new TarFile(fileName);
        }
        catch (TarException tarException) {
            return false;
        }
        catch (IOException iOException) {
            return false;
        }
        return true;
    }

    private boolean validateSourceFile(String fileName) {
        if (this.isTarFile(fileName)) {
            TarFile tarFile = this.getSpecifiedTarSourceFile(fileName);
            return tarFile != null;
        }
        ZipFile zipFile = this.getSpecifiedZipSourceFile(fileName);
        if (zipFile != null) {
            this.closeZipFile(zipFile);
            return true;
        }
        return false;
    }

    private boolean ensureZipSourceIsValid() {
        ZipFile specifiedFile = this.getSpecifiedZipSourceFile();
        if (specifiedFile == null) {
            return false;
        }
        return this.closeZipFile(specifiedFile);
    }

    private boolean ensureTarSourceIsValid() {
        TarFile specifiedFile = this.getSpecifiedTarSourceFile();
        return specifiedFile != null;
    }

    protected boolean ensureSourceIsValid() {
        if (this.isTarFile(this.sourceNameField.getText())) {
            return this.ensureTarSourceIsValid();
        }
        return this.ensureZipSourceIsValid();
    }

    public boolean finish() {
        if (!super.finish()) {
            return false;
        }
        this.clearProviderCache();
        return true;
    }

    protected ITreeContentProvider getFileProvider() {
        return new WorkbenchContentProvider(){

            public Object[] getChildren(Object o) {
                if (o instanceof MinimizedFileSystemElement) {
                    MinimizedFileSystemElement element = (MinimizedFileSystemElement)((Object)o);
                    AdaptableList l = WizardArchiveFileResourceImportPage1.this.zipCurrentProvider != null ? element.getFiles(WizardArchiveFileResourceImportPage1.this.zipCurrentProvider) : element.getFiles(WizardArchiveFileResourceImportPage1.this.tarCurrentProvider);
                    return l.getChildren((Object)element);
                }
                return new Object[0];
            }
        };
    }

    protected MinimizedFileSystemElement getFileSystemTree() {
        ZipFileStructureProvider provider;
        if (this.isTarFile(this.sourceNameField.getText())) {
            TarFileStructureProvider provider2;
            TarFile sourceTarFile = this.getSpecifiedTarSourceFile();
            if (sourceTarFile == null) {
                this.zipCurrentProvider = null;
                this.tarCurrentProvider = null;
                return null;
            }
            this.tarCurrentProvider = provider2 = this.getTarStructureProvider(sourceTarFile);
            this.zipCurrentProvider = null;
            return this.selectFiles(provider2.getRoot(), provider2);
        }
        ZipFile sourceFile = this.getSpecifiedZipSourceFile();
        if (sourceFile == null) {
            this.zipCurrentProvider = null;
            this.tarCurrentProvider = null;
            return null;
        }
        this.zipCurrentProvider = provider = this.getZipStructureProvider(sourceFile);
        this.tarCurrentProvider = null;
        return this.selectFiles(provider.getRoot(), provider);
    }

    protected ITreeContentProvider getFolderProvider() {
        return new WorkbenchContentProvider(){

            public Object[] getChildren(Object o) {
                if (o instanceof MinimizedFileSystemElement) {
                    MinimizedFileSystemElement element = (MinimizedFileSystemElement)((Object)o);
                    AdaptableList l = WizardArchiveFileResourceImportPage1.this.zipCurrentProvider != null ? element.getFolders(WizardArchiveFileResourceImportPage1.this.zipCurrentProvider) : element.getFolders(WizardArchiveFileResourceImportPage1.this.tarCurrentProvider);
                    return l.getChildren((Object)element);
                }
                return new Object[0];
            }

            public boolean hasChildren(Object o) {
                if (o instanceof MinimizedFileSystemElement) {
                    MinimizedFileSystemElement element = (MinimizedFileSystemElement)((Object)o);
                    if (element.isPopulated()) {
                        return this.getChildren((Object)element).length > 0;
                    }
                    return true;
                }
                return false;
            }
        };
    }

    protected String getSourceLabel() {
        return DataTransferMessages.getString("ArchiveImport.fromFile");
    }

    protected ZipFile getSpecifiedZipSourceFile() {
        return this.getSpecifiedZipSourceFile(this.sourceNameField.getText());
    }

    private ZipFile getSpecifiedZipSourceFile(String fileName) {
        if (fileName.length() == 0) {
            return null;
        }
        try {
            return new ZipFile(fileName);
        }
        catch (ZipException zipException) {
            this.displayErrorDialog(DataTransferMessages.getString("ZipImport.badFormat"));
        }
        catch (IOException iOException) {
            this.displayErrorDialog(DataTransferMessages.getString("ZipImport.couldNotRead"));
        }
        this.sourceNameField.setFocus();
        return null;
    }

    protected TarFile getSpecifiedTarSourceFile() {
        return this.getSpecifiedTarSourceFile(this.sourceNameField.getText());
    }

    private TarFile getSpecifiedTarSourceFile(String fileName) {
        if (fileName.length() == 0) {
            return null;
        }
        try {
            return new TarFile(fileName);
        }
        catch (TarException tarException) {
            this.displayErrorDialog(DataTransferMessages.getString("TarImport.badFormat"));
        }
        catch (IOException iOException) {
            this.displayErrorDialog(DataTransferMessages.getString("ZipImport.couldNotRead"));
        }
        this.sourceNameField.setFocus();
        return null;
    }

    protected ZipFileStructureProvider getZipStructureProvider(ZipFile targetZip) {
        if (this.zipProviderCache == null) {
            this.zipProviderCache = new ZipFileStructureProvider(targetZip);
        } else if (!this.zipProviderCache.getZipFile().getName().equals(targetZip.getName())) {
            this.clearProviderCache();
            this.zipProviderCache = new ZipFileStructureProvider(targetZip);
        } else if (!this.zipProviderCache.getZipFile().equals(targetZip)) {
            this.closeZipFile(targetZip);
        }
        return this.zipProviderCache;
    }

    protected TarFileStructureProvider getTarStructureProvider(TarFile targetTar) {
        if (this.tarProviderCache == null) {
            this.tarProviderCache = new TarFileStructureProvider(targetTar);
        } else if (!this.tarProviderCache.getTarFile().getName().equals(targetTar.getName())) {
            this.clearProviderCache();
            this.tarProviderCache = new TarFileStructureProvider(targetTar);
        }
        return this.tarProviderCache;
    }

    protected void handleSourceBrowseButtonPressed() {
        String selectedFile = this.queryZipFileToImport();
        if (selectedFile != null && !selectedFile.equals(this.sourceNameField.getText()) && this.validateSourceFile(selectedFile)) {
            this.setSourceName(selectedFile);
            this.selectionGroup.setFocus();
        }
    }

    protected boolean importResources(List fileSystemObjects) {
        boolean result = false;
        if (this.isTarFile(this.sourceNameField.getText()) && this.ensureTarSourceIsValid()) {
            TarFile tarFile = this.getSpecifiedTarSourceFile();
            TarFileStructureProvider structureProvider = this.getTarStructureProvider(tarFile);
            ImportOperation operation = new ImportOperation(this.getContainerFullPath(), structureProvider.getRoot(), structureProvider, this, fileSystemObjects);
            operation.setContext(this.getShell());
            return this.executeImportOperation(operation);
        }
        if (this.ensureZipSourceIsValid()) {
            ZipFile zipFile = this.getSpecifiedZipSourceFile();
            ZipFileStructureProvider structureProvider = this.getZipStructureProvider(zipFile);
            ImportOperation operation = new ImportOperation(this.getContainerFullPath(), structureProvider.getRoot(), structureProvider, this, fileSystemObjects);
            operation.setContext(this.getShell());
            result = this.executeImportOperation(operation);
            this.closeZipFile(zipFile);
        }
        return result;
    }

    protected void initializeOperation(ImportOperation op) {
        op.setOverwriteResources(this.overwriteExistingResourcesCheckbox.getSelection());
    }

    protected String queryZipFileToImport() {
        FileDialog dialog = new FileDialog(this.sourceNameField.getShell(), 4096);
        dialog.setFilterExtensions(FILE_IMPORT_MASK);
        dialog.setText(DataTransferMessages.getString("ArchiveImportSource.title"));
        String currentSourceString = this.sourceNameField.getText();
        int lastSeparatorIndex = currentSourceString.lastIndexOf(File.separator);
        if (lastSeparatorIndex != -1) {
            dialog.setFilterPath(currentSourceString.substring(0, lastSeparatorIndex));
        }
        return dialog.open();
    }

    protected void resetSelection() {
        super.resetSelection();
        this.setAllSelections(true);
    }

    protected void restoreWidgetValues() {
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null) {
            String[] sourceNames = settings.getArray(STORE_SOURCE_NAMES_ID);
            if (sourceNames == null) {
                return;
            }
            int i = 0;
            while (i < sourceNames.length) {
                this.sourceNameField.add(sourceNames[i]);
                ++i;
            }
            this.overwriteExistingResourcesCheckbox.setSelection(settings.getBoolean(STORE_OVERWRITE_EXISTING_RESOURCES_ID));
        }
    }

    protected void saveWidgetValues() {
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null) {
            String[] sourceNames = settings.getArray(STORE_SOURCE_NAMES_ID);
            if (sourceNames == null) {
                sourceNames = new String[]{};
            }
            sourceNames = this.addToHistory(sourceNames, this.sourceNameField.getText());
            settings.put(STORE_SOURCE_NAMES_ID, sourceNames);
            String[] selectedTypesNames = settings.getArray(STORE_SELECTED_TYPES_ID);
            if (selectedTypesNames == null) {
                selectedTypesNames = new String[]{};
            }
            settings.put(STORE_OVERWRITE_EXISTING_RESOURCES_ID, this.overwriteExistingResourcesCheckbox.getSelection());
        }
    }

    protected boolean validateSourceGroup() {
        if (this.zipCurrentProvider == null && this.tarCurrentProvider == null) {
            this.setMessage(WizardFileSystemResourceImportPage1.SOURCE_EMPTY_MESSAGE);
            this.enableButtonGroup(false);
            return false;
        }
        this.enableButtonGroup(true);
        return true;
    }
}

