/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.wizards.datatransfer;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.internal.wizards.datatransfer.DataTransferMessages;

public class WizardProjectsImportPage
extends WizardPage {
    private Text locationPathField;
    private CheckboxTreeViewer projectsList;
    private ProjectRecord[] selectedProjects = new ProjectRecord[0];
    private static String previouslyBrowsedDirectory = "";

    public WizardProjectsImportPage() {
        this("wizardExternalProjectsPage");
    }

    public WizardProjectsImportPage(String pageName) {
        super(pageName);
        this.setPageComplete(false);
        this.setTitle(DataTransferMessages.getString("WizardProjectsImportPage.ImportProjectsTitle"));
        this.setDescription(DataTransferMessages.getString("WizardProjectsImportPage.ImportProjectsDescription"));
    }

    public WizardProjectsImportPage(String pageName, String title, ImageDescriptor titleImage) {
        super(pageName, title, titleImage);
    }

    public void createControl(Composite parent) {
        Composite workArea = new Composite(parent, 0);
        this.setControl((Control)workArea);
        workArea.setLayout((Layout)new GridLayout());
        workArea.setLayoutData((Object)new GridData(1808));
        this.createProjectsRoot(workArea);
        this.createProjectsList(workArea);
        Dialog.applyDialogFont((Control)workArea);
    }

    private void createProjectsList(Composite workArea) {
        Label title = new Label(workArea, 0);
        title.setText(DataTransferMessages.getString("WizardProjectsImportPage.ProjectsListTitle"));
        Composite listComposite = new Composite(workArea, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 0;
        layout.makeColumnsEqualWidth = false;
        listComposite.setLayout((Layout)layout);
        listComposite.setLayoutData((Object)new GridData(1808));
        this.projectsList = new CheckboxTreeViewer(listComposite, 2048);
        GridData listData = new GridData(1808);
        this.projectsList.getControl().setLayoutData((Object)listData);
        this.projectsList.setContentProvider((IContentProvider)new ITreeContentProvider(){

            public Object[] getChildren(Object parentElement) {
                return null;
            }

            public Object[] getElements(Object inputElement) {
                return WizardProjectsImportPage.this.selectedProjects;
            }

            public boolean hasChildren(Object element) {
                return false;
            }

            public Object getParent(Object element) {
                return null;
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this.projectsList.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return ((ProjectRecord)element).getProjectName();
            }
        });
        this.projectsList.setInput((Object)this);
        this.createSelectionButtons(listComposite);
    }

    private void createSelectionButtons(Composite listComposite) {
        Composite buttonsComposite = new Composite(listComposite, 0);
        buttonsComposite.setLayout((Layout)new GridLayout());
        buttonsComposite.setLayoutData((Object)new GridData(2));
        Button selectAll = new Button(buttonsComposite, 8);
        selectAll.setText(DataTransferMessages.getString("DataTransfer.selectAll"));
        selectAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WizardProjectsImportPage.this.projectsList.setCheckedElements((Object[])WizardProjectsImportPage.this.selectedProjects);
            }
        });
        this.setButtonLayoutData(selectAll);
        Button deselectAll = new Button(buttonsComposite, 8);
        deselectAll.setText(DataTransferMessages.getString("DataTransfer.deselectAll"));
        deselectAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WizardProjectsImportPage.this.projectsList.setCheckedElements(new Object[0]);
            }
        });
        this.setButtonLayoutData(deselectAll);
    }

    private void createProjectsRoot(Composite workArea) {
        Composite projectGroup = new Composite(workArea, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.makeColumnsEqualWidth = false;
        layout.marginWidth = 0;
        projectGroup.setLayout((Layout)layout);
        projectGroup.setLayoutData((Object)new GridData(768));
        Label projectContentsLabel = new Label(projectGroup, 0);
        projectContentsLabel.setText(DataTransferMessages.getString("WizardProjectsImportPage.RootSelectTitle"));
        this.locationPathField = new Text(projectGroup, 2048);
        this.locationPathField.setLayoutData((Object)new GridData(768));
        Button browseButton = new Button(projectGroup, 8);
        browseButton.setText(DataTransferMessages.getString("DataTransfer.browse"));
        this.setButtonLayoutData(browseButton);
        browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WizardProjectsImportPage.this.handleLocationBrowseButtonPressed();
            }
        });
        this.locationPathField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                WizardProjectsImportPage.this.updateProjectsList(WizardProjectsImportPage.this.locationPathField.getText().trim());
            }
        });
    }

    protected void updateProjectsList(final String path) {
        try {
            this.getContainer().run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) {
                    monitor.beginTask(DataTransferMessages.getString("WizardProjectsImportPage.SearchingMessage"), 100);
                    File directory = new File(path);
                    WizardProjectsImportPage.this.selectedProjects = new ProjectRecord[0];
                    monitor.worked(10);
                    if (directory.isDirectory()) {
                        ArrayList files = new ArrayList();
                        if (!WizardProjectsImportPage.this.collectProjectFiles(files, directory, monitor)) {
                            return;
                        }
                        Iterator filesIterator = files.iterator();
                        WizardProjectsImportPage.this.selectedProjects = new ProjectRecord[files.size()];
                        int index = 0;
                        monitor.worked(50);
                        monitor.subTask(DataTransferMessages.getString("WizardProjectsImportPage.ProcessingMessage"));
                        while (filesIterator.hasNext()) {
                            File file = (File)filesIterator.next();
                            ((WizardProjectsImportPage)WizardProjectsImportPage.this).selectedProjects[index] = new ProjectRecord(file);
                            ++index;
                        }
                    } else {
                        monitor.worked(60);
                    }
                    monitor.done();
                }
            });
        }
        catch (InvocationTargetException e) {
            IDEWorkbenchPlugin.log(e.getMessage(), e);
        }
        catch (InterruptedException interruptedException) {}
        this.projectsList.refresh(true);
        this.projectsList.setCheckedElements((Object[])this.selectedProjects);
        this.setPageComplete(this.selectedProjects.length > 0);
    }

    private boolean collectProjectFiles(Collection files, File directory, IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            return false;
        }
        monitor.subTask(DataTransferMessages.format("WizardProjectsImportPage.CheckingMessage", new Object[]{directory.getPath()}));
        File[] contents = directory.listFiles();
        int i = 0;
        while (i < contents.length) {
            File file = contents[i];
            if (file.isDirectory()) {
                this.collectProjectFiles(files, file, monitor);
            } else if (file.getName().equals(".project")) {
                files.add(file);
            }
            ++i;
        }
        return true;
    }

    protected void handleLocationBrowseButtonPressed() {
        DirectoryDialog dialog = new DirectoryDialog(this.locationPathField.getShell());
        dialog.setMessage(DataTransferMessages.getString("WizardProjectsImportPage.SelectDialogTitle"));
        String dirName = this.locationPathField.getText().trim();
        if (dirName.length() == 0) {
            dirName = previouslyBrowsedDirectory;
        }
        if (dirName.length() == 0) {
            dialog.setFilterPath(IDEWorkbenchPlugin.getPluginWorkspace().getRoot().getLocation().toOSString());
        } else {
            File path = new File(dirName);
            if (path.exists()) {
                dialog.setFilterPath(new Path(dirName).toOSString());
            }
        }
        String selectedDirectory = dialog.open();
        if (selectedDirectory != null) {
            previouslyBrowsedDirectory = selectedDirectory;
            this.locationPathField.setText(previouslyBrowsedDirectory);
        }
    }

    public boolean createProjects() {
        Object[] selected = this.projectsList.getCheckedElements();
        int i = 0;
        while (i < selected.length) {
            ProjectRecord record = (ProjectRecord)selected[i];
            if (!this.createExistingProject(record)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean createExistingProject(final ProjectRecord record) {
        String projectName = record.getProjectName();
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        final IProject project = workspace.getRoot().getProject(projectName);
        if (record.description == null) {
            record.description = workspace.newProjectDescription(projectName);
            Path locationPath = new Path(record.projectFile.getAbsolutePath());
            if (Platform.getLocation().isPrefixOf((IPath)locationPath)) {
                record.description.setLocation(null);
            } else {
                record.description.setLocation((IPath)locationPath);
            }
        } else {
            record.description.setName(projectName);
        }
        WorkspaceModifyOperation op = new WorkspaceModifyOperation(){

            protected void execute(IProgressMonitor monitor) throws CoreException {
                monitor.beginTask("", 2000);
                project.create(record.description, (IProgressMonitor)new SubProgressMonitor(monitor, 1000));
                if (monitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
                project.open(128, (IProgressMonitor)new SubProgressMonitor(monitor, 1000));
            }
        };
        try {
            this.getContainer().run(true, true, (IRunnableWithProgress)op);
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            if (t instanceof CoreException) {
                if (((CoreException)t).getStatus().getCode() == 275) {
                    MessageDialog.openError((Shell)this.getShell(), (String)"", (String)"");
                } else {
                    ErrorDialog.openError((Shell)this.getShell(), (String)"", null, (IStatus)((CoreException)t).getStatus());
                }
            }
            return false;
        }
        return true;
    }

    private class ProjectRecord {
        File projectFile;
        String projectName;
        IProjectDescription description;

        ProjectRecord(File file) {
            this.projectFile = file;
            this.setProjectName();
        }

        private void setProjectName() {
            Path path = new Path(this.projectFile.getPath());
            IProjectDescription newDescription = null;
            try {
                newDescription = IDEWorkbenchPlugin.getPluginWorkspace().loadProjectDescription((IPath)path);
            }
            catch (CoreException coreException) {}
            if (newDescription == null) {
                this.description = null;
                this.projectName = "";
            } else {
                this.description = newDescription;
                this.projectName = this.description.getName();
            }
        }

        public String getProjectName() {
            return this.projectName;
        }
    }
}

