/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.sanger.jcon.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.ResourceBundle;
import javax.sql.DataSource;
import uk.ac.sanger.jcon.JobControlException;
import uk.ac.sanger.jcon.dao.ExecutableDAO;
import uk.ac.sanger.jcon.dao.SQLDAOBaseImpl;
import uk.ac.sanger.jcon.job.Executable;
import uk.ac.sanger.jcon.job.ExecutableDefaultImpl;

public class ExecutableSQLDAO
extends SQLDAOBaseImpl
implements ExecutableDAO {
    static ResourceBundle sqlStatements = ResourceBundle.getBundle((class$uk$ac$sanger$jcon$dao$ExecutableSQLDAO == null ? (class$uk$ac$sanger$jcon$dao$ExecutableSQLDAO = ExecutableSQLDAO.class$("uk.ac.sanger.jcon.dao.ExecutableSQLDAO")) : class$uk$ac$sanger$jcon$dao$ExecutableSQLDAO).getName());
    private HashMap canonical = new HashMap(50);
    static /* synthetic */ Class class$uk$ac$sanger$jcon$dao$ExecutableSQLDAO;

    public ExecutableSQLDAO() {
    }

    public ExecutableSQLDAO(DataSource datasource) {
        super(datasource);
    }

    public synchronized void createExecutable(Executable executable) throws Exception {
        String sql = sqlStatements.getString("createExecutable");
        Connection c = this.getManagedConnection();
        PreparedStatement ps = null;
        boolean rollback = false;
        try {
            int newId = this.createNewExecutableId();
            this.setObjectIntField(executable, "id", newId);
            SQLDAOBaseImpl.cat.debug((Object)("Preparing SQL: " + sql));
            ps = c.prepareStatement(sql);
            ps.setInt(1, executable.getId());
            ps.setString(2, executable.getName());
            String version = executable.getVersion();
            if (version != null) {
                ps.setString(3, version);
            } else {
                ps.setNull(3, 12);
            }
            ps.setString(4, executable.getDescription());
            SQLDAOBaseImpl.cat.debug((Object)("Executing SQL: " + ps));
            ps.executeUpdate();
        }
        catch (Exception e) {
            try {
                SQLDAOBaseImpl.cat.error((Object)"Caught an Exception; rolling back transaction", (Throwable)e);
                rollback = true;
                throw e;
            }
            catch (Throwable throwable) {
                this.cSupport.close(ps);
                if (rollback) {
                    this.cSupport.rollback(c);
                } else {
                    this.cSupport.commit(c);
                }
                if (this.isManagingConnections()) {
                    this.cSupport.close(c);
                }
                throw throwable;
            }
        }
        this.cSupport.close((Statement)ps);
        if (rollback) {
            this.cSupport.rollback(c);
        } else {
            this.cSupport.commit(c);
        }
        if (this.isManagingConnections()) {
            this.cSupport.close(c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Collection readAllExecutables() throws SQLException {
        String sql = sqlStatements.getString("readAllExecutables");
        Connection c = this.getManagedConnection();
        Statement s = null;
        ResultSet r = null;
        ArrayList<Executable> executables = new ArrayList<Executable>();
        try {
            SQLDAOBaseImpl.cat.debug((Object)("Preparing SQL: " + sql));
            s = c.createStatement();
            SQLDAOBaseImpl.cat.debug((Object)("Executing SQL: " + s));
            r = s.executeQuery(sql);
            while (r.next()) {
                executables.add(this.populateExecutable(r));
            }
        }
        catch (Throwable throwable) {
            this.cSupport.close(r);
            this.cSupport.close(s);
            if (this.isManagingConnections()) {
                this.cSupport.close(c);
            }
            throw throwable;
        }
        this.cSupport.close(r);
        this.cSupport.close(s);
        if (this.isManagingConnections()) {
            this.cSupport.close(c);
        }
        return executables;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Executable readExecutableById(int execId) throws SQLException, JobControlException {
        Integer canonKey = new Integer(execId);
        if (this.canonical.containsKey(canonKey)) {
            SQLDAOBaseImpl.cat.debug((Object)("Fetching canonical Executable [" + canonKey + "] from cache"));
            return (Executable)this.canonical.get(canonKey);
        }
        String sql = sqlStatements.getString("readExecutableById");
        Connection c = this.getManagedConnection();
        PreparedStatement ps = null;
        ResultSet r = null;
        Executable executable = null;
        try {
            SQLDAOBaseImpl.cat.debug((Object)("Preparing SQL: " + sql));
            ps = c.prepareStatement(sql);
            ps.setInt(1, execId);
            SQLDAOBaseImpl.cat.debug((Object)("Executing SQL: " + ps));
            r = ps.executeQuery();
            if (!r.next()) {
                throw new JobControlException("Requested a non-existent Executable with ID '" + execId + "'");
            }
            executable = this.populateExecutable(r);
            this.canonical.put(canonKey, executable);
        }
        catch (Throwable throwable) {
            this.cSupport.close(r);
            this.cSupport.close(ps);
            if (this.isManagingConnections()) {
                this.cSupport.close(c);
            }
            throw throwable;
        }
        this.cSupport.close(r);
        this.cSupport.close((Statement)ps);
        if (this.isManagingConnections()) {
            this.cSupport.close(c);
        }
        return executable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Collection readExecutablesByName(String name) throws SQLException {
        String sql = sqlStatements.getString("readExecutablesByName");
        Connection c = this.getManagedConnection();
        PreparedStatement ps = null;
        ResultSet r = null;
        ArrayList<Executable> executables = new ArrayList<Executable>();
        try {
            SQLDAOBaseImpl.cat.debug((Object)("Preparing SQL: " + sql));
            ps = c.prepareStatement(sql);
            ps.setString(1, name);
            SQLDAOBaseImpl.cat.debug((Object)("Executing SQL: " + ps));
            r = ps.executeQuery();
            while (r.next()) {
                executables.add(this.populateExecutable(r));
            }
        }
        catch (Throwable throwable) {
            this.cSupport.close(r);
            this.cSupport.close(ps);
            if (this.isManagingConnections()) {
                this.cSupport.close(c);
            }
            throw throwable;
        }
        this.cSupport.close(r);
        this.cSupport.close((Statement)ps);
        if (this.isManagingConnections()) {
            this.cSupport.close(c);
        }
        return executables;
    }

    public synchronized void deleteExecutable(Executable executable) throws SQLException {
        String sql = sqlStatements.getString("deleteExecutable");
        Connection c = this.getManagedConnection();
        PreparedStatement ps = null;
        boolean rollback = false;
        int execId = executable.getId();
        try {
            SQLDAOBaseImpl.cat.debug((Object)("Preparing SQL: " + sql));
            ps = c.prepareStatement(sql);
            ps.setInt(1, execId);
            SQLDAOBaseImpl.cat.debug((Object)("Executing SQL: " + ps));
            ps.executeUpdate();
        }
        catch (SQLException se) {
            try {
                SQLDAOBaseImpl.cat.error((Object)"Caught an Exception; rolling back transaction", (Throwable)se);
                rollback = true;
                throw se;
            }
            catch (Throwable throwable) {
                this.cSupport.close(ps);
                if (rollback) {
                    this.cSupport.rollback(c);
                } else {
                    this.cSupport.commit(c);
                    this.canonical.remove(new Integer(execId));
                }
                if (this.isManagingConnections()) {
                    this.cSupport.close(c);
                }
                throw throwable;
            }
        }
        this.cSupport.close((Statement)ps);
        if (rollback) {
            this.cSupport.rollback(c);
        } else {
            this.cSupport.commit(c);
            this.canonical.remove(new Integer(execId));
        }
        if (this.isManagingConnections()) {
            this.cSupport.close(c);
        }
    }

    private Executable populateExecutable(ResultSet r) throws SQLException {
        ExecutableDefaultImpl executable = new ExecutableDefaultImpl(r.getString("name"), r.getString("version"), r.getString("description"));
        this.setObjectIntField(executable, "id", r.getInt("exec_id"));
        return executable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int createNewExecutableId() throws Exception {
        String sql = sqlStatements.getString("createNewExecutableId");
        Connection c = this.getConnection();
        Statement s = null;
        ResultSet r = null;
        int id = 0;
        try {
            SQLDAOBaseImpl.cat.debug((Object)("Preparing SQL: " + sql));
            s = c.createStatement();
            SQLDAOBaseImpl.cat.debug((Object)("Executing SQL: " + s));
            r = s.executeQuery(sql);
            if (!r.next()) {
                throw new Exception("Failed to retrieve a new Executable ID");
            }
            id = r.getInt("exec_id");
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.cSupport.close(r);
            this.cSupport.close(s);
            throw throwable;
        }
        this.cSupport.close(r);
        this.cSupport.close(s);
        return id;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

