/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.sanger.jcon.protocol;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.util.List;
import java.util.Map;
import java.util.PropertyResourceBundle;
import org.apache.log4j.Category;
import uk.ac.sanger.jcon.JobControlException;
import uk.ac.sanger.jcon.dao.ExecutableDAO;
import uk.ac.sanger.jcon.dao.StatusDAO;
import uk.ac.sanger.jcon.job.Executable;
import uk.ac.sanger.jcon.job.Job;
import uk.ac.sanger.jcon.job.JobBatchImpl;
import uk.ac.sanger.jcon.job.Owner;
import uk.ac.sanger.jcon.job.Status;
import uk.ac.sanger.jcon.job.TaskDefaultImpl;
import uk.ac.sanger.jcon.protocol.AbstractProtocol;
import uk.ac.sanger.jcon.util.UserConfiguration;

public class ProtocolUserImpl
extends AbstractProtocol {
    public static final String INPUT_SUFFIX = "in";
    public static final String OUTPUT_SUFFIX = "out";
    public static final String ERROR_SUFFIX = "err";
    public static final String LOG_SUFFIX = "log";
    static Category cat = Category.getInstance((String)(class$uk$ac$sanger$jcon$protocol$ProtocolUserImpl == null ? (class$uk$ac$sanger$jcon$protocol$ProtocolUserImpl = ProtocolUserImpl.class$("uk.ac.sanger.jcon.protocol.ProtocolUserImpl")) : class$uk$ac$sanger$jcon$protocol$ProtocolUserImpl).getName());
    private ExecutableDAO execDAO;
    private StatusDAO statusDAO;
    static /* synthetic */ Class class$uk$ac$sanger$jcon$protocol$ProtocolUserImpl;

    public ProtocolUserImpl() throws Exception {
        this.execDAO = this.jobControl.createExecutableDAO();
        this.statusDAO = this.jobControl.createStatusDAO();
    }

    public void apply(String ownerName, Map config, String[] data) throws Exception {
        if (ownerName == null) {
            throw new IllegalArgumentException("ownerName was null");
        }
        Owner owner = this.admin.getOwnerByUserName(ownerName);
        if (!config.containsKey("config")) {
            throw new IllegalArgumentException("Config map did not contain the mandatory key 'config'");
        }
        String configFileName = (String)config.get("config");
        File configFile = new File(configFileName);
        if (!configFile.exists() || !configFile.canRead()) {
            throw new JobControlException("Configuration file '" + configFile.getAbsolutePath() + "' is missing or unreadable");
        }
        if (!config.containsKey("queue")) {
            throw new IllegalArgumentException("Config map did not contain the mandatory key 'queue'");
        }
        String queueName = (String)config.get("queue");
        PropertyResourceBundle bundle = new PropertyResourceBundle(new FileInputStream(configFile));
        UserConfiguration taskConfig = new UserConfiguration(bundle);
        int i = 0;
        while (i < data.length) {
            try {
                this.applySingle(owner, taskConfig, queueName, data[i]);
            }
            catch (Exception e) {
                System.err.println("Exception while processing '" + data[i] + "'. Skipping this element");
                e.printStackTrace();
            }
            ++i;
        }
    }

    private void applySingle(Owner owner, UserConfiguration taskConfig, String queueName, String fileName) throws Exception {
        String taskName = taskConfig.getProtocolName();
        String taskDesc = taskConfig.getProtocolDescription();
        List prededence = taskConfig.getJobPrecedenceList();
        if (prededence.isEmpty()) {
            throw new JobControlException("No jobs were defined");
        }
        BufferedReader br = new BufferedReader(new FileReader(fileName));
        String workDirectory = System.getProperty("user.dir");
        Status waiting = this.statusDAO.readStatusById(1);
        Job[] jobs = new Job[prededence.size()];
        String prevOutputName = null;
        int i = 0;
        while (i < prededence.size()) {
            int jobDefIndex = (Integer)prededence.get(i);
            int execId = taskConfig.getExecutableId(jobDefIndex);
            int maxRetry = taskConfig.getMaxRetryCount(jobDefIndex);
            String template = taskConfig.getTemplate(jobDefIndex);
            Executable exec = this.execDAO.readExecutableById(execId);
            JobBatchImpl job = new JobBatchImpl(exec);
            job.setStatus(waiting);
            job.setQueue(queueName);
            job.setMaxRetryCount(maxRetry);
            job.setWorkDirectoryName(workDirectory);
            String baseName = this.createBaseName(owner.getUserName(), taskName, jobDefIndex);
            job.setOutputName(this.createName(baseName, LOG_SUFFIX));
            if (i == 0) {
                job.setInputName(fileName);
            } else {
                job.setInputName(prevOutputName);
                job.add(jobs[i - 1]);
            }
            prevOutputName = this.createName(baseName, OUTPUT_SUFFIX);
            jobs[i] = job;
            job.setCommandTemplate(this.createRedirectTemplate(template, this.createName(baseName, OUTPUT_SUFFIX)));
            ++i;
        }
        Job rootJob = jobs[jobs.length - 1];
        TaskDefaultImpl task = new TaskDefaultImpl(taskName, taskDesc, owner);
        task.setJobs(new Job[]{rootJob});
        int taskId = this.manager.createTask(task);
        this.manager.submitTask(taskId);
    }

    private String createBaseName(String ownerName, String taskName, int jobDefIndex) {
        StringBuffer sb = new StringBuffer(ownerName);
        sb.append(".");
        sb.append(taskName);
        sb.append(".");
        sb.append("job.");
        sb.append(jobDefIndex);
        return sb.substring(0);
    }

    private String createName(String baseName, String suffix) {
        StringBuffer sb = new StringBuffer(baseName);
        sb.append(".");
        sb.append(suffix);
        return sb.substring(0);
    }

    private String createRedirectTemplate(String template, String redirectName) {
        StringBuffer sb = new StringBuffer(template);
        sb.append(" > ");
        sb.append(redirectName);
        return sb.substring(0);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

