/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Region;
import org.eclipse.swt.internal.Compatibility;
import org.eclipse.swt.internal.win32.BITMAP;
import org.eclipse.swt.internal.win32.BITMAPINFOHEADER;
import org.eclipse.swt.internal.win32.EXTLOGPEN;
import org.eclipse.swt.internal.win32.GRADIENT_RECT;
import org.eclipse.swt.internal.win32.ICONINFO;
import org.eclipse.swt.internal.win32.LOGBRUSH;
import org.eclipse.swt.internal.win32.LOGPEN;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.POINT;
import org.eclipse.swt.internal.win32.RECT;
import org.eclipse.swt.internal.win32.SIZE;
import org.eclipse.swt.internal.win32.TCHAR;
import org.eclipse.swt.internal.win32.TEXTMETRIC;
import org.eclipse.swt.internal.win32.TEXTMETRICA;
import org.eclipse.swt.internal.win32.TEXTMETRICW;
import org.eclipse.swt.internal.win32.TRIVERTEX;

public final class GC {
    public int handle;
    Drawable drawable;
    GCData data;

    GC() {
    }

    public GC(Drawable drawable) {
        this(drawable, 0);
    }

    public GC(Drawable drawable, int style) {
        if (drawable == null) {
            SWT.error(4);
        }
        GCData data = new GCData();
        data.style = GC.checkStyle(style);
        int hDC = drawable.internal_new_GC(data);
        Device device = data.device;
        if (device == null) {
            device = Device.getDevice();
        }
        if (device == null) {
            SWT.error(4);
        }
        data.device = device;
        this.init(drawable, data, hDC);
        if (device.tracking) {
            device.new_Object(this);
        }
    }

    static int checkStyle(int style) {
        if ((style & 0x2000000) != 0) {
            style &= 0xFBFFFFFF;
        }
        return style & 0x6000000;
    }

    public void copyArea(Image image, int x, int y) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (image == null) {
            SWT.error(4);
        }
        if (image.type != 0 || image.isDisposed()) {
            SWT.error(5);
        }
        Device device = this.data.device;
        int hDC = device.internal_new_GC(null);
        Rectangle rect = image.getBounds();
        int memHdc = OS.CreateCompatibleDC(hDC);
        int hOldBitmap = OS.SelectObject(memHdc, image.handle);
        OS.BitBlt(memHdc, 0, 0, rect.width, rect.height, this.handle, x, y, 0xCC0020);
        OS.SelectObject(memHdc, hOldBitmap);
        OS.DeleteDC(memHdc);
        device.internal_dispose_GC(hDC, null);
    }

    public void copyArea(int srcX, int srcY, int width, int height, int destX, int destY) {
        int hwnd;
        if (this.handle == 0) {
            SWT.error(44);
        }
        if ((hwnd = this.data.hwnd) == 0) {
            OS.BitBlt(this.handle, destX, destY, width, height, this.handle, srcX, srcY, 0xCC0020);
        } else {
            RECT lprcClip = null;
            int hrgn = OS.CreateRectRgn(0, 0, 0, 0);
            if (OS.GetClipRgn(this.handle, hrgn) == 1) {
                lprcClip = new RECT();
                OS.GetRgnBox(hrgn, lprcClip);
            }
            OS.DeleteObject(hrgn);
            RECT lprcScroll = new RECT();
            OS.SetRect(lprcScroll, srcX, srcY, srcX + width, srcY + height);
            int res = OS.ScrollWindowEx(hwnd, destX - srcX, destY - srcY, lprcScroll, lprcClip, 0, null, 6);
            if (res == 0 && OS.IsWinCE) {
                boolean disjoint;
                OS.BitBlt(this.handle, destX, destY, width, height, this.handle, srcX, srcY, 0xCC0020);
                int deltaX = destX - srcX;
                int deltaY = destY - srcY;
                boolean bl = disjoint = destX + width < srcX || srcX + width < destX || destY + height < srcY || srcY + height < destY;
                if (disjoint) {
                    OS.InvalidateRect(hwnd, lprcScroll, true);
                } else {
                    if (deltaX != 0) {
                        int newX = destX - deltaX;
                        if (deltaX < 0) {
                            newX = destX + width;
                        }
                        OS.SetRect(lprcScroll, newX, srcY, newX + Math.abs(deltaX), srcY + height);
                        OS.InvalidateRect(hwnd, lprcScroll, true);
                    }
                    if (deltaY != 0) {
                        int newY = destY - deltaY;
                        if (deltaY < 0) {
                            newY = destY + height;
                        }
                        OS.SetRect(lprcScroll, srcX, newY, srcX + width, newY + Math.abs(deltaY));
                        OS.InvalidateRect(hwnd, lprcScroll, true);
                    }
                }
            }
        }
    }

    int createDIB(int width, int height) {
        int[] pBits;
        int hDib;
        int depth = 32;
        BITMAPINFOHEADER bmiHeader = new BITMAPINFOHEADER();
        bmiHeader.biSize = 40;
        bmiHeader.biWidth = width;
        bmiHeader.biHeight = -height;
        bmiHeader.biPlanes = 1;
        bmiHeader.biBitCount = (short)depth;
        bmiHeader.biCompression = OS.IsWinCE ? 3 : 0;
        byte[] bmi = new byte[40 + (OS.IsWinCE ? 12 : 0)];
        OS.MoveMemory(bmi, bmiHeader, 40);
        if (OS.IsWinCE) {
            int redMask = 65280;
            int greenMask = 0xFF0000;
            int blueMask = -16777216;
            int offset = 40;
            bmi[offset] = (byte)((redMask & 0xFF000000) >> 24);
            bmi[offset + 1] = (byte)((redMask & 0xFF0000) >> 16);
            bmi[offset + 2] = (byte)((redMask & 0xFF00) >> 8);
            bmi[offset + 3] = (byte)((redMask & 0xFF) >> 0);
            bmi[offset + 4] = (byte)((greenMask & 0xFF000000) >> 24);
            bmi[offset + 5] = (byte)((greenMask & 0xFF0000) >> 16);
            bmi[offset + 6] = (byte)((greenMask & 0xFF00) >> 8);
            bmi[offset + 7] = (byte)((greenMask & 0xFF) >> 0);
            bmi[offset + 8] = (byte)((blueMask & 0xFF000000) >> 24);
            bmi[offset + 9] = (byte)((blueMask & 0xFF0000) >> 16);
            bmi[offset + 10] = (byte)((blueMask & 0xFF00) >> 8);
            bmi[offset + 11] = (byte)((blueMask & 0xFF) >> 0);
        }
        if ((hDib = OS.CreateDIBSection(0, bmi, 0, pBits = new int[1], 0, 0)) == 0) {
            SWT.error(2);
        }
        return hDib;
    }

    public void dispose() {
        Image image;
        int hNullBitmap;
        if (this.handle == 0) {
            return;
        }
        if (this.data.device.isDisposed()) {
            return;
        }
        if (this.data.hPen != 0) {
            int nullPen = OS.GetStockObject(8);
            OS.SelectObject(this.handle, nullPen);
            OS.DeleteObject(this.data.hPen);
            this.data.hPen = 0;
        }
        if (this.data.hBrush != 0) {
            int nullBrush = OS.GetStockObject(5);
            OS.SelectObject(this.handle, nullBrush);
            OS.DeleteObject(this.data.hBrush);
            this.data.hBrush = 0;
        }
        if ((hNullBitmap = this.data.hNullBitmap) != 0) {
            OS.SelectObject(this.handle, hNullBitmap);
            this.data.hNullBitmap = 0;
        }
        if ((image = this.data.image) != null) {
            image.memGC = null;
        }
        Device device = this.data.device;
        if (this.drawable != null) {
            this.drawable.internal_dispose_GC(this.handle, this.data);
        }
        this.drawable = null;
        this.handle = 0;
        this.data.image = null;
        this.data.ps = null;
        if (device.tracking) {
            device.dispose_Object(this);
        }
        this.data.device = null;
        this.data = null;
    }

    public void drawArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (width < 0) {
            x += width;
            width = -width;
        }
        if (height < 0) {
            y += height;
            height = -height;
        }
        if (width == 0 || height == 0 || arcAngle == 0) {
            return;
        }
        if (OS.IsWinCE) {
            if (arcAngle < 0) {
                startAngle += arcAngle;
                arcAngle = -arcAngle;
            }
            if (arcAngle > 360) {
                arcAngle = 360;
            }
            int[] points = new int[(arcAngle + 1) * 2];
            int cteX = 2 * x + width;
            int cteY = 2 * y + height;
            int index = 0;
            int i = 0;
            while (i <= arcAngle) {
                points[index++] = Compatibility.cos(startAngle + i, width) + cteX >> 1;
                points[index++] = cteY - Compatibility.sin(startAngle + i, height) >> 1;
                ++i;
            }
            OS.Polyline(this.handle, points, points.length / 2);
        } else {
            int y1;
            int y2;
            int x1;
            int x2;
            if (arcAngle >= 360 || arcAngle <= -360) {
                x1 = x2 = x + width;
                y1 = y2 = y + height / 2;
            } else {
                boolean isNegative = arcAngle < 0;
                arcAngle += startAngle;
                if (isNegative) {
                    int tmp = startAngle;
                    startAngle = arcAngle;
                    arcAngle = tmp;
                }
                x1 = Compatibility.cos(startAngle, width) + x + width / 2;
                y1 = -1 * Compatibility.sin(startAngle, height) + y + height / 2;
                x2 = Compatibility.cos(arcAngle, width) + x + width / 2;
                y2 = -1 * Compatibility.sin(arcAngle, height) + y + height / 2;
            }
            int nullBrush = OS.GetStockObject(5);
            int oldBrush = OS.SelectObject(this.handle, nullBrush);
            OS.Arc(this.handle, x, y, x + width + 1, y + height + 1, x1, y1, x2, y2);
            OS.SelectObject(this.handle, oldBrush);
        }
    }

    public void drawFocus(int x, int y, int width, int height) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        RECT rect = new RECT();
        OS.SetRect(rect, x, y, x + width, y + height);
        OS.DrawFocusRect(this.handle, rect);
    }

    public void drawImage(Image image, int x, int y) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (image == null) {
            SWT.error(4);
        }
        if (image.isDisposed()) {
            SWT.error(5);
        }
        this.drawImage(image, 0, 0, -1, -1, x, y, -1, -1, true);
    }

    public void drawImage(Image image, int srcX, int srcY, int srcWidth, int srcHeight, int destX, int destY, int destWidth, int destHeight) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (srcWidth == 0 || srcHeight == 0 || destWidth == 0 || destHeight == 0) {
            return;
        }
        if (srcX < 0 || srcY < 0 || srcWidth < 0 || srcHeight < 0 || destWidth < 0 || destHeight < 0) {
            SWT.error(5);
        }
        if (image == null) {
            SWT.error(4);
        }
        if (image.isDisposed()) {
            SWT.error(5);
        }
        this.drawImage(image, srcX, srcY, srcWidth, srcHeight, destX, destY, destWidth, destHeight, false);
    }

    void drawImage(Image srcImage, int srcX, int srcY, int srcWidth, int srcHeight, int destX, int destY, int destWidth, int destHeight, boolean simple) {
        switch (srcImage.type) {
            case 0: {
                this.drawBitmap(srcImage, srcX, srcY, srcWidth, srcHeight, destX, destY, destWidth, destHeight, simple);
                break;
            }
            case 1: {
                this.drawIcon(srcImage, srcX, srcY, srcWidth, srcHeight, destX, destY, destWidth, destHeight, simple);
                break;
            }
            default: {
                SWT.error(42);
            }
        }
    }

    void drawIcon(Image srcImage, int srcX, int srcY, int srcWidth, int srcHeight, int destX, int destY, int destWidth, int destHeight, boolean simple) {
        boolean failed;
        int technology = OS.GetDeviceCaps(this.handle, 2);
        if (simple && technology != 2) {
            OS.DrawIconEx(this.handle, destX, destY, srcImage.handle, 0, 0, 0, 0, 3);
            return;
        }
        ICONINFO srcIconInfo = new ICONINFO();
        if (OS.IsWinCE) {
            Image.GetIconInfo(srcImage, srcIconInfo);
        } else {
            OS.GetIconInfo(srcImage.handle, srcIconInfo);
        }
        int hBitmap = srcIconInfo.hbmColor;
        if (hBitmap == 0) {
            hBitmap = srcIconInfo.hbmMask;
        }
        BITMAP bm = new BITMAP();
        OS.GetObject(hBitmap, 24, bm);
        int iconWidth = bm.bmWidth;
        int iconHeight = bm.bmHeight;
        if (hBitmap == srcIconInfo.hbmMask) {
            iconHeight /= 2;
        }
        if (simple) {
            srcWidth = destWidth = iconWidth;
            srcHeight = destHeight = iconHeight;
        }
        boolean bl = failed = srcX + srcWidth > iconWidth || srcY + srcHeight > iconHeight;
        if (!failed) {
            boolean bl2 = simple = srcX == 0 && srcY == 0 && srcWidth == destWidth && srcHeight == destHeight && srcWidth == iconWidth && srcHeight == iconHeight;
            if (simple && technology != 2) {
                OS.DrawIconEx(this.handle, destX, destY, srcImage.handle, 0, 0, 0, 0, 3);
            } else {
                boolean stretch;
                Device device = this.data.device;
                int hDC = device.internal_new_GC(null);
                ICONINFO newIconInfo = new ICONINFO();
                newIconInfo.fIcon = true;
                int srcHdc = OS.CreateCompatibleDC(hDC);
                int dstHdc = OS.CreateCompatibleDC(hDC);
                int srcColorY = srcY;
                int srcColor = srcIconInfo.hbmColor;
                if (srcColor == 0) {
                    srcColor = srcIconInfo.hbmMask;
                    srcColorY += iconHeight;
                }
                int oldSrcBitmap = OS.SelectObject(srcHdc, srcColor);
                newIconInfo.hbmColor = OS.CreateCompatibleBitmap(srcHdc, destWidth, destHeight);
                if (newIconInfo.hbmColor == 0) {
                    SWT.error(2);
                }
                int oldDestBitmap = OS.SelectObject(dstHdc, newIconInfo.hbmColor);
                boolean bl3 = stretch = !simple && (srcWidth != destWidth || srcHeight != destHeight);
                if (stretch) {
                    if (!OS.IsWinCE) {
                        OS.SetStretchBltMode(dstHdc, 3);
                    }
                    OS.StretchBlt(dstHdc, 0, 0, destWidth, destHeight, srcHdc, srcX, srcColorY, srcWidth, srcHeight, 0xCC0020);
                } else {
                    OS.BitBlt(dstHdc, 0, 0, destWidth, destHeight, srcHdc, srcX, srcColorY, 0xCC0020);
                }
                OS.SelectObject(srcHdc, srcIconInfo.hbmMask);
                newIconInfo.hbmMask = OS.CreateBitmap(destWidth, destHeight, 1, 1, null);
                if (newIconInfo.hbmMask == 0) {
                    SWT.error(2);
                }
                OS.SelectObject(dstHdc, newIconInfo.hbmMask);
                if (stretch) {
                    OS.StretchBlt(dstHdc, 0, 0, destWidth, destHeight, srcHdc, srcX, srcY, srcWidth, srcHeight, 0xCC0020);
                } else {
                    OS.BitBlt(dstHdc, 0, 0, destWidth, destHeight, srcHdc, srcX, srcY, 0xCC0020);
                }
                if (technology == 2) {
                    OS.SelectObject(srcHdc, newIconInfo.hbmColor);
                    OS.SelectObject(dstHdc, srcIconInfo.hbmMask);
                    this.drawBitmapTransparentByClipping(srcHdc, dstHdc, 0, 0, destWidth, destHeight, destX, destY, destWidth, destHeight, true, destWidth, destHeight);
                    OS.SelectObject(srcHdc, oldSrcBitmap);
                    OS.SelectObject(dstHdc, oldDestBitmap);
                } else {
                    OS.SelectObject(srcHdc, oldSrcBitmap);
                    OS.SelectObject(dstHdc, oldDestBitmap);
                    int hIcon = OS.CreateIconIndirect(newIconInfo);
                    if (hIcon == 0) {
                        SWT.error(2);
                    }
                    OS.DrawIconEx(this.handle, destX, destY, hIcon, destWidth, destHeight, 0, 0, 3);
                    OS.DestroyIcon(hIcon);
                }
                OS.DeleteObject(newIconInfo.hbmMask);
                OS.DeleteObject(newIconInfo.hbmColor);
                OS.DeleteDC(dstHdc);
                OS.DeleteDC(srcHdc);
                device.internal_dispose_GC(hDC, null);
            }
        }
        OS.DeleteObject(srcIconInfo.hbmMask);
        if (srcIconInfo.hbmColor != 0) {
            OS.DeleteObject(srcIconInfo.hbmColor);
        }
        if (failed) {
            SWT.error(5);
        }
    }

    void drawBitmap(Image srcImage, int srcX, int srcY, int srcWidth, int srcHeight, int destX, int destY, int destWidth, int destHeight, boolean simple) {
        BITMAP bm = new BITMAP();
        OS.GetObject(srcImage.handle, 24, bm);
        int imgWidth = bm.bmWidth;
        int imgHeight = bm.bmHeight;
        if (simple) {
            srcWidth = destWidth = imgWidth;
            srcHeight = destHeight = imgHeight;
        } else {
            if (srcX + srcWidth > imgWidth || srcY + srcHeight > imgHeight) {
                SWT.error(5);
            }
            simple = srcX == 0 && srcY == 0 && srcWidth == destWidth && destWidth == imgWidth && srcHeight == destHeight && destHeight == imgHeight;
        }
        boolean mustRestore = false;
        GC memGC = srcImage.memGC;
        if (memGC != null && !memGC.isDisposed()) {
            mustRestore = true;
            GCData data = memGC.data;
            if (data.hNullBitmap != 0) {
                OS.SelectObject(memGC.handle, data.hNullBitmap);
                data.hNullBitmap = 0;
            }
        }
        if (srcImage.alpha != -1 || srcImage.alphaData != null) {
            this.drawBitmapAlpha(srcImage, srcX, srcY, srcWidth, srcHeight, destX, destY, destWidth, destHeight, simple, bm, imgWidth, imgHeight);
        } else if (srcImage.transparentPixel != -1) {
            this.drawBitmapTransparent(srcImage, srcX, srcY, srcWidth, srcHeight, destX, destY, destWidth, destHeight, simple, bm, imgWidth, imgHeight);
        } else {
            this.drawBitmap(srcImage, srcX, srcY, srcWidth, srcHeight, destX, destY, destWidth, destHeight, simple, bm, imgWidth, imgHeight);
        }
        if (mustRestore) {
            int hOldBitmap;
            memGC.data.hNullBitmap = hOldBitmap = OS.SelectObject(memGC.handle, srcImage.handle);
        }
    }

    void drawBitmapAlpha(Image srcImage, int srcX, int srcY, int srcWidth, int srcHeight, int destX, int destY, int destWidth, int destHeight, boolean simple, BITMAP bm, int imgWidth, int imgHeight) {
        boolean hasAlphaChannel;
        if (srcImage.alpha == 0) {
            return;
        }
        if (srcImage.alpha == 255) {
            this.drawBitmap(srcImage, srcX, srcY, srcWidth, srcHeight, destX, destY, destWidth, destHeight, simple, bm, imgWidth, imgHeight);
            return;
        }
        Rectangle rect = this.getClipping();
        if ((rect = rect.intersection(new Rectangle(destX, destY, destWidth, destHeight))).isEmpty()) {
            return;
        }
        int sx1 = srcX + (rect.x - destX) * srcWidth / destWidth;
        int sx2 = srcX + (rect.x + rect.width - destX) * srcWidth / destWidth;
        int sy1 = srcY + (rect.y - destY) * srcHeight / destHeight;
        int sy2 = srcY + (rect.y + rect.height - destY) * srcHeight / destHeight;
        destX = rect.x;
        destY = rect.y;
        destWidth = rect.width;
        destHeight = rect.height;
        srcX = sx1;
        srcY = sy1;
        srcWidth = Math.max(1, sx2 - sx1);
        srcHeight = Math.max(1, sy2 - sy1);
        int srcHdc = OS.CreateCompatibleDC(this.handle);
        int oldSrcBitmap = OS.SelectObject(srcHdc, srcImage.handle);
        int memHdc = OS.CreateCompatibleDC(this.handle);
        int memDib = this.createDIB(Math.max(srcWidth, destWidth), Math.max(srcHeight, destHeight));
        int oldMemBitmap = OS.SelectObject(memHdc, memDib);
        BITMAP dibBM = new BITMAP();
        OS.GetObject(memDib, 24, dibBM);
        int sizeInBytes = dibBM.bmWidthBytes * dibBM.bmHeight;
        OS.BitBlt(memHdc, 0, 0, destWidth, destHeight, this.handle, destX, destY, 0xCC0020);
        byte[] destData = new byte[sizeInBytes];
        OS.MoveMemory(destData, dibBM.bmBits, sizeInBytes);
        OS.BitBlt(memHdc, 0, 0, srcWidth, srcHeight, srcHdc, srcX, srcY, 0xCC0020);
        byte[] srcData = new byte[sizeInBytes];
        OS.MoveMemory(srcData, dibBM.bmBits, sizeInBytes);
        int alpha = srcImage.alpha;
        boolean bl = hasAlphaChannel = srcImage.alpha == -1;
        if (hasAlphaChannel) {
            int apinc = imgWidth - srcWidth;
            int spinc = dibBM.bmWidthBytes - srcWidth * 4;
            int ap = srcY * imgWidth + srcX;
            int sp = 3;
            byte[] alphaData = srcImage.alphaData;
            int y = 0;
            while (y < srcHeight) {
                int x = 0;
                while (x < srcWidth) {
                    srcData[sp] = alphaData[ap++];
                    sp += 4;
                    ++x;
                }
                ap += apinc;
                sp += spinc;
                ++y;
            }
        }
        OS.MoveMemory(dibBM.bmBits, srcData, sizeInBytes);
        if (OS.IsWinCE && (destWidth > srcWidth || destHeight > srcHeight) || !OS.IsWinNT && !OS.IsWinCE) {
            int tempHdc = OS.CreateCompatibleDC(this.handle);
            int tempDib = this.createDIB(destWidth, destHeight);
            int oldTempBitmap = OS.SelectObject(tempHdc, tempDib);
            if (!(simple || srcWidth == destWidth && srcHeight == destHeight)) {
                if (!OS.IsWinCE) {
                    OS.SetStretchBltMode(memHdc, 3);
                }
                OS.StretchBlt(tempHdc, 0, 0, destWidth, destHeight, memHdc, 0, 0, srcWidth, srcHeight, 0xCC0020);
            } else {
                OS.BitBlt(tempHdc, 0, 0, destWidth, destHeight, memHdc, 0, 0, 0xCC0020);
            }
            OS.BitBlt(memHdc, 0, 0, destWidth, destHeight, tempHdc, 0, 0, 0xCC0020);
            OS.SelectObject(tempHdc, oldTempBitmap);
            OS.DeleteObject(tempDib);
            OS.DeleteDC(tempHdc);
        } else if (!(simple || srcWidth == destWidth && srcHeight == destHeight)) {
            if (!OS.IsWinCE) {
                OS.SetStretchBltMode(memHdc, 3);
            }
            OS.StretchBlt(memHdc, 0, 0, destWidth, destHeight, memHdc, 0, 0, srcWidth, srcHeight, 0xCC0020);
        } else {
            OS.BitBlt(memHdc, 0, 0, destWidth, destHeight, memHdc, 0, 0, 0xCC0020);
        }
        OS.MoveMemory(srcData, dibBM.bmBits, sizeInBytes);
        int dpinc = dibBM.bmWidthBytes - destWidth * 4;
        int dp = 0;
        int y = 0;
        while (y < destHeight) {
            int x = 0;
            while (x < destWidth) {
                if (hasAlphaChannel) {
                    alpha = srcData[dp + 3] & 0xFF;
                }
                int n = dp;
                destData[n] = (byte)(destData[n] + ((srcData[dp] & 0xFF) - (destData[dp] & 0xFF)) * alpha / 255);
                int n2 = dp + 1;
                destData[n2] = (byte)(destData[n2] + ((srcData[dp + 1] & 0xFF) - (destData[dp + 1] & 0xFF)) * alpha / 255);
                int n3 = dp + 2;
                destData[n3] = (byte)(destData[n3] + ((srcData[dp + 2] & 0xFF) - (destData[dp + 2] & 0xFF)) * alpha / 255);
                dp += 4;
                ++x;
            }
            dp += dpinc;
            ++y;
        }
        OS.MoveMemory(dibBM.bmBits, destData, sizeInBytes);
        OS.BitBlt(this.handle, destX, destY, destWidth, destHeight, memHdc, 0, 0, 0xCC0020);
        OS.SelectObject(memHdc, oldMemBitmap);
        OS.DeleteDC(memHdc);
        OS.DeleteObject(memDib);
        OS.SelectObject(srcHdc, oldSrcBitmap);
        OS.DeleteDC(srcHdc);
    }

    void drawBitmapTransparentByClipping(int srcHdc, int maskHdc, int srcX, int srcY, int srcWidth, int srcHeight, int destX, int destY, int destWidth, int destHeight, boolean simple, int imgWidth, int imgHeight) {
        int dwRop;
        int rgn = OS.CreateRectRgn(0, 0, 0, 0);
        int y = 0;
        while (y < imgHeight) {
            int x = 0;
            while (x < imgWidth) {
                if (OS.GetPixel(maskHdc, x, y) == 0) {
                    int tempRgn = OS.CreateRectRgn(x, y, x + 1, y + 1);
                    OS.CombineRgn(rgn, rgn, tempRgn, 2);
                    OS.DeleteObject(tempRgn);
                }
                ++x;
            }
            ++y;
        }
        OS.OffsetRgn(rgn, destX, destY);
        int clip = OS.CreateRectRgn(0, 0, 0, 0);
        int result = OS.GetClipRgn(this.handle, clip);
        if (result == 1) {
            OS.CombineRgn(rgn, rgn, clip, 1);
        }
        OS.SelectClipRgn(this.handle, rgn);
        int rop2 = 0;
        if (!OS.IsWinCE) {
            rop2 = OS.GetROP2(this.handle);
        } else {
            rop2 = OS.SetROP2(this.handle, 13);
            OS.SetROP2(this.handle, rop2);
        }
        int n = dwRop = rop2 == 7 ? 0x660046 : 0xCC0020;
        if (!(simple || srcWidth == destWidth && srcHeight == destHeight)) {
            int mode = 0;
            if (!OS.IsWinCE) {
                mode = OS.SetStretchBltMode(this.handle, 3);
            }
            OS.StretchBlt(this.handle, destX, destY, destWidth, destHeight, srcHdc, srcX, srcY, srcWidth, srcHeight, dwRop);
            if (!OS.IsWinCE) {
                OS.SetStretchBltMode(this.handle, mode);
            }
        } else {
            OS.BitBlt(this.handle, destX, destY, destWidth, destHeight, srcHdc, srcX, srcY, dwRop);
        }
        OS.SelectClipRgn(this.handle, result == 1 ? clip : 0);
        OS.DeleteObject(clip);
        OS.DeleteObject(rgn);
    }

    void drawBitmapTransparent(Image srcImage, int srcX, int srcY, int srcWidth, int srcHeight, int destX, int destY, int destWidth, int destHeight, boolean simple, BITMAP bm, int imgWidth, int imgHeight) {
        Device device = this.data.device;
        int hDC = device.internal_new_GC(null);
        int transBlue = 0;
        int transGreen = 0;
        int transRed = 0;
        boolean isDib = bm.bmBits != 0;
        int hBitmap = srcImage.handle;
        int srcHdc = OS.CreateCompatibleDC(this.handle);
        int oldSrcBitmap = OS.SelectObject(srcHdc, hBitmap);
        byte[] originalColors = null;
        if (bm.bmBitsPixel <= 8) {
            if (isDib) {
                if (OS.IsWinCE) {
                    byte[] pBits = new byte[1];
                    OS.MoveMemory(pBits, bm.bmBits, 1);
                    byte oldValue = pBits[0];
                    int mask = 255 << 8 - bm.bmBitsPixel & 0xFF;
                    pBits[0] = (byte)(srcImage.transparentPixel << 8 - bm.bmBitsPixel | pBits[0] & ~mask);
                    OS.MoveMemory(bm.bmBits, pBits, 1);
                    int color = OS.GetPixel(srcHdc, 0, 0);
                    pBits[0] = oldValue;
                    OS.MoveMemory(bm.bmBits, pBits, 1);
                    transBlue = (color & 0xFF0000) >> 16;
                    transGreen = (color & 0xFF00) >> 8;
                    transRed = color & 0xFF;
                } else {
                    int maxColors = 1 << bm.bmBitsPixel;
                    byte[] oldColors = new byte[maxColors * 4];
                    OS.GetDIBColorTable(srcHdc, 0, maxColors, oldColors);
                    int offset = srcImage.transparentPixel * 4;
                    byte[] newColors = new byte[oldColors.length];
                    transBlue = 255;
                    transGreen = 255;
                    transRed = 255;
                    newColors[offset] = (byte)transBlue;
                    newColors[offset + 1] = (byte)transGreen;
                    newColors[offset + 2] = (byte)transRed;
                    OS.SetDIBColorTable(srcHdc, 0, maxColors, newColors);
                    originalColors = oldColors;
                }
            } else {
                int numColors = 1 << bm.bmBitsPixel;
                BITMAPINFOHEADER bmiHeader = new BITMAPINFOHEADER();
                bmiHeader.biSize = 40;
                bmiHeader.biPlanes = bm.bmPlanes;
                bmiHeader.biBitCount = bm.bmBitsPixel;
                byte[] bmi = new byte[40 + numColors * 4];
                OS.MoveMemory(bmi, bmiHeader, 40);
                if (OS.IsWinCE) {
                    SWT.error(20);
                }
                OS.GetDIBits(srcHdc, srcImage.handle, 0, 0, 0, bmi, 0);
                int offset = 40 + 4 * srcImage.transparentPixel;
                transRed = bmi[offset + 2] & 0xFF;
                transGreen = bmi[offset + 1] & 0xFF;
                transBlue = bmi[offset] & 0xFF;
            }
        } else {
            int pixel = srcImage.transparentPixel;
            switch (bm.bmBitsPixel) {
                case 16: {
                    transBlue = (pixel & 0x1F) << 3;
                    transGreen = (pixel & 0x3E0) >> 2;
                    transRed = (pixel & 0x7C00) >> 7;
                    break;
                }
                case 24: {
                    transBlue = (pixel & 0xFF0000) >> 16;
                    transGreen = (pixel & 0xFF00) >> 8;
                    transRed = pixel & 0xFF;
                    break;
                }
                case 32: {
                    transBlue = (pixel & 0xFF000000) >>> 24;
                    transGreen = (pixel & 0xFF0000) >> 16;
                    transRed = (pixel & 0xFF00) >> 8;
                }
            }
        }
        if (OS.IsWinCE) {
            int transparentColor = transBlue << 16 | transGreen << 8 | transRed;
            OS.TransparentImage(this.handle, destX, destY, destWidth, destHeight, srcHdc, srcX, srcY, srcWidth, srcHeight, transparentColor);
        } else {
            int maskHdc = OS.CreateCompatibleDC(hDC);
            int maskBitmap = OS.CreateBitmap(imgWidth, imgHeight, 1, 1, null);
            int oldMaskBitmap = OS.SelectObject(maskHdc, maskBitmap);
            OS.SetBkColor(srcHdc, transBlue << 16 | transGreen << 8 | transRed);
            OS.BitBlt(maskHdc, 0, 0, imgWidth, imgHeight, srcHdc, 0, 0, 0xCC0020);
            if (originalColors != null) {
                OS.SetDIBColorTable(srcHdc, 0, 1 << bm.bmBitsPixel, originalColors);
            }
            if (OS.GetDeviceCaps(this.handle, 2) == 2) {
                this.drawBitmapTransparentByClipping(srcHdc, maskHdc, srcX, srcY, srcWidth, srcHeight, destX, destY, destWidth, destHeight, simple, imgWidth, imgHeight);
            } else {
                int tempHdc = OS.CreateCompatibleDC(hDC);
                int tempBitmap = OS.CreateCompatibleBitmap(hDC, destWidth, destHeight);
                int oldTempBitmap = OS.SelectObject(tempHdc, tempBitmap);
                OS.BitBlt(tempHdc, 0, 0, destWidth, destHeight, this.handle, destX, destY, 0xCC0020);
                if (!(simple || srcWidth == destWidth && srcHeight == destHeight)) {
                    if (!OS.IsWinCE) {
                        OS.SetStretchBltMode(tempHdc, 3);
                    }
                    OS.StretchBlt(tempHdc, 0, 0, destWidth, destHeight, srcHdc, srcX, srcY, srcWidth, srcHeight, 0x660046);
                    OS.StretchBlt(tempHdc, 0, 0, destWidth, destHeight, maskHdc, srcX, srcY, srcWidth, srcHeight, 8913094);
                    OS.StretchBlt(tempHdc, 0, 0, destWidth, destHeight, srcHdc, srcX, srcY, srcWidth, srcHeight, 0x660046);
                } else {
                    OS.BitBlt(tempHdc, 0, 0, destWidth, destHeight, srcHdc, srcX, srcY, 0x660046);
                    OS.BitBlt(tempHdc, 0, 0, destWidth, destHeight, maskHdc, srcX, srcY, 8913094);
                    OS.BitBlt(tempHdc, 0, 0, destWidth, destHeight, srcHdc, srcX, srcY, 0x660046);
                }
                OS.BitBlt(this.handle, destX, destY, destWidth, destHeight, tempHdc, 0, 0, 0xCC0020);
                OS.SelectObject(tempHdc, oldTempBitmap);
                OS.DeleteDC(tempHdc);
                OS.DeleteObject(tempBitmap);
            }
            OS.SelectObject(maskHdc, oldMaskBitmap);
            OS.DeleteDC(maskHdc);
            OS.DeleteObject(maskBitmap);
        }
        OS.SelectObject(srcHdc, oldSrcBitmap);
        if (hBitmap != srcImage.handle) {
            OS.DeleteObject(hBitmap);
        }
        OS.DeleteDC(srcHdc);
        device.internal_dispose_GC(hDC, null);
    }

    void drawBitmap(Image srcImage, int srcX, int srcY, int srcWidth, int srcHeight, int destX, int destY, int destWidth, int destHeight, boolean simple, BITMAP bm, int imgWidth, int imgHeight) {
        int dwRop;
        int srcHdc = OS.CreateCompatibleDC(this.handle);
        int oldSrcBitmap = OS.SelectObject(srcHdc, srcImage.handle);
        int rop2 = 0;
        if (!OS.IsWinCE) {
            rop2 = OS.GetROP2(this.handle);
        } else {
            rop2 = OS.SetROP2(this.handle, 13);
            OS.SetROP2(this.handle, rop2);
        }
        int n = dwRop = rop2 == 7 ? 0x660046 : 0xCC0020;
        if (!(simple || srcWidth == destWidth && srcHeight == destHeight)) {
            int mode = 0;
            if (!OS.IsWinCE) {
                mode = OS.SetStretchBltMode(this.handle, 3);
            }
            OS.StretchBlt(this.handle, destX, destY, destWidth, destHeight, srcHdc, srcX, srcY, srcWidth, srcHeight, dwRop);
            if (!OS.IsWinCE) {
                OS.SetStretchBltMode(this.handle, mode);
            }
        } else {
            OS.BitBlt(this.handle, destX, destY, destWidth, destHeight, srcHdc, srcX, srcY, dwRop);
        }
        OS.SelectObject(srcHdc, oldSrcBitmap);
        OS.DeleteDC(srcHdc);
    }

    public void drawLine(int x1, int y1, int x2, int y2) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (OS.IsWinCE) {
            int[] points = new int[]{x1, y1, x2, y2};
            OS.Polyline(this.handle, points, points.length / 2);
        } else {
            OS.MoveToEx(this.handle, x1, y1, 0);
            OS.LineTo(this.handle, x2, y2);
        }
        if (this.data.lineWidth <= 1) {
            OS.SetPixel(this.handle, x2, y2, OS.GetTextColor(this.handle));
        }
    }

    public void drawOval(int x, int y, int width, int height) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        int nullBrush = OS.GetStockObject(5);
        int oldBrush = OS.SelectObject(this.handle, nullBrush);
        OS.Ellipse(this.handle, x, y, x + width + 1, y + height + 1);
        OS.SelectObject(this.handle, oldBrush);
    }

    public void drawPoint(int x, int y) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        OS.SetPixel(this.handle, x, y, OS.GetTextColor(this.handle));
    }

    public void drawPolygon(int[] pointArray) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (pointArray == null) {
            SWT.error(4);
        }
        int nullBrush = OS.GetStockObject(5);
        int oldBrush = OS.SelectObject(this.handle, nullBrush);
        OS.Polygon(this.handle, pointArray, pointArray.length / 2);
        OS.SelectObject(this.handle, oldBrush);
    }

    public void drawPolyline(int[] pointArray) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (pointArray == null) {
            SWT.error(4);
        }
        OS.Polyline(this.handle, pointArray, pointArray.length / 2);
        int length = pointArray.length;
        if (length >= 2 && this.data.lineWidth <= 1) {
            OS.SetPixel(this.handle, pointArray[length - 2], pointArray[length - 1], OS.GetTextColor(this.handle));
        }
    }

    public void drawRectangle(int x, int y, int width, int height) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        int hOld = OS.SelectObject(this.handle, OS.GetStockObject(5));
        OS.Rectangle(this.handle, x, y, x + width + 1, y + height + 1);
        OS.SelectObject(this.handle, hOld);
    }

    public void drawRectangle(Rectangle rect) {
        if (rect == null) {
            SWT.error(4);
        }
        this.drawRectangle(rect.x, rect.y, rect.width, rect.height);
    }

    public void drawRoundRectangle(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (OS.IsWinCE) {
            if (width == 0 || height == 0) {
                return;
            }
            if (arcWidth == 0 || arcHeight == 0) {
                this.drawRectangle(x, y, width, height);
                return;
            }
            if (width < 0) {
                x += width;
                width = -width;
            }
            if (height < 0) {
                y += height;
                height = -height;
            }
            if (arcWidth < 0) {
                arcWidth = -arcWidth;
            }
            if (arcHeight < 0) {
                arcHeight = -arcHeight;
            }
            if (arcWidth > width) {
                arcWidth = width;
            }
            if (arcHeight > height) {
                arcHeight = height;
            }
            if (arcWidth < width) {
                this.drawLine(x + arcWidth / 2, y, x + width - arcWidth / 2, y);
                this.drawLine(x + arcWidth / 2, y + height, x + width - arcWidth / 2, y + height);
            }
            if (arcHeight < height) {
                this.drawLine(x, y + arcHeight / 2, x, y + height - arcHeight / 2);
                this.drawLine(x + width, y + arcHeight / 2, x + width, y + height - arcHeight / 2);
            }
            if (arcWidth != 0 && arcHeight != 0) {
                this.drawArc(x, y, arcWidth, arcHeight, 90, 90);
                this.drawArc(x + width - arcWidth, y, arcWidth, arcHeight, 0, 90);
                this.drawArc(x + width - arcWidth, y + height - arcHeight, arcWidth, arcHeight, 0, -90);
                this.drawArc(x, y + height - arcHeight, arcWidth, arcHeight, 180, 90);
            }
        } else {
            int nullBrush = OS.GetStockObject(5);
            int oldBrush = OS.SelectObject(this.handle, nullBrush);
            OS.RoundRect(this.handle, x, y, x + width + 1, y + height + 1, arcWidth, arcHeight);
            OS.SelectObject(this.handle, oldBrush);
        }
    }

    public void drawString(String string, int x, int y) {
        this.drawString(string, x, y, false);
    }

    public void drawString(String string, int x, int y, boolean isTransparent) {
        int length;
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (string == null) {
            SWT.error(4);
        }
        if ((length = string.length()) == 0) {
            return;
        }
        char[] buffer = new char[length];
        string.getChars(0, length, buffer, 0);
        int rop2 = 0;
        if (OS.IsWinCE) {
            rop2 = OS.SetROP2(this.handle, 13);
            OS.SetROP2(this.handle, rop2);
        } else {
            rop2 = OS.GetROP2(this.handle);
        }
        int oldBkMode = OS.SetBkMode(this.handle, isTransparent ? 1 : 2);
        if (rop2 != 7) {
            OS.ExtTextOutW(this.handle, x, y, 0, null, buffer, length, null);
        } else {
            int foreground = OS.GetTextColor(this.handle);
            if (isTransparent) {
                SIZE size = new SIZE();
                OS.GetTextExtentPoint32W(this.handle, buffer, length, size);
                int width = size.cx;
                int height = size.cy;
                int hBitmap = OS.CreateCompatibleBitmap(this.handle, width, height);
                if (hBitmap == 0) {
                    SWT.error(2);
                }
                int memDC = OS.CreateCompatibleDC(this.handle);
                int hOldBitmap = OS.SelectObject(memDC, hBitmap);
                OS.PatBlt(memDC, 0, 0, width, height, 66);
                OS.SetBkMode(memDC, 1);
                OS.SetTextColor(memDC, foreground);
                OS.SelectObject(memDC, OS.GetCurrentObject(this.handle, 6));
                OS.ExtTextOutW(memDC, 0, 0, 0, null, buffer, length, null);
                OS.BitBlt(this.handle, x, y, width, height, memDC, 0, 0, 0x660046);
                OS.SelectObject(memDC, hOldBitmap);
                OS.DeleteDC(memDC);
                OS.DeleteObject(hBitmap);
            } else {
                int background = OS.GetBkColor(this.handle);
                OS.SetTextColor(this.handle, foreground ^ background);
                OS.ExtTextOutW(this.handle, x, y, 0, null, buffer, length, null);
                OS.SetTextColor(this.handle, foreground);
            }
        }
        OS.SetBkMode(this.handle, oldBkMode);
    }

    public void drawText(String string, int x, int y) {
        this.drawText(string, x, y, 6);
    }

    public void drawText(String string, int x, int y, boolean isTransparent) {
        int flags = 6;
        if (isTransparent) {
            flags |= 1;
        }
        this.drawText(string, x, y, flags);
    }

    public void drawText(String string, int x, int y, int flags) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (string == null) {
            SWT.error(4);
        }
        if (string.length() == 0) {
            return;
        }
        TCHAR buffer = new TCHAR(this.getCodePage(), string, false);
        int length = buffer.length();
        if (length == 0) {
            return;
        }
        RECT rect = new RECT();
        int limit = OS.IsWin95 ? Short.MAX_VALUE : 0x6FFFFFF;
        OS.SetRect(rect, x, y, limit, limit);
        int uFormat = 0;
        if ((flags & 2) == 0) {
            uFormat |= 0x20;
        }
        if ((flags & 4) != 0) {
            uFormat |= 0x40;
        }
        if ((flags & 8) == 0) {
            uFormat |= 0x800;
        }
        int rop2 = 0;
        if (OS.IsWinCE) {
            rop2 = OS.SetROP2(this.handle, 13);
            OS.SetROP2(this.handle, rop2);
        } else {
            rop2 = OS.GetROP2(this.handle);
        }
        int oldBkMode = OS.SetBkMode(this.handle, (flags & 1) != 0 ? 1 : 2);
        if (rop2 != 7) {
            OS.DrawText(this.handle, buffer, length, rect, uFormat);
        } else {
            int foreground = OS.GetTextColor(this.handle);
            if ((flags & 1) != 0) {
                OS.DrawText(this.handle, buffer, buffer.length(), rect, uFormat | 0x400);
                int width = rect.right - rect.left;
                int height = rect.bottom - rect.top;
                int hBitmap = OS.CreateCompatibleBitmap(this.handle, width, height);
                if (hBitmap == 0) {
                    SWT.error(2);
                }
                int memDC = OS.CreateCompatibleDC(this.handle);
                int hOldBitmap = OS.SelectObject(memDC, hBitmap);
                OS.PatBlt(memDC, 0, 0, width, height, 66);
                OS.SetBkMode(memDC, 1);
                OS.SetTextColor(memDC, foreground);
                OS.SelectObject(memDC, OS.GetCurrentObject(this.handle, 6));
                OS.SetRect(rect, 0, 0, Short.MAX_VALUE, Short.MAX_VALUE);
                OS.DrawText(memDC, buffer, length, rect, uFormat);
                OS.BitBlt(this.handle, x, y, width, height, memDC, 0, 0, 0x660046);
                OS.SelectObject(memDC, hOldBitmap);
                OS.DeleteDC(memDC);
                OS.DeleteObject(hBitmap);
            } else {
                int background = OS.GetBkColor(this.handle);
                OS.SetTextColor(this.handle, foreground ^ background);
                OS.DrawText(this.handle, buffer, length, rect, uFormat);
                OS.SetTextColor(this.handle, foreground);
            }
        }
        OS.SetBkMode(this.handle, oldBkMode);
    }

    public boolean equals(Object object) {
        return object == this || object instanceof GC && this.handle == ((GC)object).handle;
    }

    public void fillArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (width < 0) {
            x += width;
            width = -width;
        }
        if (height < 0) {
            y += height;
            height = -height;
        }
        if (width == 0 || height == 0 || arcAngle == 0) {
            return;
        }
        if (OS.IsWinCE) {
            if (arcAngle < 0) {
                startAngle += arcAngle;
                arcAngle = -arcAngle;
            }
            boolean drawSegments = true;
            if (arcAngle >= 360) {
                arcAngle = 360;
                drawSegments = false;
            }
            int[] points = new int[(arcAngle + 1) * 2 + (drawSegments ? 4 : 0)];
            int cteX = 2 * x + width;
            int cteY = 2 * y + height;
            int index = drawSegments ? 2 : 0;
            int i = 0;
            while (i <= arcAngle) {
                points[index++] = Compatibility.cos(startAngle + i, width) + cteX >> 1;
                points[index++] = cteY - Compatibility.sin(startAngle + i, height) >> 1;
                ++i;
            }
            if (drawSegments) {
                int n = cteX >> 1;
                points[points.length - 2] = n;
                points[0] = n;
                int n2 = cteY >> 1;
                points[points.length - 1] = n2;
                points[1] = n2;
            }
            int nullPen = OS.GetStockObject(8);
            int oldPen = OS.SelectObject(this.handle, nullPen);
            OS.Polygon(this.handle, points, points.length / 2);
            OS.SelectObject(this.handle, oldPen);
        } else {
            int y1;
            int y2;
            int x1;
            int x2;
            if (arcAngle >= 360 || arcAngle <= -360) {
                x1 = x2 = x + width;
                y1 = y2 = y + height / 2;
            } else {
                boolean isNegative = arcAngle < 0;
                arcAngle += startAngle;
                if (isNegative) {
                    int tmp = startAngle;
                    startAngle = arcAngle;
                    arcAngle = tmp;
                }
                x1 = Compatibility.cos(startAngle, width) + x + width / 2;
                y1 = -1 * Compatibility.sin(startAngle, height) + y + height / 2;
                x2 = Compatibility.cos(arcAngle, width) + x + width / 2;
                y2 = -1 * Compatibility.sin(arcAngle, height) + y + height / 2;
            }
            int nullPen = OS.GetStockObject(8);
            int oldPen = OS.SelectObject(this.handle, nullPen);
            OS.Pie(this.handle, x, y, x + width + 1, y + height + 1, x1, y1, x2, y2);
            OS.SelectObject(this.handle, oldPen);
        }
    }

    public void fillGradientRectangle(int x, int y, int width, int height, boolean vertical) {
        int depth;
        int toColor;
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (width == 0 || height == 0) {
            return;
        }
        int fromColor = OS.GetTextColor(this.handle);
        if (fromColor == -1) {
            fromColor = OS.GetSysColor(OS.COLOR_WINDOWTEXT);
        }
        if ((toColor = OS.GetBkColor(this.handle)) == -1) {
            toColor = OS.GetSysColor(OS.COLOR_WINDOW);
        }
        boolean swapColors = false;
        if (width < 0) {
            x += width;
            width = -width;
            if (!vertical) {
                swapColors = true;
            }
        }
        if (height < 0) {
            y += height;
            height = -height;
            if (vertical) {
                swapColors = true;
            }
        }
        if (swapColors) {
            int t = fromColor;
            fromColor = toColor;
            toColor = t;
        }
        int rop2 = 0;
        if (OS.IsWinCE) {
            rop2 = OS.SetROP2(this.handle, 13);
            OS.SetROP2(this.handle, rop2);
        } else {
            rop2 = OS.GetROP2(this.handle);
        }
        RGB fromRGB = new RGB(fromColor & 0xFF, fromColor >>> 8 & 0xFF, fromColor >>> 16 & 0xFF);
        RGB toRGB = new RGB(toColor & 0xFF, toColor >>> 8 & 0xFF, toColor >>> 16 & 0xFF);
        if (fromRGB.red == toRGB.red && fromRGB.green == toRGB.green && fromRGB.blue == toRGB.blue) {
            int dwRop = rop2 == 7 ? 5898313 : 15728673;
            OS.PatBlt(this.handle, x, y, width, height, dwRop);
            return;
        }
        if (!OS.IsWinCE && rop2 != 7 && OS.GetDeviceCaps(this.handle, 2) != 2) {
            int hHeap = OS.GetProcessHeap();
            int pMesh = OS.HeapAlloc(hHeap, 8, 40);
            int pVertex = pMesh + 8;
            GRADIENT_RECT gradientRect = new GRADIENT_RECT();
            gradientRect.UpperLeft = 0;
            gradientRect.LowerRight = 1;
            OS.MoveMemory(pMesh, gradientRect, 8);
            TRIVERTEX trivertex = new TRIVERTEX();
            trivertex.x = x;
            trivertex.y = y;
            trivertex.Red = (short)(fromRGB.red << 8 | fromRGB.red);
            trivertex.Green = (short)(fromRGB.green << 8 | fromRGB.green);
            trivertex.Blue = (short)(fromRGB.blue << 8 | fromRGB.blue);
            trivertex.Alpha = (short)-1;
            OS.MoveMemory(pVertex, trivertex, 16);
            trivertex.x = x + width;
            trivertex.y = y + height;
            trivertex.Red = (short)(toRGB.red << 8 | toRGB.red);
            trivertex.Green = (short)(toRGB.green << 8 | toRGB.green);
            trivertex.Blue = (short)(toRGB.blue << 8 | toRGB.blue);
            trivertex.Alpha = (short)-1;
            OS.MoveMemory(pVertex + 16, trivertex, 16);
            boolean success = OS.GradientFill(this.handle, pVertex, 2, pMesh, 1, vertical ? 1 : 0);
            OS.HeapFree(hHeap, 0, pMesh);
            if (success) {
                return;
            }
        }
        int bitResolution = (depth = OS.GetDeviceCaps(this.handle, 12)) >= 24 ? 8 : (depth >= 15 ? 5 : 0);
        ImageData.fillGradientRectangle(this, this.data.device, x, y, width, height, vertical, fromRGB, toRGB, bitResolution, bitResolution, bitResolution);
    }

    public void fillOval(int x, int y, int width, int height) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        int nullPen = OS.GetStockObject(8);
        int oldPen = OS.SelectObject(this.handle, nullPen);
        OS.Ellipse(this.handle, x, y, x + width + 1, y + height + 1);
        OS.SelectObject(this.handle, oldPen);
    }

    public void fillPolygon(int[] pointArray) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (pointArray == null) {
            SWT.error(4);
        }
        int nullPen = OS.GetStockObject(8);
        int oldPen = OS.SelectObject(this.handle, nullPen);
        OS.Polygon(this.handle, pointArray, pointArray.length / 2);
        OS.SelectObject(this.handle, oldPen);
    }

    public void fillRectangle(int x, int y, int width, int height) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        int rop2 = 0;
        if (OS.IsWinCE) {
            rop2 = OS.SetROP2(this.handle, 13);
            OS.SetROP2(this.handle, rop2);
        } else {
            rop2 = OS.GetROP2(this.handle);
        }
        int dwRop = rop2 == 7 ? 5898313 : 15728673;
        OS.PatBlt(this.handle, x, y, width, height, dwRop);
    }

    public void fillRectangle(Rectangle rect) {
        if (rect == null) {
            SWT.error(4);
        }
        this.fillRectangle(rect.x, rect.y, rect.width, rect.height);
    }

    public void fillRoundRectangle(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        int nullPen = OS.GetStockObject(8);
        int oldPen = OS.SelectObject(this.handle, nullPen);
        OS.RoundRect(this.handle, x, y, x + width + 1, y + height + 1, arcWidth, arcHeight);
        OS.SelectObject(this.handle, oldPen);
    }

    public int getAdvanceWidth(char ch) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (OS.IsWinCE) {
            SIZE size = new SIZE();
            OS.GetTextExtentPoint32W(this.handle, new char[]{ch}, 1, size);
            return size.cx;
        }
        int tch = ch;
        if (ch > 127) {
            TCHAR buffer = new TCHAR(this.getCodePage(), (char)ch, false);
            tch = buffer.tcharAt(0);
        }
        int[] width = new int[1];
        OS.GetCharWidth(this.handle, tch, tch, width);
        return width[0];
    }

    public Color getBackground() {
        int color;
        if (this.handle == 0) {
            SWT.error(44);
        }
        if ((color = OS.GetBkColor(this.handle)) == -1) {
            color = OS.GetSysColor(OS.COLOR_WINDOW);
        }
        return Color.win32_new(this.data.device, color);
    }

    public int getCharWidth(char ch) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (!OS.IsWinCE) {
            int[] width;
            int tch = ch;
            if (ch > 127) {
                TCHAR buffer = new TCHAR(this.getCodePage(), (char)ch, false);
                tch = buffer.tcharAt(0);
            }
            if (OS.GetCharABCWidths(this.handle, tch, tch, width = new int[3])) {
                return width[1];
            }
        }
        TEXTMETRIC lptm = OS.IsUnicode ? new TEXTMETRICW() : new TEXTMETRICA();
        OS.GetTextMetrics(this.handle, lptm);
        SIZE size = new SIZE();
        OS.GetTextExtentPoint32W(this.handle, new char[]{ch}, 1, size);
        return size.cx - lptm.tmOverhang;
    }

    public Rectangle getClipping() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        RECT rect = new RECT();
        OS.GetClipBox(this.handle, rect);
        return new Rectangle(rect.left, rect.top, rect.right - rect.left, rect.bottom - rect.top);
    }

    public void getClipping(Region region) {
        int result;
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (region == null) {
            SWT.error(4);
        }
        if ((result = OS.GetClipRgn(this.handle, region.handle)) != 1) {
            RECT rect = new RECT();
            OS.GetClipBox(this.handle, rect);
            OS.SetRectRgn(region.handle, rect.left, rect.top, rect.right, rect.bottom);
        }
        if (!OS.IsWinCE) {
            int hwnd;
            int flags = 0;
            if (OS.WIN32_VERSION >= OS.VERSION(4, 10)) {
                flags = OS.GetLayout(this.handle);
            }
            if ((hwnd = this.data.hwnd) != 0 && this.data.ps != null && (flags & 1) == 0) {
                int sysRgn = OS.CreateRectRgn(0, 0, 0, 0);
                if (OS.GetRandomRgn(this.handle, sysRgn, 4) == 1) {
                    if (OS.IsWinNT) {
                        POINT pt = new POINT();
                        OS.MapWindowPoints(0, hwnd, pt, 1);
                        OS.OffsetRgn(sysRgn, pt.x, pt.y);
                    }
                    OS.CombineRgn(region.handle, sysRgn, region.handle, 1);
                }
                OS.DeleteObject(sysRgn);
            }
        }
    }

    int getCodePage() {
        if (OS.IsUnicode) {
            return 0;
        }
        int[] lpCs = new int[8];
        int cs = OS.GetTextCharset(this.handle);
        OS.TranslateCharsetInfo(cs, lpCs, 1);
        return lpCs[1];
    }

    public Font getFont() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        int hFont = OS.GetCurrentObject(this.handle, 6);
        return Font.win32_new(this.data.device, hFont);
    }

    public FontMetrics getFontMetrics() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        TEXTMETRIC lptm = OS.IsUnicode ? new TEXTMETRICW() : new TEXTMETRICA();
        OS.GetTextMetrics(this.handle, lptm);
        return FontMetrics.win32_new(lptm);
    }

    public Color getForeground() {
        int color;
        if (this.handle == 0) {
            SWT.error(44);
        }
        if ((color = OS.GetTextColor(this.handle)) == -1) {
            color = OS.GetSysColor(OS.COLOR_WINDOWTEXT);
        }
        return Color.win32_new(this.data.device, color);
    }

    public int getLineCap() {
        int style;
        Object logPen;
        int hPen;
        int size;
        if (this.handle == 0) {
            SWT.error(44);
        }
        if ((size = OS.GetObject(hPen = OS.GetCurrentObject(this.handle, 1), 0, null)) == 16) {
            logPen = new LOGPEN();
            OS.GetObject(hPen, 16, (LOGPEN)logPen);
            style = ((LOGPEN)logPen).lopnStyle | 0x200;
        } else {
            logPen = new EXTLOGPEN();
            if (size <= 28) {
                OS.GetObject(hPen, size, (EXTLOGPEN)logPen);
            } else {
                int hHeap = OS.GetProcessHeap();
                int ptr = OS.HeapAlloc(hHeap, 8, size);
                OS.GetObject(hPen, size, ptr);
                OS.MoveMemory((EXTLOGPEN)logPen, ptr, 28);
                OS.HeapFree(hHeap, 0, ptr);
            }
            style = ((EXTLOGPEN)logPen).elpPenStyle & 0xF00;
        }
        int cap = 2;
        switch (style) {
            case 0: {
                cap = 2;
                break;
            }
            case 512: {
                cap = 1;
                break;
            }
            case 256: {
                cap = 3;
            }
        }
        return cap;
    }

    public int[] getLineDash() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (this.data.dashes == null) {
            return null;
        }
        int[] dashes = new int[this.data.dashes.length];
        System.arraycopy(this.data.dashes, 0, dashes, 0, dashes.length);
        return dashes;
    }

    public int getLineJoin() {
        int style;
        Object logPen;
        int hPen;
        int size;
        if (this.handle == 0) {
            SWT.error(44);
        }
        if ((size = OS.GetObject(hPen = OS.GetCurrentObject(this.handle, 1), 0, null)) == 16) {
            logPen = new LOGPEN();
            OS.GetObject(hPen, 16, (LOGPEN)logPen);
            style = ((LOGPEN)logPen).lopnStyle | 0x2000;
        } else {
            logPen = new EXTLOGPEN();
            if (size <= 28) {
                OS.GetObject(hPen, size, (EXTLOGPEN)logPen);
            } else {
                int hHeap = OS.GetProcessHeap();
                int ptr = OS.HeapAlloc(hHeap, 8, size);
                OS.GetObject(hPen, size, ptr);
                OS.MoveMemory((EXTLOGPEN)logPen, ptr, 28);
                OS.HeapFree(hHeap, 0, ptr);
            }
            style = ((EXTLOGPEN)logPen).elpPenStyle & 0xF000;
        }
        int join = 2;
        switch (style) {
            case 8192: {
                join = 1;
                break;
            }
            case 0: {
                join = 2;
                break;
            }
            case 4096: {
                join = 3;
            }
        }
        return join;
    }

    public int getLineStyle() {
        int style;
        int hPen;
        int size;
        if (this.handle == 0) {
            SWT.error(44);
        }
        if ((size = OS.GetObject(hPen = OS.GetCurrentObject(this.handle, 1), 0, null)) == 16) {
            LOGPEN logPen = new LOGPEN();
            OS.GetObject(hPen, 16, logPen);
            style = logPen.lopnStyle;
        } else {
            EXTLOGPEN logPen = new EXTLOGPEN();
            if (size <= 28) {
                OS.GetObject(hPen, size, logPen);
            } else {
                int hHeap = OS.GetProcessHeap();
                int ptr = OS.HeapAlloc(hHeap, 8, size);
                OS.GetObject(hPen, size, ptr);
                OS.MoveMemory(logPen, ptr, 28);
                OS.HeapFree(hHeap, 0, ptr);
            }
            style = logPen.elpPenStyle & 0xF;
        }
        switch (style) {
            case 0: {
                return 1;
            }
            case 1: {
                return 2;
            }
            case 2: {
                return 3;
            }
            case 3: {
                return 4;
            }
            case 4: {
                return 5;
            }
            case 7: {
                return 6;
            }
        }
        return 1;
    }

    public int getLineWidth() {
        int hPen;
        int size;
        if (this.handle == 0) {
            SWT.error(44);
        }
        if ((size = OS.GetObject(hPen = OS.GetCurrentObject(this.handle, 1), 0, null)) == 16) {
            LOGPEN logPen = new LOGPEN();
            OS.GetObject(hPen, 16, logPen);
            return logPen.x;
        }
        EXTLOGPEN logPen = new EXTLOGPEN();
        if (size <= 28) {
            OS.GetObject(hPen, size, logPen);
        } else {
            int hHeap = OS.GetProcessHeap();
            int ptr = OS.HeapAlloc(hHeap, 8, size);
            OS.GetObject(hPen, size, ptr);
            OS.MoveMemory(logPen, ptr, 28);
            OS.HeapFree(hHeap, 0, ptr);
        }
        return logPen.elpWidth;
    }

    public int getStyle() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        return this.data.style;
    }

    public boolean getXORMode() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        int rop2 = 0;
        if (OS.IsWinCE) {
            rop2 = OS.SetROP2(this.handle, 13);
            OS.SetROP2(this.handle, rop2);
        } else {
            rop2 = OS.GetROP2(this.handle);
        }
        return rop2 == 7;
    }

    void init(Drawable drawable, GCData data, int hDC) {
        int layout;
        Image image;
        int hPalette;
        int hFont;
        int background;
        int foreground = data.foreground;
        if (foreground != -1 && OS.GetTextColor(hDC) != foreground) {
            OS.SetTextColor(hDC, foreground);
            int newPen = OS.CreatePen(0, 0, foreground);
            OS.SelectObject(hDC, newPen);
            if (data.hPen != 0) {
                OS.DeleteObject(data.hPen);
            }
            data.hPen = newPen;
        }
        if ((background = data.background) != -1 && OS.GetBkColor(hDC) != background) {
            OS.SetBkColor(hDC, background);
            int newBrush = OS.CreateSolidBrush(background);
            OS.SelectObject(hDC, newBrush);
            if (data.hBrush != 0) {
                OS.DeleteObject(data.hBrush);
            }
            data.hBrush = newBrush;
        }
        if ((hFont = data.hFont) != 0) {
            OS.SelectObject(hDC, hFont);
        }
        if ((hPalette = data.device.hPalette) != 0) {
            OS.SelectPalette(hDC, hPalette, true);
            OS.RealizePalette(hDC);
        }
        if ((image = data.image) != null) {
            data.hNullBitmap = OS.SelectObject(hDC, image.handle);
            image.memGC = this;
        }
        if ((layout = data.layout) != -1 && !OS.IsWinCE && OS.WIN32_VERSION >= OS.VERSION(4, 10)) {
            int flags = OS.GetLayout(hDC);
            if ((flags & 1) != (layout & 1)) {
                OS.SetLayout(hDC, (flags &= 0xFFFFFFFE) | layout);
            }
            if ((data.style & 0x4000000) != 0) {
                data.style |= 0x8000000;
            }
        }
        this.drawable = drawable;
        this.data = data;
        this.handle = hDC;
    }

    public int hashCode() {
        return this.handle;
    }

    public boolean isClipped() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (this.data.hwnd != 0 && this.data.ps != null) {
            return true;
        }
        int region = OS.CreateRectRgn(0, 0, 0, 0);
        int result = OS.GetClipRgn(this.handle, region);
        OS.DeleteObject(region);
        return result > 0;
    }

    public boolean isDisposed() {
        return this.handle == 0;
    }

    public void setBackground(Color color) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (color == null) {
            SWT.error(4);
        }
        if (color.isDisposed()) {
            SWT.error(5);
        }
        if (OS.GetBkColor(this.handle) == color.handle) {
            return;
        }
        this.data.background = color.handle;
        OS.SetBkColor(this.handle, color.handle);
        int newBrush = OS.CreateSolidBrush(color.handle);
        OS.SelectObject(this.handle, newBrush);
        if (this.data.hBrush != 0) {
            OS.DeleteObject(this.data.hBrush);
        }
        this.data.hBrush = newBrush;
    }

    public void setClipping(int x, int y, int width, int height) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        int hRgn = OS.CreateRectRgn(x, y, x + width, y + height);
        OS.SelectClipRgn(this.handle, hRgn);
        OS.DeleteObject(hRgn);
    }

    public void setClipping(Rectangle rect) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (rect == null) {
            OS.SelectClipRgn(this.handle, 0);
        } else {
            this.setClipping(rect.x, rect.y, rect.width, rect.height);
        }
    }

    public void setClipping(Region region) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        int hRegion = 0;
        if (region != null) {
            hRegion = region.handle;
        }
        OS.SelectClipRgn(this.handle, hRegion);
    }

    public void setFont(Font font) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (font == null) {
            OS.SelectObject(this.handle, this.data.device.systemFont);
        } else {
            if (font.isDisposed()) {
                SWT.error(5);
            }
            OS.SelectObject(this.handle, font.handle);
        }
    }

    public void setForeground(Color color) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (color == null) {
            SWT.error(4);
        }
        if (color.isDisposed()) {
            SWT.error(5);
        }
        if (OS.GetTextColor(this.handle) == color.handle) {
            return;
        }
        this.data.foreground = color.handle;
        OS.SetTextColor(this.handle, color.handle);
        this.setPen(color.handle, -1, -1, -1, -1, this.data.dashes);
    }

    public void setLineCap(int cap) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        int capStyle = 0;
        switch (cap) {
            case 2: {
                capStyle = 0;
                break;
            }
            case 1: {
                capStyle = 512;
                break;
            }
            case 3: {
                capStyle = 256;
                break;
            }
            default: {
                SWT.error(5);
            }
        }
        this.setPen(-1, -1, -1, capStyle, -1, this.data.dashes);
    }

    public void setLineDash(int[] dashes) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (dashes != null && dashes.length > 0) {
            this.data.dashes = new int[dashes.length];
            int i = 0;
            while (i < dashes.length) {
                int dash = dashes[i];
                if (dash <= 0) {
                    SWT.error(5);
                }
                this.data.dashes[i] = dash;
                ++i;
            }
        } else {
            this.data.dashes = null;
        }
        this.setPen(-1, -1, this.data.dashes == null ? 0 : 7, -1, -1, this.data.dashes);
    }

    public void setLineJoin(int join) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        int joinStyle = 0;
        switch (join) {
            case 1: {
                joinStyle = 8192;
                break;
            }
            case 2: {
                joinStyle = 0;
                break;
            }
            case 3: {
                joinStyle = 4096;
                break;
            }
            default: {
                SWT.error(5);
            }
        }
        this.setPen(-1, -1, -1, -1, joinStyle, this.data.dashes);
    }

    public void setLineStyle(int lineStyle) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        int style = -1;
        switch (lineStyle) {
            case 1: {
                style = 0;
                break;
            }
            case 2: {
                style = 1;
                break;
            }
            case 3: {
                style = 2;
                break;
            }
            case 4: {
                style = 3;
                break;
            }
            case 5: {
                style = 4;
                break;
            }
            case 6: {
                style = this.data.dashes == null ? 0 : 7;
                break;
            }
            default: {
                SWT.error(5);
            }
        }
        OS.SetBkMode(this.handle, style == 0 ? 2 : 1);
        this.setPen(-1, -1, style, -1, -1, this.data.dashes);
    }

    public void setLineWidth(int lineWidth) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        this.setPen(-1, lineWidth, -1, -1, -1, this.data.dashes);
    }

    void setPen(int newColor, int newWidth, int lineStyle, int capStyle, int joinStyle, int[] dashes) {
        int newPen;
        int style;
        int width;
        int color;
        Object logPen;
        boolean extPen = false;
        boolean changed = false;
        int hPen = OS.GetCurrentObject(this.handle, 1);
        int size = OS.GetObject(hPen, 0, null);
        if (size == 16) {
            logPen = new LOGPEN();
            OS.GetObject(hPen, 16, (LOGPEN)logPen);
            color = ((LOGPEN)logPen).lopnColor;
            width = ((LOGPEN)logPen).x;
            style = ((LOGPEN)logPen).lopnStyle;
            if (width <= 1 && (newWidth > 1 || lineStyle == 7)) {
                if (capStyle == -1) {
                    capStyle = 512;
                }
                if (joinStyle == -1) {
                    joinStyle = 8192;
                }
            }
        } else {
            logPen = new EXTLOGPEN();
            if (size <= 28) {
                OS.GetObject(hPen, size, (EXTLOGPEN)logPen);
            } else {
                int hHeap = OS.GetProcessHeap();
                int ptr = OS.HeapAlloc(hHeap, 8, size);
                OS.GetObject(hPen, size, ptr);
                OS.MoveMemory((EXTLOGPEN)logPen, ptr, 28);
                OS.HeapFree(hHeap, 0, ptr);
            }
            color = ((EXTLOGPEN)logPen).elpColor;
            width = ((EXTLOGPEN)logPen).elpWidth;
            style = ((EXTLOGPEN)logPen).elpPenStyle;
            extPen = true;
        }
        if (newColor != -1 && newColor != color) {
            color = newColor;
            changed = true;
        }
        if (newWidth != -1 && newWidth != width) {
            width = newWidth;
            changed = true;
        }
        if (lineStyle != -1 && ((style & 0xF) != lineStyle || (style & 0xF) == 7)) {
            style = style & 0xFFFFFFF0 | lineStyle;
            changed = true;
        }
        if (capStyle != -1 && (style & 0xF00) != capStyle) {
            style = style & 0xFFFFF0FF | capStyle;
            changed = true;
        }
        if (joinStyle != -1 && (style & 0xF000) != joinStyle) {
            style = style & 0xFFFF0FFF | joinStyle;
            changed = true;
        }
        if (!changed) {
            return;
        }
        if ((style & 0xF) != 7) {
            dashes = null;
        }
        if (!OS.IsWinCE && (extPen || width > 1 || (style & 0xF) == 7)) {
            LOGBRUSH logBrush = new LOGBRUSH();
            logBrush.lbStyle = 0;
            logBrush.lbColor = color;
            newPen = OS.ExtCreatePen(style | 0x10000, width, logBrush, dashes != null ? dashes.length : 0, dashes);
        } else {
            newPen = OS.CreatePen(style, width, color);
        }
        OS.SelectObject(this.handle, newPen);
        if (this.data.hPen != 0) {
            OS.DeleteObject(this.data.hPen);
        }
        this.data.hPen = newPen;
        this.data.lineWidth = width;
    }

    public void setXORMode(boolean xor) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        OS.SetROP2(this.handle, xor ? 7 : 13);
    }

    public Point stringExtent(String string) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (string == null) {
            SWT.error(4);
        }
        SIZE size = new SIZE();
        int length = string.length();
        if (length == 0) {
            OS.GetTextExtentPoint32W(this.handle, new char[]{' '}, 1, size);
            return new Point(0, size.cy);
        }
        char[] buffer = new char[length];
        string.getChars(0, length, buffer, 0);
        OS.GetTextExtentPoint32W(this.handle, buffer, length, size);
        return new Point(size.cx, size.cy);
    }

    public Point textExtent(String string) {
        return this.textExtent(string, 6);
    }

    public Point textExtent(String string, int flags) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (string == null) {
            SWT.error(4);
        }
        if (string.length() == 0) {
            SIZE size = new SIZE();
            OS.GetTextExtentPoint32W(this.handle, new char[]{' '}, 1, size);
            return new Point(0, size.cy);
        }
        RECT rect = new RECT();
        TCHAR buffer = new TCHAR(this.getCodePage(), string, false);
        int uFormat = 1024;
        if ((flags & 2) == 0) {
            uFormat |= 0x20;
        }
        if ((flags & 4) != 0) {
            uFormat |= 0x40;
        }
        if ((flags & 8) == 0) {
            uFormat |= 0x800;
        }
        OS.DrawText(this.handle, buffer, buffer.length(), rect, uFormat);
        return new Point(rect.right, rect.bottom);
    }

    public String toString() {
        if (this.isDisposed()) {
            return "GC {*DISPOSED*}";
        }
        return "GC {" + this.handle + "}";
    }

    public static GC win32_new(Drawable drawable, GCData data) {
        GC gc = new GC();
        int hDC = drawable.internal_new_GC(data);
        gc.init(drawable, data, hDC);
        return gc;
    }

    public static GC win32_new(int hDC, GCData data) {
        GC gc = new GC();
        gc.init(null, data, hDC);
        return gc;
    }
}

