/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.intro.impl;

import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.intro.impl.model.IntroModelRoot;
import org.eclipse.ui.internal.intro.impl.model.loader.ExtensionPointManager;
import org.eclipse.ui.internal.intro.impl.util.Log;
import org.eclipse.ui.intro.IIntroPart;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class IntroPlugin
extends AbstractUIPlugin {
    private static IntroPlugin inst;
    private ResourceBundle resourceBundle;
    private static String INTRO_RESOURCE_BUNDLE;

    static {
        INTRO_RESOURCE_BUNDLE = "org.eclipse.ui.internal.intro.impl.IntroPluginResources";
    }

    public static IntroPlugin getDefault() {
        return inst;
    }

    public static String getString(String key) {
        try {
            ResourceBundle bundle = IntroPlugin.getDefault().getResourceBundle();
            return bundle != null ? bundle.getString(key) : key;
        }
        catch (MissingResourceException missingResourceException) {
            Log.warning("IntroPlugin - unable to load resource bundle");
            return key;
        }
    }

    public static String getFormattedString(String key, Object[] args) {
        return MessageFormat.format(IntroPlugin.getString(key), args);
    }

    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    public ExtensionPointManager getExtensionPointManager() {
        return ExtensionPointManager.getInst();
    }

    public IntroModelRoot getIntroModelRoot() {
        return this.getExtensionPointManager().getCurrentModel();
    }

    public static IIntroPart getIntro() {
        IIntroPart introPart = PlatformUI.getWorkbench().getIntroManager().getIntro();
        return introPart;
    }

    public static IIntroPart showIntro(boolean standby) {
        IIntroPart introPart = PlatformUI.getWorkbench().getIntroManager().showIntro(PlatformUI.getWorkbench().getActiveWorkbenchWindow(), standby);
        return introPart;
    }

    public static boolean isIntroStandby() {
        return PlatformUI.getWorkbench().getIntroManager().isIntroStandby(IntroPlugin.getIntro());
    }

    public static void setIntroStandby(boolean standby) {
        PlatformUI.getWorkbench().getIntroManager().setIntroStandby(IntroPlugin.getIntro(), standby);
    }

    public static boolean closeIntro() {
        return PlatformUI.getWorkbench().getIntroManager().closeIntro(IntroPlugin.getIntro());
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        inst = this;
        try {
            this.resourceBundle = ResourceBundle.getBundle(INTRO_RESOURCE_BUNDLE);
        }
        catch (MissingResourceException missingResourceException) {
            this.resourceBundle = null;
            Log.warning("IntroPlugin - unable to load resource bundle");
        }
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
    }
}

