/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.operations;

import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Vector;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.Status;
import org.eclipse.update.configuration.IConfiguredSite;
import org.eclipse.update.configuration.IInstallConfiguration;
import org.eclipse.update.configuration.ILocalSite;
import org.eclipse.update.core.IFeature;
import org.eclipse.update.core.IFeatureReference;
import org.eclipse.update.core.IImport;
import org.eclipse.update.core.IIncludedFeatureReference;
import org.eclipse.update.core.IURLEntry;
import org.eclipse.update.core.SiteManager;
import org.eclipse.update.core.VersionedIdentifier;
import org.eclipse.update.core.model.InstallAbortedException;
import org.eclipse.update.internal.configurator.UpdateURLDecoder;
import org.eclipse.update.internal.core.Policy;
import org.eclipse.update.internal.core.UpdateCore;
import org.eclipse.update.internal.search.UpdatePolicy;
import org.eclipse.update.internal.search.UpdatesSearchCategory;
import org.eclipse.update.operations.IInstallFeatureOperation;
import org.eclipse.update.search.EnvironmentFilter;
import org.eclipse.update.search.UpdateSearchRequest;
import org.eclipse.update.search.UpdateSearchScope;

public class UpdateUtils {
    public static final String P_UPDATE_POLICY_URL = "updatePolicyURL";

    private UpdateUtils() {
    }

    public static String getPluginId() {
        return UpdateCore.getPlugin().getBundle().getSymbolicName();
    }

    public static void logException(Throwable e) {
        if (e instanceof InvocationTargetException) {
            e = ((InvocationTargetException)e).getTargetException();
        }
        IStatus status = null;
        if (e instanceof CoreException) {
            status = ((CoreException)e).getStatus();
        } else {
            String message = e.getMessage();
            if (message == null) {
                message = e.toString();
            }
            status = new Status(4, UpdateUtils.getPluginId(), 0, message, e);
        }
        UpdateUtils.log(status);
    }

    public static void log(IStatus status) {
        if (status.getSeverity() != 1) {
            UpdateCore.getPlugin().getLog().log(status);
        }
    }

    public static IFeature[] searchSite(String featureId, IConfiguredSite site, boolean onlyConfigured) throws CoreException {
        IFeatureReference[] references = null;
        references = onlyConfigured ? site.getConfiguredFeatures() : site.getSite().getFeatureReferences();
        Vector<IFeature> result = new Vector<IFeature>();
        int i = 0;
        while (i < references.length) {
            IFeature feature = references[i].getFeature(null);
            String id = feature.getVersionedIdentifier().getIdentifier();
            if (featureId.equals(id)) {
                result.add(feature);
            }
            ++i;
        }
        return result.toArray(new IFeature[result.size()]);
    }

    public static IFeature[] getInstalledFeatures(IFeature feature) {
        return UpdateUtils.getInstalledFeatures(feature, true);
    }

    public static IFeature[] getInstalledFeatures(IFeature feature, boolean onlyConfigured) {
        return UpdateUtils.getInstalledFeatures(feature.getVersionedIdentifier(), onlyConfigured);
    }

    public static IFeature[] getInstalledFeatures(VersionedIdentifier vid, boolean onlyConfigured) {
        Vector<IFeature> features = new Vector<IFeature>();
        try {
            ILocalSite localSite = SiteManager.getLocalSite();
            IInstallConfiguration config = localSite.getCurrentConfiguration();
            IConfiguredSite[] isites = config.getConfiguredSites();
            String id = vid.getIdentifier();
            int i = 0;
            while (i < isites.length) {
                IConfiguredSite isite = isites[i];
                IFeature[] result = UpdateUtils.searchSite(id, isite, onlyConfigured);
                int j = 0;
                while (j < result.length) {
                    IFeature installedFeature = result[j];
                    features.add(installedFeature);
                    ++j;
                }
                ++i;
            }
        }
        catch (CoreException e) {
            UpdateUtils.logException(e);
        }
        return features.toArray(new IFeature[features.size()]);
    }

    public static IFeature getPatchedFeature(IFeature patch) {
        IImport[] imports = patch.getImports();
        int i = 0;
        while (i < imports.length) {
            IImport iimport = imports[i];
            if (iimport.isPatch()) {
                VersionedIdentifier patchedVid = iimport.getVersionedIdentifier();
                IFeature[] features = UpdateUtils.getInstalledFeatures(patchedVid, false);
                int f = 0;
                while (f < features.length) {
                    if (patchedVid.equals(features[f].getVersionedIdentifier())) {
                        return features[f];
                    }
                    ++f;
                }
            }
            ++i;
        }
        return null;
    }

    public static boolean isPatch(IFeature candidate) {
        IImport[] imports = candidate.getImports();
        int i = 0;
        while (i < imports.length) {
            IImport iimport = imports[i];
            if (iimport.isPatch()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean isPatch(IFeature target, IFeature candidate) {
        VersionedIdentifier vid = target.getVersionedIdentifier();
        IImport[] imports = candidate.getImports();
        int i = 0;
        while (i < imports.length) {
            VersionedIdentifier ivid;
            IImport iimport = imports[i];
            if (iimport.isPatch() && vid.equals(ivid = iimport.getVersionedIdentifier())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static IInstallConfiguration getBackupConfigurationFor(IFeature feature) {
        VersionedIdentifier vid = feature.getVersionedIdentifier();
        String key = "@" + vid.getIdentifier() + "_" + vid.getVersion();
        try {
            ILocalSite lsite = SiteManager.getLocalSite();
            IInstallConfiguration[] configs = lsite.getPreservedConfigurations();
            int i = 0;
            while (i < configs.length) {
                IInstallConfiguration config = configs[i];
                if (config.getLabel().startsWith(key)) {
                    return config;
                }
                ++i;
            }
        }
        catch (CoreException coreException) {}
        return null;
    }

    public static boolean hasLicense(IFeature feature) {
        IURLEntry info = feature.getLicense();
        if (info == null) {
            return false;
        }
        String licenseTxt = info.getAnnotation();
        if (licenseTxt == null) {
            return false;
        }
        return licenseTxt.trim().length() > 0;
    }

    public static boolean hasOptionalFeatures(IFeatureReference fref) {
        try {
            return UpdateUtils.hasOptionalFeatures(fref.getFeature(null));
        }
        catch (CoreException coreException) {
            return false;
        }
    }

    public static boolean hasOptionalFeatures(IFeature feature) {
        try {
            IIncludedFeatureReference[] irefs = feature.getIncludedFeatureReferences();
            int i = 0;
            while (i < irefs.length) {
                IIncludedFeatureReference iref = irefs[i];
                if (iref.isOptional()) {
                    return true;
                }
                IFeature child = iref.getFeature(null);
                if (UpdateUtils.hasOptionalFeatures(child)) {
                    return true;
                }
                ++i;
            }
        }
        catch (CoreException coreException) {}
        return false;
    }

    public static IFeature getLocalFeature(IConfiguredSite csite, IFeature feature) throws CoreException {
        IFeatureReference[] refs = csite.getConfiguredFeatures();
        int i = 0;
        while (i < refs.length) {
            IFeatureReference ref = refs[i];
            VersionedIdentifier refVid = ref.getVersionedIdentifier();
            if (feature.getVersionedIdentifier().equals(refVid)) {
                return ref.getFeature(null);
            }
            ++i;
        }
        return null;
    }

    public static IConfiguredSite getConfigSite(IFeature feature, IInstallConfiguration config) throws CoreException {
        IConfiguredSite[] configSites = config.getConfiguredSites();
        int i = 0;
        while (i < configSites.length) {
            IConfiguredSite site = configSites[i];
            if (site.getSite().equals(feature.getSite())) {
                return site;
            }
            ++i;
        }
        return null;
    }

    public static IConfiguredSite getDefaultTargetSite(IInstallConfiguration config, IInstallFeatureOperation pendingChange) {
        return UpdateUtils.getDefaultTargetSite(config, pendingChange, true);
    }

    public static IConfiguredSite getDefaultTargetSite(IInstallConfiguration config, IInstallFeatureOperation pendingChange, boolean checkAffinityFeature) {
        IFeature oldFeature = pendingChange.getOldFeature();
        IFeature newFeature = pendingChange.getFeature();
        if (oldFeature != null) {
            try {
                return UpdateUtils.getConfigSite(oldFeature, config);
            }
            catch (CoreException e) {
                UpdateUtils.logException(e);
                return null;
            }
        }
        String newFeatureID = newFeature.getVersionedIdentifier().getIdentifier();
        IConfiguredSite sameSite = UpdateUtils.getSiteWithFeature(config, newFeatureID);
        if (sameSite != null) {
            return sameSite;
        }
        if (checkAffinityFeature) {
            return UpdateUtils.getAffinitySite(config, newFeature);
        }
        return null;
    }

    public static IConfiguredSite getAffinitySite(IInstallConfiguration config, IFeature newFeature) {
        String affinityID = newFeature.getAffinityFeature();
        if (affinityID != null) {
            IConfiguredSite affinitySite = UpdateUtils.getSiteWithFeature(config, affinityID);
            if (affinitySite != null) {
                return affinitySite;
            }
        } else {
            IFeature patchedFeature = UpdateUtils.getPatchedFeature(newFeature);
            if (patchedFeature != null) {
                return UpdateUtils.getSiteWithFeature(config, patchedFeature.getVersionedIdentifier().getIdentifier());
            }
        }
        return null;
    }

    public static IConfiguredSite getSiteWithFeature(IInstallConfiguration config, String featureID) {
        if (featureID == null) {
            return null;
        }
        IConfiguredSite[] sites = config.getConfiguredSites();
        int i = 0;
        while (i < sites.length) {
            IConfiguredSite site = sites[i];
            IFeatureReference[] refs = site.getFeatureReferences();
            int j = 0;
            while (j < refs.length) {
                IFeatureReference ref = refs[j];
                try {
                    IFeature feature = ref.getFeature(null);
                    if (featureID.equals(feature.getVersionedIdentifier().getIdentifier())) {
                        return site;
                    }
                }
                catch (CoreException e) {
                    UpdateUtils.logException(e);
                }
                ++j;
            }
            ++i;
        }
        return null;
    }

    public static void collectOldFeatures(IFeature feature, IConfiguredSite targetSite, ArrayList result) throws CoreException {
        IIncludedFeatureReference[] included = feature.getIncludedFeatureReferences();
        int i = 0;
        while (i < included.length) {
            block6: {
                IFeature ifeature;
                IIncludedFeatureReference iref = included[i];
                try {
                    ifeature = iref.getFeature(null);
                }
                catch (CoreException e) {
                    if (!iref.isOptional()) {
                        throw e;
                    }
                    break block6;
                }
                String id = iref.getVersionedIdentifier().getIdentifier();
                IFeature[] sameIds = UpdateUtils.searchSite(id, targetSite, true);
                int j = 0;
                while (j < sameIds.length) {
                    IFeature sameId = sameIds[j];
                    if (!sameId.equals(ifeature)) {
                        result.add(sameId);
                    }
                    ++j;
                }
                UpdateUtils.collectOldFeatures(ifeature, targetSite, result);
            }
            ++i;
        }
    }

    public static UpdateSearchRequest createNewUpdatesRequest(IFeature[] features) {
        UpdateSearchScope scope = new UpdateSearchScope();
        scope.setUpdateMapURL(UpdateUtils.getUpdateMapURL());
        UpdatesSearchCategory category = new UpdatesSearchCategory();
        if (features != null) {
            category.setFeatures(features);
        }
        UpdateSearchRequest searchRequest = new UpdateSearchRequest(category, scope);
        searchRequest.addFilter(new EnvironmentFilter());
        return searchRequest;
    }

    public static boolean isNestedChild(IInstallConfiguration config, IFeature feature) {
        IConfiguredSite[] csites = config.getConfiguredSites();
        try {
            int i = 0;
            while (csites != null && i < csites.length) {
                IFeatureReference[] refs = csites[i].getConfiguredFeatures();
                int j = 0;
                while (refs != null && j < refs.length) {
                    IFeature parent = refs[j].getFeature(null);
                    IIncludedFeatureReference[] children = parent.getIncludedFeatureReferences();
                    int k = 0;
                    while (children != null && k < children.length) {
                        IFeature child = children[k].getFeature(null);
                        if (feature.equals(child)) {
                            return true;
                        }
                        ++k;
                    }
                    ++j;
                }
                ++i;
            }
        }
        catch (CoreException coreException) {}
        return false;
    }

    public static boolean hasObsoletePatches(IFeature feature) {
        try {
            IIncludedFeatureReference[] irefs = feature.getIncludedFeatureReferences();
            int i = 0;
            while (i < irefs.length) {
                IIncludedFeatureReference iref = irefs[i];
                IFeature ifeature = iref.getFeature(null);
                IConfiguredSite csite = ifeature.getSite().getCurrentConfiguredSite();
                if (!csite.isConfigured(ifeature) && !UpdateUtils.isPatchHappy(ifeature)) {
                    return false;
                }
                ++i;
            }
        }
        catch (CoreException coreException) {
            return false;
        }
        return true;
    }

    public static boolean isPatchHappy(IFeature feature) throws CoreException {
        IImport[] imports = feature.getImports();
        IImport patchReference = null;
        int i = 0;
        while (i < imports.length) {
            IImport iimport = imports[i];
            if (iimport.isPatch()) {
                patchReference = iimport;
                break;
            }
            ++i;
        }
        if (patchReference == null) {
            return false;
        }
        VersionedIdentifier refVid = patchReference.getVersionedIdentifier();
        IConfiguredSite csite = feature.getSite().getCurrentConfiguredSite();
        if (csite == null) {
            return false;
        }
        IFeatureReference[] crefs = csite.getConfiguredFeatures();
        int i2 = 0;
        while (i2 < crefs.length) {
            IFeatureReference cref = crefs[i2];
            VersionedIdentifier cvid = cref.getVersionedIdentifier();
            if (cvid.getIdentifier().equals(refVid.getIdentifier()) && cvid.getVersion().isGreaterThan(refVid.getVersion())) {
                return true;
            }
            ++i2;
        }
        return false;
    }

    public static URL getUpdateMapURL() {
        Preferences pref = UpdateCore.getPlugin().getPluginPreferences();
        String mapFile = pref.getString(P_UPDATE_POLICY_URL);
        if (mapFile != null && mapFile.length() > 0) {
            try {
                String decodedFile = UpdateURLDecoder.decode((String)mapFile, (String)"UTF-8");
                return new URL(decodedFile);
            }
            catch (MalformedURLException malformedURLException) {
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {}
        }
        return null;
    }

    public static IStatus loadUpdatePolicy(UpdatePolicy map, URL url, IProgressMonitor monitor) throws CoreException {
        monitor.subTask(Policy.bind("UpdateSearchRequest.loadingPolicy"));
        try {
            map.load(url, monitor);
            monitor.worked(1);
        }
        catch (CoreException e) {
            IStatus status = e.getStatus();
            if (status == null || status.getCode() != 42) {
                throw e;
            }
            monitor.worked(1);
            return status;
        }
        return null;
    }

    /*
     * Exception decompiling
     */
    public static void downloadFeatureContent(IConfiguredSite targetSite, IFeature feature, IFeatureReference[] optionalChildren, IProgressMonitor progress) throws InstallAbortedException, CoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [2 : 469->473)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static void monitorWork(IProgressMonitor monitor, int tick) throws CoreException {
        if (monitor != null) {
            monitor.worked(tick);
            if (monitor.isCanceled()) {
                String msg = "download cancelled";
                throw new InstallAbortedException(msg, null);
            }
        }
    }
}

