/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.cheatsheets.data;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.util.Assert;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.cheatsheets.AbstractItemExtensionElement;
import org.eclipse.ui.internal.cheatsheets.CheatSheetPlugin;
import org.eclipse.ui.internal.cheatsheets.data.Action;
import org.eclipse.ui.internal.cheatsheets.data.CheatSheet;
import org.eclipse.ui.internal.cheatsheets.data.ConditionalSubItem;
import org.eclipse.ui.internal.cheatsheets.data.IActionItem;
import org.eclipse.ui.internal.cheatsheets.data.IPerformWhenItem;
import org.eclipse.ui.internal.cheatsheets.data.ISubItemItem;
import org.eclipse.ui.internal.cheatsheets.data.Item;
import org.eclipse.ui.internal.cheatsheets.data.PerformWhen;
import org.eclipse.ui.internal.cheatsheets.data.RepeatedSubItem;
import org.eclipse.ui.internal.cheatsheets.data.SubItem;
import org.eclipse.ui.internal.cheatsheets.registry.CheatSheetItemExtensionElement;
import org.eclipse.ui.internal.cheatsheets.registry.CheatSheetRegistryReader;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class CheatSheetParser {
    private static final String TRUE_STRING = "true";
    private DocumentBuilder documentBuilder = CheatSheetPlugin.getPlugin().getDocumentBuilder();
    private ArrayList itemExtensionContainerList;

    private StringBuffer escapeXMLCharacters(StringBuffer text) {
        int length = text.length();
        StringBuffer result = new StringBuffer(length);
        int i = 0;
        while (i < length) {
            char c = text.charAt(i);
            switch (c) {
                case '<': {
                    String tmp = "";
                    tmp = i + 5 < length ? text.substring(i, i + 5).toLowerCase() : text.substring(i, length).toLowerCase();
                    if (tmp.startsWith("<b>") || tmp.startsWith("</b>") || tmp.startsWith("<br/>")) {
                        result.append(c);
                        break;
                    }
                    result.append("&lt;");
                    break;
                }
                case '>': {
                    String tmp = "";
                    tmp = i >= 5 ? text.substring(i - 5, i + 1).toLowerCase() : text.substring(0, i + 1).toLowerCase();
                    if (tmp.endsWith("<b>") || tmp.endsWith("</b>") || tmp.endsWith("<br/>")) {
                        result.append(c);
                        break;
                    }
                    result.append("&gt;");
                    break;
                }
                case '&': {
                    result.append("&amp;");
                    break;
                }
                case '\'': {
                    result.append("&apos;");
                    break;
                }
                case '\"': {
                    result.append("&quot;");
                    break;
                }
                default: {
                    result.append(c);
                }
            }
            ++i;
        }
        return result;
    }

    private Node findNode(Node startNode, String nodeName) {
        if (startNode == null) {
            return null;
        }
        if (startNode.getNodeName().equals(nodeName)) {
            return startNode;
        }
        NodeList nodes = startNode.getChildNodes();
        int i = 0;
        while (i < nodes.getLength()) {
            Node node = nodes.item(i);
            if (node.getNodeName().equals(nodeName)) {
                return node;
            }
            ++i;
        }
        return null;
    }

    private void handleAction(IActionItem item, Node actionNode) throws CheatSheetParserException {
        Assert.isNotNull((Object)item);
        Assert.isNotNull((Object)actionNode);
        Assert.isTrue((boolean)actionNode.getNodeName().equals("action"));
        Action action = new Action();
        String[] params = null;
        boolean classAttr = false;
        boolean pluginId = false;
        NamedNodeMap attributes = actionNode.getAttributes();
        if (attributes != null) {
            int x = 0;
            while (x < attributes.getLength()) {
                block19: {
                    Node attribute = attributes.item(x);
                    String attributeName = attribute.getNodeName();
                    if (attribute != null && attributeName != null) {
                        if (attributeName.equals("pluginId")) {
                            pluginId = true;
                            action.setPluginID(attribute.getNodeValue());
                        } else if (attributeName.equals("class")) {
                            classAttr = true;
                            action.setClass(attribute.getNodeValue());
                        } else if (attributeName.equals("confirm")) {
                            action.setConfirm(attribute.getNodeValue().equals(TRUE_STRING));
                        } else {
                            if (attributeName.startsWith("param")) {
                                try {
                                    String paramNum;
                                    int num;
                                    if (params == null) {
                                        params = new String[9];
                                    }
                                    if ((num = Integer.parseInt(paramNum = attributeName.substring("param".length())) - 1) > -1 && num < 9) {
                                        params[num] = attribute.getNodeValue();
                                        break block19;
                                    }
                                    String message = CheatSheetPlugin.formatResourceString("%ERROR_PARSING_PARAM_INVALIDRANGE", new Object[]{attributeName, paramNum});
                                    throw new NumberFormatException(message);
                                }
                                catch (NumberFormatException e) {
                                    String message = CheatSheetPlugin.getResourceString("%ERROR_PARSING_PARAM_INVALIDNUMBER");
                                    this.logMessage(4, false, message, null, e);
                                    throw new CheatSheetParserException(message);
                                }
                            }
                            if (attributeName.equals("when")) {
                                action.setWhen(attribute.getNodeValue());
                            } else {
                                String message = CheatSheetPlugin.formatResourceString("%WARNING_PARSING_UNKNOWN_ATTRIBUTE", new Object[]{attributeName, actionNode.getNodeName()});
                                this.logMessage(2, false, message, null, null);
                            }
                        }
                    }
                }
                ++x;
            }
        }
        if (!classAttr) {
            String message = CheatSheetPlugin.formatResourceString("%ERROR_PARSING_NO_CLASS", new Object[]{actionNode.getNodeName()});
            throw new CheatSheetParserException(message);
        }
        if (!pluginId) {
            String message = CheatSheetPlugin.formatResourceString("%ERROR_PARSING_NO_PLUGINID", new Object[]{actionNode.getNodeName()});
            throw new CheatSheetParserException(message);
        }
        if (params != null) {
            action.setParams(params);
        }
        item.setAction(action);
    }

    private void handleCheatSheet(CheatSheet cheatSheet, Node cheatSheetNode) throws CheatSheetParserException {
        Assert.isNotNull((Object)cheatSheet);
        Assert.isNotNull((Object)cheatSheetNode);
        Assert.isTrue((boolean)cheatSheetNode.getNodeName().equals("cheatsheet"));
        boolean title = false;
        NamedNodeMap attributes = cheatSheetNode.getAttributes();
        if (attributes != null) {
            int x = 0;
            while (x < attributes.getLength()) {
                Node attribute = attributes.item(x);
                String attributeName = attribute.getNodeName();
                if (attribute != null && attributeName != null) {
                    if (attributeName.equals("title")) {
                        title = true;
                        cheatSheet.setTitle(attribute.getNodeValue());
                    } else {
                        String message = CheatSheetPlugin.formatResourceString("%WARNING_PARSING_UNKNOWN_ATTRIBUTE", new Object[]{attributeName, cheatSheetNode.getNodeName()});
                        this.logMessage(2, false, message, null, null);
                    }
                }
                ++x;
            }
        }
        if (!title) {
            String message = CheatSheetPlugin.formatResourceString("%ERROR_PARSING_NO_TITLE", new Object[]{cheatSheetNode.getNodeName()});
            throw new CheatSheetParserException(message);
        }
    }

    private void handleConditionalSubItem(Item item, Node conditionalSubItemNode) throws CheatSheetParserException {
        Assert.isNotNull((Object)item);
        Assert.isNotNull((Object)conditionalSubItemNode);
        Assert.isTrue((boolean)conditionalSubItemNode.getNodeName().equals("conditional-subitem"));
        ConditionalSubItem conditionalSubItem = new ConditionalSubItem();
        boolean condition = false;
        NamedNodeMap attributes = conditionalSubItemNode.getAttributes();
        if (attributes != null) {
            int x = 0;
            while (x < attributes.getLength()) {
                Node attribute = attributes.item(x);
                String attributeName = attribute.getNodeName();
                if (attribute != null && attributeName != null) {
                    if (attributeName.equals("condition")) {
                        condition = true;
                        conditionalSubItem.setCondition(attribute.getNodeValue());
                    } else {
                        String message = CheatSheetPlugin.formatResourceString("%WARNING_PARSING_UNKNOWN_ATTRIBUTE", new Object[]{attributeName, conditionalSubItemNode.getNodeName()});
                        this.logMessage(2, false, message, null, null);
                    }
                }
                ++x;
            }
        }
        if (!condition) {
            String message = CheatSheetPlugin.formatResourceString("%ERROR_PARSING_NO_CONDITION", new Object[]{conditionalSubItemNode.getNodeName()});
            throw new CheatSheetParserException(message);
        }
        boolean subitem = false;
        NodeList nodes = conditionalSubItemNode.getChildNodes();
        int i = 0;
        while (i < nodes.getLength()) {
            Node node = nodes.item(i);
            if (node.getNodeName().equals("subitem")) {
                subitem = true;
                this.handleSubItem(conditionalSubItem, node);
            } else if (node.getNodeType() != 3 && node.getNodeType() != 8) {
                String message = CheatSheetPlugin.formatResourceString("%WARNING_PARSING_UNKNOWN_ELEMENT", new Object[]{node.getNodeName(), conditionalSubItemNode.getNodeName()});
                this.logMessage(2, false, message, null, null);
            }
            ++i;
        }
        if (!subitem) {
            String message = CheatSheetPlugin.formatResourceString("%ERROR_PARSING_NO_SUBITEM", new Object[]{conditionalSubItemNode.getNodeName()});
            throw new CheatSheetParserException(message);
        }
        item.addSubItem(conditionalSubItem);
    }

    private void handleDescription(Item item, Node startNode) throws CheatSheetParserException {
        StringBuffer text;
        Assert.isNotNull((Object)item);
        Assert.isNotNull((Object)startNode);
        Node descriptionNode = this.findNode(startNode, "description");
        if (descriptionNode != null) {
            NodeList nodes = descriptionNode.getChildNodes();
            text = new StringBuffer();
            boolean containsMarkup = false;
            int i = 0;
            while (i < nodes.getLength()) {
                Node node = nodes.item(i);
                if (node.getNodeType() == 3) {
                    text.append(node.getNodeValue());
                } else if (node.getNodeType() == 1) {
                    if (node.getNodeName().equals("b")) {
                        containsMarkup = true;
                        text.append("<b>");
                        text.append(node.getFirstChild().getNodeValue());
                        text.append("</b>");
                    } else if (node.getNodeName().equals("br")) {
                        containsMarkup = true;
                        text.append("<br/>");
                    } else {
                        Node parentNode = startNode;
                        if (startNode.getNodeName().equals("description")) {
                            parentNode = startNode.getParentNode();
                        }
                        String message = CheatSheetPlugin.formatResourceString("%WARNING_PARSING_DESCRIPTION_UNKNOWN_ELEMENT", new Object[]{parentNode.getNodeName(), node.getNodeName()});
                        this.logMessage(2, false, message, null, null);
                    }
                }
                ++i;
            }
            if (containsMarkup) {
                text = this.escapeXMLCharacters(text);
                text.insert(0, "<form><p>");
                text.append("</p></form>");
            }
        } else {
            Node parentNode = startNode;
            if (startNode.getNodeName().equals("description")) {
                parentNode = startNode.getParentNode();
            }
            String message = CheatSheetPlugin.formatResourceString("%ERROR_PARSING_NO_DESCRIPTION", new Object[]{parentNode.getNodeName()});
            throw new CheatSheetParserException(message);
        }
        item.setDescription(text.toString().trim());
    }

    private void handleIntro(CheatSheet cheatSheet, Document document) throws CheatSheetParserException {
        Assert.isNotNull((Object)cheatSheet);
        Assert.isNotNull((Object)document);
        NodeList introList = document.getElementsByTagName("intro");
        Node introNode = introList.item(0);
        if (introNode == null) {
            throw new CheatSheetParserException(CheatSheetPlugin.getResourceString("%ERROR_PARSING_NO_INTRO"));
        }
        if (introList.getLength() > 1) {
            throw new CheatSheetParserException(CheatSheetPlugin.getResourceString("%ERROR_PARSING_MORE_THAN_ONE_INTRO"));
        }
        Item introItem = new Item();
        introItem.setTitle(CheatSheetPlugin.getResourceString("%CHEAT_SHEET_INTRO_TITLE"));
        this.handleIntroAttributes(introItem, introNode);
        this.handleDescription(introItem, introNode);
        cheatSheet.setIntroItem(introItem);
    }

    private void handleIntroAttributes(Item item, Node introNode) {
        Assert.isNotNull((Object)item);
        Assert.isNotNull((Object)introNode);
        NamedNodeMap attributes = introNode.getAttributes();
        if (attributes != null) {
            int x = 0;
            while (x < attributes.getLength()) {
                Node attribute = attributes.item(x);
                String attributeName = attribute.getNodeName();
                if (attribute != null && attributeName != null) {
                    if (attributeName.equals("contextId")) {
                        item.setContextId(attribute.getNodeValue());
                    } else if (attributeName.equals("href")) {
                        item.setHref(attribute.getNodeValue());
                    } else {
                        String message = CheatSheetPlugin.formatResourceString("%WARNING_PARSING_UNKNOWN_ATTRIBUTE", new Object[]{attributeName, introNode.getNodeName()});
                        this.logMessage(2, false, message, null, null);
                    }
                }
                ++x;
            }
        }
    }

    private Item handleItem(Node itemNode) throws CheatSheetParserException {
        Assert.isNotNull((Object)itemNode);
        Assert.isTrue((boolean)itemNode.getNodeName().equals("item"));
        Item item = new Item();
        this.handleItemAttributes(item, itemNode);
        boolean description = false;
        NodeList nodes = itemNode.getChildNodes();
        int i = 0;
        while (i < nodes.getLength()) {
            Node node = nodes.item(i);
            if (node.getNodeName().equals("action")) {
                this.handleAction(item, node);
            } else if (node.getNodeName().equals("description")) {
                description = true;
                this.handleDescription(item, node);
            } else if (node.getNodeName().equals("subitem")) {
                this.handleSubItem(item, node);
            } else if (node.getNodeName().equals("conditional-subitem")) {
                this.handleConditionalSubItem(item, node);
            } else if (node.getNodeName().equals("repeated-subitem")) {
                this.handleRepeatedSubItem(item, node);
            } else if (node.getNodeName().equals("perform-when")) {
                this.handlePerformWhen(item, node);
            } else if (node.getNodeType() != 3 && node.getNodeType() != 8) {
                String message = CheatSheetPlugin.formatResourceString("%WARNING_PARSING_UNKNOWN_ELEMENT", new Object[]{node.getNodeName(), itemNode.getNodeName()});
                this.logMessage(2, false, message, null, null);
            }
            ++i;
        }
        if (!description) {
            String message = CheatSheetPlugin.formatResourceString("%ERROR_PARSING_NO_DESCRIPTION", new Object[]{itemNode.getNodeName()});
            throw new CheatSheetParserException(message);
        }
        return item;
    }

    private void handleItemAttributes(Item item, Node itemNode) throws CheatSheetParserException {
        Assert.isNotNull((Object)item);
        Assert.isNotNull((Object)itemNode);
        ArrayList<AbstractItemExtensionElement[]> itemExtensionElements = new ArrayList<AbstractItemExtensionElement[]>();
        boolean title = false;
        NamedNodeMap attributes = itemNode.getAttributes();
        if (attributes != null) {
            int x = 0;
            while (x < attributes.getLength()) {
                Node attribute = attributes.item(x);
                String attributeName = attribute.getNodeName();
                if (attribute != null && attributeName != null) {
                    if (attributeName.equals("title")) {
                        title = true;
                        item.setTitle(attribute.getNodeValue());
                    } else if (attributeName.equals("contextId")) {
                        item.setContextId(attribute.getNodeValue());
                    } else if (attributeName.equals("href")) {
                        item.setHref(attribute.getNodeValue());
                    } else if (attributeName.equals("skip")) {
                        item.setSkip(attribute.getNodeValue().equals(TRUE_STRING));
                    } else {
                        AbstractItemExtensionElement[] ie = this.handleUnknownItemAttribute(attribute, itemNode);
                        if (ie != null) {
                            itemExtensionElements.add(ie);
                        }
                    }
                }
                ++x;
            }
        }
        if (!title) {
            String message = CheatSheetPlugin.formatResourceString("%ERROR_PARSING_NO_TITLE", new Object[]{itemNode.getNodeName()});
            throw new CheatSheetParserException(message);
        }
        if (itemExtensionElements != null) {
            item.setItemExtensions(itemExtensionElements);
        }
    }

    private void handleItems(CheatSheet cheatSheet, Document document) throws CheatSheetParserException {
        NodeList itemList = document.getElementsByTagName("item");
        if (itemList == null || itemList.getLength() == 0) {
            throw new CheatSheetParserException(CheatSheetPlugin.getResourceString("%ERROR_PARSING_NO_ITEM"));
        }
        ArrayList items = this.handleItems(itemList);
        if (items == null || items.size() == 0) {
            throw new CheatSheetParserException(CheatSheetPlugin.getResourceString("%ERROR_PARSING_NO_ITEM"));
        }
        cheatSheet.addItems(items);
    }

    private ArrayList handleItems(NodeList itemList) throws CheatSheetParserException {
        CheatSheetRegistryReader reader = CheatSheetRegistryReader.getInstance();
        this.itemExtensionContainerList = reader.readItemExtensions();
        ArrayList<Item> localList = new ArrayList<Item>();
        int i = 0;
        while (i < itemList.getLength()) {
            Node itemNode = itemList.item(i);
            Item item = this.handleItem(itemNode);
            localList.add(item);
            ++i;
        }
        return localList;
    }

    private void handlePerformWhen(IPerformWhenItem item, Node performWhenNode) throws CheatSheetParserException {
        Assert.isNotNull((Object)item);
        Assert.isNotNull((Object)performWhenNode);
        Assert.isTrue((boolean)performWhenNode.getNodeName().equals("perform-when"));
        PerformWhen performWhen = new PerformWhen();
        boolean condition = false;
        NamedNodeMap attributes = performWhenNode.getAttributes();
        if (attributes != null) {
            int x = 0;
            while (x < attributes.getLength()) {
                Node attribute = attributes.item(x);
                String attributeName = attribute.getNodeName();
                if (attribute != null && attributeName != null) {
                    if (attributeName.equals("condition")) {
                        condition = true;
                        performWhen.setCondition(attribute.getNodeValue());
                    } else {
                        String message = CheatSheetPlugin.formatResourceString("%WARNING_PARSING_UNKNOWN_ATTRIBUTE", new Object[]{attributeName, performWhenNode.getNodeName()});
                        this.logMessage(2, false, message, null, null);
                    }
                }
                ++x;
            }
        }
        if (!condition) {
            String message = CheatSheetPlugin.formatResourceString("%ERROR_PARSING_NO_CONDITION", new Object[]{performWhenNode.getNodeName()});
            throw new CheatSheetParserException(message);
        }
        boolean action = false;
        NodeList nodes = performWhenNode.getChildNodes();
        int i = 0;
        while (i < nodes.getLength()) {
            Node node = nodes.item(i);
            if (node.getNodeName().equals("action")) {
                action = true;
                this.handleAction(performWhen, node);
            } else if (node.getNodeType() != 3 && node.getNodeType() != 8) {
                String message = CheatSheetPlugin.formatResourceString("%WARNING_PARSING_UNKNOWN_ELEMENT", new Object[]{node.getNodeName(), performWhenNode.getNodeName()});
                this.logMessage(2, false, message, null, null);
            }
            ++i;
        }
        if (!action) {
            String message = CheatSheetPlugin.formatResourceString("%ERROR_PARSING_NO_ACTION", new Object[]{performWhenNode.getNodeName()});
            throw new CheatSheetParserException(message);
        }
        item.setPerformWhen(performWhen);
    }

    private void handleRepeatedSubItem(Item item, Node repeatedSubItemNode) throws CheatSheetParserException {
        Assert.isNotNull((Object)item);
        Assert.isNotNull((Object)repeatedSubItemNode);
        Assert.isTrue((boolean)repeatedSubItemNode.getNodeName().equals("repeated-subitem"));
        RepeatedSubItem repeatedSubItem = new RepeatedSubItem();
        boolean values = false;
        NamedNodeMap attributes = repeatedSubItemNode.getAttributes();
        if (attributes != null) {
            int x = 0;
            while (x < attributes.getLength()) {
                Node attribute = attributes.item(x);
                String attributeName = attribute.getNodeName();
                if (attribute != null && attributeName != null) {
                    if (attributeName.equals("values")) {
                        values = true;
                        repeatedSubItem.setValues(attribute.getNodeValue());
                    } else {
                        String message = CheatSheetPlugin.formatResourceString("%WARNING_PARSING_UNKNOWN_ATTRIBUTE", new Object[]{attributeName, repeatedSubItemNode.getNodeName()});
                        this.logMessage(2, false, message, null, null);
                    }
                }
                ++x;
            }
        }
        if (!values) {
            String message = CheatSheetPlugin.formatResourceString("%ERROR_PARSING_NO_VALUES", new Object[]{repeatedSubItemNode.getNodeName()});
            throw new CheatSheetParserException(message);
        }
        boolean subitem = false;
        NodeList nodes = repeatedSubItemNode.getChildNodes();
        int i = 0;
        while (i < nodes.getLength()) {
            Node node = nodes.item(i);
            if (node.getNodeName().equals("subitem")) {
                subitem = true;
                this.handleSubItem(repeatedSubItem, node);
            } else if (node.getNodeType() != 3 && node.getNodeType() != 8) {
                String message = CheatSheetPlugin.formatResourceString("%WARNING_PARSING_UNKNOWN_ELEMENT", new Object[]{node.getNodeName(), repeatedSubItemNode.getNodeName()});
                this.logMessage(2, false, message, null, null);
            }
            ++i;
        }
        if (!subitem) {
            String message = CheatSheetPlugin.formatResourceString("%ERROR_PARSING_NO_SUBITEM", new Object[]{repeatedSubItemNode.getNodeName()});
            throw new CheatSheetParserException(message);
        }
        item.addSubItem(repeatedSubItem);
    }

    private void handleSubItem(ISubItemItem item, Node subItemNode) throws CheatSheetParserException {
        Assert.isNotNull((Object)item);
        Assert.isNotNull((Object)subItemNode);
        Assert.isTrue((boolean)subItemNode.getNodeName().equals("subitem"));
        SubItem subItem = new SubItem();
        this.handleSubItemAttributes(subItem, subItemNode);
        NodeList nodes = subItemNode.getChildNodes();
        int i = 0;
        while (i < nodes.getLength()) {
            Node node = nodes.item(i);
            if (node.getNodeName().equals("action")) {
                this.handleAction(subItem, node);
            } else if (node.getNodeName().equals("perform-when")) {
                this.handlePerformWhen(subItem, node);
            } else if (node.getNodeType() != 3 && node.getNodeType() != 8) {
                String message = CheatSheetPlugin.formatResourceString("%WARNING_PARSING_UNKNOWN_ELEMENT", new Object[]{node.getNodeName(), subItemNode.getNodeName()});
                this.logMessage(2, false, message, null, null);
            }
            ++i;
        }
        item.addSubItem(subItem);
    }

    private void handleSubItemAttributes(SubItem subItem, Node subItemNode) throws CheatSheetParserException {
        Assert.isNotNull((Object)subItem);
        Assert.isNotNull((Object)subItemNode);
        boolean label = false;
        NamedNodeMap attributes = subItemNode.getAttributes();
        if (attributes != null) {
            int x = 0;
            while (x < attributes.getLength()) {
                Node attribute = attributes.item(x);
                String attributeName = attribute.getNodeName();
                if (attribute != null && attributeName != null) {
                    if (attributeName.equals("label")) {
                        label = true;
                        subItem.setLabel(attribute.getNodeValue());
                    } else if (attributeName.equals("skip")) {
                        subItem.setSkip(attribute.getNodeValue().equals(TRUE_STRING));
                    } else if (attributeName.equals("when")) {
                        subItem.setWhen(attribute.getNodeValue());
                    } else {
                        String message = CheatSheetPlugin.formatResourceString("%WARNING_PARSING_UNKNOWN_ATTRIBUTE", new Object[]{attributeName, subItemNode.getNodeName()});
                        this.logMessage(2, false, message, null, null);
                    }
                }
                ++x;
            }
        }
        if (!label) {
            String message = CheatSheetPlugin.formatResourceString("%ERROR_PARSING_NO_LABEL", new Object[]{subItemNode.getNodeName()});
            throw new CheatSheetParserException(message);
        }
    }

    private AbstractItemExtensionElement[] handleUnknownItemAttribute(Node item, Node node) {
        ArrayList<AbstractItemExtensionElement> al = new ArrayList<AbstractItemExtensionElement>();
        if (this.itemExtensionContainerList == null) {
            return null;
        }
        int i = 0;
        while (i < this.itemExtensionContainerList.size()) {
            AbstractItemExtensionElement itemElement;
            CheatSheetItemExtensionElement itemExtensionElement = (CheatSheetItemExtensionElement)((Object)this.itemExtensionContainerList.get(i));
            if (itemExtensionElement.getItemAttribute().equals(item.getNodeName()) && (itemElement = itemExtensionElement.createInstance()) != null) {
                itemElement.handleAttribute(item.getNodeValue());
                al.add(itemElement);
            }
            ++i;
        }
        if (al.size() == 0) {
            String message = CheatSheetPlugin.formatResourceString("%WARNING_PARSING_UNKNOWN_ATTRIBUTE", new Object[]{item.getNodeName(), node.getNodeName()});
            this.logMessage(2, false, message, null, null);
        }
        return al.toArray(new AbstractItemExtensionElement[al.size()]);
    }

    private void logMessage(int severity, boolean informUser, String message, String title, Throwable exception) {
        Status status = new Status(severity, "org.eclipse.ui.cheatsheets", 0, message, exception);
        CheatSheetPlugin.getPlugin().getLog().log((IStatus)status);
        if (informUser) {
            ErrorDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)title, null, (IStatus)status);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public CheatSheet parse(URL url) {
        Document document;
        InputStream is;
        block21: {
            CheatSheet cheatSheet;
            block20: {
                if (url == null) {
                    return null;
                }
                is = null;
                InputSource inputSource = null;
                try {
                    is = url.openStream();
                    if (is != null) {
                        inputSource = new InputSource(is);
                    }
                }
                catch (Exception e) {
                    String message = CheatSheetPlugin.formatResourceString("%ERROR_OPENING_FILE", new Object[]{url.getFile()});
                    this.logMessage(4, true, message, CheatSheetPlugin.getResourceString("%ERROR_TITLE"), e);
                    return null;
                }
                try {
                    try {
                        if (this.documentBuilder == null) {
                            this.logMessage(4, false, CheatSheetPlugin.getResourceString("%ERROR_DOCUMENT_BUILDER_NOT_INIT"), null, null);
                            cheatSheet = null;
                            Object var7_14 = null;
                            break block20;
                        }
                        document = this.documentBuilder.parse(inputSource);
                        break block21;
                    }
                    catch (IOException e) {
                        String message = CheatSheetPlugin.formatResourceString("%ERROR_OPENING_FILE_IN_PARSER", new Object[]{url.getFile()});
                        this.logMessage(4, false, message, null, e);
                        CheatSheet cheatSheet2 = null;
                        Object var7_15 = null;
                        try {
                            is.close();
                            return cheatSheet2;
                        }
                        catch (Exception exception) {}
                        return cheatSheet2;
                    }
                    catch (SAXParseException spe) {
                        String message = CheatSheetPlugin.formatResourceString("%ERROR_SAX_PARSING_WITH_LOCATION", new Object[]{url.getFile(), new Integer(spe.getLineNumber()), new Integer(spe.getColumnNumber())});
                        this.logMessage(4, false, message, null, spe);
                        CheatSheet cheatSheet3 = null;
                        Object var7_16 = null;
                        try {}
                        catch (Exception exception) {}
                        is.close();
                        return cheatSheet3;
                    }
                    catch (SAXException se) {
                        String message = CheatSheetPlugin.formatResourceString("%ERROR_SAX_PARSING", new Object[]{url.getFile()});
                        this.logMessage(4, false, message, null, se);
                        CheatSheet cheatSheet4 = null;
                        Object var7_17 = null;
                        try {}
                        catch (Exception exception) {}
                        is.close();
                        return cheatSheet4;
                    }
                }
                catch (Throwable throwable) {
                    Object var7_18 = null;
                    try {}
                    catch (Exception exception) {}
                    is.close();
                    throw throwable;
                    throw throwable;
                }
            }
            try {}
            catch (Exception exception) {}
            is.close();
            return cheatSheet;
        }
        Object var7_19 = null;
        try {}
        catch (Exception exception) {
            return this.parseCheatSheet(document);
        }
        is.close();
        return this.parseCheatSheet(document);
    }

    private CheatSheet parseCheatSheet(Document document) throws CheatSheetParserException {
        if (document != null) {
            Element rootnode = document.getDocumentElement();
            if (!rootnode.getNodeName().equals("cheatsheet")) {
                throw new CheatSheetParserException(CheatSheetPlugin.getResourceString("%ERROR_PARSING_CHEATSHEET_ELEMENT"));
            }
            CheatSheet cheatSheet = new CheatSheet();
            this.handleCheatSheet(cheatSheet, rootnode);
            this.handleIntro(cheatSheet, document);
            this.handleItems(cheatSheet, document);
            return cheatSheet;
        }
        throw new CheatSheetParserException(CheatSheetPlugin.getResourceString("%ERROR_PARSING_CHEATSHEET_CONTENTS"));
    }

    private String getNormalizedText(String text) {
        int[] spaceCounter = new int[1];
        StringBuffer buf = new StringBuffer();
        if (text == null) {
            return null;
        }
        int j = 0;
        while (j < text.length()) {
            char c = text.charAt(j);
            if (c == ' ' || c == '\t') {
                spaceCounter[0] = spaceCounter[0] + 1;
                if (spaceCounter[0] == 1) {
                    buf.append(c);
                }
            } else if (c == '\n' || c == '\r' || c == '\f') {
                spaceCounter[0] = spaceCounter[0] + 1;
                if (spaceCounter[0] == 1) {
                    buf.append(' ');
                }
            } else {
                spaceCounter[0] = 0;
                buf.append(c);
            }
            ++j;
        }
        return buf.toString();
    }

    class CheatSheetParserException
    extends Exception {
        private static final long serialVersionUID = 6009335074727417445L;

        public CheatSheetParserException(String message) {
            super(message);
        }
    }
}

