/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.text.contentassist;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.contentassist.IContentAssistSubjectControl;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.IEditingSupport;
import org.eclipse.jface.text.IEditingSupportRegistry;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.IRewriteTarget;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITextViewerExtension;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.contentassist.AdditionalInfoController;
import org.eclipse.jface.text.contentassist.ContentAssistSubjectControlAdapter;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.Helper;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension2;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension3;
import org.eclipse.jface.text.contentassist.IContentAssistListener;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.PopupCloser;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;

class CompletionProposalPopup
implements IContentAssistListener {
    private ITextViewer fViewer;
    private ContentAssistant fContentAssistant;
    private AdditionalInfoController fAdditionalInfoController;
    private PopupCloser fPopupCloser = new PopupCloser();
    private Shell fProposalShell;
    private Table fProposalTable;
    private boolean fInserting = false;
    private ProposalSelectionListener fKeyListener;
    private List fDocumentEvents = new ArrayList();
    private IDocumentListener fDocumentListener;
    private long fInvocationCounter = 0L;
    private ICompletionProposal[] fFilteredProposals;
    private ICompletionProposal[] fComputedProposals;
    private int fInvocationOffset;
    private int fFilterOffset;
    private String fLineDelimiter;
    private ICompletionProposal fLastProposal;
    private IContentAssistSubjectControl fContentAssistSubjectControl;
    private ContentAssistSubjectControlAdapter fContentAssistSubjectControlAdapter;
    private Point fSize;
    private IEditingSupport fFocusHelper;

    public CompletionProposalPopup(ContentAssistant contentAssistant, ITextViewer viewer, AdditionalInfoController infoController) {
        this.fContentAssistant = contentAssistant;
        this.fViewer = viewer;
        this.fAdditionalInfoController = infoController;
        this.fContentAssistSubjectControlAdapter = new ContentAssistSubjectControlAdapter(this.fViewer);
    }

    public CompletionProposalPopup(ContentAssistant contentAssistant, IContentAssistSubjectControl contentAssistSubjectControl, AdditionalInfoController infoController) {
        this.fContentAssistant = contentAssistant;
        this.fContentAssistSubjectControl = contentAssistSubjectControl;
        this.fAdditionalInfoController = infoController;
        this.fContentAssistSubjectControlAdapter = new ContentAssistSubjectControlAdapter(this.fContentAssistSubjectControl);
    }

    public String showProposals(final boolean autoActivated) {
        if (this.fKeyListener == null) {
            this.fKeyListener = new ProposalSelectionListener();
        }
        final Control control = this.fContentAssistSubjectControlAdapter.getControl();
        if (!Helper.okToUse((Widget)this.fProposalShell) && control != null && !control.isDisposed()) {
            this.fContentAssistSubjectControlAdapter.addKeyListener(this.fKeyListener);
            BusyIndicator.showWhile((Display)control.getDisplay(), (Runnable)new Runnable(){

                public void run() {
                    int count;
                    CompletionProposalPopup.this.fInvocationOffset = ((CompletionProposalPopup)CompletionProposalPopup.this).fContentAssistSubjectControlAdapter.getSelectedRange().x;
                    CompletionProposalPopup.this.fFilterOffset = CompletionProposalPopup.this.fInvocationOffset;
                    CompletionProposalPopup.this.fComputedProposals = CompletionProposalPopup.this.computeProposals(CompletionProposalPopup.this.fInvocationOffset);
                    int n = count = CompletionProposalPopup.this.fComputedProposals == null ? 0 : CompletionProposalPopup.this.fComputedProposals.length;
                    if (count == 0) {
                        if (!autoActivated) {
                            control.getDisplay().beep();
                        }
                        CompletionProposalPopup.this.hide();
                    } else if (count == 1 && !autoActivated && CompletionProposalPopup.this.fContentAssistant.isAutoInserting()) {
                        CompletionProposalPopup.this.insertProposal(CompletionProposalPopup.this.fComputedProposals[0], '\u0000', 0, CompletionProposalPopup.this.fInvocationOffset);
                        CompletionProposalPopup.this.hide();
                    } else {
                        if (CompletionProposalPopup.this.fLineDelimiter == null) {
                            CompletionProposalPopup.this.fLineDelimiter = CompletionProposalPopup.this.fContentAssistSubjectControlAdapter.getLineDelimiter();
                        }
                        CompletionProposalPopup.this.createProposalSelector();
                        CompletionProposalPopup.this.setProposals(CompletionProposalPopup.this.fComputedProposals);
                        CompletionProposalPopup.this.displayProposals();
                    }
                }
            });
        }
        return this.getErrorMessage();
    }

    private ICompletionProposal[] computeProposals(int offset) {
        if (this.fContentAssistSubjectControl != null) {
            return this.fContentAssistant.computeCompletionProposals(this.fContentAssistSubjectControl, offset);
        }
        return this.fContentAssistant.computeCompletionProposals(this.fViewer, offset);
    }

    private String getErrorMessage() {
        return this.fContentAssistant.getErrorMessage();
    }

    private void createProposalSelector() {
        Color c;
        if (Helper.okToUse((Widget)this.fProposalShell)) {
            return;
        }
        Control control = this.fContentAssistSubjectControlAdapter.getControl();
        this.fProposalShell = new Shell(control.getShell(), 16400);
        this.fProposalTable = new Table((Composite)this.fProposalShell, 768);
        this.fProposalTable.setLocation(0, 0);
        if (this.fAdditionalInfoController != null) {
            this.fAdditionalInfoController.setSizeConstraints(50, 10, true, false);
        }
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        this.fProposalShell.setLayout((Layout)layout);
        GridData data = new GridData(1808);
        Point size = this.fContentAssistant.restoreCompletionProposalPopupSize();
        if (size != null) {
            this.fProposalTable.setLayoutData((Object)data);
            this.fProposalShell.setSize(size);
        } else {
            data.heightHint = this.fProposalTable.getItemHeight() * 10;
            data.widthHint = 300;
            this.fProposalTable.setLayoutData((Object)data);
            this.fProposalShell.pack();
        }
        this.fProposalShell.addControlListener(new ControlListener(){

            public void controlMoved(ControlEvent e) {
            }

            public void controlResized(ControlEvent e) {
                if (CompletionProposalPopup.this.fAdditionalInfoController != null) {
                    CompletionProposalPopup.this.fAdditionalInfoController.setSizeConstraints(50, 10, true, false);
                }
                CompletionProposalPopup.this.fSize = CompletionProposalPopup.this.fProposalShell.getSize();
            }
        });
        if (!"carbon".equals(SWT.getPlatform())) {
            this.fProposalShell.setBackground(control.getDisplay().getSystemColor(2));
        }
        if ((c = this.fContentAssistant.getProposalSelectorBackground()) == null) {
            c = control.getDisplay().getSystemColor(29);
        }
        this.fProposalTable.setBackground(c);
        c = this.fContentAssistant.getProposalSelectorForeground();
        if (c == null) {
            c = control.getDisplay().getSystemColor(28);
        }
        this.fProposalTable.setForeground(c);
        this.fProposalTable.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                CompletionProposalPopup.this.selectProposalWithMask(e.stateMask);
            }
        });
        this.fPopupCloser.install(this.fContentAssistant, this.fProposalTable);
        this.fProposalShell.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                CompletionProposalPopup.this.unregister();
            }
        });
        this.fProposalTable.setHeaderVisible(false);
        this.fContentAssistant.addToLayout(this, this.fProposalShell, 0, this.fContentAssistant.getSelectionOffset());
    }

    private ICompletionProposal getSelectedProposal() {
        int i = this.fProposalTable.getSelectionIndex();
        if (this.fFilteredProposals == null || i < 0 || i >= this.fFilteredProposals.length) {
            return null;
        }
        return this.fFilteredProposals[i];
    }

    private void selectProposalWithMask(int stateMask) {
        ICompletionProposal p = this.getSelectedProposal();
        this.hide();
        if (p != null) {
            this.insertProposal(p, '\u0000', stateMask, this.fContentAssistSubjectControlAdapter.getSelectedRange().x);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void insertProposal(ICompletionProposal p, char trigger, int stateMask, final int offset) {
        IEditingSupport helper;
        block19: {
            this.fInserting = true;
            IRewriteTarget target = null;
            helper = new IEditingSupport(){

                public boolean isSourceOfEvent(Object event) {
                    return true;
                }

                public boolean isOriginator(DocumentEvent event, IRegion focus) {
                    return focus.getOffset() <= offset && focus.getOffset() + focus.getLength() >= offset;
                }

                public boolean ownsFocusShell() {
                    return false;
                }
            };
            try {
                IContextInformation info;
                Object e;
                IDocument document = this.fContentAssistSubjectControlAdapter.getDocument();
                if (this.fViewer instanceof ITextViewerExtension) {
                    ITextViewerExtension extension = (ITextViewerExtension)((Object)this.fViewer);
                    target = extension.getRewriteTarget();
                }
                if (target != null) {
                    target.beginCompoundChange();
                }
                if (this.fViewer instanceof IEditingSupportRegistry) {
                    IEditingSupportRegistry registry = (IEditingSupportRegistry)((Object)this.fViewer);
                    registry.register(helper);
                }
                if (p instanceof ICompletionProposalExtension2 && this.fViewer != null) {
                    e = (ICompletionProposalExtension2)((Object)p);
                    e.apply(this.fViewer, trigger, stateMask, offset);
                } else if (p instanceof ICompletionProposalExtension) {
                    e = (ICompletionProposalExtension)((Object)p);
                    e.apply(document, trigger, offset);
                } else {
                    p.apply(document);
                }
                Point selection = p.getSelection(document);
                if (selection != null) {
                    this.fContentAssistSubjectControlAdapter.setSelectedRange(selection.x, selection.y);
                    this.fContentAssistSubjectControlAdapter.revealRange(selection.x, selection.y);
                }
                if ((info = p.getContextInformation()) != null) {
                    int contextInformationOffset;
                    if (p instanceof ICompletionProposalExtension) {
                        ICompletionProposalExtension e2 = (ICompletionProposalExtension)((Object)p);
                        contextInformationOffset = e2.getContextInformationPosition();
                    } else {
                        if (selection == null) {
                            selection = this.fContentAssistSubjectControlAdapter.getSelectedRange();
                        }
                        contextInformationOffset = selection.x + selection.y;
                    }
                    this.fContentAssistant.showContextInformation(info, contextInformationOffset);
                } else {
                    this.fContentAssistant.showContextInformation(null, -1);
                }
            }
            catch (Throwable throwable) {
                Object var12_13 = null;
                if (target != null) {
                    target.endCompoundChange();
                }
                if (this.fViewer instanceof IEditingSupportRegistry) {
                    IEditingSupportRegistry registry = (IEditingSupportRegistry)((Object)this.fViewer);
                    registry.unregister(helper);
                }
                this.fInserting = false;
                throw throwable;
            }
            {
                Object var12_14 = null;
                if (target == null) break block19;
                target.endCompoundChange();
            }
        }
        if (this.fViewer instanceof IEditingSupportRegistry) {
            IEditingSupportRegistry registry = (IEditingSupportRegistry)((Object)this.fViewer);
            registry.unregister(helper);
        }
        this.fInserting = false;
    }

    public boolean hasFocus() {
        if (Helper.okToUse((Widget)this.fProposalShell)) {
            return this.fProposalShell.isFocusControl() || this.fProposalTable.isFocusControl();
        }
        return false;
    }

    public void hide() {
        this.unregister();
        if (this.fViewer instanceof IEditingSupportRegistry) {
            IEditingSupportRegistry registry = (IEditingSupportRegistry)((Object)this.fViewer);
            registry.unregister(this.fFocusHelper);
        }
        if (Helper.okToUse((Widget)this.fProposalShell)) {
            this.fContentAssistant.removeContentAssistListener(this, 1);
            this.fPopupCloser.uninstall();
            this.fProposalShell.setVisible(false);
            this.fProposalShell.dispose();
            this.fProposalShell = null;
        }
    }

    private void unregister() {
        if (this.fDocumentListener != null) {
            IDocument document = this.fContentAssistSubjectControlAdapter.getDocument();
            if (document != null) {
                document.removeDocumentListener(this.fDocumentListener);
            }
            this.fDocumentListener = null;
        }
        this.fDocumentEvents.clear();
        if (this.fKeyListener != null && this.fContentAssistSubjectControlAdapter.getControl() != null && !this.fContentAssistSubjectControlAdapter.getControl().isDisposed()) {
            this.fContentAssistSubjectControlAdapter.removeKeyListener(this.fKeyListener);
            this.fKeyListener = null;
        }
        if (this.fLastProposal != null) {
            if (this.fLastProposal instanceof ICompletionProposalExtension2 && this.fViewer != null) {
                ICompletionProposalExtension2 extension = (ICompletionProposalExtension2)((Object)this.fLastProposal);
                extension.unselected(this.fViewer);
            }
            this.fLastProposal = null;
        }
        this.fFilteredProposals = null;
        this.fComputedProposals = null;
        this.fContentAssistant.possibleCompletionsClosed();
    }

    public boolean isActive() {
        return this.fProposalShell != null && !this.fProposalShell.isDisposed();
    }

    private void setProposals(ICompletionProposal[] proposals) {
        if (Helper.okToUse((Widget)this.fProposalTable)) {
            ICompletionProposal oldProposal = this.getSelectedProposal();
            if (oldProposal instanceof ICompletionProposalExtension2 && this.fViewer != null) {
                ((ICompletionProposalExtension2)((Object)oldProposal)).unselected(this.fViewer);
            }
            this.fFilteredProposals = proposals;
            this.fProposalTable.setRedraw(false);
            this.fProposalTable.removeAll();
            int i = 0;
            while (i < proposals.length) {
                ICompletionProposal p = proposals[i];
                TableItem item = new TableItem(this.fProposalTable, 0);
                if (p.getImage() != null) {
                    item.setImage(p.getImage());
                }
                item.setText(p.getDisplayString());
                item.setData((Object)p);
                ++i;
            }
            Point currentLocation = this.fProposalShell.getLocation();
            Point newLocation = this.getLocation();
            if (newLocation.x < currentLocation.x && newLocation.y == currentLocation.y || newLocation.y < currentLocation.y) {
                this.fProposalShell.setLocation(newLocation);
            }
            this.selectProposal(0, false);
            this.fProposalTable.setRedraw(true);
        }
    }

    private Point getLocation() {
        int caret = this.fContentAssistSubjectControlAdapter.getCaretOffset();
        Point p = this.fContentAssistSubjectControlAdapter.getLocationAtOffset(caret);
        if (p.x < 0) {
            p.x = 0;
        }
        if (p.y < 0) {
            p.y = 0;
        }
        p = new Point(p.x, p.y + this.fContentAssistSubjectControlAdapter.getLineHeight());
        p = this.fContentAssistSubjectControlAdapter.getControl().toDisplay(p);
        if (p.x < 0) {
            p.x = 0;
        }
        if (p.y < 0) {
            p.y = 0;
        }
        return p;
    }

    Point getSize() {
        return this.fSize;
    }

    private void displayProposals() {
        if (!Helper.okToUse((Widget)this.fProposalShell) || !Helper.okToUse((Widget)this.fProposalTable)) {
            return;
        }
        if (this.fContentAssistant.addContentAssistListener(this, 1)) {
            IDocument document;
            if (this.fDocumentListener == null) {
                this.fDocumentListener = new IDocumentListener(){

                    public void documentAboutToBeChanged(DocumentEvent event) {
                        if (!CompletionProposalPopup.this.fInserting) {
                            CompletionProposalPopup.this.fDocumentEvents.add(event);
                        }
                    }

                    public void documentChanged(DocumentEvent event) {
                        if (!CompletionProposalPopup.this.fInserting) {
                            CompletionProposalPopup.this.filterProposals();
                        }
                    }
                };
            }
            if ((document = this.fContentAssistSubjectControlAdapter.getDocument()) != null) {
                document.addDocumentListener(this.fDocumentListener);
            }
            if (this.fFocusHelper == null) {
                this.fFocusHelper = new IEditingSupport(){

                    public boolean isSourceOfEvent(Object event) {
                        return false;
                    }

                    public boolean isOriginator(DocumentEvent event, IRegion focus) {
                        return false;
                    }

                    public boolean ownsFocusShell() {
                        return true;
                    }
                };
            }
            if (this.fViewer instanceof IEditingSupportRegistry) {
                IEditingSupportRegistry registry = (IEditingSupportRegistry)((Object)this.fViewer);
                registry.register(this.fFocusHelper);
            }
            this.fProposalShell.setVisible(true);
            if (!this.fContentAssistSubjectControlAdapter.supportsVerifyKeyListener() && Helper.okToUse((Widget)this.fProposalShell)) {
                this.fProposalShell.setFocus();
            }
            if (this.fAdditionalInfoController != null && Helper.okToUse((Widget)this.fProposalTable)) {
                this.fAdditionalInfoController.install((Control)this.fProposalTable);
                this.fAdditionalInfoController.handleTableSelectionChanged();
            }
        }
    }

    public boolean verifyKey(VerifyEvent e) {
        if (!Helper.okToUse((Widget)this.fProposalShell)) {
            return true;
        }
        char key = e.character;
        if (key == '\u0000') {
            int newSelection = this.fProposalTable.getSelectionIndex();
            int visibleRows = this.fProposalTable.getSize().y / this.fProposalTable.getItemHeight() - 1;
            boolean smartToggle = false;
            switch (e.keyCode) {
                case 0x1000003: 
                case 0x1000004: {
                    this.filterProposals();
                    return true;
                }
                case 0x1000001: {
                    if (--newSelection >= 0) break;
                    newSelection = this.fProposalTable.getItemCount() - 1;
                    break;
                }
                case 0x1000002: {
                    if (++newSelection <= this.fProposalTable.getItemCount() - 1) break;
                    newSelection = 0;
                    break;
                }
                case 0x1000006: {
                    if ((newSelection += visibleRows) < this.fProposalTable.getItemCount()) break;
                    newSelection = this.fProposalTable.getItemCount() - 1;
                    break;
                }
                case 0x1000005: {
                    if ((newSelection -= visibleRows) >= 0) break;
                    newSelection = 0;
                    break;
                }
                case 0x1000007: {
                    newSelection = 0;
                    break;
                }
                case 0x1000008: {
                    newSelection = this.fProposalTable.getItemCount() - 1;
                    break;
                }
                default: {
                    if (e.keyCode != 16777298 && e.keyCode != SWT.MOD1 && e.keyCode != SWT.MOD2 && e.keyCode != SWT.MOD3 && e.keyCode != SWT.MOD4) {
                        this.hide();
                    }
                    return true;
                }
            }
            this.selectProposal(newSelection, smartToggle);
            e.doit = false;
            return false;
        }
        switch (key) {
            case '\u001b': {
                e.doit = false;
                this.hide();
                break;
            }
            case '\n': 
            case '\r': {
                e.doit = false;
                this.selectProposalWithMask(e.stateMask);
                break;
            }
            case '\t': {
                e.doit = false;
                this.fProposalShell.setFocus();
                return false;
            }
            default: {
                ICompletionProposalExtension t;
                char[] triggers;
                ICompletionProposal p = this.getSelectedProposal();
                if (!(p instanceof ICompletionProposalExtension) || !this.contains(triggers = (t = (ICompletionProposalExtension)((Object)p)).getTriggerCharacters(), key)) break;
                e.doit = false;
                this.hide();
                this.insertProposal(p, key, e.stateMask, this.fContentAssistSubjectControlAdapter.getSelectedRange().x);
            }
        }
        return true;
    }

    private void selectProposal(int index, boolean smartToggle) {
        ICompletionProposal proposal;
        if (this.fFilteredProposals == null) {
            return;
        }
        ICompletionProposal oldProposal = this.getSelectedProposal();
        if (oldProposal instanceof ICompletionProposalExtension2 && this.fViewer != null) {
            ((ICompletionProposalExtension2)((Object)oldProposal)).unselected(this.fViewer);
        }
        if ((proposal = this.fFilteredProposals[index]) instanceof ICompletionProposalExtension2 && this.fViewer != null) {
            ((ICompletionProposalExtension2)((Object)proposal)).selected(this.fViewer, smartToggle);
        }
        this.fLastProposal = proposal;
        this.fProposalTable.setSelection(index);
        this.fProposalTable.showSelection();
        if (this.fAdditionalInfoController != null) {
            this.fAdditionalInfoController.handleTableSelectionChanged();
        }
    }

    private boolean contains(char[] characters, char c) {
        if (characters == null) {
            return false;
        }
        int i = 0;
        while (i < characters.length) {
            if (c == characters[i]) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void processEvent(VerifyEvent e) {
    }

    private void filterProposals() {
        ++this.fInvocationCounter;
        final Control control = this.fContentAssistSubjectControlAdapter.getControl();
        control.getDisplay().asyncExec(new Runnable(){
            long fCounter;
            {
                this.fCounter = CompletionProposalPopup.this.fInvocationCounter;
            }

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run() {
                if (this.fCounter != CompletionProposalPopup.this.fInvocationCounter) {
                    return;
                }
                if (control.isDisposed()) {
                    return;
                }
                int offset = ((CompletionProposalPopup)CompletionProposalPopup.this).fContentAssistSubjectControlAdapter.getSelectedRange().x;
                ICompletionProposal[] proposals = null;
                try {
                    try {
                        if (offset > -1) {
                            DocumentEvent event = TextUtilities.mergeProcessedDocumentEvents((List)CompletionProposalPopup.this.fDocumentEvents);
                            proposals = CompletionProposalPopup.this.computeFilteredProposals(offset, event);
                        }
                    }
                    catch (BadLocationException badLocationException) {}
                }
                catch (Throwable throwable) {
                    Object var4_5 = null;
                    CompletionProposalPopup.this.fDocumentEvents.clear();
                    throw throwable;
                }
                {
                    Object var4_6 = null;
                    CompletionProposalPopup.this.fDocumentEvents.clear();
                }
                CompletionProposalPopup.this.fFilterOffset = offset;
                if (proposals != null && proposals.length > 0) {
                    CompletionProposalPopup.this.setProposals(proposals);
                    return;
                }
                CompletionProposalPopup.this.hide();
            }
        });
    }

    private ICompletionProposal[] computeFilteredProposals(int offset, DocumentEvent event) {
        if (offset == this.fInvocationOffset && event == null) {
            return this.fComputedProposals;
        }
        if (offset < this.fInvocationOffset) {
            this.fInvocationOffset = offset;
            this.fComputedProposals = this.computeProposals(this.fInvocationOffset);
            return this.fComputedProposals;
        }
        ICompletionProposal[] proposals = this.fComputedProposals;
        if (offset > this.fFilterOffset) {
            proposals = this.fFilteredProposals;
        }
        if (proposals == null) {
            return null;
        }
        IDocument document = this.fContentAssistSubjectControlAdapter.getDocument();
        int length = proposals.length;
        ArrayList<Object> filtered = new ArrayList<Object>(length);
        int i = 0;
        while (i < length) {
            Object p;
            if (proposals[i] instanceof ICompletionProposalExtension2) {
                p = (ICompletionProposalExtension2)((Object)proposals[i]);
                if (p.validate(document, offset, event)) {
                    filtered.add(p);
                }
            } else if (proposals[i] instanceof ICompletionProposalExtension) {
                p = (ICompletionProposalExtension)((Object)proposals[i]);
                if (p.isValidFor(document, offset)) {
                    filtered.add(p);
                }
            } else {
                this.fInvocationOffset = offset;
                this.fComputedProposals = this.computeProposals(this.fInvocationOffset);
                return this.fComputedProposals;
            }
            ++i;
        }
        ICompletionProposal[] p = new ICompletionProposal[filtered.size()];
        filtered.toArray(p);
        return p;
    }

    public void setFocus() {
        if (Helper.okToUse((Widget)this.fProposalShell)) {
            this.fProposalShell.setFocus();
        }
    }

    public String incrementalComplete() {
        if (Helper.okToUse((Widget)this.fProposalShell) && this.fFilteredProposals != null) {
            this.completeCommonPrefix();
        } else {
            final Control control = this.fContentAssistSubjectControlAdapter.getControl();
            if (this.fKeyListener == null) {
                this.fKeyListener = new ProposalSelectionListener();
            }
            if (!Helper.okToUse((Widget)this.fProposalShell) && !control.isDisposed()) {
                this.fContentAssistSubjectControlAdapter.addKeyListener(this.fKeyListener);
            }
            BusyIndicator.showWhile((Display)control.getDisplay(), (Runnable)new Runnable(){

                public void run() {
                    int count;
                    CompletionProposalPopup.this.fInvocationOffset = ((CompletionProposalPopup)CompletionProposalPopup.this).fContentAssistSubjectControlAdapter.getSelectedRange().x;
                    CompletionProposalPopup.this.fFilterOffset = CompletionProposalPopup.this.fInvocationOffset;
                    CompletionProposalPopup.this.fFilteredProposals = CompletionProposalPopup.this.computeProposals(CompletionProposalPopup.this.fInvocationOffset);
                    int n = count = CompletionProposalPopup.this.fFilteredProposals == null ? 0 : CompletionProposalPopup.this.fFilteredProposals.length;
                    if (count == 0) {
                        control.getDisplay().beep();
                        CompletionProposalPopup.this.hide();
                    } else if (count == 1 && CompletionProposalPopup.this.fContentAssistant.isAutoInserting()) {
                        CompletionProposalPopup.this.insertProposal(CompletionProposalPopup.this.fFilteredProposals[0], '\u0000', 0, CompletionProposalPopup.this.fInvocationOffset);
                        CompletionProposalPopup.this.hide();
                    } else {
                        if (CompletionProposalPopup.this.fLineDelimiter == null) {
                            CompletionProposalPopup.this.fLineDelimiter = CompletionProposalPopup.this.fContentAssistSubjectControlAdapter.getLineDelimiter();
                        }
                        if (CompletionProposalPopup.this.completeCommonPrefix()) {
                            CompletionProposalPopup.this.hide();
                        } else {
                            CompletionProposalPopup.this.fComputedProposals = CompletionProposalPopup.this.fFilteredProposals;
                            CompletionProposalPopup.this.createProposalSelector();
                            CompletionProposalPopup.this.setProposals(CompletionProposalPopup.this.fComputedProposals);
                            CompletionProposalPopup.this.displayProposals();
                        }
                    }
                }
            });
        }
        return this.getErrorMessage();
    }

    private boolean completeCommonPrefix() {
        if (this.fFilteredProposals.length == 1) {
            this.insertProposal(this.fFilteredProposals[0], '\u0000', 0, this.fInvocationOffset);
            this.hide();
            return true;
        }
        IDocument document = this.fContentAssistSubjectControlAdapter.getDocument();
        CharSequence rightCasePostfix = null;
        ArrayList<ICompletionProposal> rightCase = new ArrayList<ICompletionProposal>();
        boolean checkWrongCase = true;
        CharSequence wrongCasePrefix = null;
        int wrongCasePrefixStart = 0;
        CharSequence wrongCasePostfix = null;
        ArrayList<ICompletionProposal> wrongCase = new ArrayList<ICompletionProposal>();
        int i = 0;
        while (i < this.fFilteredProposals.length) {
            ICompletionProposal proposal = this.fFilteredProposals[i];
            CharSequence insertion = this.getPrefixCompletion(proposal);
            int start = this.getPrefixCompletionOffset(proposal);
            try {
                int prefixLength = this.fFilterOffset - start;
                int relativeCompletionOffset = Math.min(insertion.length(), prefixLength);
                String prefix = document.get(start, prefixLength);
                if (insertion.toString().startsWith(prefix)) {
                    checkWrongCase = false;
                    rightCase.add(proposal);
                    CharSequence newPostfix = insertion.subSequence(relativeCompletionOffset, insertion.length());
                    if (rightCasePostfix == null) {
                        rightCasePostfix = new StringBuffer(newPostfix.toString());
                    } else {
                        this.truncatePostfix((StringBuffer)rightCasePostfix, newPostfix);
                    }
                } else if (checkWrongCase) {
                    CharSequence newPrefix = insertion.subSequence(0, relativeCompletionOffset);
                    if (this.isPrefixCompatible(wrongCasePrefix, wrongCasePrefixStart, newPrefix, start, document)) {
                        wrongCasePrefix = newPrefix;
                        wrongCasePrefixStart = start;
                        CharSequence newPostfix = insertion.subSequence(relativeCompletionOffset, insertion.length());
                        if (wrongCasePostfix == null) {
                            wrongCasePostfix = new StringBuffer(newPostfix.toString());
                        } else {
                            this.truncatePostfix((StringBuffer)wrongCasePostfix, newPostfix);
                        }
                        wrongCase.add(proposal);
                    } else {
                        checkWrongCase = false;
                    }
                }
            }
            catch (BadLocationException badLocationException) {
                return false;
            }
            if (rightCasePostfix != null && ((StringBuffer)rightCasePostfix).length() == 0 && rightCase.size() > 1) {
                return false;
            }
            ++i;
        }
        if (rightCase.size() == 1) {
            this.insertProposal((ICompletionProposal)rightCase.get(0), '\u0000', 0, this.fInvocationOffset);
            this.hide();
            return true;
        }
        if (checkWrongCase && wrongCase.size() == 1) {
            this.insertProposal((ICompletionProposal)wrongCase.get(0), '\u0000', 0, this.fInvocationOffset);
            this.hide();
            return true;
        }
        CharSequence prefix = checkWrongCase ? wrongCasePrefix : "";
        CharSequence postfix = checkWrongCase ? wrongCasePostfix : rightCasePostfix;
        if (prefix == null || postfix == null) {
            return false;
        }
        try {
            int to = Math.min(document.getLength(), this.fFilterOffset + postfix.length());
            StringBuffer inDocument = new StringBuffer(document.get(this.fFilterOffset, to - this.fFilterOffset));
            this.truncatePostfix(inDocument, postfix);
            document.replace(this.fFilterOffset - prefix.length(), prefix.length() + inDocument.length(), String.valueOf(prefix.toString()) + postfix.toString());
            this.fContentAssistSubjectControlAdapter.setSelectedRange(this.fFilterOffset + postfix.length(), 0);
            this.fContentAssistSubjectControlAdapter.revealRange(this.fFilterOffset + postfix.length(), 0);
            return postfix.length() > 0;
        }
        catch (BadLocationException badLocationException) {
            return false;
        }
    }

    private boolean isPrefixCompatible(CharSequence oneSequence, int oneOffset, CharSequence twoSequence, int twoOffset, IDocument document) throws BadLocationException {
        if (oneSequence == null || twoSequence == null) {
            return true;
        }
        int min = Math.min(oneOffset, twoOffset);
        int oneEnd = oneOffset + oneSequence.length();
        int twoEnd = twoOffset + twoSequence.length();
        String one = String.valueOf(document.get(oneOffset, min - oneOffset)) + oneSequence + document.get(oneEnd, Math.min(this.fFilterOffset, this.fFilterOffset - oneEnd));
        String two = String.valueOf(document.get(twoOffset, min - twoOffset)) + twoSequence + document.get(twoEnd, Math.min(this.fFilterOffset, this.fFilterOffset - twoEnd));
        return one.equals(two);
    }

    private void truncatePostfix(StringBuffer buffer, CharSequence sequence) {
        int min = Math.min(buffer.length(), sequence.length());
        int c = 0;
        while (c < min) {
            if (sequence.charAt(c) != buffer.charAt(c)) {
                buffer.delete(c, buffer.length());
                return;
            }
            ++c;
        }
        buffer.delete(min, buffer.length());
    }

    private int getPrefixCompletionOffset(ICompletionProposal proposal) {
        if (proposal instanceof ICompletionProposalExtension3) {
            return ((ICompletionProposalExtension3)((Object)proposal)).getPrefixCompletionStart(this.fContentAssistSubjectControlAdapter.getDocument(), this.fFilterOffset);
        }
        return this.fInvocationOffset;
    }

    private CharSequence getPrefixCompletion(ICompletionProposal proposal) {
        CharSequence insertion = null;
        if (proposal instanceof ICompletionProposalExtension3) {
            insertion = ((ICompletionProposalExtension3)((Object)proposal)).getPrefixCompletionText(this.fContentAssistSubjectControlAdapter.getDocument(), this.fFilterOffset);
        }
        if (insertion == null) {
            insertion = proposal.getDisplayString();
        }
        return insertion;
    }

    private final class ProposalSelectionListener
    implements KeyListener {
        ProposalSelectionListener() {
        }

        public void keyPressed(KeyEvent e) {
            int index;
            if (!Helper.okToUse((Widget)CompletionProposalPopup.this.fProposalShell)) {
                return;
            }
            if (e.character == '\u0000' && e.keyCode == SWT.MOD1 && (index = CompletionProposalPopup.this.fProposalTable.getSelectionIndex()) >= 0) {
                CompletionProposalPopup.this.selectProposal(index, true);
            }
        }

        public void keyReleased(KeyEvent e) {
            int index;
            if (!Helper.okToUse((Widget)CompletionProposalPopup.this.fProposalShell)) {
                return;
            }
            if (e.character == '\u0000' && e.keyCode == SWT.MOD1 && (index = CompletionProposalPopup.this.fProposalTable.getSelectionIndex()) >= 0) {
                CompletionProposalPopup.this.selectProposal(index, false);
            }
        }
    }
}

