/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.smarter;

import java.io.BufferedReader;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.Model;
import org.jmol.adapter.smarter.ModelReader;

class MopacReader
extends ModelReader {
    String frameInfo;
    int modelNumber;
    int baseAtomIndex;
    private boolean hasSymmetry = false;

    MopacReader() {
    }

    Model readModel(BufferedReader input) throws Exception {
        String line;
        this.model = new Model("mopac");
        this.frameInfo = null;
        this.modelNumber = 1;
        while ((line = input.readLine()) != null && !line.startsWith(" ---")) {
            if (line.indexOf("MOLECULAR POINT GROUP") < 0) continue;
            this.hasSymmetry = true;
        }
        while ((line = input.readLine()) != null) {
            if (line.indexOf("TOTAL ENERGY") >= 0) {
                this.processTotalEnergy(line);
                continue;
            }
            if (line.indexOf("ATOMIC CHARGES") >= 0) {
                this.processAtomicCharges(input);
                continue;
            }
            if (line.indexOf("CARTESIAN COORDINATES") >= 0 || line.indexOf("ORIENTATION OF MOLECULE IN FORCE") >= 0) {
                this.processCoordinates(input);
                continue;
            }
            if (line.indexOf("NORMAL COORDINATE ANALYSIS") < 0) continue;
            this.processFrequencies(input);
        }
        return this.model;
    }

    void processTotalEnergy(String line) {
        this.frameInfo = line.trim();
    }

    void processAtomicCharges(BufferedReader input) throws Exception {
        int atomNumber;
        String line;
        this.discardLines(input, 2);
        this.baseAtomIndex = this.model.atomCount;
        int expectedAtomNumber = 0;
        while ((line = input.readLine()) != null && (atomNumber = this.parseInt(line)) != Integer.MIN_VALUE) {
            if (atomNumber != ++expectedAtomNumber) {
                throw new Exception("unexpected atom number in atomic charges");
            }
            Atom atom = this.model.addNewAtom();
            atom.elementSymbol = this.parseToken(line, this.ichNextParse);
            atom.partialCharge = this.parseFloat(line, this.ichNextParse);
        }
    }

    void processCoordinates(BufferedReader input) throws Exception {
        int atomNumber;
        String line;
        this.discardLines(input, 3);
        int expectedAtomNumber = 0;
        while ((line = input.readLine()) != null && (atomNumber = this.parseInt(line)) != Integer.MIN_VALUE) {
            if (atomNumber != ++expectedAtomNumber) {
                throw new Exception("unexpected atom number in coordinates");
            }
            Atom atom = this.model.atoms[this.baseAtomIndex + atomNumber - 1];
            atom.x = this.parseFloat(line, 30);
            atom.y = this.parseFloat(line, 40);
            atom.z = this.parseFloat(line, 50);
        }
    }

    void processFrequencies(BufferedReader input) throws Exception {
        this.discardLines(input, 2);
    }
}

