/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.smarter;

import java.io.BufferedReader;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.Model;
import org.jmol.adapter.smarter.ModelReader;

class SpartanReader
extends ModelReader {
    int atomCountInFirstModel;

    SpartanReader() {
    }

    Model readModel(BufferedReader reader) throws Exception {
        this.model = new Model("spartan");
        try {
            if (this.discardLinesUntilContains(reader, "Cartesian Coordinates (Ang") != null) {
                this.readAtoms(reader);
            }
            if (this.discardLinesUntilContains(reader, "Vibrational Frequencies") != null) {
                this.readFrequencies(reader);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.model.errorMessage = "Could not read file:" + ex;
            return this.model;
        }
        if (this.model.atomCount == 0) {
            this.model.errorMessage = "No atoms in file";
        }
        return this.model;
    }

    void readAtoms(BufferedReader reader) throws Exception {
        int atomNum;
        String line;
        this.discardLinesUntilBlank(reader);
        while ((line = reader.readLine()) != null && (atomNum = this.parseInt(line, 0, 3)) > 0) {
            String elementSymbol = this.parseToken(line, 4, 6);
            String atomName = this.parseToken(line, 7, 13);
            float x = this.parseFloat(line, 17, 30);
            float y = this.parseFloat(line, 31, 44);
            float z = this.parseFloat(line, 45, 58);
            Atom atom = this.model.addNewAtom();
            atom.elementSymbol = elementSymbol;
            atom.atomName = atomName;
            atom.x = x;
            atom.y = y;
            atom.z = z;
        }
    }

    void readFrequencies(BufferedReader reader) throws Exception {
        int totalFrequencyCount = 0;
        this.atomCountInFirstModel = this.model.atomCount;
        float[] frequencies = new float[5];
        float[] xComponents = new float[5];
        float[] yComponents = new float[5];
        float[] zComponents = new float[5];
        block0: while (true) {
            float frequency;
            int lineFreqCount;
            String line = this.discardLinesUntilNonBlank(reader);
            int lineBaseFreqCount = totalFrequencyCount;
            this.ichNextParse = 16;
            for (lineFreqCount = 0; lineFreqCount < 3 && !Float.isNaN(frequency = this.parseFloat(line, this.ichNextParse)); ++lineFreqCount) {
                if (++totalFrequencyCount <= 1) continue;
                this.createNewModel(totalFrequencyCount);
            }
            if (lineFreqCount == 0) {
                return;
            }
            Atom[] atoms = this.model.atoms;
            this.discardLines(reader, 2);
            int i = 0;
            while (true) {
                if (i >= this.atomCountInFirstModel) continue block0;
                line = reader.readLine();
                for (int j = 0; j < lineFreqCount; ++j) {
                    int ichCoords = j * 23 + 10;
                    float x = this.parseFloat(line, ichCoords, ichCoords + 7);
                    float y = this.parseFloat(line, ichCoords + 7, ichCoords + 14);
                    float z = this.parseFloat(line, ichCoords + 14, ichCoords + 21);
                    int atomIndex = (lineBaseFreqCount + j) * this.atomCountInFirstModel + i;
                    Atom atom = atoms[atomIndex];
                    atom.vectorX = x;
                    atom.vectorY = y;
                    atom.vectorZ = z;
                }
                ++i;
            }
            break;
        }
    }

    void createNewModel(int modelNumber) {
        Atom[] atoms = this.model.atoms;
        for (int i = 0; i < this.atomCountInFirstModel; ++i) {
            Atom atomNew = this.model.newCloneAtom(atoms[i]);
            atomNew.modelNumber = modelNumber;
        }
    }
}

