/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk;

import java.io.Serializable;
import org.openscience.cdk.ChemModel;
import org.openscience.cdk.ChemObject;

public class ChemSequence
extends ChemObject
implements Serializable,
Cloneable {
    protected ChemModel[] chemModels = new ChemModel[this.growArraySize];
    protected int chemModelCount = 0;
    protected int growArraySize = 4;

    public void addChemModel(ChemModel chemModel) {
        if (this.chemModelCount + 1 >= this.chemModels.length) {
            this.growChemModelArray();
        }
        this.chemModels[this.chemModelCount] = chemModel;
        ++this.chemModelCount;
    }

    public ChemModel[] getChemModels() {
        ChemModel[] returnModels = new ChemModel[this.getChemModelCount()];
        System.arraycopy(this.chemModels, 0, returnModels, 0, returnModels.length);
        return returnModels;
    }

    public ChemModel getChemModel(int number) {
        return this.chemModels[number];
    }

    protected void growChemModelArray() {
        this.growArraySize = this.chemModels.length;
        ChemModel[] newchemModels = new ChemModel[this.chemModels.length + this.growArraySize];
        System.arraycopy(this.chemModels, 0, newchemModels, 0, this.chemModels.length);
        this.chemModels = newchemModels;
    }

    public int getChemModelCount() {
        return this.chemModelCount;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("ChemSequence(#M=");
        ChemModel[] models = this.getChemModels();
        buffer.append(models.length);
        buffer.append(", ");
        for (int i = 0; i < models.length; ++i) {
            ChemModel model = models[i];
            buffer.append(model.toString());
        }
        buffer.append(")");
        return buffer.toString();
    }
}

