/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.applications.swing;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.openscience.cdk.applications.swing.ListeningTableModel;

public class SortedTableModel
extends ListeningTableModel {
    Integer[] indexes;
    List sortingColumns = new ArrayList();
    boolean ascending = true;
    private PropertyChangeSupport changeSupport = new PropertyChangeSupport(this);

    public SortedTableModel(TableModel model) {
        super(model);
        this.initializeIndexes();
    }

    public void initializeIndexes() {
        this.indexes = new Integer[this.model.getRowCount()];
        for (int row = 0; row < this.indexes.length; ++row) {
            this.indexes[row] = new Integer(row);
        }
    }

    public void tableChanged(TableModelEvent e) {
        this.initializeIndexes();
        super.tableChanged(e);
    }

    void sort() {
        Arrays.sort(this.indexes, new Comparator(){

            public int compare(Object r1, Object r2) {
                int row1 = (Integer)r1;
                int row2 = (Integer)r2;
                int result = 0;
                for (int level = 0; result == 0 && level < SortedTableModel.this.sortingColumns.size(); ++level) {
                    int column = (Integer)SortedTableModel.this.sortingColumns.get(level);
                    Object o1 = SortedTableModel.this.model.getValueAt(row1, column);
                    Object o2 = SortedTableModel.this.model.getValueAt(row2, column);
                    if (o1 == null && o2 == null) {
                        return 0;
                    }
                    if (o1 == null) {
                        return -1;
                    }
                    if (o2 == null) {
                        return 1;
                    }
                    result = ((Comparable)o1).compareTo(o2);
                }
                if (!SortedTableModel.this.ascending) {
                    result = -result;
                }
                return result;
            }
        });
    }

    public Object getValueAt(int aRow, int aColumn) {
        return this.model.getValueAt(this.indexes[aRow], aColumn);
    }

    public int getSortedIndex(int aRow) {
        return this.indexes[aRow];
    }

    public void setValueAt(Object aValue, int aRow, int aColumn) {
        this.model.setValueAt(aValue, this.indexes[aRow], aColumn);
    }

    public int getSortedColumn() {
        if (this.sortingColumns.size() > 0) {
            return (Integer)this.sortingColumns.get(0);
        }
        return -1;
    }

    public boolean isAscending() {
        return this.ascending;
    }

    public void sortByColumn(int column) {
        this.sortByColumn(column, true);
    }

    public void sortByColumn(int column, boolean ascending) {
        Integer oldSortColumn = null;
        if (this.sortingColumns.size() > 0) {
            oldSortColumn = (Integer)this.sortingColumns.get(0);
        }
        Boolean oldSortDirection = new Boolean(this.ascending);
        this.ascending = ascending;
        Integer newSortColumn = new Integer(column);
        this.sortingColumns.add(0, newSortColumn);
        while (this.sortingColumns.size() > this.model.getColumnCount()) {
            this.sortingColumns.remove(this.sortingColumns.size() - 1);
        }
        this.sort();
        super.tableChanged(new TableModelEvent(this));
        this.changeSupport.firePropertyChange("sortColumn", oldSortColumn, newSortColumn);
        Boolean newSortDirection = new Boolean(ascending);
        this.changeSupport.firePropertyChange("sortDirection", oldSortDirection, newSortDirection);
    }

    public void addMouseListenerToHeaderInTable(final JTable table) {
        table.setColumnSelectionAllowed(false);
        MouseAdapter listMouseListener = new MouseAdapter(){
            boolean order = true;

            public void mouseClicked(MouseEvent e) {
                TableColumnModel columnModel = table.getColumnModel();
                int viewColumn = columnModel.getColumnIndexAtX(e.getX());
                int column = table.convertColumnIndexToModel(viewColumn);
                if (e.getClickCount() == 1 && column != -1) {
                    if (SortedTableModel.this.getSortedColumn() == column) {
                        this.order = !this.order;
                    }
                    SortedTableModel.this.sortByColumn(column, this.order);
                }
            }
        };
        table.getTableHeader().addMouseListener(listMouseListener);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.changeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.changeSupport.removePropertyChangeListener(listener);
    }
}

