/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.io;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.StringTokenizer;
import org.openscience.cdk.Atom;
import org.openscience.cdk.AtomContainer;
import org.openscience.cdk.ChemFile;
import org.openscience.cdk.ChemModel;
import org.openscience.cdk.ChemObject;
import org.openscience.cdk.ChemSequence;
import org.openscience.cdk.Mapping;
import org.openscience.cdk.Molecule;
import org.openscience.cdk.Reaction;
import org.openscience.cdk.SetOfReactions;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.io.DefaultChemObjectReader;
import org.openscience.cdk.io.MDLReader;
import org.openscience.cdk.tools.LoggingTool;

public class MDLRXNReader
extends DefaultChemObjectReader {
    BufferedReader input = null;
    private LoggingTool logger = new LoggingTool(this.getClass().getName());

    public MDLRXNReader(Reader in) {
        this.input = new BufferedReader(in);
    }

    public MDLRXNReader() {
        this(new StringReader(""));
    }

    public String getFormatName() {
        return "MDL RXN";
    }

    public void setReader(Reader input) throws CDKException {
        this.input = input instanceof BufferedReader ? (BufferedReader)input : new BufferedReader(input);
    }

    public boolean matches(int lineNumber, String line) {
        return line.startsWith("$RXN");
    }

    public ChemObject read(ChemObject object) throws CDKException {
        if (object instanceof Reaction) {
            return this.readReaction();
        }
        if (object instanceof ChemModel) {
            ChemModel model = new ChemModel();
            SetOfReactions reactionSet = new SetOfReactions();
            reactionSet.addReaction(this.readReaction());
            model.setSetOfReactions(reactionSet);
            return model;
        }
        if (object instanceof ChemFile) {
            ChemFile chemFile = new ChemFile();
            ChemSequence sequence = new ChemSequence();
            sequence.addChemModel((ChemModel)this.read(new ChemModel()));
            chemFile.addChemSequence(sequence);
            return chemFile;
        }
        throw new CDKException("Only supported are Reaction and ChemModel, and not " + object.getClass().getName() + ".");
    }

    public boolean accepts(ChemObject object) {
        if (object instanceof Reaction) {
            return true;
        }
        if (object instanceof ChemModel) {
            return true;
        }
        return object instanceof ChemFile;
    }

    private Reaction readReaction() throws CDKException {
        MDLReader reader;
        String molFileLine;
        String announceMDLFileLine;
        StringBuffer molFile;
        int i;
        Reaction reaction = new Reaction();
        try {
            String firstLine = this.input.readLine();
            String secondLine = this.input.readLine();
            String thirdLine = this.input.readLine();
            String fourthLine = this.input.readLine();
        }
        catch (IOException exception) {
            this.logger.debug(exception);
            throw new CDKException("Error while reading header of RXN file");
        }
        int reactantCount = 0;
        int productCount = 0;
        try {
            String countsLine = this.input.readLine();
            StringTokenizer tokenizer = new StringTokenizer(countsLine);
            reactantCount = Integer.valueOf(tokenizer.nextToken());
            this.logger.info("Expecting " + reactantCount + " reactants in file");
            productCount = Integer.valueOf(tokenizer.nextToken());
            this.logger.info("Expecting " + productCount + " products in file");
        }
        catch (Exception exception) {
            this.logger.debug(exception);
            throw new CDKException("Error while counts line of RXN file");
        }
        try {
            for (i = 1; i <= reactantCount; ++i) {
                molFile = new StringBuffer();
                announceMDLFileLine = this.input.readLine();
                molFileLine = "";
                do {
                    molFileLine = this.input.readLine();
                    molFile.append(molFileLine);
                    molFile.append("\n");
                } while (!molFileLine.equals("M  END"));
                reader = new MDLReader(new StringReader(molFile.toString()));
                Molecule reactant = (Molecule)reader.read(new Molecule());
                reaction.addReactant(reactant);
            }
        }
        catch (CDKException exception) {
            throw exception;
        }
        catch (Exception exception) {
            this.logger.debug(exception);
            throw new CDKException("Error while reading reactant");
        }
        try {
            for (i = 1; i <= productCount; ++i) {
                molFile = new StringBuffer();
                announceMDLFileLine = this.input.readLine();
                molFileLine = "";
                do {
                    molFileLine = this.input.readLine();
                    molFile.append(molFileLine);
                    molFile.append("\n");
                } while (!molFileLine.equals("M  END"));
                reader = new MDLReader(new StringReader(molFile.toString()));
                Molecule product = (Molecule)reader.read(new Molecule());
                reaction.addProduct(product);
            }
        }
        catch (CDKException exception) {
            throw exception;
        }
        catch (Exception exception) {
            this.logger.debug(exception);
            throw new CDKException("Error while reading products");
        }
        this.logger.info("Reading atom-atom mapping from file");
        AtomContainer reactingSide = new AtomContainer();
        Molecule[] molecules = reaction.getReactants().getMolecules();
        for (int i2 = 0; i2 < molecules.length; ++i2) {
            reactingSide.add(molecules[i2]);
        }
        AtomContainer producedSide = new AtomContainer();
        molecules = reaction.getProducts().getMolecules();
        for (int i3 = 0; i3 < molecules.length; ++i3) {
            producedSide.add(molecules[i3]);
        }
        int mappingCount = 0;
        Atom[] reactantAtoms = reactingSide.getAtoms();
        Atom[] producedAtoms = producedSide.getAtoms();
        block16: for (int i4 = 0; i4 < reactantAtoms.length; ++i4) {
            for (int j = 0; j < producedAtoms.length; ++j) {
                if (reactantAtoms[i4].getID() == null || !reactantAtoms[i4].getID().equals(producedAtoms[j].getID())) continue;
                reaction.addMapping(new Mapping((ChemObject)reactantAtoms[i4], (ChemObject)producedAtoms[j]));
                ++mappingCount;
                continue block16;
            }
        }
        this.logger.info("Mapped atom pairs: " + mappingCount);
        return reaction;
    }

    public void close() throws IOException {
        this.input.close();
    }
}

