/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.io.iterator;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.NoSuchElementException;
import org.openscience.cdk.Molecule;
import org.openscience.cdk.io.MDLReader;
import org.openscience.cdk.io.iterator.DefaultIteratingChemObjectReader;
import org.openscience.cdk.tools.LoggingTool;

public class IteratingMDLReader
extends DefaultIteratingChemObjectReader {
    private BufferedReader input;
    private LoggingTool logger = new LoggingTool(this);
    private String currentLine;
    private boolean nextAvailableIsKnown;
    private boolean hasNext;
    private Molecule nextMolecule;

    public IteratingMDLReader(Reader in) {
        this.input = new BufferedReader(in);
        this.nextMolecule = null;
        this.nextAvailableIsKnown = false;
        this.hasNext = false;
    }

    public String getFormatName() {
        return "MDL SDF";
    }

    public boolean hasNext() {
        if (!this.nextAvailableIsKnown) {
            this.hasNext = false;
            try {
                if (this.input.ready()) {
                    this.currentLine = this.input.readLine();
                    StringBuffer buffer = new StringBuffer();
                    while (this.input.ready() && this.currentLine != null && !this.currentLine.equals("$$$$")) {
                        buffer.append(this.currentLine);
                        buffer.append("\n");
                        this.currentLine = this.input.readLine();
                    }
                    MDLReader reader = new MDLReader(new StringReader(buffer.toString()));
                    this.nextMolecule = (Molecule)reader.read(new Molecule());
                    this.hasNext = this.nextMolecule.getAtomCount() > 0;
                } else {
                    this.hasNext = false;
                }
            }
            catch (Exception exception) {
                this.logger.error("Error while reading next molecule: " + exception.getMessage());
                this.logger.debug(exception);
                this.hasNext = false;
            }
            if (!this.hasNext) {
                this.nextMolecule = null;
            }
            this.nextAvailableIsKnown = true;
        }
        return this.hasNext;
    }

    public Object next() {
        if (!this.nextAvailableIsKnown) {
            this.hasNext();
        }
        this.nextAvailableIsKnown = false;
        if (!this.hasNext) {
            throw new NoSuchElementException();
        }
        return this.nextMolecule;
    }

    public void close() throws IOException {
        this.input.close();
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }
}

