/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.smiles;

import java.util.Enumeration;
import java.util.Stack;
import java.util.StringTokenizer;
import org.openscience.cdk.Atom;
import org.openscience.cdk.AtomContainer;
import org.openscience.cdk.AtomType;
import org.openscience.cdk.Bond;
import org.openscience.cdk.Element;
import org.openscience.cdk.Molecule;
import org.openscience.cdk.PseudoAtom;
import org.openscience.cdk.Reaction;
import org.openscience.cdk.SetOfMolecules;
import org.openscience.cdk.aromaticity.HueckelAromaticityDetector;
import org.openscience.cdk.exception.InvalidSmilesException;
import org.openscience.cdk.graph.ConnectivityChecker;
import org.openscience.cdk.tools.HydrogenAdder;
import org.openscience.cdk.tools.LoggingTool;
import org.openscience.cdk.tools.ValencyChecker;

public class SmilesParser {
    private LoggingTool logger = new LoggingTool(this);
    private HydrogenAdder hAdder = new HydrogenAdder("org.openscience.cdk.tools.ValencyChecker");
    private ValencyChecker valencyChecker;
    int position = -1;
    int nodeCounter = -1;
    String smiles = null;
    double bondStatus = -1.0;
    Atom[] rings = null;
    double[] ringbonds = null;
    int thisRing = -1;
    Molecule molecule = null;
    String currentSymbol = null;

    public SmilesParser() {
        try {
            this.valencyChecker = new ValencyChecker();
        }
        catch (Exception exception) {
            this.logger.error((Object)"Could not instantiate valencyChecker: ", exception.getMessage());
            this.logger.debug(exception);
        }
    }

    public Reaction parseReactionSmiles(String smiles) throws InvalidSmilesException {
        int i;
        StringTokenizer tokenizer = new StringTokenizer(smiles, ">");
        String reactantSmiles = tokenizer.nextToken();
        String agentSmiles = "";
        String productSmiles = tokenizer.nextToken();
        if (tokenizer.hasMoreTokens()) {
            agentSmiles = productSmiles;
            productSmiles = tokenizer.nextToken();
        }
        ConnectivityChecker connChecker = new ConnectivityChecker();
        Reaction reaction = new Reaction();
        Molecule reactantContainer = this.parseSmiles(reactantSmiles);
        SetOfMolecules reactantSet = ConnectivityChecker.partitionIntoMolecules((AtomContainer)reactantContainer);
        Molecule[] reactants = reactantSet.getMolecules();
        for (int i2 = 0; i2 < reactants.length; ++i2) {
            reaction.addReactant(reactants[i2]);
        }
        if (agentSmiles.length() > 0) {
            Molecule agentContainer = this.parseSmiles(agentSmiles);
            SetOfMolecules agentSet = ConnectivityChecker.partitionIntoMolecules((AtomContainer)agentContainer);
            Molecule[] agents = agentSet.getMolecules();
            for (i = 0; i < agents.length; ++i) {
                reaction.addAgent(agents[i]);
            }
        }
        Molecule productContainer = this.parseSmiles(productSmiles);
        SetOfMolecules productSet = ConnectivityChecker.partitionIntoMolecules((AtomContainer)productContainer);
        Molecule[] products = productSet.getMolecules();
        for (i = 0; i < products.length; ++i) {
            reaction.addProduct(products[i]);
        }
        return reaction;
    }

    public Molecule parseSmiles(String smiles) throws InvalidSmilesException {
        this.logger.debug("parseSmiles()...");
        Bond bond = null;
        this.nodeCounter = 0;
        this.bondStatus = 0.0;
        boolean bondExists = true;
        this.thisRing = -1;
        this.currentSymbol = null;
        this.molecule = new Molecule();
        this.position = 0;
        this.rings = new Atom[1024];
        this.ringbonds = new double[1024];
        for (int f = 0; f < 1024; ++f) {
            this.rings[f] = null;
            this.ringbonds[f] = -1.0;
        }
        char mychar = 'X';
        char[] chars = new char[1];
        Object lastNode = null;
        Object thisNode = null;
        Stack<Object> atomStack = new Stack<Object>();
        Stack<Double> bondStack = new Stack<Double>();
        Atom atom = null;
        Object partner = null;
        do {
            block37: {
                try {
                    Atom a;
                    Enumeration ses;
                    mychar = smiles.charAt(this.position);
                    this.logger.debug("");
                    this.logger.debug("Processing: " + mychar);
                    if (lastNode != null) {
                        this.logger.debug("Lastnode: " + lastNode.hashCode());
                    }
                    if (mychar >= 'A' && mychar <= 'Z' || mychar >= 'a' && mychar <= 'z' || mychar == '*') {
                        this.logger.debug("Found a must-be 'organic subset' element");
                        atom = null;
                        if (mychar == '*') {
                            this.currentSymbol = "*";
                            atom = new PseudoAtom("*");
                        } else {
                            this.currentSymbol = this.getSymbolForOrganicSubsetElement(smiles, this.position);
                            if (this.currentSymbol != null) {
                                if (this.currentSymbol.length() == 1) {
                                    if (!this.currentSymbol.toUpperCase().equals(this.currentSymbol)) {
                                        this.currentSymbol = this.currentSymbol.toUpperCase();
                                        atom = this.createAtom(this.currentSymbol);
                                        atom.setHybridization(2);
                                        if (atom.getHydrogenCount() > 0) {
                                            atom.setHydrogenCount(atom.getHydrogenCount() - 1);
                                        }
                                    } else {
                                        atom = this.createAtom(this.currentSymbol);
                                    }
                                } else {
                                    atom = this.createAtom(this.currentSymbol);
                                }
                                this.logger.debug("Made atom: " + atom);
                            } else {
                                throw new InvalidSmilesException("Found element which is not a 'organic subset' element. You must use [" + mychar + "].");
                            }
                        }
                        this.molecule.addAtom(atom);
                        this.logger.debug("Adding atom " + atom.hashCode());
                        if (lastNode != null && bondExists) {
                            this.logger.debug("Creating bond between " + atom.getSymbol() + " and " + ((Element)lastNode).getSymbol());
                            bond = this.createBond(atom, (Atom)lastNode, this.bondStatus);
                            this.molecule.addBond(bond);
                            if (this.bondStatus == 2.0) {
                                if (atom.getHybridization() == 2) {
                                    atom.setHydrogenCount(atom.getHydrogenCount() + 1);
                                }
                                if (((AtomType)lastNode).getHybridization() == 2) {
                                    ((Atom)lastNode).setHydrogenCount(((Atom)lastNode).getHydrogenCount() + 1);
                                }
                            }
                        }
                        this.bondStatus = 1.0;
                        lastNode = atom;
                        ++this.nodeCounter;
                        this.position += this.currentSymbol.length();
                        bondExists = true;
                        break block37;
                    }
                    if (mychar == '=') {
                        this.bondStatus = 2.0;
                        ++this.position;
                        break block37;
                    }
                    if (mychar == '#') {
                        this.bondStatus = 3.0;
                        ++this.position;
                        break block37;
                    }
                    if (mychar == '(') {
                        atomStack.push(lastNode);
                        this.logger.debug("Stack:");
                        ses = atomStack.elements();
                        while (ses.hasMoreElements()) {
                            a = (Atom)ses.nextElement();
                            this.logger.debug("" + a.hashCode());
                        }
                        this.logger.debug("------");
                        bondStack.push(new Double(this.bondStatus));
                        ++this.position;
                        break block37;
                    }
                    if (mychar == ')') {
                        lastNode = (Atom)atomStack.pop();
                        this.logger.debug("Stack:");
                        ses = atomStack.elements();
                        while (ses.hasMoreElements()) {
                            a = (Atom)ses.nextElement();
                            this.logger.debug("" + a.hashCode());
                        }
                        this.logger.debug("------");
                        this.bondStatus = (Double)bondStack.pop();
                        ++this.position;
                        break block37;
                    }
                    if (mychar >= '0' && mychar <= '9') {
                        chars[0] = mychar;
                        this.currentSymbol = new String(chars);
                        this.thisRing = new Integer(new String(chars));
                        this.handleRing((Atom)lastNode);
                        ++this.position;
                        break block37;
                    }
                    if (mychar == '%') {
                        this.currentSymbol = this.getRingNumber(smiles, this.position);
                        this.thisRing = new Integer(this.currentSymbol);
                        this.handleRing((Atom)lastNode);
                        this.position += this.currentSymbol.length() + 1;
                        break block37;
                    }
                    if (mychar == '[') {
                        this.currentSymbol = this.getAtomString(smiles, this.position);
                        atom = this.assembleAtom(this.currentSymbol, this.nodeCounter);
                        this.molecule.addAtom(atom);
                        this.logger.debug("Added atom: " + atom);
                        if (lastNode != null && bondExists) {
                            bond = this.createBond(atom, (Atom)lastNode, this.bondStatus);
                            this.molecule.addBond(bond);
                            this.logger.debug("Added bond: " + bond);
                        }
                        this.bondStatus = 1.0;
                        lastNode = atom;
                        ++this.nodeCounter;
                        this.position = this.position + this.currentSymbol.length() + 2;
                        bondExists = true;
                        break block37;
                    }
                    if (mychar == '.') {
                        bondExists = false;
                        ++this.position;
                        break block37;
                    }
                    if (mychar == '/' || mychar == '\\') {
                        this.logger.warn("Ignoring stereo information for double bond");
                        ++this.position;
                        break block37;
                    }
                    if (mychar == '@') {
                        if (this.position < smiles.length() - 1 && smiles.charAt(this.position + 1) == '@') {
                            ++this.position;
                        }
                        this.logger.warn("Ignoring stereo information for atom");
                        ++this.position;
                        break block37;
                    }
                    throw new InvalidSmilesException("Unexpected character found: " + mychar);
                }
                catch (InvalidSmilesException exc) {
                    this.logger.error("InvalidSmilesException while parsing char (in parseSmiles()): " + mychar);
                    this.logger.debug(exc);
                    throw exc;
                }
                catch (Exception exception) {
                    this.logger.error("Error while parsing char: " + mychar);
                    this.logger.debug(exception);
                    throw new InvalidSmilesException("Error while parsing char: " + mychar);
                }
            }
            this.logger.debug("Parsing next char");
        } while (this.position < smiles.length());
        Molecule[] moleculeSet = ConnectivityChecker.partitionIntoMolecules((AtomContainer)this.molecule).getMolecules();
        this.logger.debug((Object)"#mols ", moleculeSet.length);
        for (int i = 0; i < moleculeSet.length; ++i) {
            this.logger.debug((Object)"mol: ", moleculeSet[i]);
            try {
                this.valencyChecker.saturate(moleculeSet[i]);
                this.logger.debug((Object)" after saturation: ", moleculeSet[i]);
                if (!HueckelAromaticityDetector.detectAromaticity((AtomContainer)moleculeSet[i])) continue;
                this.logger.debug("Structure is aromatic...");
                continue;
            }
            catch (Exception exception) {
                this.logger.error((Object)"Could not perceive aromaticity: ", exception.getMessage());
                this.logger.debug(exception);
            }
        }
        return this.molecule;
    }

    private String getAtomString(String smiles, int pos) throws InvalidSmilesException {
        this.logger.debug("getAtomString()");
        StringBuffer atomString = new StringBuffer();
        try {
            char character;
            for (int f = pos + 1; f < smiles.length() && (character = smiles.charAt(f)) != ']'; ++f) {
                atomString.append(character);
            }
        }
        catch (Exception exception) {
            String message = "Problem parsing Atom specification given in brackets.\n";
            message = message + "Invalid SMILES string was: " + smiles;
            this.logger.error(message);
            this.logger.debug(exception);
            throw new InvalidSmilesException(message);
        }
        return atomString.toString();
    }

    private int getCharge(String chargeString, int position) {
        this.logger.debug("getCharge(): Parsing charge from: " + chargeString.substring(position));
        int charge = 0;
        if (chargeString.charAt(position) == '+') {
            charge = 1;
            ++position;
        } else if (chargeString.charAt(position) == '-') {
            charge = -1;
            ++position;
        } else {
            return charge;
        }
        StringBuffer multiplier = new StringBuffer();
        while (position < chargeString.length() && Character.isDigit(chargeString.charAt(position))) {
            multiplier.append(chargeString.charAt(position));
            ++position;
        }
        if (multiplier.length() > 0) {
            this.logger.debug("Found multiplier: " + multiplier.toString());
            try {
                charge *= Integer.parseInt(multiplier.toString());
            }
            catch (Exception exception) {
                this.logger.error("Could not parse positive atomic charge!");
                this.logger.debug(exception);
            }
        }
        this.logger.debug("Found charge: " + charge);
        return charge;
    }

    private int getImplicitHydrogenCount(String s, int position) {
        this.logger.debug("getImplicitHydrogenCount(): Parsing implicit hydrogens from: " + s);
        int count = 1;
        if (s.charAt(position) == 'H') {
            StringBuffer multiplier = new StringBuffer();
            while (position < s.length() - 1 && Character.isDigit(s.charAt(position + 1))) {
                multiplier.append(position + 1);
                ++position;
            }
            if (multiplier.length() > 0) {
                try {
                    count += Integer.parseInt(multiplier.toString());
                }
                catch (Exception exception) {
                    this.logger.error("Could not parse number of implicit hydrogens!");
                    this.logger.debug(exception);
                }
            }
        }
        return count;
    }

    private String getElementSymbol(String s, int pos) {
        String possibleSymbol;
        this.logger.debug("getElementSymbol(): Parsing element symbol (pos=" + pos + ") from: " + s);
        if (pos < s.length() - 1) {
            possibleSymbol = s.substring(pos, pos + 2);
            this.logger.debug("possibleSymbol: " + possibleSymbol);
            if ("HeLiBeNeNaMgAlSiClArCaScTiCrMnFeCoNiCuZnGaGeAsSe".indexOf(possibleSymbol) >= 0 || "BrKrRbSrZrNbMoTcRuRhPdAgCdInSnSbTeXeCsBaLuHfTaRe".indexOf(possibleSymbol) >= 0 || "OsIrPtAuHgTlPbBiPoAtRnFrRaLrRfDbSgBhHsMtDs".indexOf(possibleSymbol) >= 0) {
                return possibleSymbol;
            }
        }
        possibleSymbol = s.substring(pos, pos + 1);
        this.logger.debug("possibleSymbol: " + possibleSymbol);
        if ("H".indexOf(possibleSymbol) >= 0) {
            return possibleSymbol;
        }
        return this.getSymbolForOrganicSubsetElement(s, pos);
    }

    private String getSymbolForOrganicSubsetElement(String s, int pos) {
        String possibleSymbol;
        this.logger.debug("getSymbolForOrganicSubsetElement(): Parsing organic subset element from: " + s);
        if (pos < s.length() - 1 && "ClBr".indexOf(possibleSymbol = s.substring(pos, pos + 2)) >= 0) {
            return possibleSymbol;
        }
        if ("BCcNnOoFPSsI".indexOf(s.charAt(pos)) >= 0) {
            return s.substring(pos, pos + 1);
        }
        if ("fpi".indexOf(s.charAt(pos)) >= 0) {
            this.logger.warn("Element " + s + " is normally not sp2 hybridisized!");
            return s.substring(pos, pos + 1);
        }
        this.logger.warn("Subset element not found!");
        return null;
    }

    private String getRingNumber(String s, int pos) {
        this.logger.debug("getRingNumber()");
        int mychar = 32;
        String retString = "";
        ++pos;
        do {
            retString = retString + s.charAt(pos);
        } while (++pos < s.length() && s.charAt(pos) >= '0' && s.charAt(pos) <= '9');
        return retString;
    }

    private Atom assembleAtom(String s, int nodeCounter) throws InvalidSmilesException {
        char mychar;
        this.logger.debug("assembleAtom(): Assembling atom from: " + s);
        Atom atom = null;
        int position = 0;
        String currentSymbol = null;
        StringBuffer isotopicNumber = new StringBuffer();
        this.logger.debug("Parse everythings before and including element symbol");
        do {
            try {
                mychar = s.charAt(position);
                this.logger.debug("Parsing char: " + mychar);
                if (mychar >= 'A' && mychar <= 'Z' || mychar >= 'a' && mychar <= 'z') {
                    currentSymbol = this.getElementSymbol(s, position);
                    if (currentSymbol == null) {
                        throw new InvalidSmilesException("Expected element symbol, found null!");
                    }
                    this.logger.debug("Found element symbol: " + currentSymbol);
                    position += currentSymbol.length();
                    if (currentSymbol.length() == 1) {
                        if (!currentSymbol.toUpperCase().equals(currentSymbol)) {
                            currentSymbol = currentSymbol.toUpperCase();
                            atom = this.createAtom(currentSymbol);
                            atom.setHybridization(2);
                            if (atom.getHydrogenCount() > 0) {
                                atom.setHydrogenCount(atom.getHydrogenCount() - 1);
                            }
                        } else {
                            atom = this.createAtom(currentSymbol);
                        }
                    } else {
                        atom = this.createAtom(currentSymbol);
                    }
                    this.logger.debug("Made atom: " + atom);
                    break;
                }
                if (mychar >= '0' && mychar <= '9') {
                    isotopicNumber.append(mychar);
                    continue;
                }
                if (mychar == '*') {
                    currentSymbol = "*";
                    atom = new PseudoAtom(currentSymbol);
                    this.logger.debug("Made atom: " + atom);
                    ++position;
                    break;
                }
                throw new InvalidSmilesException("Found unexpected char: " + mychar);
            }
            catch (InvalidSmilesException exc) {
                this.logger.error("InvalidSmilesException while parsing atom string: " + s);
                this.logger.debug(exc);
                throw exc;
            }
            catch (Exception exception) {
                this.logger.error("Could not parse atom string: " + s);
                this.logger.debug(exception);
                throw new InvalidSmilesException("Could not parse atom string: " + s);
            }
        } while (++position < s.length());
        if (isotopicNumber.toString().length() > 0) {
            try {
                atom.setMassNumber(Integer.parseInt(isotopicNumber.toString()));
            }
            catch (Exception exception) {
                this.logger.error("Could not set atom's atom number.");
                this.logger.debug(exception);
            }
        }
        this.logger.debug("Parsing part after element symbol (like charge): " + s.substring(position));
        int charge = 0;
        int implicitHydrogens = 0;
        while (position < s.length()) {
            try {
                mychar = s.charAt(position);
                this.logger.debug("Parsing char: " + mychar);
                if (mychar == 'H') {
                    implicitHydrogens = this.getImplicitHydrogenCount(s, position);
                    ++position;
                    if (implicitHydrogens > 1) {
                        ++position;
                    }
                    atom.setHydrogenCount(implicitHydrogens);
                    continue;
                }
                if (mychar == '+' || mychar == '-') {
                    charge = this.getCharge(s, position);
                    ++position;
                    if (charge < -1 || charge > 1) {
                        ++position;
                    }
                    atom.setFormalCharge(charge);
                    continue;
                }
                if (mychar == '@') {
                    if (position < s.length() - 1 && s.charAt(position + 1) == '@') {
                        ++position;
                    }
                    this.logger.warn("Ignoring stereo information for atom");
                    ++position;
                    continue;
                }
                throw new InvalidSmilesException("Found unexpected char: " + mychar);
            }
            catch (InvalidSmilesException exc) {
                this.logger.error("InvalidSmilesException while parsing atom string: " + s);
                this.logger.debug(exc);
                throw exc;
            }
            catch (Exception exception) {
                this.logger.error("Could not parse atom string: " + s);
                this.logger.debug(exception);
                throw new InvalidSmilesException("Could not parse atom string: " + s);
            }
        }
        return atom;
    }

    private void handleRing(Atom atom) {
        this.logger.debug("handleRing():");
        double bondStat = this.bondStatus;
        Bond bond = null;
        Atom partner = null;
        Atom thisNode = this.rings[this.thisRing];
        if (thisNode != null) {
            partner = thisNode;
            bond = this.createBond(atom, partner, bondStat);
            this.molecule.addBond(bond);
            this.rings[this.thisRing] = null;
            this.ringbonds[this.thisRing] = -1.0;
        } else {
            this.rings[this.thisRing] = atom;
            this.ringbonds[this.thisRing] = this.bondStatus;
        }
    }

    private Atom createAtom(String symbol) {
        Atom atom = new Atom(symbol);
        try {
            this.hAdder.addImplicitHydrogensToSatisfyValency(atom);
        }
        catch (Exception exception) {
            this.logger.error((Object)"Error while calculation Hcount for SMILES atom: ", exception.getMessage());
        }
        return atom;
    }

    private Bond createBond(Atom atom, Atom AtomToAtach, double bondOrder) {
        if (atom.getHydrogenCount() > 0) {
            atom.setHydrogenCount(atom.getHydrogenCount() - (int)bondOrder);
        }
        if (AtomToAtach.getHydrogenCount() > 0) {
            AtomToAtach.setHydrogenCount(AtomToAtach.getHydrogenCount() - (int)bondOrder);
        }
        Bond newBond = new Bond(atom, AtomToAtach, bondOrder);
        return newBond;
    }
}

