/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.tools;

import java.awt.Color;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.StringTokenizer;
import java.util.Vector;
import org.openscience.cdk.AtomType;
import org.openscience.cdk.tools.AtomTypeConfigurator;

public class TXTBasedAtomTypeConfigurator
implements AtomTypeConfigurator {
    private String configFile = "jmol_atomtypes.txt";
    private InputStream ins = null;

    public void setInputStream(InputStream ins) {
        this.ins = ins;
    }

    public Vector readAtomTypes() throws Exception {
        Vector<AtomType> atomTypes = new Vector<AtomType>();
        if (this.ins == null) {
            this.ins = this.getClass().getResourceAsStream(this.configFile);
        }
        if (this.ins == null) {
            throw new IOException("There was a problem getting the default stream: " + this.configFile);
        }
        BufferedReader r = new BufferedReader(new InputStreamReader(this.ins), 1024);
        try {
            String s;
            while ((s = r.readLine()) != null) {
                if (s.startsWith("#")) continue;
                String name = "";
                String rootType = "";
                int an = 0;
                int rl = 0;
                int gl = 0;
                int bl = 0;
                double mass = 0.0;
                double vdw = 0.0;
                double covalent = 0.0;
                StringTokenizer st = new StringTokenizer(s, "\t ,;");
                int nt = st.countTokens();
                if (nt == 9) {
                    name = st.nextToken();
                    rootType = st.nextToken();
                    String san = st.nextToken();
                    String sam = st.nextToken();
                    String svdw = st.nextToken();
                    String scov = st.nextToken();
                    String sr = st.nextToken();
                    String sg = st.nextToken();
                    String sb = st.nextToken();
                    try {
                        mass = new Double(sam);
                        vdw = new Double(svdw);
                        covalent = new Double(scov);
                        an = Integer.parseInt(san);
                        rl = Integer.parseInt(sr);
                        gl = Integer.parseInt(sg);
                        bl = Integer.parseInt(sb);
                    }
                    catch (NumberFormatException nfe) {
                        throw new IOException("AtomTypeTable.ReadAtypes: Malformed Number");
                    }
                    AtomType at = new AtomType(name, rootType);
                    at.setAtomicNumber(an);
                    at.setExactMass(mass);
                    at.setVanderwaalsRadius(vdw);
                    at.setCovalentRadius(covalent);
                    Color co = new Color(rl, gl, bl);
                    at.setProperty("org.openscience.cdk.renderer.color", co);
                    atomTypes.addElement(at);
                    continue;
                }
                throw new IOException("AtomTypeTable.ReadAtypes: Wrong Number of fields");
            }
            this.ins.close();
        }
        catch (IOException e) {
            System.err.println(e.toString());
            e.printStackTrace();
        }
        return atomTypes;
    }
}

