/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.tools.manipulator;

import org.openscience.cdk.Atom;
import org.openscience.cdk.AtomContainer;
import org.openscience.cdk.ChemModel;
import org.openscience.cdk.Crystal;
import org.openscience.cdk.ElectronContainer;
import org.openscience.cdk.Molecule;
import org.openscience.cdk.Reaction;
import org.openscience.cdk.SetOfMolecules;
import org.openscience.cdk.SetOfReactions;
import org.openscience.cdk.tools.manipulator.ReactionManipulator;
import org.openscience.cdk.tools.manipulator.SetOfMoleculesManipulator;
import org.openscience.cdk.tools.manipulator.SetOfReactionsManipulator;

public class ChemModelManipulator {
    public static void removeAtomAndConnectedElectronContainers(ChemModel chemModel, Atom atom) {
        SetOfReactions reactionSet;
        Crystal crystal = chemModel.getCrystal();
        if (crystal != null) {
            if (crystal.contains(atom)) {
                crystal.removeAtomAndConnectedElectronContainers(atom);
            }
            return;
        }
        SetOfMolecules moleculeSet = chemModel.getSetOfMolecules();
        if (moleculeSet != null) {
            SetOfMoleculesManipulator.removeAtomAndConnectedElectronContainers(moleculeSet, atom);
        }
        if ((reactionSet = chemModel.getSetOfReactions()) != null) {
            SetOfReactionsManipulator.removeAtomAndConnectedElectronContainers((SetOfReactions)reactionSet, (Atom)atom);
        }
    }

    public static void removeElectronContainer(ChemModel chemModel, ElectronContainer electrons) {
        SetOfReactions reactionSet;
        Crystal crystal = chemModel.getCrystal();
        if (crystal != null) {
            if (crystal.contains(electrons)) {
                crystal.removeElectronContainer(electrons);
            }
            return;
        }
        SetOfMolecules moleculeSet = chemModel.getSetOfMolecules();
        if (moleculeSet != null) {
            SetOfMoleculesManipulator.removeElectronContainer(moleculeSet, electrons);
        }
        if ((reactionSet = chemModel.getSetOfReactions()) != null) {
            SetOfReactionsManipulator.removeElectronContainer((SetOfReactions)reactionSet, (ElectronContainer)electrons);
        }
    }

    public static AtomContainer getAllInOneContainer(ChemModel chemModel) {
        SetOfReactions reactionSet;
        SetOfMolecules moleculeSet;
        AtomContainer container = new AtomContainer();
        Crystal crystal = chemModel.getCrystal();
        if (crystal != null) {
            container.add(crystal);
        }
        if ((moleculeSet = chemModel.getSetOfMolecules()) != null) {
            container.add(SetOfMoleculesManipulator.getAllInOneContainer(moleculeSet));
        }
        if ((reactionSet = chemModel.getSetOfReactions()) != null) {
            container.add(SetOfReactionsManipulator.getAllInOneContainer((SetOfReactions)reactionSet));
        }
        return container;
    }

    public static AtomContainer createNewMolecule(ChemModel chemModel) {
        Molecule molecule = new Molecule();
        if (chemModel.getSetOfMolecules() != null) {
            SetOfMolecules moleculeSet = chemModel.getSetOfMolecules();
            moleculeSet.addMolecule(molecule);
        } else {
            SetOfMolecules moleculeSet = new SetOfMolecules();
            moleculeSet.addMolecule(molecule);
            chemModel.setSetOfMolecules(moleculeSet);
        }
        return molecule;
    }

    public static AtomContainer getRelevantAtomContainer(ChemModel chemModel, Atom atom) {
        int i;
        if (chemModel.getSetOfMolecules() != null) {
            SetOfMolecules moleculeSet = chemModel.getSetOfMolecules();
            Molecule[] molecules = moleculeSet.getMolecules();
            for (i = 0; i < molecules.length; ++i) {
                if (!molecules[i].contains(atom)) continue;
                return molecules[i];
            }
        }
        if (chemModel.getSetOfReactions() != null) {
            SetOfReactions reactionSet = chemModel.getSetOfReactions();
            Reaction[] reactions = reactionSet.getReactions();
            for (i = 0; i < reactions.length; ++i) {
                Reaction reaction = reactions[i];
                AtomContainer container = ReactionManipulator.getRelevantAtomContainer((Reaction)reaction, (Atom)atom);
                if (container == null) continue;
                return container;
            }
        }
        return null;
    }

    public static Reaction getRelevantReaction(ChemModel chemModel, Atom atom) {
        Reaction reaction = null;
        if (chemModel.getSetOfReactions() != null) {
            SetOfReactions reactionSet = chemModel.getSetOfReactions();
            reaction = SetOfReactionsManipulator.getRelevantReaction((SetOfReactions)reactionSet, (Atom)atom);
        }
        return reaction;
    }

    public static AtomContainer[] getAllAtomContainers(ChemModel chemModel) {
        SetOfMolecules moleculeSet = new SetOfMolecules();
        if (chemModel.getSetOfMolecules() != null) {
            moleculeSet.add(chemModel.getSetOfMolecules());
        }
        if (chemModel.getSetOfReactions() != null) {
            moleculeSet.add(SetOfReactionsManipulator.getAllMolecules((SetOfReactions)chemModel.getSetOfReactions()));
        }
        return SetOfMoleculesManipulator.getAllAtomContainers(moleculeSet);
    }
}

