/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.jmol.app;

import java.awt.Color;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Position;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import org.openscience.jmol.app.ConsoleTextPane;

class ConsoleDocument
extends DefaultStyledDocument {
    ConsoleTextPane consoleTextPane;
    SimpleAttributeSet attError = new SimpleAttributeSet();
    SimpleAttributeSet attEcho;
    SimpleAttributeSet attPrompt;
    SimpleAttributeSet attUserInput;
    SimpleAttributeSet attStatus;
    Position positionBeforePrompt;
    int offsetAfterPrompt;

    ConsoleDocument() {
        StyleConstants.setForeground(this.attError, Color.red);
        this.attPrompt = new SimpleAttributeSet();
        StyleConstants.setForeground(this.attPrompt, Color.magenta);
        this.attUserInput = new SimpleAttributeSet();
        StyleConstants.setForeground(this.attUserInput, Color.black);
        this.attEcho = new SimpleAttributeSet();
        StyleConstants.setForeground(this.attEcho, Color.blue);
        StyleConstants.setBold(this.attEcho, true);
        this.attStatus = new SimpleAttributeSet();
        StyleConstants.setForeground(this.attStatus, Color.black);
        StyleConstants.setItalic(this.attStatus, true);
    }

    void setConsoleTextPane(ConsoleTextPane consoleTextPane) {
        this.consoleTextPane = consoleTextPane;
    }

    void setPrompt() {
        try {
            super.insertString(this.getLength(), "$ ", this.attPrompt);
            this.offsetAfterPrompt = this.getLength();
            this.positionBeforePrompt = this.createPosition(this.offsetAfterPrompt - 2);
            this.consoleTextPane.setCaretPosition(this.offsetAfterPrompt);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    void outputBeforePrompt(String str, SimpleAttributeSet attribute) {
        try {
            Position caretPosition = this.createPosition(this.consoleTextPane.getCaretPosition());
            super.insertString(this.positionBeforePrompt.getOffset(), str, attribute);
            super.insertString(this.positionBeforePrompt.getOffset(), "\n", attribute);
            this.offsetAfterPrompt = this.positionBeforePrompt.getOffset() + 2;
            this.consoleTextPane.setCaretPosition(caretPosition.getOffset());
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    void outputError(String strError) {
        this.outputBeforePrompt(strError, this.attError);
    }

    void outputErrorForeground(String strError) {
        try {
            super.insertString(this.getLength(), strError, this.attError);
            super.insertString(this.getLength(), "\n", this.attError);
            this.consoleTextPane.setCaretPosition(this.getLength());
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    void outputEcho(String strEcho) {
        this.outputBeforePrompt(strEcho, this.attEcho);
    }

    void outputStatus(String strStatus) {
        this.outputBeforePrompt(strStatus, this.attStatus);
    }

    void appendNewline() {
        try {
            super.insertString(this.getLength(), "\n", this.attUserInput);
            this.consoleTextPane.setCaretPosition(this.getLength());
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
        int ichNewline = str.indexOf(10);
        if (ichNewline > 0) {
            str = str.substring(0, ichNewline);
        }
        if (ichNewline != 0) {
            if (offs < this.offsetAfterPrompt) {
                offs = this.getLength();
            }
            super.insertString(offs, str, this.attUserInput);
            this.consoleTextPane.setCaretPosition(this.getLength());
        }
        if (ichNewline >= 0) {
            this.consoleTextPane.enterPressed();
        }
    }

    String getCommandString() {
        String strCommand = "";
        try {
            strCommand = this.getText(this.offsetAfterPrompt, this.getLength() - this.offsetAfterPrompt);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        return strCommand;
    }

    public void remove(int offs, int len) throws BadLocationException {
        if (offs < this.offsetAfterPrompt) {
            if ((len -= this.offsetAfterPrompt - offs) <= 0) {
                return;
            }
            offs = this.offsetAfterPrompt;
        }
        super.remove(offs, len);
        this.consoleTextPane.setCaretPosition(offs);
    }

    public void replace(int offs, int length, String str, AttributeSet attrs) throws BadLocationException {
        if (offs < this.offsetAfterPrompt) {
            if (offs + length < this.offsetAfterPrompt) {
                offs = this.getLength();
                length = 0;
            } else {
                length -= this.offsetAfterPrompt - offs;
                offs = this.offsetAfterPrompt;
            }
        }
        super.replace(offs, length, str, this.attUserInput);
        this.consoleTextPane.setCaretPosition(offs + str.length());
    }

    void replaceCommand(String newCommand) throws BadLocationException {
        this.replace(this.offsetAfterPrompt, this.getLength() - this.offsetAfterPrompt, newCommand, this.attUserInput);
    }
}

