/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.jmol.app;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Properties;

class HistoryFile {
    private Properties properties = new Properties();
    File file;
    String header;

    HistoryFile(File file, String header) {
        this.file = file;
        this.header = header;
        this.load();
    }

    void addProperties(Properties properties) {
        Enumeration<Object> keys = properties.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            String value = properties.getProperty(key);
            this.properties.setProperty(key, value);
        }
        this.save();
    }

    Properties getProperties() {
        return new Properties(this.properties);
    }

    private void load() {
        try {
            FileInputStream input = new FileInputStream(this.file);
            this.properties.load(input);
            input.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void save() {
        try {
            FileOutputStream output = new FileOutputStream(this.file);
            this.properties.store(output, this.header);
            output.close();
        }
        catch (IOException ex) {
            System.err.println("Error saving history: " + ex);
        }
    }
}

