/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.jmol.app;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Hashtable;
import java.util.Properties;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.JTabbedPane;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openscience.jmol.app.GuiMap;
import org.openscience.jmol.app.Jmol;
import org.openscience.jmol.app.JmolResourceHandler;
import org.openscience.jmol.viewer.JmolViewer;

public class PreferencesDialog
extends JDialog
implements ActionListener {
    private boolean autoBond;
    private boolean showHydrogens;
    private boolean showVectors;
    private boolean showMeasurements;
    private boolean wireframeRotation;
    private boolean perspectiveDepth;
    private boolean showAxes;
    private boolean showBoundingBox;
    private boolean axesOrientationRasmol;
    private boolean isLabelAtomColor;
    private boolean isBondAtomColor;
    private Color colorBackground;
    private Color colorSelection;
    private Color colorText;
    private Color colorBond;
    private Color colorVector;
    private Color colorMeasurement;
    private byte modeAtomColorProfile;
    private float minBondDistance;
    private float bondTolerance;
    private short marBond;
    private int percentVdwAtom;
    private JButton bButton;
    private JButton pButton;
    private JButton tButton;
    private JButton eButton;
    private JButton vButton;
    private JButton measurementColorButton;
    private JRadioButton pYes;
    private JRadioButton pNo;
    private JRadioButton abYes;
    private JRadioButton abNo;
    private JComboBox aProps;
    private JComboBox cRender;
    private JSlider vdwPercentSlider;
    private JSlider bdSlider;
    private JSlider bwSlider;
    private JSlider btSlider;
    private JSlider vasSlider;
    private JSlider vvsSlider;
    private JSlider vfSlider;
    private JCheckBox cH;
    private JCheckBox cM;
    private JCheckBox cbWireframeRotation;
    private JCheckBox cbPerspectiveDepth;
    private JCheckBox cbShowAxes;
    private JCheckBox cbShowBoundingBox;
    private JCheckBox cbAxesOrientationRasmol;
    private JCheckBox cbIsLabelAtomColor;
    private JCheckBox cbIsBondAtomColor;
    private Properties originalSystemProperties;
    private Properties jmolDefaultProperties;
    private Properties currentProperties;
    private PrefsAction prefsAction = new PrefsAction();
    private Hashtable commands;
    static final String[] jmolDefaults = new String[]{"showHydrogens", "true", "showVectors", "true", "showMeasurements", "true", "wireframeRotation", "false", "perspectiveDepth", "true", "showAxes", "false", "showBoundingBox", "false", "axesOrientationRasmol", "false", "percentVdwAtom", "20", "autoBond", "true", "marBond", "150", "minBondDistance", "0.40", "bondTolerance", "0.45", "colorSelection", "16762880", "colorBackground", "0", "isLabelAtomColor", "false", "colorVector", "16777215", "isBondAtomColor", "true", "colorBond", "0", "colorVector", "16777215", "colorMeasurement", "16777215"};
    static final String[] rasmolOverrides = new String[]{"colorBackground", "0", "isLabelAtomColor", "true", "percentVdwAtom", "0", "marBond", "1", "axesOrientationRasmol", "true"};
    private JmolViewer viewer;
    private GuiMap guimap;
    ItemListener checkBoxListener = new ItemListener(){
        Component c;
        AbstractButton b;

        public void itemStateChanged(ItemEvent e) {
            String strSelected;
            JCheckBox cb = (JCheckBox)e.getSource();
            String key = PreferencesDialog.this.guimap.getKey(cb);
            boolean isSelected = cb.isSelected();
            String string = strSelected = isSelected ? "true" : "false";
            if (key.equals("Prefs.showHydrogens")) {
                PreferencesDialog.this.showHydrogens = isSelected;
                PreferencesDialog.this.viewer.setShowHydrogens(PreferencesDialog.this.showHydrogens);
                PreferencesDialog.this.currentProperties.put("showHydrogens", strSelected);
            } else if (key.equals("Prefs.showMeasurements")) {
                PreferencesDialog.this.showMeasurements = isSelected;
                PreferencesDialog.this.viewer.setShowMeasurements(PreferencesDialog.this.showMeasurements);
                PreferencesDialog.this.currentProperties.put("showMeasurements", strSelected);
            } else if (key.equals("Prefs.isLabelAtomColor")) {
                PreferencesDialog.this.isLabelAtomColor = isSelected;
                PreferencesDialog.this.viewer.setColorLabel(PreferencesDialog.this.isLabelAtomColor ? null : PreferencesDialog.this.colorText);
                PreferencesDialog.this.currentProperties.put("isLabelAtomColor", strSelected);
                PreferencesDialog.this.tButton.setEnabled(!PreferencesDialog.this.isLabelAtomColor);
            } else if (key.equals("Prefs.isBondAtomColor")) {
                PreferencesDialog.this.isBondAtomColor = isSelected;
                PreferencesDialog.this.viewer.setColorBond(PreferencesDialog.this.isBondAtomColor ? null : PreferencesDialog.this.colorBond);
                PreferencesDialog.this.currentProperties.put("isBondAtomColor", strSelected);
                PreferencesDialog.this.eButton.setEnabled(!PreferencesDialog.this.isBondAtomColor);
            } else if (key.equals("Prefs.wireframeRotation")) {
                PreferencesDialog.this.wireframeRotation = isSelected;
                PreferencesDialog.this.viewer.setWireframeRotation(PreferencesDialog.this.wireframeRotation);
                PreferencesDialog.this.currentProperties.put("wireframeRotation", strSelected);
            } else if (key.equals("Prefs.perspectiveDepth")) {
                PreferencesDialog.this.perspectiveDepth = isSelected;
                PreferencesDialog.this.viewer.setPerspectiveDepth(PreferencesDialog.this.perspectiveDepth);
                PreferencesDialog.this.currentProperties.put("perspectiveDepth", strSelected);
            } else if (key.equals("Prefs.showAxes")) {
                PreferencesDialog.this.showAxes = isSelected;
                PreferencesDialog.this.viewer.setShapeShow(15, isSelected);
                PreferencesDialog.this.currentProperties.put("showAxes", strSelected);
            } else if (key.equals("Prefs.showBoundingBox")) {
                PreferencesDialog.this.showBoundingBox = isSelected;
                PreferencesDialog.this.viewer.setShapeShow(16, isSelected);
                PreferencesDialog.this.currentProperties.put("showBoundingBox", strSelected);
            } else if (key.equals("Prefs.axesOrientationRasmol")) {
                PreferencesDialog.this.axesOrientationRasmol = isSelected;
                PreferencesDialog.this.viewer.setAxesOrientationRasmol(isSelected);
                PreferencesDialog.this.currentProperties.put("axesOrientationRasmol", strSelected);
            }
        }
    };
    private JButton applyButton;
    private JButton jmolDefaultsButton;
    private JButton rasmolDefaultsButton;
    private JButton cancelButton;
    private JButton okButton;

    public PreferencesDialog(JFrame f, GuiMap guimap, JmolViewer viewer) {
        super((Frame)f, false);
        this.guimap = guimap;
        this.viewer = viewer;
        this.initializeProperties();
        this.setTitle(JmolResourceHandler.translateX("Preferences"));
        this.initVariables();
        this.commands = new Hashtable();
        Action[] actions = this.getActions();
        for (int i = 0; i < actions.length; ++i) {
            Action a = actions[i];
            this.commands.put(a.getValue("Name"), a);
        }
        JPanel container = new JPanel();
        container.setLayout(new BorderLayout());
        JTabbedPane tabs = new JTabbedPane();
        JPanel disp = this.buildDispPanel();
        JPanel atoms = this.buildAtomsPanel();
        JPanel bonds = this.buildBondPanel();
        JPanel colors = this.buildColorsPanel();
        tabs.addTab(JmolResourceHandler.getStringX("Prefs.displayLabel"), null, disp);
        tabs.addTab(JmolResourceHandler.getStringX("Prefs.atomsLabel"), null, atoms);
        tabs.addTab(JmolResourceHandler.getStringX("Prefs.bondsLabel"), null, bonds);
        tabs.addTab(JmolResourceHandler.getStringX("Prefs.colorsLabel"), null, colors);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new FlowLayout(2));
        this.jmolDefaultsButton = new JButton(JmolResourceHandler.getStringX("Prefs.jmolDefaultsLabel"));
        this.jmolDefaultsButton.addActionListener(this);
        buttonPanel.add(this.jmolDefaultsButton);
        this.rasmolDefaultsButton = new JButton(JmolResourceHandler.getStringX("Prefs.rasmolDefaultsLabel"));
        this.rasmolDefaultsButton.addActionListener(this);
        buttonPanel.add(this.rasmolDefaultsButton);
        this.cancelButton = new JButton(JmolResourceHandler.getStringX("Prefs.cancelButton"));
        this.cancelButton.addActionListener(this);
        buttonPanel.add(this.cancelButton);
        this.applyButton = new JButton(JmolResourceHandler.getStringX("Prefs.applyButton"));
        this.applyButton.addActionListener(this);
        buttonPanel.add(this.applyButton);
        this.okButton = new JButton(JmolResourceHandler.getStringX("Prefs.okLabel"));
        this.okButton.addActionListener(this);
        buttonPanel.add(this.okButton);
        this.getRootPane().setDefaultButton(this.okButton);
        container.add((Component)tabs, "Center");
        container.add((Component)buttonPanel, "South");
        this.getContentPane().add(container);
        this.updateComponents();
        this.pack();
        this.centerDialog();
    }

    public JPanel buildDispPanel() {
        JPanel disp = new JPanel();
        GridBagLayout gridbag = new GridBagLayout();
        disp.setLayout(gridbag);
        JPanel showPanel = new JPanel();
        showPanel.setLayout(new GridLayout(1, 3));
        showPanel.setBorder(new TitledBorder(JmolResourceHandler.getStringX("Prefs.showLabel")));
        this.cH = this.guimap.newJCheckBox("Prefs.showHydrogens", this.viewer.getShowHydrogens());
        this.cH.addItemListener(this.checkBoxListener);
        this.cM = this.guimap.newJCheckBox("Prefs.showMeasurements", this.viewer.getShowMeasurements());
        this.cM.addItemListener(this.checkBoxListener);
        showPanel.add(this.cH);
        showPanel.add(this.cM);
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridwidth = 0;
        constraints.fill = 2;
        constraints.weightx = 1.0;
        disp.add((Component)showPanel, constraints);
        JPanel fooPanel = new JPanel();
        fooPanel.setBorder(new TitledBorder(""));
        fooPanel.setLayout(new GridLayout(2, 1));
        this.cbWireframeRotation = this.guimap.newJCheckBox("Prefs.wireframeRotation", this.viewer.getWireframeRotation());
        this.cbWireframeRotation.addItemListener(this.checkBoxListener);
        fooPanel.add(this.cbWireframeRotation);
        this.cbPerspectiveDepth = this.guimap.newJCheckBox("Prefs.perspectiveDepth", this.viewer.getPerspectiveDepth());
        this.cbPerspectiveDepth.addItemListener(this.checkBoxListener);
        fooPanel.add(this.cbPerspectiveDepth);
        this.cbShowAxes = this.guimap.newJCheckBox("Prefs.showAxes", this.viewer.getShapeShow(15));
        this.cbShowAxes.addItemListener(this.checkBoxListener);
        fooPanel.add(this.cbShowAxes);
        this.cbShowBoundingBox = this.guimap.newJCheckBox("Prefs.showBoundingBox", this.viewer.getShapeShow(16));
        this.cbShowBoundingBox.addItemListener(this.checkBoxListener);
        fooPanel.add(this.cbShowBoundingBox);
        this.cbAxesOrientationRasmol = this.guimap.newJCheckBox("Prefs.axesOrientationRasmol", this.viewer.getAxesOrientationRasmol());
        constraints = new GridBagConstraints();
        constraints.gridwidth = 0;
        constraints.fill = 2;
        constraints.weightx = 1.0;
        disp.add((Component)fooPanel, constraints);
        JPanel axesPanel = new JPanel();
        axesPanel.setBorder(new TitledBorder(""));
        axesPanel.setLayout(new GridLayout(1, 1));
        this.cbAxesOrientationRasmol.addItemListener(this.checkBoxListener);
        axesPanel.add(this.cbAxesOrientationRasmol);
        constraints = new GridBagConstraints();
        constraints.gridwidth = 0;
        constraints.fill = 2;
        constraints.weightx = 1.0;
        disp.add((Component)axesPanel, constraints);
        JLabel filler = new JLabel();
        constraints = new GridBagConstraints();
        constraints.gridwidth = 0;
        constraints.gridheight = 0;
        constraints.fill = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        disp.add((Component)filler, constraints);
        return disp;
    }

    public JPanel buildAtomsPanel() {
        JPanel atomPanel = new JPanel(new GridBagLayout());
        JPanel sfPanel = new JPanel();
        sfPanel.setLayout(new BorderLayout());
        sfPanel.setBorder(new TitledBorder(JmolResourceHandler.getStringX("Prefs.atomSizeLabel")));
        JLabel sfLabel = new JLabel(JmolResourceHandler.getStringX("Prefs.atomSizeExpl"), 0);
        sfPanel.add((Component)sfLabel, "North");
        this.vdwPercentSlider = new JSlider(0, 0, 100, this.viewer.getPercentVdwAtom());
        this.vdwPercentSlider.putClientProperty("JSlider.isFilled", Boolean.TRUE);
        this.vdwPercentSlider.setPaintTicks(true);
        this.vdwPercentSlider.setMajorTickSpacing(20);
        this.vdwPercentSlider.setMinorTickSpacing(10);
        this.vdwPercentSlider.setPaintLabels(true);
        this.vdwPercentSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                JSlider source = (JSlider)e.getSource();
                PreferencesDialog.this.percentVdwAtom = source.getValue();
                PreferencesDialog.this.viewer.setPercentVdwAtom(PreferencesDialog.this.percentVdwAtom);
                PreferencesDialog.this.currentProperties.put("percentVdwAtom", "" + PreferencesDialog.this.percentVdwAtom);
            }
        });
        sfPanel.add((Component)this.vdwPercentSlider, "Center");
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridwidth = 0;
        constraints.fill = 2;
        constraints.weightx = 1.0;
        atomPanel.add((Component)sfPanel, constraints);
        JLabel filler = new JLabel();
        constraints = new GridBagConstraints();
        constraints.gridwidth = 0;
        constraints.gridheight = 0;
        constraints.fill = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        atomPanel.add((Component)filler, constraints);
        return atomPanel;
    }

    public JPanel buildBondPanel() {
        JPanel bondPanel = new JPanel();
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        bondPanel.setLayout(gridbag);
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        JPanel autobondPanel = new JPanel();
        autobondPanel.setLayout(new BoxLayout(autobondPanel, 1));
        autobondPanel.setBorder(new TitledBorder(JmolResourceHandler.getStringX("Prefs.autoBondLabel")));
        ButtonGroup abGroup = new ButtonGroup();
        this.abYes = new JRadioButton(JmolResourceHandler.getStringX("Prefs.abYesLabel"));
        this.abNo = new JRadioButton(JmolResourceHandler.getStringX("Prefs.abNoLabel"));
        abGroup.add(this.abYes);
        abGroup.add(this.abNo);
        autobondPanel.add(this.abYes);
        autobondPanel.add(this.abNo);
        autobondPanel.add(Box.createVerticalGlue());
        this.abYes.setSelected(this.viewer.getAutoBond());
        this.abYes.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PreferencesDialog.this.viewer.setAutoBond(true);
            }
        });
        this.abNo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PreferencesDialog.this.viewer.setAutoBond(false);
            }
        });
        c.gridwidth = 0;
        gridbag.setConstraints(autobondPanel, c);
        bondPanel.add(autobondPanel);
        JPanel bwPanel = new JPanel();
        bwPanel.setLayout(new BorderLayout());
        bwPanel.setBorder(new TitledBorder(JmolResourceHandler.getStringX("Prefs.bondRadiusLabel")));
        JLabel bwLabel = new JLabel(JmolResourceHandler.getStringX("Prefs.bondRadiusExpl"), 0);
        bwPanel.add((Component)bwLabel, "North");
        this.bwSlider = new JSlider(0, 250, this.viewer.getMadBond() / 2);
        this.bwSlider.putClientProperty("JSlider.isFilled", Boolean.TRUE);
        this.bwSlider.setPaintTicks(true);
        this.bwSlider.setMajorTickSpacing(50);
        this.bwSlider.setMinorTickSpacing(25);
        this.bwSlider.setPaintLabels(true);
        for (int i = 0; i <= 250; i += 50) {
            String label = "" + (1000 + i);
            label = "0." + label.substring(1);
            this.bwSlider.getLabelTable().put(new Integer(i), new JLabel(label, 0));
            this.bwSlider.setLabelTable(this.bwSlider.getLabelTable());
        }
        this.bwSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                JSlider source = (JSlider)e.getSource();
                PreferencesDialog.this.marBond = (short)source.getValue();
                PreferencesDialog.this.viewer.setMarBond(PreferencesDialog.this.marBond);
                PreferencesDialog.this.currentProperties.put("marBond", "" + PreferencesDialog.this.marBond);
            }
        });
        bwPanel.add((Component)this.bwSlider, "South");
        c.weightx = 0.0;
        gridbag.setConstraints(bwPanel, c);
        bondPanel.add(bwPanel);
        JPanel btPanel = new JPanel();
        btPanel.setLayout(new BorderLayout());
        btPanel.setBorder(new TitledBorder(JmolResourceHandler.getStringX("Prefs.bondToleranceLabel")));
        JLabel btLabel = new JLabel(JmolResourceHandler.getStringX("Prefs.bondToleranceExpl"), 0);
        btPanel.add((Component)btLabel, "North");
        this.btSlider = new JSlider(0, 0, 100, (int)(100.0f * this.viewer.getBondTolerance()));
        this.btSlider.putClientProperty("JSlider.isFilled", Boolean.TRUE);
        this.btSlider.setPaintTicks(true);
        this.btSlider.setMajorTickSpacing(20);
        this.btSlider.setMinorTickSpacing(10);
        this.btSlider.setPaintLabels(true);
        this.btSlider.getLabelTable().put(new Integer(0), new JLabel("0.0", 0));
        this.btSlider.setLabelTable(this.btSlider.getLabelTable());
        this.btSlider.getLabelTable().put(new Integer(20), new JLabel("0.2", 0));
        this.btSlider.setLabelTable(this.btSlider.getLabelTable());
        this.btSlider.getLabelTable().put(new Integer(40), new JLabel("0.4", 0));
        this.btSlider.setLabelTable(this.btSlider.getLabelTable());
        this.btSlider.getLabelTable().put(new Integer(60), new JLabel("0.6", 0));
        this.btSlider.setLabelTable(this.btSlider.getLabelTable());
        this.btSlider.getLabelTable().put(new Integer(80), new JLabel("0.8", 0));
        this.btSlider.setLabelTable(this.btSlider.getLabelTable());
        this.btSlider.getLabelTable().put(new Integer(100), new JLabel("1.0", 0));
        this.btSlider.setLabelTable(this.btSlider.getLabelTable());
        this.btSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                JSlider source = (JSlider)e.getSource();
                PreferencesDialog.this.bondTolerance = (float)source.getValue() / 100.0f;
                PreferencesDialog.this.viewer.setBondTolerance(PreferencesDialog.this.bondTolerance);
                PreferencesDialog.this.currentProperties.put("bondTolerance", "" + PreferencesDialog.this.bondTolerance);
                PreferencesDialog.this.viewer.rebond();
            }
        });
        btPanel.add(this.btSlider);
        c.weightx = 0.0;
        gridbag.setConstraints(btPanel, c);
        bondPanel.add(btPanel);
        JPanel bdPanel = new JPanel();
        bdPanel.setLayout(new BorderLayout());
        bdPanel.setBorder(new TitledBorder(JmolResourceHandler.getStringX("Prefs.minBondDistanceLabel")));
        JLabel bdLabel = new JLabel(JmolResourceHandler.getStringX("Prefs.minBondDistanceExpl"), 0);
        bdPanel.add((Component)bdLabel, "North");
        this.bdSlider = new JSlider(0, 0, 100, (int)(100.0f * this.viewer.getMinBondDistance()));
        this.bdSlider.putClientProperty("JSlider.isFilled", Boolean.TRUE);
        this.bdSlider.setPaintTicks(true);
        this.bdSlider.setMajorTickSpacing(20);
        this.bdSlider.setMinorTickSpacing(10);
        this.bdSlider.setPaintLabels(true);
        this.bdSlider.getLabelTable().put(new Integer(0), new JLabel("0.0", 0));
        this.bdSlider.setLabelTable(this.bdSlider.getLabelTable());
        this.bdSlider.getLabelTable().put(new Integer(20), new JLabel("0.2", 0));
        this.bdSlider.setLabelTable(this.bdSlider.getLabelTable());
        this.bdSlider.getLabelTable().put(new Integer(40), new JLabel("0.4", 0));
        this.bdSlider.setLabelTable(this.bdSlider.getLabelTable());
        this.bdSlider.getLabelTable().put(new Integer(60), new JLabel("0.6", 0));
        this.bdSlider.setLabelTable(this.bdSlider.getLabelTable());
        this.bdSlider.getLabelTable().put(new Integer(80), new JLabel("0.8", 0));
        this.bdSlider.setLabelTable(this.bdSlider.getLabelTable());
        this.bdSlider.getLabelTable().put(new Integer(100), new JLabel("1.0", 0));
        this.bdSlider.setLabelTable(this.bdSlider.getLabelTable());
        this.bdSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                JSlider source = (JSlider)e.getSource();
                PreferencesDialog.this.minBondDistance = (float)source.getValue() / 100.0f;
                PreferencesDialog.this.viewer.setMinBondDistance(PreferencesDialog.this.minBondDistance);
                PreferencesDialog.this.currentProperties.put("minBondDistance", "" + PreferencesDialog.this.minBondDistance);
                PreferencesDialog.this.viewer.rebond();
            }
        });
        bdPanel.add(this.bdSlider);
        c.weightx = 0.0;
        gridbag.setConstraints(bdPanel, c);
        bondPanel.add(bdPanel);
        return bondPanel;
    }

    public JPanel buildColorsPanel() {
        JPanel colorPanel = new JPanel();
        colorPanel.setLayout(new GridLayout(0, 2));
        JPanel backgroundPanel = new JPanel();
        backgroundPanel.setLayout(new BorderLayout());
        backgroundPanel.setBorder(new TitledBorder(JmolResourceHandler.getStringX("Prefs.bgLabel")));
        this.bButton = new JButton();
        this.bButton.setBackground(this.colorBackground);
        this.bButton.setToolTipText(JmolResourceHandler.getStringX("Prefs.bgToolTip"));
        ActionListener startBackgroundChooser = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Color color = JColorChooser.showDialog(PreferencesDialog.this.bButton, JmolResourceHandler.getStringX("Prefs.bgChooserTitle"), PreferencesDialog.this.colorBackground);
                PreferencesDialog.this.colorBackground = color;
                PreferencesDialog.this.bButton.setBackground(PreferencesDialog.this.colorBackground);
                PreferencesDialog.this.viewer.setColorBackground(PreferencesDialog.this.colorBackground);
                PreferencesDialog.this.currentProperties.put("colorBackground", Integer.toString(PreferencesDialog.this.colorBackground.getRGB()));
            }
        };
        this.bButton.addActionListener(startBackgroundChooser);
        backgroundPanel.add((Component)this.bButton, "Center");
        colorPanel.add(backgroundPanel);
        JPanel pickedPanel = new JPanel();
        pickedPanel.setLayout(new BorderLayout());
        pickedPanel.setBorder(new TitledBorder(JmolResourceHandler.getStringX("Prefs.pickedLabel")));
        this.pButton = new JButton();
        this.pButton.setBackground(this.colorSelection);
        this.pButton.setToolTipText(JmolResourceHandler.getStringX("Prefs.pickedToolTip"));
        ActionListener startPickedChooser = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Color color = JColorChooser.showDialog(PreferencesDialog.this.pButton, JmolResourceHandler.getStringX("Prefs.pickedChooserTitle"), PreferencesDialog.this.colorSelection);
                PreferencesDialog.this.colorSelection = color;
                PreferencesDialog.this.pButton.setBackground(PreferencesDialog.this.colorSelection);
                PreferencesDialog.this.viewer.setColorSelection(PreferencesDialog.this.colorSelection);
                PreferencesDialog.this.currentProperties.put("colorSelection", Integer.toString(PreferencesDialog.this.colorSelection.getRGB()));
            }
        };
        this.pButton.addActionListener(startPickedChooser);
        pickedPanel.add((Component)this.pButton, "Center");
        colorPanel.add(pickedPanel);
        JPanel textPanel = new JPanel();
        textPanel.setLayout(new BorderLayout());
        textPanel.setBorder(new TitledBorder(JmolResourceHandler.getStringX("Prefs.textLabel")));
        this.isLabelAtomColor = this.viewer.getColorLabel() == null;
        this.cbIsLabelAtomColor = this.guimap.newJCheckBox("Prefs.isLabelAtomColor", this.isLabelAtomColor);
        this.cbIsLabelAtomColor.addItemListener(this.checkBoxListener);
        textPanel.add((Component)this.cbIsLabelAtomColor, "North");
        this.tButton = new JButton();
        this.tButton.setBackground(this.colorText);
        this.tButton.setToolTipText(JmolResourceHandler.getStringX("Prefs.textToolTip"));
        this.tButton.setEnabled(!this.isLabelAtomColor);
        ActionListener startTextChooser = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Color color = JColorChooser.showDialog(PreferencesDialog.this.tButton, JmolResourceHandler.getStringX("Prefs.textChooserTitle"), PreferencesDialog.this.colorText);
                PreferencesDialog.this.colorText = color;
                PreferencesDialog.this.tButton.setBackground(PreferencesDialog.this.colorText);
                PreferencesDialog.this.viewer.setColorLabel(PreferencesDialog.this.colorText);
                PreferencesDialog.this.currentProperties.put("colorText", Integer.toString(PreferencesDialog.this.colorText.getRGB()));
            }
        };
        this.tButton.addActionListener(startTextChooser);
        textPanel.add((Component)this.tButton, "Center");
        colorPanel.add(textPanel);
        JPanel bondPanel = new JPanel();
        bondPanel.setLayout(new BorderLayout());
        bondPanel.setBorder(new TitledBorder(JmolResourceHandler.getStringX("Prefs.bondLabel")));
        this.isBondAtomColor = this.viewer.getColorBond() == null;
        this.cbIsBondAtomColor = this.guimap.newJCheckBox("Prefs.isBondAtomColor", this.isBondAtomColor);
        this.cbIsBondAtomColor.addItemListener(this.checkBoxListener);
        bondPanel.add((Component)this.cbIsBondAtomColor, "North");
        this.eButton = new JButton();
        this.eButton.setBackground(this.colorBond);
        this.eButton.setToolTipText(JmolResourceHandler.getStringX("Prefs.textToolTip"));
        this.eButton.setEnabled(!this.isBondAtomColor);
        ActionListener startBondChooser = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Color color = JColorChooser.showDialog(PreferencesDialog.this.eButton, JmolResourceHandler.getStringX("Prefs.bondChooserTitle"), PreferencesDialog.this.colorBond);
                PreferencesDialog.this.colorBond = color;
                PreferencesDialog.this.eButton.setBackground(PreferencesDialog.this.colorBond);
                PreferencesDialog.this.viewer.setColorBond(PreferencesDialog.this.colorBond);
                PreferencesDialog.this.currentProperties.put("colorBond", "" + PreferencesDialog.this.colorBond.getRGB());
            }
        };
        this.eButton.addActionListener(startBondChooser);
        bondPanel.add((Component)this.eButton, "Center");
        colorPanel.add(bondPanel);
        JPanel vectorPanel = new JPanel();
        vectorPanel.setLayout(new BorderLayout());
        vectorPanel.setBorder(new TitledBorder(JmolResourceHandler.getStringX("Prefs.vectorLabel")));
        this.vButton = new JButton();
        this.vButton.setBackground(this.colorVector);
        this.vButton.setToolTipText(JmolResourceHandler.getStringX("Prefs.vectorToolTip"));
        ActionListener startVectorChooser = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Color color = JColorChooser.showDialog(PreferencesDialog.this.vButton, JmolResourceHandler.getStringX("Prefs.vectorChooserTitle"), PreferencesDialog.this.colorVector);
                PreferencesDialog.this.colorVector = color;
                PreferencesDialog.this.vButton.setBackground(PreferencesDialog.this.colorVector);
                PreferencesDialog.this.viewer.setColorVector(PreferencesDialog.this.colorVector);
                PreferencesDialog.this.currentProperties.put("colorVector", Integer.toString(PreferencesDialog.this.colorVector.getRGB()));
                PreferencesDialog.this.viewer.refresh();
            }
        };
        this.vButton.addActionListener(startVectorChooser);
        vectorPanel.add((Component)this.vButton, "Center");
        colorPanel.add(vectorPanel);
        JPanel measurementColorPanel = new JPanel();
        measurementColorPanel.setLayout(new BorderLayout());
        measurementColorPanel.setBorder(new TitledBorder(JmolResourceHandler.getStringX("Prefs.measurementColorLabel")));
        this.measurementColorButton = new JButton();
        this.measurementColorButton.setBackground(this.colorVector);
        this.measurementColorButton.setToolTipText(JmolResourceHandler.getStringX("Prefs.measurementColorToolTip"));
        ActionListener startMeasurementColorChooser = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Color color = JColorChooser.showDialog(PreferencesDialog.this.measurementColorButton, JmolResourceHandler.getStringX("Prefs.measurementColorChooserTitle"), PreferencesDialog.this.colorMeasurement);
                PreferencesDialog.this.colorMeasurement = color;
                PreferencesDialog.this.measurementColorButton.setBackground(PreferencesDialog.this.colorMeasurement);
                PreferencesDialog.this.viewer.setColorMeasurement(PreferencesDialog.this.colorMeasurement);
                PreferencesDialog.this.currentProperties.put("colorMeasurement", Integer.toString(PreferencesDialog.this.colorMeasurement.getRGB()));
                PreferencesDialog.this.viewer.refresh();
            }
        };
        this.measurementColorButton.addActionListener(startMeasurementColorChooser);
        measurementColorPanel.add((Component)this.measurementColorButton, "Center");
        colorPanel.add(measurementColorPanel);
        return colorPanel;
    }

    protected void centerDialog() {
        Dimension screenSize = this.getToolkit().getScreenSize();
        Dimension size = this.getSize();
        screenSize.height /= 2;
        screenSize.width /= 2;
        size.height /= 2;
        size.width /= 2;
        int y = screenSize.height - size.height;
        int x = screenSize.width - size.width;
        this.setLocation(x, y);
    }

    public void ok() {
        this.save();
        this.dispose();
    }

    public void cancel() {
        this.updateComponents();
        this.dispose();
    }

    private void updateComponents() {
        this.cH.setSelected(this.viewer.getShowHydrogens());
        this.cM.setSelected(this.viewer.getShowMeasurements());
        this.cbWireframeRotation.setSelected(this.viewer.getWireframeRotation());
        this.cbPerspectiveDepth.setSelected(this.viewer.getPerspectiveDepth());
        this.cbShowAxes.setSelected(this.viewer.getShapeShow(15));
        this.cbShowBoundingBox.setSelected(this.viewer.getShapeShow(16));
        this.cbAxesOrientationRasmol.setSelected(this.viewer.getAxesOrientationRasmol());
        this.vdwPercentSlider.setValue(this.viewer.getPercentVdwAtom());
        this.abYes.setSelected(this.viewer.getAutoBond());
        this.bwSlider.setValue(this.viewer.getMadBond() / 2);
        this.bdSlider.setValue((int)(100.0f * this.viewer.getMinBondDistance()));
        this.btSlider.setValue((int)(100.0f * this.viewer.getBondTolerance()));
        this.bButton.setBackground(this.colorBackground);
        this.pButton.setBackground(this.colorSelection);
        this.cbIsLabelAtomColor.setSelected(this.isLabelAtomColor);
        this.tButton.setBackground(this.colorText);
        this.tButton.setEnabled(!this.isLabelAtomColor);
        this.cbIsBondAtomColor.setSelected(this.isBondAtomColor);
        this.eButton.setBackground(this.colorBond);
        this.eButton.setEnabled(!this.isBondAtomColor);
        this.vButton.setBackground(this.colorVector);
        this.measurementColorButton.setBackground(this.colorMeasurement);
    }

    private void save() {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(Jmol.UserPropsFile);
            this.currentProperties.store(fileOutputStream, "Jmol");
            fileOutputStream.close();
        }
        catch (Exception e) {
            System.out.println("Error saving preferences" + e);
        }
        this.viewer.refresh();
    }

    void initializeProperties() {
        this.originalSystemProperties = System.getProperties();
        this.jmolDefaultProperties = new Properties(this.originalSystemProperties);
        int i = jmolDefaults.length;
        while ((i -= 2) >= 0) {
            this.jmolDefaultProperties.put(jmolDefaults[i], jmolDefaults[i + 1]);
        }
        this.currentProperties = new Properties(this.jmolDefaultProperties);
        try {
            FileInputStream fis2 = new FileInputStream(Jmol.UserPropsFile);
            this.currentProperties.load(new BufferedInputStream(fis2, 1024));
            fis2.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        System.setProperties(this.currentProperties);
    }

    void resetDefaults(String[] overrides) {
        this.currentProperties = new Properties(this.jmolDefaultProperties);
        System.setProperties(this.currentProperties);
        if (overrides != null) {
            int i = overrides.length;
            while ((i -= 2) >= 0) {
                this.currentProperties.put(overrides[i], overrides[i + 1]);
            }
        }
        this.initVariables();
        this.viewer.refresh();
        this.updateComponents();
    }

    void initVariables() {
        this.autoBond = Boolean.getBoolean("autoBond");
        this.showHydrogens = Boolean.getBoolean("showHydrogens");
        this.showVectors = Boolean.getBoolean("showVectors");
        this.showMeasurements = Boolean.getBoolean("showMeasurements");
        this.wireframeRotation = Boolean.getBoolean("wireframeRotation");
        this.perspectiveDepth = Boolean.getBoolean("perspectiveDepth");
        this.showAxes = Boolean.getBoolean("showAxes");
        this.showBoundingBox = Boolean.getBoolean("showBoundingBox");
        this.axesOrientationRasmol = Boolean.getBoolean("axesOrientationRasmol");
        this.colorBackground = Color.getColor("colorBackground");
        this.colorSelection = Color.getColor("colorSelection");
        this.isLabelAtomColor = Boolean.getBoolean("isLabelAtomColor");
        this.colorText = Color.getColor("colorText");
        this.isBondAtomColor = Boolean.getBoolean("isBondAtomColor");
        this.colorBond = Color.getColor("colorBond");
        this.colorVector = Color.getColor("colorVector");
        this.colorMeasurement = Color.getColor("colorMeasurement");
        this.minBondDistance = new Float(this.currentProperties.getProperty("minBondDistance")).floatValue();
        this.bondTolerance = new Float(this.currentProperties.getProperty("bondTolerance")).floatValue();
        this.marBond = Short.parseShort(this.currentProperties.getProperty("marBond"));
        this.percentVdwAtom = Integer.parseInt(this.currentProperties.getProperty("percentVdwAtom"));
        this.viewer.setColorSelection(this.colorSelection);
        this.viewer.setColorLabel(this.isLabelAtomColor ? null : this.colorText);
        this.viewer.setColorBond(this.isBondAtomColor ? null : this.colorBond);
        this.viewer.setPercentVdwAtom(this.percentVdwAtom);
        this.viewer.setMarBond(this.marBond);
        this.viewer.setColorVector(this.colorVector);
        this.viewer.setColorMeasurement(this.colorMeasurement);
        this.viewer.setColorBackground(this.colorBackground);
        this.viewer.setMinBondDistance(this.minBondDistance);
        this.viewer.setBondTolerance(this.bondTolerance);
        this.viewer.setAutoBond(this.autoBond);
        this.viewer.setShowHydrogens(this.showHydrogens);
        this.viewer.setShowMeasurements(this.showMeasurements);
        this.viewer.setWireframeRotation(this.wireframeRotation);
        this.viewer.setPerspectiveDepth(this.perspectiveDepth);
        this.viewer.setShapeShow(15, this.showAxes);
        this.viewer.setShapeShow(16, this.showBoundingBox);
        this.viewer.setAxesOrientationRasmol(this.axesOrientationRasmol);
    }

    public Action[] getActions() {
        Action[] defaultActions = new Action[]{this.prefsAction};
        return defaultActions;
    }

    protected Action getAction(String cmd) {
        return (Action)this.commands.get(cmd);
    }

    public void actionPerformed(ActionEvent event) {
        if (event.getSource() == this.applyButton) {
            this.save();
        } else if (event.getSource() == this.jmolDefaultsButton) {
            this.resetDefaults(null);
        } else if (event.getSource() == this.rasmolDefaultsButton) {
            this.resetDefaults(rasmolOverrides);
        } else if (event.getSource() == this.cancelButton) {
            this.cancel();
        } else if (event.getSource() == this.okButton) {
            this.ok();
        }
    }

    class PrefsAction
    extends AbstractAction {
        public PrefsAction() {
            super("prefs");
            this.setEnabled(true);
        }

        public void actionPerformed(ActionEvent e) {
            PreferencesDialog.this.show();
        }
    }
}

