/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.jmol.viewer.datamodel;

import java.util.Hashtable;
import org.jmol.api.ModelAdapter;
import org.openscience.jmol.viewer.JmolConstants;
import org.openscience.jmol.viewer.JmolViewer;
import org.openscience.jmol.viewer.Util;
import org.openscience.jmol.viewer.datamodel.AlphaMonomer;
import org.openscience.jmol.viewer.datamodel.AminoMonomer;
import org.openscience.jmol.viewer.datamodel.Atom;
import org.openscience.jmol.viewer.datamodel.Bond;
import org.openscience.jmol.viewer.datamodel.Chain;
import org.openscience.jmol.viewer.datamodel.Frame;
import org.openscience.jmol.viewer.datamodel.Group;
import org.openscience.jmol.viewer.datamodel.Model;
import org.openscience.jmol.viewer.datamodel.Monomer;
import org.openscience.jmol.viewer.datamodel.NucleicMonomer;
import org.openscience.jmol.viewer.datamodel.PhosphorusMonomer;
import org.openscience.jmol.viewer.datamodel.Polymer;

public final class FrameBuilder {
    final JmolViewer viewer;
    final ModelAdapter adapter;
    boolean fileHasHbonds;
    private static final int ATOM_GROWTH_INCREMENT = 2000;
    String currentModelTag;
    int currentModelIndex;
    Model currentModel;
    char currentChainID;
    Chain currentChain;
    int currentGroupSequenceNumber;
    char currentGroupInsertionCode;
    int atomCount;
    Atom[] atoms;
    Object[] clientAtomReferences;
    int bondCount;
    Bond[] bonds;
    private final Hashtable htAtomMap = new Hashtable();
    static final int defaultGroupCount = 32;
    int groupCount;
    Chain[] chains = new Chain[32];
    String[] group3s = new String[32];
    int[] seqcodes = new int[32];
    int[] firstAtomIndexes = new int[32];
    Group[] groups;
    final int[] specialAtomIndexes = new int[JmolConstants.ATOMID_MAX];

    public FrameBuilder(JmolViewer viewer, ModelAdapter adapter) {
        this.viewer = viewer;
        this.adapter = adapter;
    }

    public Frame buildFrame(Object clientFile) {
        ModelAdapter.StructureIterator iterStructure;
        long timeBegin = System.currentTimeMillis();
        String fileTypeName = this.adapter.getFileTypeName(clientFile);
        this.initializeBuild(this.adapter.getEstimatedAtomCount(clientFile));
        Frame frame = new Frame(this.viewer, fileTypeName);
        frame.fileCoordinatesAreFractional = this.adapter.coordinatesAreFractional(clientFile);
        frame.setNotionalUnitcell(this.adapter.getNotionalUnitcell(clientFile));
        frame.setPdbScaleMatrix(this.adapter.getPdbScaleMatrix(clientFile));
        frame.setPdbScaleTranslate(this.adapter.getPdbScaleTranslate(clientFile));
        ModelAdapter.AtomIterator iterAtom = this.adapter.getAtomIterator(clientFile);
        while (iterAtom.hasNext()) {
            byte elementNumber = (byte)iterAtom.getElementNumber();
            if (elementNumber <= 0) {
                elementNumber = JmolConstants.elementNumberFromSymbol(iterAtom.getElementSymbol());
            }
            this.addAtom(frame, iterAtom.getModelTag().intern(), iterAtom.getUniqueID(), elementNumber, iterAtom.getAtomName(), iterAtom.getFormalCharge(), iterAtom.getPartialCharge(), iterAtom.getOccupancy(), iterAtom.getBfactor(), iterAtom.getX(), iterAtom.getY(), iterAtom.getZ(), iterAtom.getIsHetero(), iterAtom.getAtomSerial(), iterAtom.getChainID(), iterAtom.getGroup3(), iterAtom.getSequenceNumber(), iterAtom.getInsertionCode(), iterAtom.getVectorX(), iterAtom.getVectorY(), iterAtom.getVectorZ(), iterAtom.getClientAtomReference());
        }
        this.fileHasHbonds = false;
        ModelAdapter.BondIterator iterBond = this.adapter.getBondIterator(clientFile);
        if (iterBond != null) {
            while (iterBond.hasNext()) {
                this.bondAtoms(iterBond.getAtomUniqueID1(), iterBond.getAtomUniqueID2(), iterBond.getEncodedOrder());
            }
        }
        if ((iterStructure = this.adapter.getStructureIterator(clientFile)) != null) {
            while (iterStructure.hasNext()) {
                frame.defineStructure(iterStructure.getStructureType(), iterStructure.getStartChainID(), iterStructure.getStartSequenceNumber(), iterStructure.getStartInsertionCode(), iterStructure.getEndChainID(), iterStructure.getEndSequenceNumber(), iterStructure.getEndInsertionCode());
            }
        }
        frame.atomCount = this.atomCount;
        frame.atoms = this.atoms;
        frame.clientAtomReferences = this.clientAtomReferences;
        frame.bondCount = this.bondCount;
        frame.bonds = this.bonds;
        frame.fileHasHbonds = this.fileHasHbonds;
        frame.doUnitcellStuff();
        frame.doAutobond();
        this.finalizeGroupBuild(frame);
        this.buildPolymers(frame);
        frame.freeze();
        long msToBuild = System.currentTimeMillis() - timeBegin;
        this.adapter.finish(clientFile);
        this.finalizeBuild();
        return frame;
    }

    void initializeBuild(int atomCountEstimate) {
        this.currentModelTag = null;
        this.currentModel = null;
        this.currentChainID = (char)65535;
        this.currentChain = null;
        this.currentGroupInsertionCode = (char)65535;
        this.atomCount = 0;
        if (atomCountEstimate <= 0) {
            atomCountEstimate = 2000;
        }
        this.atoms = new Atom[atomCountEstimate];
        this.clientAtomReferences = null;
        this.bondCount = 0;
        this.bonds = new Bond[2 * atomCountEstimate];
        this.htAtomMap.clear();
        this.initializeGroupBuild();
    }

    void finalizeBuild() {
        this.currentModel = null;
        this.currentChain = null;
        this.atoms = null;
        this.clientAtomReferences = null;
        this.bonds = null;
        this.htAtomMap.clear();
    }

    void addAtom(Frame frame, String modelTag, Object atomUid, byte atomicNumber, String atomName, int formalCharge, float partialCharge, int occupancy, float bfactor, float x, float y, float z, boolean isHetero, int atomSerial, char chainID, String group3, int groupSequenceNumber, char groupInsertionCode, float vectorX, float vectorY, float vectorZ, Object clientAtomReference) {
        if (modelTag != this.currentModelTag) {
            this.currentModelTag = modelTag;
            this.currentModel = frame.mmset.getOrAllocateModel(modelTag);
            this.currentModelIndex = frame.mmset.getModelIndex(modelTag);
            this.currentChainID = (char)65535;
        }
        if (chainID != this.currentChainID) {
            this.currentChainID = chainID;
            this.currentChain = this.currentModel.getOrAllocateChain(chainID);
            this.currentGroupInsertionCode = (char)65535;
        }
        if (groupSequenceNumber != this.currentGroupSequenceNumber || groupInsertionCode != this.currentGroupInsertionCode) {
            this.currentGroupSequenceNumber = groupSequenceNumber;
            this.currentGroupInsertionCode = groupInsertionCode;
            this.startGroup(this.currentChain, group3, groupSequenceNumber, groupInsertionCode, this.atomCount);
        }
        Atom atom = new Atom(this.viewer, this.currentModelIndex, this.atomCount, atomicNumber, atomName, formalCharge, partialCharge, occupancy, bfactor, x, y, z, isHetero, atomSerial, chainID, vectorX, vectorY, vectorZ);
        if (this.atomCount == this.atoms.length) {
            this.atoms = (Atom[])Util.setLength(this.atoms, this.atomCount + 2000);
        }
        this.atoms[this.atomCount] = atom;
        if (clientAtomReference != null) {
            if (this.clientAtomReferences == null) {
                this.clientAtomReferences = new Object[this.atoms.length];
            } else if (this.clientAtomReferences.length <= this.atomCount) {
                this.clientAtomReferences = (Object[])Util.setLength(this.clientAtomReferences, this.atoms.length);
            }
            this.clientAtomReferences[this.atomCount] = clientAtomReference;
        }
        ++this.atomCount;
        this.htAtomMap.put(atomUid, atom);
    }

    void bondAtoms(Object atomUid1, Object atomUid2, int order) {
        Bond bond;
        Atom atom1 = (Atom)this.htAtomMap.get(atomUid1);
        if (atom1 == null) {
            System.out.println("bondAtoms cannot find atomUid1?");
            return;
        }
        Atom atom2 = (Atom)this.htAtomMap.get(atomUid2);
        if (atom2 == null) {
            System.out.println("bondAtoms cannot find atomUid2?");
            return;
        }
        if (this.bondCount == this.bonds.length) {
            this.bonds = (Bond[])Util.setLength(this.bonds, this.bondCount + 4000);
        }
        if ((bond = atom1.bondMutually(atom2, order, this.viewer)) != null) {
            this.bonds[this.bondCount++] = bond;
            if ((order & 0x3C0) != 0) {
                this.fileHasHbonds = true;
            }
        }
    }

    void initializeGroupBuild() {
        this.groupCount = 0;
    }

    void finalizeGroupBuild(Frame frame) {
        this.groups = new Group[this.groupCount];
        for (int i = 0; i < this.groupCount; ++i) {
            this.distinguishAndPropogateGroup(i, this.chains[i], this.group3s[i], this.seqcodes[i], this.firstAtomIndexes[i], i == this.groupCount - 1 ? this.atomCount : this.firstAtomIndexes[i + 1]);
            this.chains[i] = null;
            this.group3s[i] = null;
        }
        frame.groupCount = this.groupCount;
        frame.groups = this.groups;
        this.groups = null;
    }

    void startGroup(Chain chain, String group3, int groupSequenceNumber, char groupInsertionCode, int firstAtomIndex) {
        if (this.groupCount == this.group3s.length) {
            this.chains = (Chain[])Util.doubleLength(this.chains);
            this.group3s = Util.doubleLength(this.group3s);
            this.seqcodes = Util.doubleLength(this.seqcodes);
            this.firstAtomIndexes = Util.doubleLength(this.firstAtomIndexes);
        }
        this.firstAtomIndexes[this.groupCount] = firstAtomIndex;
        this.chains[this.groupCount] = chain;
        this.group3s[this.groupCount] = group3;
        this.seqcodes[this.groupCount] = Group.getSeqcode(groupSequenceNumber, groupInsertionCode);
        ++this.groupCount;
    }

    void distinguishAndPropogateGroup(int groupIndex, Chain chain, String group3, int seqcode, int firstAtomIndex, int maxAtomIndex) {
        int distinguishingBits = 0;
        int i = JmolConstants.ATOMID_MAX;
        while (--i >= 0) {
            this.specialAtomIndexes[i] = Integer.MIN_VALUE;
        }
        i = maxAtomIndex;
        while (--i >= firstAtomIndex) {
            byte specialAtomID = this.atoms[i].specialAtomID;
            if (specialAtomID <= 0) continue;
            if (specialAtomID < 32) {
                distinguishingBits |= 1 << specialAtomID;
            }
            this.specialAtomIndexes[specialAtomID] = i;
        }
        int lastAtomIndex = maxAtomIndex - 1;
        if (lastAtomIndex < firstAtomIndex) {
            throw new NullPointerException();
        }
        Group group = null;
        if ((distinguishingBits & 0xE) == 14) {
            group = AminoMonomer.validateAndAllocate(chain, group3, seqcode, firstAtomIndex, lastAtomIndex, this.specialAtomIndexes, this.atoms);
        } else if (distinguishingBits == 4) {
            group = AlphaMonomer.validateAndAllocate(chain, group3, seqcode, firstAtomIndex, lastAtomIndex, this.specialAtomIndexes, this.atoms);
        } else if ((distinguishingBits & 0xFE0) == 4064) {
            group = NucleicMonomer.validateAndAllocate(chain, group3, seqcode, firstAtomIndex, lastAtomIndex, this.specialAtomIndexes, this.atoms);
        } else if (distinguishingBits == 4096) {
            group = PhosphorusMonomer.validateAndAllocate(chain, group3, seqcode, firstAtomIndex, lastAtomIndex, this.specialAtomIndexes, this.atoms);
        }
        if (group == null) {
            group = new Group(chain, group3, seqcode, firstAtomIndex, lastAtomIndex);
        }
        chain.addGroup(group);
        this.groups[groupIndex] = group;
        int i2 = maxAtomIndex;
        while (--i2 >= firstAtomIndex) {
            this.atoms[i2].setGroup(group);
        }
    }

    void buildPolymers(Frame frame) {
        Group[] groups = frame.groups;
        for (int i = 0; i < this.groupCount; ++i) {
            Group group = groups[i];
            if (!(group instanceof Monomer)) continue;
            Monomer monomer = (Monomer)group;
            if (monomer.polymer != null) continue;
            Polymer.allocatePolymer(groups, i);
        }
    }
}

